﻿package org.papervision3d.view.layer
{
    import flash.display.*;
    import flash.utils.*;
    import org.papervision3d.core.log.*;
    import org.papervision3d.core.render.command.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.util.*;

    public class ViewportLayer extends Sprite
    {
        public var layerIndex:Number;
        public var originDepth:Number = 0;
        public var layers:Dictionary;
        public var dynamicLayer:Boolean = false;
        public var sortMode:String;
        public var weight:Number = 0;
        public var childLayers:Array;
        public var forceDepth:Boolean = false;
        protected var viewport:Viewport3D;
        public var screenDepth:Number = 0;
        public var displayObject3D:DisplayObject3D;
        public var displayObjects:Dictionary;
        public var graphicsChannel:Graphics;

        public function ViewportLayer(param1:Viewport3D, param2:DisplayObject3D, param3:Boolean = false)
        {
            layers = new Dictionary(true);
            displayObjects = new Dictionary(true);
            forceDepth = false;
            screenDepth = 0;
            originDepth = 0;
            weight = 0;
            sortMode = ViewportLayerSortMode.Z_SORT;
            dynamicLayer = false;
            this.viewport = param1;
            this.displayObject3D = param2;
            this.dynamicLayer = param3;
            this.graphicsChannel = this.graphics;
            if (param3)
            {
                this.filters = param2.filters;
                this.blendMode = param2.blendMode;
                this.alpha = param2.alpha;
            }// end if
            if (param2)
            {
                addDisplayObject3D(param2);
                param2.container = this;
            }// end if
            init();
            return;
        }// end function

        public function getLayerObjects(param1:Array = null) : Array
        {
            var _loc_2:DisplayObject3D;
            var _loc_3:ViewportLayer;
            if (!param1)
            {
                param1 = new Array();
            }// end if
            for each (_loc_2 in this.displayObjects)
            {
                // label
                if (_loc_2)
                {
                    param1.push(_loc_2);
                }// end if
            }// end of for each ... in
            for each (_loc_3 in childLayers)
            {
                // label
                _loc_3.getLayerObjects(param1);
            }// end of for each ... in
            return param1;
        }// end function

        protected function init() : void
        {
            childLayers = new Array();
            return;
        }// end function

        public function updateInfo() : void
        {
            var _loc_1:ViewportLayer;
            for each (_loc_1 in childLayers)
            {
                // label
                _loc_1.updateInfo();
                if (!forceDepth)
                {
                    if (!isNaN(_loc_1.screenDepth))
                    {
                        this.weight = this.weight + _loc_1.weight;
                        this.screenDepth = this.screenDepth + _loc_1.screenDepth * _loc_1.weight;
                        this.originDepth = this.originDepth + _loc_1.originDepth * _loc_1.weight;
                    }// end if
                }// end if
            }// end of for each ... in
            if (!forceDepth)
            {
                this.screenDepth = this.screenDepth / this.weight;
                this.originDepth = this.originDepth / this.weight;
            }// end if
            return;
        }// end function

        public function sortChildLayers() : void
        {
            switch(sortMode)
            {
                case ViewportLayerSortMode.Z_SORT:
                {
                    childLayers.sortOn("screenDepth", Array.DESCENDING | Array.NUMERIC);
                    break;
                }// end case
                case ViewportLayerSortMode.INDEX_SORT:
                {
                    childLayers.sortOn("layerIndex", Array.NUMERIC);
                    break;
                }// end case
                case ViewportLayerSortMode.ORIGIN_SORT:
                {
                    childLayers.sortOn(["originDepth", "screenDepth"], [Array.DESCENDING | Array.NUMERIC, Array.DESCENDING | Array.NUMERIC]);
                    break;
                }// end case
                default:
                {
                    break;
                }// end default
            }// end switch
            orderLayers();
            return;
        }// end function

        private function onChildRemoved(param1:ViewportLayerEvent) : void
        {
            if (param1.do3d)
            {
                unlinkChild(param1.do3d, param1);
            }// end if
            return;
        }// end function

        public function removeAllLayers() : void
        {
            var _loc_1:int;
            while (_loc_1-- >= 0)
            {
                // label
                removeLayerAt(childLayers.length--);
            }// end while
            return;
        }// end function

        public function updateAfterRender() : void
        {
            var _loc_1:ViewportLayer;
            for each (_loc_1 in childLayers)
            {
                // label
                _loc_1.updateAfterRender();
            }// end of for each ... in
            return;
        }// end function

        public function removeLayer(param1:ViewportLayer) : void
        {
            var _loc_2:int;
            _loc_2 = getChildIndex(param1);
            if (_loc_2 > -1)
            {
                removeLayerAt(_loc_2);
            }
            else
            {
                PaperLogger.error("Layer not found for removal.");
            }// end else if
            return;
        }// end function

        protected function getChildLayerFor(param1:DisplayObject3D, param2:Boolean = false) : ViewportLayer
        {
            var _loc_3:ViewportLayer;
            if (param1)
            {
                _loc_3 = new ViewportLayer(viewport, param1, param1.useOwnContainer);
                addLayer(_loc_3);
                if (param2)
                {
                    param1.addChildrenToLayer(param1, _loc_3);
                }// end if
                return _loc_3;
            }
            else
            {
                PaperLogger.warning("Needs to be a do3d");
            }// end else if
            return null;
        }// end function

        public function addLayer(param1:ViewportLayer) : void
        {
            var _loc_2:DisplayObject3D;
            var _loc_3:ViewportLayer;
            if (childLayers.indexOf(param1) != -1)
            {
                PaperLogger.warning("Child layer already exists in ViewportLayer");
                return;
            }// end if
            childLayers.push(param1);
            addChild(param1);
            param1.addEventListener(ViewportLayerEvent.CHILD_ADDED, onChildAdded);
            param1.addEventListener(ViewportLayerEvent.CHILD_REMOVED, onChildRemoved);
            for each (_loc_2 in param1.displayObjects)
            {
                // label
                linkChild(_loc_2, param1);
            }// end of for each ... in
            for each (_loc_3 in param1.layers)
            {
                // label
                for each (_loc_2 in _loc_3.displayObjects)
                {
                    // label
                    linkChild(_loc_2, _loc_3);
                }// end of for each ... in
            }// end of for each ... in
            return;
        }// end function

        protected function orderLayers() : void
        {
            var _loc_1:int;
            var _loc_2:ViewportLayer;
            _loc_1 = 0;
            while (_loc_1 < childLayers.length)
            {
                // label
                _loc_2 = childLayers[_loc_1];
                if (this.getChildIndex(_loc_2) != _loc_1)
                {
                    this.setChildIndex(_loc_2, _loc_1);
                }// end if
                _loc_2.sortChildLayers();
                _loc_1++;
            }// end while
            return;
        }// end function

        public function childLayerIndex(param1:DisplayObject3D) : Number
        {
            var _loc_2:int;
            param1 = param1.parentContainer ? (param1.parentContainer) : (param1);
            _loc_2 = 0;
            while (_loc_2 < childLayers.length)
            {
                // label
                if (childLayers[_loc_2].hasDisplayObject3D(param1))
                {
                    return _loc_2;
                }// end if
                _loc_2++;
            }// end while
            return -1;
        }// end function

        public function removeLayerAt(param1:Number) : void
        {
            var _loc_2:DisplayObject3D;
            for each (_loc_2 in childLayers[param1].displayObjects)
            {
                // label
                unlinkChild(_loc_2);
            }// end of for each ... in
            removeChild(childLayers[param1]);
            childLayers.splice(param1, 1);
            return;
        }// end function

        protected function reset() : void
        {
            if (!forceDepth)
            {
                screenDepth = 0;
                originDepth = 0;
            }// end if
            this.weight = 0;
            return;
        }// end function

        private function linkChild(param1:DisplayObject3D, param2:ViewportLayer, param3:ViewportLayerEvent = null) : void
        {
            layers[param1] = param2;
            dispatchEvent(new ViewportLayerEvent(ViewportLayerEvent.CHILD_ADDED, param1, param2));
            return;
        }// end function

        public function updateBeforeRender() : void
        {
            var _loc_1:ViewportLayer;
            clear();
            for each (_loc_1 in childLayers)
            {
                // label
                _loc_1.updateBeforeRender();
            }// end of for each ... in
            return;
        }// end function

        private function onChildAdded(param1:ViewportLayerEvent) : void
        {
            if (param1.do3d)
            {
                linkChild(param1.do3d, param1.layer, param1);
            }// end if
            return;
        }// end function

        public function getChildLayer(param1:DisplayObject3D, param2:Boolean = true, param3:Boolean = false) : ViewportLayer
        {
            param1 = param1.parentContainer ? (param1.parentContainer) : (param1);
            if (layers[param1])
            {
                return layers[param1];
            }// end if
            if (param2)
            {
                return getChildLayerFor(param1, param3);
            }// end if
            return null;
        }// end function

        public function processRenderItem(param1:RenderableListItem) : void
        {
            if (!forceDepth)
            {
                if (!isNaN(param1.screenZ))
                {
                    this.screenDepth = this.screenDepth + param1.screenZ;
                    if (param1.instance)
                    {
                        this.originDepth = this.originDepth + param1.instance.world.n34;
                        this.originDepth = this.originDepth + param1.instance.screen.z;
                    }// end if
                    var _loc_2:String;
                    _loc_2.weight = this.weight++;
                }// end if
            }// end if
            return;
        }// end function

        public function clear() : void
        {
            graphicsChannel.clear();
            reset();
            return;
        }// end function

        public function removeDisplayObject3D(param1:DisplayObject3D) : void
        {
            displayObjects[param1] = null;
            dispatchEvent(new ViewportLayerEvent(ViewportLayerEvent.CHILD_REMOVED, param1, this));
            return;
        }// end function

        private function unlinkChild(param1:DisplayObject3D, param2:ViewportLayerEvent = null) : void
        {
            layers[param1] = null;
            dispatchEvent(new ViewportLayerEvent(ViewportLayerEvent.CHILD_REMOVED, param1));
            return;
        }// end function

        public function addDisplayObject3D(param1:DisplayObject3D, param2:Boolean = false) : void
        {
            if (!param1)
            {
                return;
            }// end if
            displayObjects[param1] = param1;
            dispatchEvent(new ViewportLayerEvent(ViewportLayerEvent.CHILD_ADDED, param1, this));
            if (param2)
            {
                param1.addChildrenToLayer(param1, this);
            }// end if
            return;
        }// end function

        public function hasDisplayObject3D(param1:DisplayObject3D) : Boolean
        {
            return displayObjects[param1] != null;
        }// end function

    }
}
