<?php

include_once( "shopObject.php" );
class mdl_SowuProduct extends shopObject
{
	function getcolumns( $filter )
	{
		$columns = array(
				"bn" => array(
						"label" => "商品编号",
						"class" => "span-3",
						"fuzzySearch" => 1,
						"required" => true,
						"primary" => true
				),
				"name" => array(
						"label" => "商品名称",
						"class" => "span-8",
						"fuzzySearch" => 1,
						"required" => true,
						"primary" => true,
						"type" => "goods_name"
				)
				
		);
		
		return  $columns;
	}
	
	function GetSowuProducts($page,&$count)
	{	
		$products = array();
		
		///计算页数
		$m = $page * 10;
		$currenturl = 1;
		if($m >= 100)
		{
			$tempn = $m % 100;
			$currenturl = ($m - $tempn) / 100;
			$currenturl += 1;
		}else {
			$tempn = $m;
		}
		////************///////////////

		$prodXml = simplexml_load_file("http://www.sowu.com/products/goods_on_sale_api_".$currenturl.".xml");
		
		$itemcount = $prodXml->total;
		
		if($itemcount == 0)
		{
			return $products;
		}
		
		if($itemcount > 10)
		{
			$n = $itemcount % 10;
			$urlcount = ($itemcount - $n) / 10;
			if($n > 0)
			{
				$urlcount = $urlcount + 1;
			}
			$count = $urlcount;
		}else {
			$count = 1;
		}
		
		$i = 0;
		$s = 0;
		$e = 10;
		
		if(isset($tempn))
		{
			$s = $tempn;
			$e = $s + 10;
		}
		
		$pids = "";
		
		//die("$s= ".$s."  $e=".$e."  $currenturl=".$currenturl);
		foreach ($prodXml->ids->children() as $item)
		{

			if($i >= $s && $i < $e)
			{
				$pids = $pids . $item . ",";
			}
			
			$i++;
			
		}
		
		
		if($pids != "")
		{
			$pids = substr($pids,0, strlen($pids) - 1);
		}
		
		
		$products = $this->GetSowuProdInfo($pids);
		
		
		return $products;
	}
	
	function GetSowuProductsForTitle($page,&$count,$title)
	{
		$products = array();
	
		///计算页数
		$m = $page * 10;
		$currenturl = 1;
		if($m > 100)
		{
			$tempn = $m % 100;
			$currenturl = ($m - $tempn) / 100;
			$currenturl += 1;
		}else {
			$tempn = $m;
		}
		////************///////////////
		
		$prodXml = simplexml_load_file("http://www.sowu.com/products/search_goods_on_sale_api_".$currenturl.".xml?".$title);
		
		$itemcount = $prodXml->total;
		
		if($itemcount == 0)
		{
			return $products;
		}
		
		if($itemcount > 10)
		{
			$n = $itemcount % 10;
			$urlcount = ($itemcount - $n) / 10;
			if($n > 0)
			{
				$urlcount = $urlcount + 1;
			}
			$count = $urlcount;
		}else {
			$count = 1;
		}
	
		
	
		$i = 0;
		$s = 0;
		$e = 10;
	
		if(isset($tempn))
		{
			$s = $tempn;
			$e = $s + 10;
		}
	
		$pids = "";
	
		//die("$s= ".$s."  $e=".$e."  $currenturl=".$currenturl);
		foreach ($prodXml->ids->children() as $item)
		{
	
			if($i >= $s && $i < $e)
			{
				$pids = $pids . $item . ",";
			}
				
			$i++;	
		}
	
		if($pids != "")
		{
			$pids = substr($pids,0, strlen($pids) - 1);
		}
		
		$products = $this->GetSowuProdInfo($pids);
	
		return $products;
	}
	
	//记录到图片数据库
	function saveimg(&$arrData)
	{
		$arrimgid = array();
		foreach ($arrData as $k => $v)
		{
			$rs = $this->db->exec( "select * from ".DB_PREFIX."gimages where 0=1" );
			$sql = $this->db->getinsertsql( $rs, $v);
			$this->db->exec( $sql );
			$arrimgid[$k] = $this->db->lastinsertid();
		}
		
		foreach ($arrimgid as $key => $value)
		{
			$arrData[$key]["gimage_id"] = $value;
		}
	}
	
	function delimg($imdID)
	{
		$this->db->exec( "delete from ".DB_PREFIX."gimages where gimage_id = ".$imdID);
	}
	
	
	function GetSowuProdInfo($id,$is_one = false)
	{
		
		$prodXml = simplexml_load_file("http://www.sowu.com/products/goods_api_ids_". $id .".xml");
		
		$products = array();
		
		$arrProd = array();
		
		
		if(!empty($prodXml))
		{
			$pxml = $prodXml->product;
			
			if(empty($pxml))
			{
				return $products;
			}
			
			foreach ($pxml as $item)
			{
				$arrProd = array();
				
				foreach ($item->children() as $t)
				{
					if($t->getName() == "skulist")
					{
						$temp = array();
						foreach ($t->children() as $sku)
						{
							$temp2 = array();
							foreach ($sku->children() as $skui)
							{
								$temp2[$skui->getName()] = $skui;
							}
							$temp[] = $temp2;
						}
						
						$arrProd[$t->getName()] = $temp;
						
					}else if($t->getName() == "gallerylist"){
						$temp = array();
						foreach ($t->children() as $sku)
						{
							$temp2 = array();
							foreach ($sku->children() as $skui)
							{
								$temp2[$skui->getName()] = $skui;
							}
							$temp[] = $temp2;
						}
						
						$arrProd[$t->getName()] = $temp;
					}else if ($t->getName() == "goods_thumb"){
						$strArr = explode(".",$t);
						$arrProd[$t->getName()] = $strArr[0]."_s".".".$strArr[1];
					}else {
						$arrProd[$t->getName()] = $t;
					}
				}
				$products[] = $arrProd;
			}
		}
			
		
		return $products;
	}
	
	function AddProdCat($name)
	{
		$catid = 0;
		
		//$aCats = $this->db->select( "SELECT cat_id FROM sdb_goods_cat WHERE type_id = 1 and cat_name = '".$name."'" );

		$catid = $this->SaveProdCat($name);		

		
		return $catid;
	}
	
	function SaveProdCat($name)
	{
		$modelCat = $this->system->loadmodel( "goods/productCat" );
		$data = array();
		$data["parent_id"] = "0";
		$data["cat_id"] = "";
	
		$data["type_id"] = 1;
		$data["cat_name"] = $name;
	
		$data["p_order"] = 1;
	
		$data["keywords"] = "";
		$data["description"] = "";
	
		//child_count
		
		$catlist = $modelCat->getcat(); //的到一级类目

		$cat_id = false;
		
		foreach ($catlist as $key => $value)
		{
			//print( $key. "  : " . $value["cat_id"].$value["cat_name"]."<br/>");
			if($value["cat_name"] == $name && $value["type_id"] == 1)
			{
				$cat_id = $value["cat_id"];
				break;
			}
			
		}
			
		if($cat_id)
		{
			return $cat_id;
		}else {
			$ret = $modelCat->addnew($data);
		}
		
		if($ret)
		{
			$id = $modelCat->db->lastinsertid( );
		}else {
			$id = false;
		}
	
		return $id;
	}
	
	
	function SavaSaleProd($data)
	{
		$modelSale = $this->system->loadmodel( "goods/specification" );
		
		$retArray = array();
		
		if(is_array($data["skulist"]))
		{
			if( count($data["skulist"]) > 1 || $data["skulist"][0]["skuattrname"] != "")
			{
				//$modelSale = $this->system->loadmodel( "goods/specification" );
				$skudata = array();
				$skudata["spec_name"] = "规格";
				$skudata["spec_memo"] = $data["goods_sn"];
				$skudata["spec_type"] = "text";
				$skudata["spec_show_type"] = "flat";
				
				$skudata["spec_value"] = array();
				
				$skulist = array();
				
				foreach ($data["skulist"] as $item)
				{
					$skuItem = array(); //记录单个销售属性
					
					$strTemp = $item["skuattrname"];
					
					$skuItem["sName"] = $strTemp;   //记录原值ֵ
					
					$strTemp_array = explode(";", $strTemp);

					$strSpecValue = "";
					
					foreach ($strTemp_array as $k => $v)
					{
						$temparr = explode(":" ,$v);
						$strSpecValue .= $temparr[1]. ";";
					}
					
					$skudata["spec_value"][] = $strSpecValue;
					
					$skuItem["dName"] = $strSpecValue;   //记录新值ֵ
					
					$skulist[$strSpecValue] = $skuItem;
				}
				
				$skudata["val"] = array();
				
				$skudata["val"][] = "";
				$skudata["val"][] = "";
				$skudata["val"][] = "";
				
				$retArray["skuItems"] = $skulist;
				$retArray["skuName"] = $skudata["spec_name"];
				
				//$specTable = $modelSale->getspecidlistbyname($tdata);
				$sqlString = "SELECT spec_id,spec_name FROM ".$modelSale->tableName ." WHERE spec_memo ='".$skudata["spec_memo"]."'";
				$specTable = $this->db->select( $sqlString );
				
				if(count($specTable) > 0)
				{
					$retArray["skuId"] = $specTable[0]["spec_id"];         //读取并记录销售属性类ID
				
					$speclist = $modelSale->getvaluelist($retArray["skuId"]); //读取销售属性列表
				
					foreach ($speclist as $key => $value)
					{
						$retArray["skuItems"][$value["spec_value"]]["id"] = $key;   //记录单个属性的ID；
					}		
				
				}else {
							
					$ret = $modelSale->tosave($skudata);
	
					if($ret)
					{
						$sqlString = "SELECT spec_id,spec_name FROM ".$modelSale->tableName ." WHERE spec_memo ='".$skudata["spec_memo"]."'";
						$specTable = $this->db->select( $sqlString );
						if(count($specTable) > 0)
						{
							$retArray["skuId"] = $specTable[0]["spec_id"];         //读取并记录销售属性类ID
							
							$speclist = $modelSale->getvaluelist($retArray["skuId"]); //读取销售属性列表
						
							foreach ($speclist as $key => $value)
							{
								$retArray["skuItems"][$value["spec_value"]]["id"] = $key;   //记录单个属性的ID；
							}
						
						}
					}
				}
				
			}
		}
		
		return $retArray;
	}
	
	function getcatidbyalias( $alias )
	{
		$alias = trim( $alias );
		if ( $alias )
		{
			if ( strstr( $alias, "->" ) )
			{
				$aCatName = explode( "->", $alias );
				$cat_name = $aCatName[count( $aCatName ) - 1];
				$sql = "SELECT cat_id,parent_id,cat_name,cat_path FROM sdb_goods_cat WHERE cat_name = '".$cat_name."'";
				$aRows = $this->db->select( $sql );
				if ( count( $aRows ) == 1 )
				{
					return $aRows[0]['cat_id'];
				}
				foreach ( $aRows as $k => $row )
				{
					$errStatus = false;
					$aTmp = explode( ",", $row['cat_path'] );
					$aId = array( );
					foreach ( $aTmp as $cid )
					{
						if ( $cid )
						{
							$aId[] = $cid;
						}
					}
					if ( !( count( $aId ) == count( $aCatName ) - 1 ) )
					{
						continue;
					}
					$iLoop = 0;
					foreach ( $aId as $i => $catid )
					{
						$sql = "SELECT count(*) AS num FROM sdb_goods_cat WHERE cat_name = '".$aCatName[$i]."' AND cat_id =".$catid;
						$aTmp = $this->db->selectrow( $sql );
						if ( !$aTmp['num'] )
						{
							break;
						}
						++$iLoop;
					}
					if ( !( count( $aId ) == $iLoop ) )
					{
						continue;
					}
					$cat_id = $row['cat_id'];
					break;
				}
				if ( $cat_id )
				{
					return $cat_id;
				}
				return false;
			}
			$sql = "SELECT cat_id FROM sdb_goods_cat WHERE cat_name = '".$alias."'";
			$row = $this->db->selectrow( $sql );
			if ( $row['cat_id'] )
			{
				return $row['cat_id'];
			}
			return false;
		}
	}
	
	
}


?>