<?php
class Image {
	var $path;
	
	var $imgname = "temp";
	
	private $m_imgInfo;
	
	private $m_srcImg;
	
	var $imgType;
	
	var $imgWidth;
	var $imgHeight;
	
	//췽ͼƬλýгʹ
	function __construct($path="./"){
		$this->path=rtrim($path, "/")."/";
	}
	/* ͼƬ
	 *
	* $name: ҪͼƬ
	* $width:źĿ
	* $height:źĸ߶
	* $qz: ͼƬǰ׺
	* ֵ:źͼƬƣʧ򷵻false
	*
	*/
	function thumb($name, $width, $height, $qz="th_"){
		//ȡͼƬϢ
		$imgInfo=$this->getInfo($name); //ͼƬĿȣ߶ȣ
		//ȡͼƬԴ, ͵ͼƬԴԴ jpg, gif, png
		$srcImg=$this->getImg($name, $imgInfo);
		//ȡͼƬȱ֮ĴС, $size["width"], $size["height"]
		$size=$this->getNewSize($name, $width, $height, $imgInfo);
		//ȡµͼƬԴ, һgif͸
		$newImg=$this->kidOfImage($srcImg, $size, $imgInfo);
		//ΪһµͼƬµźͼƬ
		return $this->createNewImage($newImg, $qz.$this->imgname, $imgInfo);
	}
	
	function GetURLimg($url)
	{
		$baseUrl = $this->path.$this->imgname;
		
		//file_put_contents($baseUrl, file_get_contents($url));
		ob_start();
		readfile($url);
		$img_data = ob_get_contents();
		ob_end_clean();
		
		$size = strlen($img_data);
		$local_file = fopen($baseUrl , 'a');
		fwrite($local_file, $img_data);
		fclose($local_file);
		
		
		$this->m_imgInfo = $this->getInfo($baseUrl); //ͼƬĿȣ߶ȣ
		$this->m_srcImg = $this->getImg($baseUrl, $this->m_imgInfo);
		
		$this->imgWidth = $this->m_imgInfo["width"];
		$this->imgHeight = $this->m_imgInfo["height"];
		
	}
	
	function thumbTOimg($width, $height,$qz = "")
	{
		$size=$this->getNewSize($this->imgname, $width, $height, $this->m_imgInfo);
		//ȡµͼƬԴ, һgif͸
		$newImg=$this->kidOfImage($this->m_srcImg, $size, $this->m_imgInfo);
		//ΪһµͼƬµźͼƬ
		
		$tempNamearr = explode(".", $this->imgname);
		
		$name = $tempNamearr[0].$qz.".".$tempNamearr[1];
		
		return $this->createNewImage($newImg, $name, $this->m_imgInfo);
	}
	
	
	function SetSaveImgName($name)
	{
		$this->imgname = $name;
	}

	private function createNewImage($newImg, $newName, $imgInfo){
		switch($imgInfo["type"]){
			case 1://gif
				$this->imgType = ".gif";
				$result=imageGif($newImg, $this->path.$newName);
				
				break;
			case 2://jpg
				$this->imgType = ".jpg";
				$result=imageJPEG($newImg, $this->path.$newName);
				
				break;
			case 3://png
				$this->imgType = "png";
				$return=imagepng($newImg, $this->path.$newName);
				
				break;
		}
		imagedestroy($newImg);
		return $newName;
	}

	private function kidOfImage($srcImg, $size, $imgInfo){
		$newImg=imagecreatetruecolor($size["width"], $size["height"]);
		 
		$otsc=imagecolortransparent($srcImg);

		if($otsc >=0 && $otsc <= imagecolorstotal($srcImg)){
			$tran=imagecolorsforindex($srcImg, $otsc);

			$newt=imagecolorallocate($newImg, $tran["red"], $tran["green"], $tran["blue"]);

			imagefill($newImg, 0, 0, $newt);

			imagecolortransparent($newImg, $newt);
		}

		imagecopyresized($newImg, $srcImg, 0, 0, 0, 0, $size["width"], $size["height"], $imgInfo["width"], $imgInfo["height"]);

		//imagedestroy($srcImg);

		return $newImg;
	}

	private function getNewSize($name, $width, $height, $imgInfo){
		$size["width"]=$imgInfo["width"];
		$size["height"]=$imgInfo["height"];

		//ŵĿԭͼСÿ
		if($width < $imgInfo["width"]){
			$size["width"]=$width;
		}
		//ŵĸ߶ԭͼСø߶
		if($height < $imgInfo["height"]){
			$size["height"]=$height;
		}

		//ͼƬȱŵ㷨
		if($imgInfo["width"]*$size["width"] > $imgInfo["height"] * $size["height"]){
			$size["width"]=round($imgInfo["width"]*$size["height"]/$imgInfo["height"]);
		}else{
			$size["height"]=round($imgInfo["height"]*$size["width"]/$imgInfo["width"]);
		}
		

		return $size;

	}

	private function getInfo($name){
		//$data=getImageSize($this->path.$name);
		//print($name);
		
		$data=getImageSize($name);
		
		$imageInfo["width"]=$data[0];
		$imageInfo["height"]=$data[1];
		$imageInfo["type"]=$data[2];

		return $imageInfo;
	}

	private function getImg($name, $imgInfo){
		//$srcPic=$this->path.$name;
		
		$srcPic=$name;
		
		switch($imgInfo["type"]){
			case 1: //gif
				$img=imagecreatefromgif($srcPic);
				break;
			case 2: //jpg
				$img=imageCreatefromjpeg($srcPic);
				break;
			case 3: //png
				$img=imageCreatefrompng($srcPic);
				break;
			default:
				return false;
				 
		}

		return $img;
	}
	/* ܣΪͼƬˮӡͼƬ
	 * $groundName: ͼƬҪˮӡͼƬ
	* $waterName: ˮǮͼƬ
	* #aterPostˮӡλã 10״̬
	*  0Ϊλ
	*
	*  1. Ϊ˾  2. Ϊ˾  3 Ϊ˾
	*  4  Ϊв  5. Ϊв  6 Ϊв
	*  7 . Ϊ׶˾ 8. Ϊ׶˾У 9. Ϊ׶˾
	*
	* $qz : ǼˮӡͼƬǰ׺
	* ֵǴͼƬ
	*
	*/
	function waterMark($groundName, $waterName, $waterPos=0, $qz="wa_"){
		 
		if(file_exists($this->path.$groundName) && file_exists($this->path.$waterName)){
			$groundInfo=$this->getInfo($groundName);
			$waterInfo=$this->getInfo($waterName);
			//ˮӡλ
			if(!$pos=$this->position($groundInfo, $waterInfo, $waterPos)){
				echo "ˮӡӦñȱͼƬС";
				return;
			}

			$groundImg=$this->getImg($groundName, $groundInfo);
			$waterImg=$this->getImg($waterName, $waterInfo);

			$groundImg=$this->copyImage($groundImg, $waterImg, $pos, $waterInfo);

			return $this->createNewImage($groundImg, $qz.$groundName, $groundInfo);
		}else{
			echo "ͼƬˮӡͼƬ";
			return false;
		}
	}

	private function copyImage($groundImg, $waterImg, $pos, $waterInfo){
		imagecopy($groundImg, $waterImg, $pos["posX"], $pos["posY"], 0, 0, $waterInfo["width"], $waterInfo["height"]);
		imagedestroy($waterImg);

		return $groundImg;
	}
	 
	private function position($groundInfo, $waterInfo, $waterPos){
		//ҪˮӡͼƬ
		if(($groundInfo["width"]< $waterInfo["width"]) ||($groundInfo["height"] < $waterInfo["height"])){
			return false;
		}

		switch($waterPos){
			case 1:
				$posX=0;
				$posY=0;
				break;
			case 2:
				$posX=($groundInfo["width"]-$waterInfo["width"])/2;
				$posY=0;
				break;
			case 3:
				$posX=$groundInfo["width"]-$waterInfo["width"];
				$posY=0;
				break;
			case 4:
				$posX=0;
				$posY=($groundInfo["height"]-$waterInfo["height"]) /2;
				break;
			case 5:
				$posX=($groundInfo["width"]-$waterInfo["width"])/2;
				$posY=($groundInfo["height"]-$waterInfo["height"]) /2;
				break;
			case 6:
				$posX=$groundInfo["width"]-$waterInfo["width"];
				$posY=($groundInfo["height"]-$waterInfo["height"]) /2;
				break;
			case 7:
				$posX=0;
				$posY=$groundInfo["height"]-$waterInfo["height"];
				break;
			case 8:
				$posX=($groundInfo["width"]-$waterInfo["width"])/2;
				$posY=$groundInfo["height"]-$waterInfo["height"];
				break;
			case 9:
				$posX=$groundInfo["width"]-$waterInfo["width"];
				$posY=$groundInfo["height"]-$waterInfo["height"];
				break;
			case 0:
			default:
				$posX=rand(0, ($groundInfo["width"]-$waterInfo["width"]));
				$posY=rand(0, ($groundInfo["height"]-$waterInfo["height"]));
				break;
		}

		return array("posX"=>$posX, "posY"=>$posY);
	}

}

?>