/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Expression;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.lib.Set;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class FunctionSQLInvoked
extends Expression {
    RoutineSchema routineSchema;
    Routine routine;

    FunctionSQLInvoked(RoutineSchema routineSchema) {
        super(27);
        this.routineSchema = routineSchema;
    }

    public void setArguments(Expression[] expressionArray) {
        this.nodes = expressionArray;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        Type[] typeArray = new Type[this.nodes.length];
        for (n = 0; n < this.nodes.length; ++n) {
            Expression expression2 = this.nodes[n];
            expression2.resolveTypes(session, this);
            typeArray[n] = expression2.dataType;
        }
        this.routine = this.routineSchema.getSpecificRoutine(typeArray);
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n].dataType != null) continue;
            this.nodes[n].dataType = this.routine.getParameterTypes()[n];
        }
        this.dataType = this.routine.getReturnType();
    }

    private Object getValueInternal(Session session) {
        Result result;
        boolean bl = false;
        int n = this.routine.getVariableCount();
        int n2 = this.routine.javaMethodWithConnection ? 1 : 0;
        Object[] objectArray = ValuePool.emptyObjectArray;
        Object object = null;
        boolean bl2 = true;
        if (n2 + this.nodes.length > 0) {
            objectArray = new Object[this.nodes.length + n2];
            if (n2 > 0) {
                objectArray[0] = session.getInternalConnection();
            }
        }
        Type[] typeArray = this.routine.getParameterTypes();
        try {
            for (int i = 0; i < this.nodes.length; ++i) {
                Expression expression = this.nodes[i];
                Object object2 = expression.getValue(session, typeArray[i]);
                if (object2 == null) {
                    if (this.routine.isNullInputOutput()) {
                        return null;
                    }
                    if (!this.routine.getParameter(i).isNullable()) {
                        return Result.newErrorResult(Error.error(4811));
                    }
                }
                if (this.routine.isPSM()) {
                    objectArray[i] = object2;
                    continue;
                }
                objectArray[i + n2] = expression.dataType.convertSQLToJava(session, object2);
            }
        }
        catch (Throwable throwable) {
            result = Result.newErrorResult(throwable);
        }
        if (bl2) {
            session.sessionContext.push();
        }
        if (this.routine.isPSM()) {
            try {
                session.sessionContext.routineArguments = objectArray;
                session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
                if (n > 0) {
                    session.sessionContext.routineVariables = new Object[n];
                }
                result = this.routine.statement.execute(session);
            }
            catch (Throwable throwable) {
                result = Result.newErrorResult(throwable);
            }
        } else {
            try {
                if (this.routine.dataImpact == 1) {
                    session.sessionContext.isReadOnly = Boolean.TRUE;
                    session.setNoSQL();
                } else if (this.routine.dataImpact == 2) {
                    session.sessionContext.isReadOnly = Boolean.TRUE;
                } else if (this.routine.dataImpact == 3) {
                    session.sessionContext.isReadOnly = Boolean.TRUE;
                }
                object = this.routine.javaMethod.invoke(null, objectArray);
                if (this.routine.returnsTable()) {
                    result = object instanceof JDBCResultSet ? ((JDBCResultSet)object).result : null;
                } else {
                    object = this.dataType.convertJavaToSQL(session, object);
                    bl = true;
                    result = Result.updateZeroResult;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                result = Result.newErrorResult(Error.error(6000, this.routine.getName().name), null);
            }
            catch (IllegalAccessException illegalAccessException) {
                result = Result.newErrorResult(Error.error(6000, this.routine.getName().name), null);
            }
            catch (Throwable throwable) {
                result = Result.newErrorResult(Error.error(6000, this.routine.getName().name), null);
            }
        }
        if (bl2) {
            session.sessionContext.pop();
        }
        if (bl) {
            return object;
        }
        return result;
    }

    @Override
    public Object getValue(Session session) {
        Object object = this.getValueInternal(session);
        if (object instanceof Result) {
            Result result = (Result)object;
            if (result.isError()) {
                throw result.getException();
            }
            if (result.isSimpleValue()) {
                object = result.getValueObject();
            } else if (result.isData()) {
                object = result;
            } else {
                throw Error.error(4605, this.routine.getName().name);
            }
        }
        return object;
    }

    @Override
    public Result getResult(Session session) {
        Object object = this.getValueInternal(session);
        if (object instanceof Result) {
            return (Result)object;
        }
        return Result.newPSMResult(object);
    }

    @Override
    void collectObjectNames(Set set) {
        set.add(this.routine.getSpecificName());
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.routineSchema.getName().getSchemaQualifiedStatementName());
        stringBuffer.append('(');
        for (int i = 0; i < this.nodes.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.nodes[i].getSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public String describe(Session session) {
        return super.describe(session);
    }

    public boolean isDeterministic() {
        return this.routine.isDeterministic();
    }
}

