/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.constant.Constable;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner scanner) {
        super(session, scanner);
    }

    Statement compileStatement(int n) {
        Statement statement = this.compilePart(n);
        if (this.token.tokenType == 848) {
            if (statement.getSchemaName() == null) {
                statement.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return statement;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String string, Result result) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Statement statement = null;
        this.reset(string);
        while (this.token.tokenType != 848) {
            statement = this.compilePart(result.getExecuteProperties());
            if (statement.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            hsqlArrayList.add(statement);
        }
        int n = result.getStatementType();
        if (n != 0) {
            int n2 = statement.getGroup();
            if (n2 == 2003) {
                if (n == 1) {
                    throw Error.error(1253);
                }
            } else if (n == 2) {
                throw Error.error(1254);
            }
        }
        return hsqlArrayList;
    }

    private Statement compilePart(int n) {
        Statement statement;
        this.compileContext.reset();
        this.setParsePosition(this.getPosition());
        if (this.token.tokenType == 849) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 249: 
            case 276: 
            case 317: 
            case 795: {
                statement = this.compileCursorSpecification(n);
                break;
            }
            case 306: {
                statement = this.compileShortCursorSpecification(n);
                break;
            }
            case 133: {
                statement = this.compileInsertStatement(RangeVariable.emptyArray);
                break;
            }
            case 301: {
                statement = this.compileUpdateStatement(RangeVariable.emptyArray);
                break;
            }
            case 164: {
                statement = this.compileMergeStatement(RangeVariable.emptyArray);
                break;
            }
            case 78: {
                statement = this.compileDeleteStatement(RangeVariable.emptyArray);
                break;
            }
            case 293: {
                statement = this.compileDeleteStatement(RangeVariable.emptyArray);
                break;
            }
            case 24: {
                statement = this.compileCallStatement(this.session.sessionContext.sessionVariablesRange, false);
                break;
            }
            case 252: {
                statement = this.compileSet();
                break;
            }
            case 265: {
                statement = this.compileStartTransaction();
                break;
            }
            case 43: {
                statement = this.compileCommit();
                break;
            }
            case 239: {
                statement = this.compileRollback();
                break;
            }
            case 244: {
                statement = this.compileSavepoint();
                break;
            }
            case 231: {
                statement = this.compileReleaseSavepoint();
                break;
            }
            case 54: {
                statement = this.compileCreate();
                break;
            }
            case 4: {
                statement = this.compileAlter();
                break;
            }
            case 87: {
                statement = this.compileDrop();
                break;
            }
            case 120: 
            case 237: {
                statement = this.compileGrantOrRevoke();
                break;
            }
            case 579: {
                statement = this.compileLock();
                break;
            }
            case 46: {
                statement = this.compileConnect();
                break;
            }
            case 83: {
                statement = this.compileDisconnect();
                break;
            }
            case 592: {
                statement = this.compileScript();
                break;
            }
            case 594: {
                statement = this.compileShutdown();
                break;
            }
            case 553: {
                statement = this.compileBackup();
                break;
            }
            case 559: {
                statement = this.compileCheckpoint();
                break;
            }
            case 568: {
                statement = this.compileExplainPlan();
                break;
            }
            case 76: {
                statement = this.compileDeclare();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (statement.type != 76) {
            statement.setSQL(this.getLastPart());
        }
        if (this.token.tokenType == 799) {
            this.read();
        } else if (this.token.tokenType == 848) {
            // empty if block
        }
        return statement;
    }

    private Statement compileDeclare() {
        ColumnSchema[] columnSchemaArray = this.readLocalVariableDeclarationOrNull();
        if (columnSchemaArray != null) {
            Object[] objectArray = new Object[]{columnSchemaArray};
            StatementSession statementSession = new StatementSession(1074, objectArray);
            return statementSession;
        }
        StatementDMQL statementDMQL = this.compileDeclareCursor();
        return statementDMQL;
    }

    private Statement compileScript() {
        String string = null;
        this.read();
        if (this.token.tokenType == 845) {
            if (this.token.dataType.typeCode != 1) {
                throw Error.error(5581);
            }
            string = this.token.tokenString;
            this.read();
        }
        Object[] objectArray = new Object[]{string};
        StatementCommand statementCommand = new StatementCommand(1004, objectArray);
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        statementCommand.readTableNames = hsqlNameArray;
        return statementCommand;
    }

    private Statement compileConnect() {
        String string = null;
        this.read();
        this.readThis(303);
        this.checkIsSimpleName();
        String string2 = this.token.tokenString;
        this.read();
        this.readThis(586);
        string = this.readPassword();
        Expression[] expressionArray = new Expression[]{new ExpressionValue(string2, Type.SQL_VARCHAR), new ExpressionValue(string, Type.SQL_VARCHAR)};
        StatementSession statementSession = new StatementSession(76, expressionArray);
        return statementSession;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 577: {
                this.read();
                this.readThis(496);
                HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{hsqlName};
                return new StatementCommand(1031, objectArray);
            }
            case 234: {
                this.read();
                this.readThis(582);
                this.readThis(243);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1037, objectArray);
            }
            case 276: {
                this.read();
                this.readThis(533);
                int n = 3;
                switch (this.token.tokenType) {
                    case 582: {
                        break;
                    }
                    case 557: {
                        n = 4;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1032, objectArray);
            }
            case 424: {
                int n;
                this.read();
                this.readThis(432);
                switch (this.token.tokenType) {
                    case 479: {
                        this.read();
                        this.readThis(365);
                        n = 2;
                        break;
                    }
                    case 505: {
                        this.read();
                        n = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                return new StatementCommand(1046, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object object;
        this.read();
        HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String string = this.token.tokenString;
        boolean bl = hsqlDatabaseProperties.isBoolean(this.token.tokenString);
        boolean bl2 = hsqlDatabaseProperties.isIntegral(this.token.tokenString);
        boolean bl3 = hsqlDatabaseProperties.isString(this.token.tokenString);
        if (!(bl || bl2 || bl3)) {
            throw Error.error(5555, string);
        }
        int n = bl ? 16 : (bl2 ? 4 : 1);
        this.read();
        if (this.token.tokenType == 292) {
            object = Boolean.TRUE;
            if (!bl) {
                throw Error.error(5563, this.token.tokenString);
            }
        } else if (this.token.tokenType == 105) {
            object = Boolean.FALSE;
            if (!bl) {
                throw Error.error(5563, this.token.tokenString);
            }
        } else {
            this.checkIsValue();
            object = this.token.tokenValue;
            if (this.token.dataType.typeCode != n) {
                throw Error.error(5563, this.token.tokenString);
            }
        }
        this.read();
        Object[] objectArray = new Object[]{string, object};
        return new StatementCommand(1034, objectArray);
    }

    private Statement compileSet() {
        int n = super.getPosition();
        this.session.setScripting(false);
        this.read();
        switch (this.token.tokenType) {
            case 348: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(66, objectArray);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(66, expressionArray);
            }
            case 496: {
                this.read();
                Expression expression = this.XreadValueSpecificationOrNull();
                if (expression == null) {
                    HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                    Object[] objectArray = new Object[]{hsqlName};
                    return new StatementSession(74, objectArray);
                }
                if (!expression.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] expressionArray = new Expression[]{expression};
                return new StatementSession(74, expressionArray);
            }
            case 279: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 489: {
                this.read();
                return this.compileSetRole();
            }
            case 507: {
                this.read();
                return this.compileSessionSettings();
            }
            case 524: {
                this.read();
                Object[] objectArray = this.processTransactionCharacteristics();
                if (objectArray[0] == null && objectArray[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(75, objectArray);
            }
            case 552: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1064, objectArray);
            }
            case 589: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(109, objectArray);
            }
            case 573: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{bl};
                return new StatementSession(1040, objectArray);
            }
            case 581: {
                this.read();
                Integer n2 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n2};
                return new StatementSession(1065, objectArray);
            }
            case 77: {
                this.read();
                this.readThis(276);
                this.readThis(533);
                int n3 = 3;
                switch (this.token.tokenType) {
                    case 582: {
                        break;
                    }
                    case 557: {
                        n3 = 4;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] objectArray = new Object[]{ValuePool.getInt(n3)};
                return new StatementCommand(1032, objectArray);
            }
            case 234: {
                this.read();
                this.readThis(582);
                this.readThis(510);
                Integer n4 = this.readIntegerObject();
                Object[] objectArray = new Object[]{n4};
                return new StatementSession(1066, objectArray);
            }
            case 276: {
                int n5;
                this.read();
                Table table = this.readTableName();
                Object[] objectArray = new Object[]{table.tableName, null};
                switch (this.token.tokenType) {
                    default: {
                        throw this.unexpectedToken();
                    }
                    case 511: {
                        this.read();
                        return this.compileTextTableSource(table);
                    }
                    case 479: {
                        this.read();
                        boolean bl = false;
                        if (this.token.tokenType == 545) {
                            this.read();
                        } else {
                            this.readThis(193);
                            bl = true;
                        }
                        objectArray[1] = bl;
                        return new StatementCommand(1082, objectArray, null, table.getName());
                    }
                    case 589: {
                        this.read();
                        Boolean bl = this.processTrueOrFalseObject();
                        objectArray[1] = bl;
                        return new StatementCommand(1082, objectArray, null, table.getName());
                    }
                    case 576: {
                        this.read();
                        this.checkIsValue();
                        String string = this.token.tokenString;
                        this.read();
                        objectArray[1] = string;
                        return new StatementCommand(1081, objectArray);
                    }
                    case 533: 
                }
                this.read();
                if (this.token.tokenType == 557) {
                    n5 = 4;
                } else if (this.token.tokenType == 582) {
                    n5 = 3;
                } else {
                    throw Error.error(5581);
                }
                this.read();
                objectArray[1] = new Integer(n5);
                return new StatementCommand(1085, objectArray, null, table.getName());
            }
            case 597: {
                this.read();
                int n6 = 0;
                if (this.token.tokenType == 292) {
                    n6 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 105) {
                    n6 = 0;
                    this.read();
                } else {
                    n6 = this.readInteger();
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (this.token.tokenType == 583) {
                        this.read();
                    } else {
                        n6 *= 1000;
                    }
                }
                Object[] objectArray = new Object[]{new Integer(n6)};
                return new StatementCommand(1026, objectArray, null, null);
            }
            case 586: {
                this.read();
                String string = this.readPassword();
                Object[] objectArray = new Object[]{null, string};
                return new StatementCommand(1062, objectArray);
            }
            case 577: {
                this.read();
                this.readThis(496);
                HsqlNameManager.HsqlName hsqlName = this.token.tokenType == 77 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{null, hsqlName};
                return new StatementCommand(1061, objectArray);
            }
            case 570: {
                return this.compileSetFilesProperty();
            }
            case 564: {
                return this.compileSetDatabaseProperty();
            }
            case 588: {
                return this.compileSetProperty();
            }
        }
        this.rewind(n);
        return this.compileSetStatement(this.session.sessionContext.sessionVariablesRange);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 358: {
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.read();
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1039, objectArray, null, null);
            }
            case 77: {
                return this.compileSetDefault();
            }
            case 567: {
                this.read();
                this.readThis(641);
                this.readThis(432);
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1015, objectArray, null, null);
            }
            case 571: {
                this.read();
                Integer n = this.readIntegerObject();
                Object[] objectArray = new Object[]{n};
                return new StatementCommand(1033, objectArray, null, null);
            }
            case 590: {
                this.read();
                this.readThis(575);
                boolean bl = this.processTrueOrFalse();
                Object[] objectArray = new Object[]{bl};
                return new StatementCommand(1041, objectArray, null, null);
            }
            case 259: {
                this.read();
                int n = 0;
                Boolean bl = null;
                switch (this.token.tokenType) {
                    case 510: {
                        this.read();
                        n = 1043;
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    case 445: {
                        this.read();
                        n = 1042;
                        bl = this.processTrueOrFalseObject();
                        break;
                    }
                    default: {
                        this.unexpectedToken();
                    }
                }
                Object[] objectArray = new Object[]{bl};
                return new StatementCommand(n, objectArray, null, null);
            }
            case 596: {
                this.read();
                this.readThis(276);
                this.readThis(381);
                String string = this.readQuotedString();
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1044, objectArray, null, null);
            }
            case 524: {
                this.read();
                this.readThis(563);
                int n = 0;
                switch (this.token.tokenType) {
                    case 647: {
                        this.read();
                        n = 2;
                        break;
                    }
                    case 648: {
                        this.read();
                        n = 1;
                        break;
                    }
                    case 580: {
                        this.read();
                        n = 0;
                    }
                }
                Object[] objectArray = new Object[]{ValuePool.getInt(n)};
                StatementCommand statementCommand = new StatementCommand(1045, objectArray, null, null);
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
                statementCommand.writeTableNames = hsqlNameArray;
                return statementCommand;
            }
            case 297: {
                this.read();
                this.readThis(444);
                this.isUndelimitedSimpleName();
                String string = this.token.tokenString;
                this.read();
                if (string.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(string, Charset.unquotedIdentifier) || !Charset.startsWith(string, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] objectArray = new Object[]{string};
                return new StatementCommand(1047, objectArray, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int n = 0;
        Boolean bl = null;
        Integer n2 = null;
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 579: {
                this.read();
                bl = this.processTrueOrFalseObject();
                n = 1017;
                break;
            }
            case 556: {
                this.read();
                if (this.readIfThis(510)) {
                    n2 = this.readIntegerObject();
                    n = 1013;
                    break;
                }
                if (!this.readIfThis(243)) break;
                n2 = this.readIntegerObject();
                n = 1012;
                break;
            }
            case 495: {
                this.read();
                n2 = this.readIntegerObject();
                n = 1023;
                break;
            }
            case 640: {
                this.read();
                this.readThis(495);
                n2 = this.readIntegerObject();
                n = 1016;
                break;
            }
            case 565: {
                this.read();
                n = 1014;
                n2 = this.readIntegerObject();
                break;
            }
            case 649: {
                this.read();
                n = 1020;
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 553: {
                this.read();
                n = 1011;
                this.readThis(417);
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 641: {
                this.read();
                if (this.token.tokenType == 510) {
                    this.readThis(510);
                    n = 1019;
                    n2 = this.readIntegerObject();
                    break;
                }
                n = 1018;
                bl = this.processTrueOrFalseObject();
                break;
            }
            case 595: {
                this.read();
                this.readThis(471);
                n = 1025;
                n2 = this.readIntegerObject();
                break;
            }
            case 545: {
                this.read();
                this.readThis(566);
                n = 1026;
                int n3 = 0;
                if (this.token.tokenType == 292) {
                    n3 = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 105) {
                    n3 = 0;
                    this.read();
                } else {
                    n3 = this.readInteger();
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    if (this.token.tokenType == 583) {
                        this.read();
                    } else {
                        n3 *= 1000;
                    }
                }
                n2 = new Integer(n3);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{bl == null ? (Constable)n2 : (Constable)bl};
        return new StatementCommand(n, objectArray, this.database.getCatalogName(), null);
    }

    Object[] processTransactionCharacteristics() {
        int n = 0;
        boolean bl = false;
        Object[] objectArray = new Object[2];
        block10: while (true) {
            switch (this.token.tokenType) {
                case 479: {
                    if (objectArray[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 193) {
                        this.read();
                        bl = true;
                    } else {
                        this.readThis(545);
                        bl = false;
                    }
                    objectArray[0] = bl;
                    continue block10;
                }
                case 424: {
                    if (objectArray[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(432);
                    switch (this.token.tokenType) {
                        case 505: {
                            this.read();
                            n = 8;
                            break;
                        }
                        case 479: {
                            this.read();
                            if (this.token.tokenType == 365) {
                                this.read();
                                n = 2;
                                break;
                            }
                            if (this.token.tokenType == 535) {
                                this.read();
                                n = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 481: {
                            this.read();
                            this.readThis(479);
                            n = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    objectArray[1] = new Integer(n);
                    continue block10;
                }
                case 784: {
                    if (objectArray[0] == null && objectArray[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        if (!bl && n == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return objectArray;
    }

    private boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 292) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 105) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    private Boolean processTrueOrFalseObject() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 292) {
            this.read();
            return Boolean.TRUE;
        }
        if (this.token.tokenType == 105) {
            this.read();
            return Boolean.FALSE;
        }
        throw this.unexpectedToken();
    }

    private Statement compileCommit() {
        boolean bl = false;
        this.read();
        this.readIfThis(544);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 178) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(350);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{bl};
        StatementSession statementSession = new StatementSession(11, objectArray);
        return statementSession;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(524);
        Object[] objectArray = this.processTransactionCharacteristics();
        StatementSession statementSession = new StatementSession(111, objectArray);
        return statementSession;
    }

    private Statement compileLock() {
        Object[] objectArray;
        this.read();
        this.readThis(276);
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        OrderedHashSet orderedHashSet2 = new OrderedHashSet();
        while (true) {
            objectArray = this.readTableName();
            switch (this.token.tokenType) {
                case 479: {
                    this.read();
                    orderedHashSet.add(objectArray.getName());
                    break;
                }
                case 545: {
                    this.read();
                    orderedHashSet2.add(objectArray.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 784) break;
            this.read();
        }
        objectArray = new HsqlNameManager.HsqlName[orderedHashSet2.size()];
        orderedHashSet2.toArray(objectArray);
        orderedHashSet.removeAll(objectArray);
        Object[] objectArray2 = new HsqlNameManager.HsqlName[orderedHashSet.size()];
        orderedHashSet.toArray(objectArray2);
        StatementSession statementSession = new StatementSession(1063, (HsqlNameManager.HsqlName[])objectArray2, (HsqlNameManager.HsqlName[])objectArray);
        return statementSession;
    }

    private Statement compileRollback() {
        boolean bl = false;
        String string = null;
        this.read();
        if (this.token.tokenType == 283) {
            this.read();
            this.readThis(244);
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            String string2 = this.getLastPart();
            Object[] objectArray = new Object[]{string};
            StatementSession statementSession = new StatementSession(1067, objectArray);
            return statementSession;
        }
        if (this.token.tokenType == 544) {
            this.read();
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 178) {
                this.read();
            } else {
                bl = true;
            }
            this.readThis(350);
        }
        String string3 = this.getLastPart();
        Object[] objectArray = new Object[]{bl};
        StatementSession statementSession = new StatementSession(62, objectArray);
        return statementSession;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(63, objectArray);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(244);
        String string = this.token.tokenString;
        this.read();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{string};
        return new StatementSession(57, objectArray);
    }

    private Statement compileSessionSettings() {
        if (this.token.tokenType == 354) {
            this.read();
            this.readThis(9);
            this.readThis(524);
            Object[] objectArray = this.processTransactionCharacteristics();
            return new StatementSession(109, objectArray);
        }
        if (this.token.tokenType == 14) {
            this.read();
            Expression expression = this.XreadValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(5584);
            }
            expression.resolveTypes(this.session, null);
            if (expression.isParam()) {
                expression.dataType = Type.SQL_VARCHAR;
            }
            if (expression.dataType == null || !expression.dataType.isCharacterType()) {
                throw Error.error(5563);
            }
            Expression[] expressionArray = new Expression[]{expression, null};
            return new StatementSession(76, expressionArray);
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression expression;
        if (this.token.tokenType == 179) {
            this.read();
            expression = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            expression = this.XreadValueSpecificationOrNull();
            if (expression == null) {
                throw Error.error(4100);
            }
            if (!expression.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(expression.getType() == 1 || expression.getType() == 28 && ((FunctionSQL)expression).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        String string = this.getLastPart();
        return new StatementSession(73, new Expression[]{expression});
    }

    private Statement compileSetTimeZone() {
        Object object;
        Expression expression;
        this.readThis(546);
        if (this.token.tokenType == 155) {
            this.read();
            expression = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
        } else {
            expression = this.XreadIntervalValueExpression();
            object = expression.resolveColumnReferences(RangeVariable.emptyArray, null);
            ExpressionColumn.checkColumnsResolved((HsqlList)object);
            expression.resolveTypes(this.session, null);
            if (expression.dataType == null) {
                throw Error.error(5563);
            }
            if (expression.dataType.typeCode != 111) {
                throw Error.error(5563);
            }
        }
        object = this.getLastPart();
        return new StatementSession(71, new Expression[]{expression});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int n = 2;
        this.read();
        switch (this.token.tokenType) {
            case 574: {
                n = 1;
                this.read();
                break;
            }
            case 561: {
                n = 3;
                this.read();
                break;
            }
            case 592: {
                n = 4;
                this.read();
            }
        }
        if (this.token.tokenType == 799) {
            this.read();
        }
        if (this.token.tokenType != 848) {
            throw this.unexpectedToken();
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{new Integer(n)};
        StatementCommand statementCommand = new StatementCommand(1003, objectArray, null, null);
        return statementCommand;
    }

    private Statement compileBackup() {
        this.read();
        this.readThis(564);
        this.readThis(283);
        this.checkIsValue();
        String string = this.readQuotedString();
        Boolean bl = null;
        Boolean bl2 = null;
        Boolean bl3 = null;
        block6: while (true) {
            switch (this.token.tokenType) {
                case 555: {
                    if (bl != null) {
                        throw this.unexpectedToken();
                    }
                    bl = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 592: {
                    if (bl2 != null) {
                        throw this.unexpectedToken();
                    }
                    bl2 = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 562: {
                    if (bl3 != null) {
                        throw this.unexpectedToken();
                    }
                    bl3 = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 181: {
                    this.read();
                    if (this.token.tokenType == 562) {
                        if (bl3 != null) {
                            throw this.unexpectedToken();
                        }
                        bl3 = Boolean.FALSE;
                        this.read();
                        continue block6;
                    }
                    if (this.token.tokenType == 555) {
                        bl = Boolean.FALSE;
                        this.read();
                        continue block6;
                    }
                    throw this.unexpectedToken();
                }
            }
            break;
        }
        if (bl2 != null) {
            throw this.unsupportedFeature("SCRIPT");
        }
        bl2 = Boolean.FALSE;
        if (bl == null) {
            throw this.unexpectedTokenRequire("BLOCKING");
        }
        if (bl3 == null) {
            bl3 = Boolean.TRUE;
        }
        Object[] objectArray = new Object[]{string, bl, bl2, bl3};
        StatementCommand statementCommand = new StatementCommand(1001, objectArray);
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames();
        statementCommand.writeTableNames = hsqlNameArray;
        return statementCommand;
    }

    private Statement compileCheckpoint() {
        boolean bl = false;
        this.read();
        if (this.token.tokenType == 565) {
            bl = true;
            this.read();
        } else if (this.token.tokenType == 799) {
            this.read();
        }
        if (this.token.tokenType != 848) {
            throw this.unexpectedToken();
        }
        String string = this.getLastPart();
        return ParserCommand.getCheckpointStatement(this.database, bl);
    }

    public static Statement getCheckpointStatement(Database database, boolean bl) {
        Object[] objectArray = new Object[]{bl};
        StatementCommand statementCommand = new StatementCommand(1002, objectArray);
        HsqlNameManager.HsqlName[] hsqlNameArray = database.schemaManager.getCatalogAndBaseTableNames();
        statementCommand.writeTableNames = hsqlNameArray;
        return statementCommand;
    }

    private Statement compileDisconnect() {
        this.read();
        String string = "DISCONNECT";
        StatementSession statementSession = new StatementSession(22, (Object[])null);
        return statementSession;
    }

    private Statement compileExplainPlan() {
        this.read();
        this.readThis(587);
        this.readThis(111);
        Statement statement = this.compilePart(0);
        statement.setDescribe();
        return statement;
    }

    private Statement compileTextTableSource(Table table) {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        Object[] objectArray = new Object[5];
        objectArray[0] = table.tableName;
        if (!table.isText()) {
            object = Error.error(321);
        }
        if (this.token.tokenType == 192) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.TRUE;
            return new StatementCommand(1083, objectArray, null, table.getName());
        }
        if (this.token.tokenType == 585) {
            this.read();
            object = this.getLastPart();
            objectArray[1] = Boolean.FALSE;
            return new StatementCommand(1083, objectArray, null, table.getName());
        }
        if (this.token.tokenType == 572) {
            this.read();
            bl = true;
        }
        if (!(this.token.tokenType == 847 || this.token.tokenType == 845 && this.token.dataType.isCharacterType())) {
            throw Error.error(5581);
        }
        String string = this.token.tokenString;
        this.read();
        if (!bl && this.token.tokenType == 389) {
            bl2 = true;
            this.read();
        }
        object = this.getLastPart();
        objectArray[2] = string;
        objectArray[3] = bl2;
        objectArray[4] = bl;
        int n = bl ? 1084 : 1083;
        return new StatementCommand(n, objectArray, null, table.getName());
    }
}

