/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.Grantee;

public final class Schema
implements SchemaObject {
    HsqlNameManager.HsqlName name;
    SchemaObjectSet triggerLookup;
    SchemaObjectSet constraintLookup;
    SchemaObjectSet indexLookup;
    SchemaObjectSet tableLookup;
    SchemaObjectSet sequenceLookup;
    SchemaObjectSet typeLookup;
    SchemaObjectSet charsetLookup;
    SchemaObjectSet collationLookup;
    SchemaObjectSet procedureLookup;
    SchemaObjectSet functionLookup;
    SchemaObjectSet specificRoutineLookup;
    SchemaObjectSet assertionLookup;
    HashMappedList tableList;
    HashMappedList sequenceList;
    Grantee owner;
    long changeTimestamp;

    Schema(HsqlNameManager.HsqlName hsqlName, Grantee grantee) {
        this.name = hsqlName;
        this.triggerLookup = new SchemaObjectSet(8);
        this.indexLookup = new SchemaObjectSet(20);
        this.constraintLookup = new SchemaObjectSet(5);
        this.tableLookup = new SchemaObjectSet(3);
        this.sequenceLookup = new SchemaObjectSet(7);
        this.typeLookup = new SchemaObjectSet(12);
        this.charsetLookup = new SchemaObjectSet(14);
        this.collationLookup = new SchemaObjectSet(15);
        this.procedureLookup = new SchemaObjectSet(17);
        this.functionLookup = new SchemaObjectSet(16);
        this.specificRoutineLookup = new SchemaObjectSet(24);
        this.assertionLookup = new SchemaObjectSet(6);
        this.tableList = (HashMappedList)this.tableLookup.map;
        this.sequenceList = (HashMappedList)this.sequenceLookup.map;
        this.owner = grantee;
        hsqlName.owner = grantee;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return this.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(this.name.statementName).append(' ');
        stringBuffer.append("AUTHORIZATION").append(' ');
        stringBuffer.append(this.owner.getStatementName());
        return stringBuffer.toString();
    }

    public String getDefinitionSQL() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(this.name.statementName).append(' ');
        stringBuffer.append("AUTHORIZATION").append(' ');
        stringBuffer.append(this.owner.getStatementName());
        return stringBuffer.toString();
    }

    static String getSetSchemaSQL(HsqlNameManager.HsqlName hsqlName) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("SCHEMA").append(' ');
        stringBuffer.append(hsqlName.statementName);
        return stringBuffer.toString();
    }

    public String[] getSQLArray(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        String string = Schema.getSetSchemaSQL(this.name);
        hsqlArrayList.add(string);
        Object[] objectArray = this.sequenceLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.tableLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.functionLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.procedureLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        objectArray = this.assertionLookup.getSQL(orderedHashSet, orderedHashSet2);
        hsqlArrayList.addAll(objectArray);
        if (hsqlArrayList.size() == 1) {
            return new String[0];
        }
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getSequenceRestartSQL() {
        String[] stringArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.sequenceLookup.map.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            String string = stringArray.getRestartSQL();
            hsqlArrayList.add(string);
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public String[] getTriggerSQL() {
        String[] stringArray;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Iterator iterator = this.tableLookup.map.values().iterator();
        while (iterator.hasNext()) {
            stringArray = (String[])iterator.next();
            Object[] objectArray = stringArray.getTriggerSQL();
            hsqlArrayList.addAll(objectArray);
        }
        stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    public void addSimpleObjects(OrderedHashSet orderedHashSet) {
        Iterator iterator = this.specificRoutineLookup.map.values().iterator();
        while (iterator.hasNext()) {
            Routine routine = (Routine)iterator.next();
            if (routine.dataImpact != 1 && routine.dataImpact != 2) continue;
            orderedHashSet.add(routine);
        }
        orderedHashSet.addAll(this.typeLookup.map.values());
        orderedHashSet.addAll(this.charsetLookup.map.values());
        orderedHashSet.addAll(this.collationLookup.map.values());
    }

    boolean isEmpty() {
        return this.sequenceLookup.isEmpty() && this.tableLookup.isEmpty() && this.typeLookup.isEmpty() && this.charsetLookup.isEmpty() && this.collationLookup.isEmpty() && this.specificRoutineLookup.isEmpty();
    }

    Iterator schemaObjectIterator(int n) {
        switch (n) {
            case 7: {
                return this.sequenceLookup.map.values().iterator();
            }
            case 3: 
            case 4: {
                return this.tableLookup.map.values().iterator();
            }
            case 14: {
                return this.charsetLookup.map.values().iterator();
            }
            case 15: {
                return this.collationLookup.map.values().iterator();
            }
            case 17: {
                return this.procedureLookup.map.values().iterator();
            }
            case 16: {
                return this.functionLookup.map.values().iterator();
            }
            case 18: {
                Iterator iterator = this.functionLookup.map.values().iterator();
                return new WrapperIterator(iterator, this.procedureLookup.map.values().iterator());
            }
            case 24: {
                return this.specificRoutineLookup.map.values().iterator();
            }
            case 12: 
            case 13: {
                return this.typeLookup.map.values().iterator();
            }
            case 6: {
                return this.assertionLookup.map.values().iterator();
            }
            case 8: {
                return this.triggerLookup.map.values().iterator();
            }
            case 20: {
                return this.indexLookup.map.values().iterator();
            }
            case 5: {
                return this.constraintLookup.map.values().iterator();
            }
        }
        throw Error.runtimeError(201, "Schema");
    }

    void clearStructures() {
        this.tableList.clear();
        this.sequenceList.clear();
        this.triggerLookup = null;
        this.indexLookup = null;
        this.constraintLookup = null;
        this.procedureLookup = null;
        this.functionLookup = null;
        this.sequenceLookup = null;
        this.tableLookup = null;
        this.typeLookup = null;
    }
}

