/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class StatementProcedure
extends StatementDMQL {
    Expression expression;
    Routine procedure;
    Expression[] arguments;
    ResultMetaData resultMetaData;

    StatementProcedure(Session session, Expression expression, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        this.expression = expression;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
        if (this.procedure != null) {
            session.getGrantee().checkAccess(this.procedure);
        }
    }

    StatementProcedure(Session session, Routine routine, Expression[] expressionArray, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        this.procedure = routine;
        this.arguments = expressionArray;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        return this.expression == null ? this.getProcedureResult(session) : this.getExpressionResult(session);
    }

    Result getProcedureResult(Session session) {
        Object[] objectArray;
        Object object;
        int n;
        Object[] objectArray2 = ValuePool.emptyObjectArray;
        if (this.arguments.length > 0) {
            objectArray2 = new Object[this.arguments.length];
        }
        for (n = 0; n < this.arguments.length; ++n) {
            object = this.arguments[n];
            objectArray = ((Expression)object).getValue(session);
            if (object == null) continue;
            Type type = this.procedure.getParameter(n).getDataType();
            objectArray2[n] = type.convertToType(session, objectArray, ((Expression)object).getDataType());
        }
        n = this.procedure.getVariableCount();
        session.sessionContext.push();
        session.sessionContext.routineArguments = objectArray2;
        session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
        if (n > 0) {
            session.sessionContext.routineVariables = new Object[n];
        }
        if (!((Result)(object = this.procedure.statement.execute(session))).isError()) {
            object = Result.updateZeroResult;
        }
        objectArray = session.sessionContext.routineArguments;
        session.sessionContext.pop();
        if (((Result)object).isError()) {
            return object;
        }
        boolean bl = false;
        for (int i = 0; i < this.procedure.getParameterCount(); ++i) {
            int n2;
            ColumnSchema columnSchema = this.procedure.getParameter(i);
            byte by = columnSchema.getParameterMode();
            if (by == 1) continue;
            if (this.arguments[i].isParam) {
                n2 = this.arguments[i].parameterIndex;
                session.sessionContext.dynamicArguments[n2] = objectArray[i];
                bl = true;
                continue;
            }
            n2 = this.arguments[i].getColumnIndex();
            session.sessionContext.routineVariables[n2] = objectArray[i];
        }
        if (bl) {
            object = Result.newCallResponse(this.getParametersMetaData().getParameterTypes(), this.id, session.sessionContext.dynamicArguments);
        }
        return object;
    }

    Result getExpressionResult(Session session) {
        session.sessionData.startRowProcessing();
        Object object = this.expression.getValue(session);
        if (object instanceof Result) {
            return (Result)object;
        }
        if (this.resultMetaData == null) {
            this.getResultMetaData();
        }
        Result result = Result.newSingleColumnResult(this.resultMetaData);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        result.getNavigator().add(objectArray);
        return result;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        switch (this.type) {
            case 7: {
                if (this.expression == null) {
                    return ResultMetaData.emptyResultMetaData;
                }
                ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
                ColumnBase columnBase = new ColumnBase(null, null, null, "@p0");
                columnBase.setType(this.expression.getDataType());
                resultMetaData.columns[0] = columnBase;
                resultMetaData.prepareData();
                this.resultMetaData = resultMetaData;
                return resultMetaData;
            }
        }
        throw Error.runtimeError(201, "StatementProcedure");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return super.getParametersMetaData();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet orderedHashSet) {
        if (this.expression == null) {
            orderedHashSet.addAll(this.procedure.getTableNamesForRead());
        } else {
            int n;
            for (n = 0; n < this.subqueries.length; ++n) {
                if (this.subqueries[n].queryExpression == null) continue;
                this.subqueries[n].queryExpression.getBaseTableNames(orderedHashSet);
            }
            for (n = 0; n < this.routines.length; ++n) {
                orderedHashSet.addAll(this.routines[n].getTableNamesForRead());
            }
        }
    }

    @Override
    void collectTableNamesForWrite(OrderedHashSet orderedHashSet) {
        if (this.expression == null) {
            orderedHashSet.addAll(this.procedure.getTableNamesForWrite());
        }
    }
}

