/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Comparator;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;

class SubQuery
implements Comparator {
    int level;
    private boolean isCorrelated;
    private boolean isExistsPredicate;
    private boolean uniqueRows;
    private boolean isUniquePredicate;
    QueryExpression queryExpression;
    Database database;
    private TableDerived table;
    View view;
    View parentView;
    Expression dataExpression;
    boolean isDataExpression;
    int parsePosition;
    public static final SubQuery[] emptySubqueryArray = new SubQuery[0];

    SubQuery(Database database, int n, QueryExpression queryExpression, int n2) {
        this.level = n;
        this.queryExpression = queryExpression;
        this.database = database;
        switch (n2) {
            case 55: {
                this.isExistsPredicate = true;
                break;
            }
            case 54: {
                this.uniqueRows = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
                break;
            }
            case 57: {
                this.isUniquePredicate = true;
                if (queryExpression == null) break;
                queryExpression.setFullOrder();
            }
        }
    }

    SubQuery(Database database, int n, QueryExpression queryExpression, View view) {
        this.level = n;
        this.queryExpression = queryExpression;
        this.database = database;
        this.view = view;
    }

    SubQuery(Database database, int n, Expression expression, int n2) {
        this.level = n;
        this.database = database;
        this.dataExpression = expression;
        expression.subQuery = this;
        this.isDataExpression = true;
        switch (n2) {
            case 54: {
                this.uniqueRows = true;
            }
        }
    }

    public boolean isCorrelated() {
        return this.isCorrelated;
    }

    public void setCorrelated() {
        this.isCorrelated = true;
    }

    public TableDerived getTable() {
        return this.table;
    }

    public void prepareTable(Session session) {
        if (this.table != null) {
            return;
        }
        if (this.view == null) {
            this.table = TableUtil.newSubqueryTable(this.database, null);
            if (this.isDataExpression) {
                TableUtil.setTableColumnsForSubquery(this.table, this.dataExpression.nodeDataTypes, this.uniqueRows || this.isUniquePredicate, this.uniqueRows);
            } else {
                TableUtil.setTableColumnsForSubquery(this.table, this.queryExpression, this.uniqueRows || this.isUniquePredicate);
            }
        } else {
            this.table = new TableDerived(this.database, this.view.getName(), 7, this.queryExpression);
            this.table.columnList = this.view.columnList;
            this.table.columnCount = this.table.columnList.size();
            this.table.createPrimaryKey();
        }
    }

    public void materialiseCorrelated(Session session) {
        if (this.isCorrelated) {
            this.materialise(session);
        }
    }

    public void materialise(Session session) {
        if (this.isDataExpression) {
            PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this.table);
            this.dataExpression.insertValuesIntoSubqueryTable(session, persistentStore);
            return;
        }
        Result result = this.queryExpression.getResult(session, this.isExistsPredicate ? 1 : 0);
        if (this.uniqueRows) {
            RowSetNavigatorData rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
            rowSetNavigatorData.removeDuplicates();
        }
        PersistentStore persistentStore = session.sessionData.getSubqueryRowStore(this.table);
        this.table.insertResult(persistentStore, result);
        result.getNavigator().close();
    }

    public boolean hasUniqueNotNullRows(Session session) {
        RowSetNavigatorDataTable rowSetNavigatorDataTable = new RowSetNavigatorDataTable(session, this.table);
        boolean bl = ((RowSetNavigatorData)rowSetNavigatorDataTable).hasUniqueNotNullRows();
        return bl;
    }

    public Object[] getValues(Session session) {
        RowIterator rowIterator = this.table.rowIterator(session);
        if (rowIterator.hasNext()) {
            Row row = rowIterator.getNextRow();
            if (rowIterator.hasNext()) {
                throw Error.error(3201);
            }
            return row.getData();
        }
        return new Object[this.table.getColumnCount()];
    }

    public Object getValue(Session session) {
        Object[] objectArray = this.getValues(session);
        return objectArray[0];
    }

    public RowSetNavigatorData getNavigator(Session session) {
        RowSetNavigatorDataTable rowSetNavigatorDataTable = new RowSetNavigatorDataTable(session, this.table);
        return rowSetNavigatorDataTable;
    }

    public int compare(Object object, Object object2) {
        SubQuery subQuery = (SubQuery)object;
        SubQuery subQuery2 = (SubQuery)object2;
        if (subQuery.parentView == null && subQuery2.parentView == null) {
            return subQuery2.level - subQuery.level;
        }
        if (subQuery.parentView != null && subQuery2.parentView != null) {
            int n;
            int n2 = this.database.schemaManager.getTableIndex(subQuery.parentView);
            int n3 = this.database.schemaManager.getTableIndex(subQuery2.parentView);
            if (n2 == -1) {
                n2 = this.database.schemaManager.getTables(subQuery.parentView.getSchemaName().name).size();
            }
            if (n3 == -1) {
                n3 = this.database.schemaManager.getTables(subQuery2.parentView.getSchemaName().name).size();
            }
            return (n = n2 - n3) == 0 ? subQuery2.level - subQuery.level : n;
        }
        return subQuery.parentView == null ? 1 : -1;
    }
}

