/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.CachedObject;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    LongDeque liveTransactionTimestamps = new LongDeque();
    AtomicLong globalChangeTimestamp = new AtomicLong();
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    int transactionCount = 0;
    int redoCount = 0;

    public TransactionManagerMVCC(Database database) {
        this.database = database;
        this.hasPersistence = this.database.logger.isLogged();
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new IntKeyHashMapConcurrent(10000);
        this.txModel = 2;
    }

    @Override
    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setTransactionControl(Session session, int n) {
        this.writeLock.lock();
        try {
            if (this.liveTransactionTimestamps.size() != 1) throw Error.error(3701);
            switch (n) {
                case 2: {
                    return;
                }
                case 1: {
                    TransactionManagerMV2PL transactionManagerMV2PL = new TransactionManagerMV2PL(this.database);
                    transactionManagerMV2PL.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                    transactionManagerMV2PL.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                    this.database.txManager = transactionManagerMV2PL;
                    return;
                }
                case 0: {
                    TransactionManager2PL transactionManager2PL = new TransactionManager2PL(this.database);
                    transactionManager2PL.globalChangeTimestamp.set(this.globalChangeTimestamp.get());
                    this.database.txManager = transactionManager2PL;
                    return;
                }
            }
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        Object[] objectArray = session.rowActionList.getArray();
        int n = session.rowActionList.size();
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n2;
            for (n2 = 0; n2 < n; n2 += 1) {
                object = (RowAction)objectArray[n2];
                if (((RowAction)object).canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionTimestamp = this.nextChangeTimestamp();
            for (n2 = 0; n2 < n; n2 += 1) {
                object = (RowAction)objectArray[n2];
                ((RowAction)object).prepareCommit(session);
            }
            for (n2 = 0; n2 < session.tempSet.size(); n2 += 1) {
                object = (Session)session.tempSet.get(n2);
                ((Session)object).abortTransaction = true;
            }
            n2 = 1;
            return n2 != 0;
        }
        finally {
            this.writeLock.unlock();
            session.tempSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int n = session.rowActionList.size();
        Object[] objectArray = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            Object object;
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                object = (RowAction)objectArray[n2];
                if (((RowAction)object).canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                return bl;
            }
            this.endTransaction(session);
            session.actionTimestamp = this.nextChangeTimestamp();
            for (n2 = 0; n2 < n; ++n2) {
                object = (RowAction)objectArray[n2];
                ((RowAction)object).commit(session);
            }
            for (n2 = 0; n2 < session.tempSet.size(); ++n2) {
                object = (Session)session.tempSet.get(n2);
                ((Session)object).abortTransaction = true;
            }
            this.persistCommit(session, objectArray, n);
            if (this.getFirstLiveTransactionTimestamp() > session.actionTimestamp) {
                this.mergeTransaction(session, objectArray, 0, n, session.actionTimestamp);
                this.finaliseRows(session, objectArray, 0, n, true);
            } else {
                objectArray = session.rowActionList.toArray();
                this.addToCommittedQueue(session, objectArray);
            }
            this.endTransactionTPL(session);
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
        }
        session.tempSet.clear();
        if (session != this.lobSession && this.lobSession.rowActionList.size() > 0) {
            this.lobSession.isTransaction = true;
            this.lobSession.actionIndex = this.lobSession.rowActionList.size();
            this.lobSession.commit(false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.actionTimestamp = this.nextChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n) {
        long l = session.sessionContext.savepointTimestamps.get(n);
        Integer n2 = (Integer)session.sessionContext.savepoints.get(n);
        int n3 = n2;
        while (session.sessionContext.savepoints.size() > n + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n3, l);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPartial(Session session, int n, long l) {
        Object[] objectArray = session.rowActionList.getArray();
        int n2 = session.rowActionList.size();
        if (n == n2) {
            return;
        }
        for (int i = n; i < n2; ++i) {
            RowAction rowAction = (RowAction)objectArray[i];
            if (rowAction != null) {
                rowAction.rollback(session, l);
                continue;
            }
            System.out.println("null action in rollback " + n);
        }
        this.writeLock.lock();
        try {
            this.mergeRolledBackTransaction(session, l, objectArray, n, n2);
            this.finaliseRows(session, objectArray, n, n2, false);
        }
        finally {
            this.writeLock.unlock();
        }
        session.rowActionList.setSize(n);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] nArray) {
        RowAction rowAction = this.addDeleteActionToRow(session, table, row, nArray);
        if (rowAction == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.tempSet.clear();
                    session.abortTransaction = true;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.tempSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl = this.checkDeadlock(session, session.tempSet);
                if (bl) {
                    Session session2 = (Session)session.tempSet.get(0);
                    session.redoAction = true;
                    session2.waitingSessions.add(session);
                    session.waitedSessions.add(session2);
                    session.latch.countUp();
                } else {
                    session.redoAction = false;
                    session.abortTransaction = true;
                }
                session.tempSet.clear();
                ++this.redoCount;
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, Row row) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        session.rowActionList.add(rowAction);
        if (!row.isMemory()) {
            this.rowActionMap.put(rowAction.getPos(), rowAction);
        }
    }

    @Override
    public boolean canRead(Session session, Row row, int n, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (n == 0) {
            if (rowAction == null) {
                return true;
            }
            return rowAction.canRead(session, 0);
        }
        if (n == 2) {
            boolean bl = rowAction == null ? true : rowAction.canRead(session, 0);
            return bl;
        }
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n);
    }

    @Override
    public boolean canRead(Session session, int n, int n2) {
        RowAction rowAction = (RowAction)this.rowActionMap.get(n);
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n2);
    }

    @Override
    public void setTransactionInfo(CachedObject cachedObject) {
        RowAction rowAction;
        Row row = (Row)cachedObject;
        row.rowAction = rowAction = (RowAction)this.rowActionMap.get(row.position);
    }

    @Override
    public void removeTransactionInfo(CachedObject cachedObject) {
        this.rowActionMap.remove(cachedObject.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] objectArray;
            long l2;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                l2 = this.committedTransactionTimestamps.getFirst();
                if (l2 >= l) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(session, objectArray, 0, objectArray.length, l2);
            this.finaliseRows(session, objectArray, 0, objectArray.length, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            session.isTransaction = true;
            this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginAction(Session session, Statement statement) {
        if (session.isTransaction) {
            return;
        }
        if (statement == null) {
            return;
        }
        this.writeLock.lock();
        try {
            session.isPreTransaction = true;
            if (!this.isLockedMode && !statement.isCatalogChange()) {
                return;
            }
            this.beingActionTPL(session, statement);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.nextChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.actionTimestamp);
            }
            session.isPreTransaction = false;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowAction addDeleteActionToRow(Session session, Table table, Row row, int[] nArray) {
        RowAction rowAction = null;
        Row row2 = row;
        synchronized (row2) {
            if (row.isMemory()) {
                rowAction = RowAction.addDeleteAction(session, table, row, nArray);
            } else {
                ReentrantReadWriteLock.WriteLock writeLock = this.rowActionMap.getWriteLock();
                writeLock.lock();
                try {
                    rowAction = (RowAction)this.rowActionMap.get(row.getPos());
                    if (rowAction == null) {
                        if (row.rowAction != null) {
                            rowAction = row.rowAction;
                        }
                        if ((rowAction = RowAction.addDeleteAction(session, table, row, nArray)) != null) {
                            this.rowActionMap.put(row.getPos(), rowAction);
                        }
                    } else {
                        if (row.rowAction != rowAction) {
                            rowAction = row.rowAction;
                        }
                        row.rowAction = rowAction;
                        rowAction = RowAction.addDeleteAction(session, table, row, nArray);
                    }
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
        return rowAction;
    }

    void endTransaction(Session session) {
        long l = session.transactionTimestamp;
        session.isTransaction = false;
        int n = this.liveTransactionTimestamps.indexOf(l);
        if (n >= 0) {
            this.liveTransactionTimestamps.remove(n);
            this.mergeExpiredTransactions(session);
        }
    }

    long getFirstLiveTransactionTimestamp() {
        if (this.liveTransactionTimestamps.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return this.liveTransactionTimestamps.get(0);
    }

    @Override
    public DoubleIntIndex getTransactionIDList() {
        return super.getTransactionIDList();
    }

    @Override
    public void convertTransactionIDs(DoubleIntIndex doubleIntIndex) {
        super.convertTransactionIDs(doubleIntIndex);
    }

    private void countDownLatches(Session session) {
        for (int i = 0; i < session.waitingSessions.size(); ++i) {
            Session session2 = (Session)session.waitingSessions.get(i);
            session2.waitedSessions.remove(session);
            session2.latch.countDown();
        }
        session.waitingSessions.clear();
    }

    void getTransactionSessions(HashSet hashSet) {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            long l = sessionArray[i].getTransactionTimestamp();
            if (this.liveTransactionTimestamps.contains(l)) {
                hashSet.add(sessionArray[i]);
                continue;
            }
            if (!sessionArray[i].isPreTransaction) continue;
            hashSet.add(sessionArray[i]);
        }
    }

    @Override
    void endTransactionTPL(Session session) {
        if (this.catalogWriteSession != session) {
            return;
        }
        this.catalogWriteSession = null;
        this.isLockedMode = false;
    }

    boolean beingActionTPL(Session session, Statement statement) {
        boolean bl;
        if (statement == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        session.tempSet.clear();
        if (statement.isCatalogChange()) {
            if (this.catalogWriteSession == null) {
                this.getTransactionSessions(session.tempSet);
                session.tempSet.remove(session);
                if (session.tempSet.isEmpty()) {
                    this.catalogWriteSession = session;
                    this.isLockedMode = true;
                } else {
                    this.catalogWriteSession = session;
                    this.isLockedMode = true;
                    this.setWaitingSessionTPL(session);
                }
                return true;
            }
            this.catalogWriteSession.waitingSessions.add(session);
            session.latch.countUp();
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        boolean bl2 = bl = statement.getTableNamesForRead().length > 0 || statement.getTableNamesForWrite().length > 0;
        if (!bl) {
            return true;
        }
        if (statement.getTableNamesForWrite().length > 0 ? statement.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME : statement.getTableNamesForRead().length > 0 && statement.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
            return true;
        }
        this.catalogWriteSession.waitingSessions.add(session);
        session.latch.countUp();
        return true;
    }
}

