/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.dbinfo;

import java.util.Locale;
import org.hsqldb.Table;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DITableInfo {
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    static final short tableIndexOther = 3;
    private static final int HALF_MAX_INT = 0x3FFFFFFF;
    private int hnd_column_remarks = -1;
    private int hnd_table_remarks = -1;
    private Table table;

    DITableInfo() {
        this.setupBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupBundles() {
        Class<BundleHandler> clazz = BundleHandler.class;
        synchronized (BundleHandler.class) {
            Locale locale = BundleHandler.getLocale();
            BundleHandler.setLocale(Locale.getDefault());
            this.hnd_column_remarks = BundleHandler.getBundleHandle("column-remarks", null);
            this.hnd_table_remarks = BundleHandler.getBundleHandle("table-remarks", null);
            BundleHandler.setLocale(locale);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    Integer getBRIPseudo() {
        return ValuePool.getInt(this.bestRowNotPseudo);
    }

    Integer getBRIScope() {
        return this.table.isWritable() ? ValuePool.getInt(this.bestRowTemporary) : ValuePool.getInt(this.bestRowSession);
    }

    String getColName(int n) {
        return this.table.getColumn((int)n).getName().name;
    }

    String getColRemarks(int n) {
        if (this.table.getTableType() != 0) {
            return null;
        }
        String string = this.getName() + "_" + this.getColName(n);
        return BundleHandler.getString(this.hnd_column_remarks, string);
    }

    String getHsqlType() {
        switch (this.table.getTableType()) {
            case 0: 
            case 2: 
            case 3: {
                return "MEMORY";
            }
            case 4: {
                return "CACHED";
            }
            case 5: 
            case 6: {
                return "TEXT";
            }
        }
        return null;
    }

    String getName() {
        return this.table.getName().name;
    }

    String getRemark() {
        return this.table.getTableType() == 0 ? BundleHandler.getString(this.hnd_table_remarks, this.getName()) : null;
    }

    String getJDBCStandardType() {
        switch (this.table.getTableType()) {
            case 7: {
                return "VIEW";
            }
            case 2: 
            case 5: {
                return "GLOBAL TEMPORARY";
            }
            case 0: {
                return "SYSTEM TABLE";
            }
        }
        if (this.table.getOwner().isSystem()) {
            return "SYSTEM TABLE";
        }
        return "TABLE";
    }

    Table getTable() {
        return this.table;
    }

    void setTable(Table table) {
        this.table = table;
    }
}

