/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Comparator;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.HsqlList;

public class HsqlArrayList
extends BaseList
implements HsqlList {
    private static final int DEFAULT_INITIAL_CAPACITY = 10;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    Object[] elementData;
    Object[] reserveElementData;
    private boolean minimizeOnClear;

    public HsqlArrayList(Object[] objectArray, int n) {
        this.elementData = objectArray;
        this.elementCount = n;
    }

    public HsqlArrayList() {
        this.elementData = new Object[10];
    }

    public HsqlArrayList(boolean bl) {
        this.elementData = new Object[10];
        this.minimizeOnClear = bl;
    }

    public HsqlArrayList(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        this.elementData = n == 0 ? new Object[1] : new Object[n];
    }

    @Override
    public void add(int n, Object object) {
        if (n > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + ">" + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        for (int i = this.elementCount; i > n; --i) {
            this.elementData[i] = this.elementData[i - 1];
        }
        this.elementData[n] = object;
        ++this.elementCount;
    }

    @Override
    public boolean add(Object object) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = object;
        ++this.elementCount;
        return true;
    }

    @Override
    public Object get(int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        return this.elementData[n];
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.elementCount; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object remove(int n) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        Object object = this.elementData[n];
        for (int i = n; i < this.elementCount - 1; ++i) {
            this.elementData[i] = this.elementData[i + 1];
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.clear();
        } else {
            this.elementData[this.elementCount] = null;
        }
        return object;
    }

    @Override
    public Object set(int n, Object object) {
        if (n >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n + " < 0");
        }
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    @Override
    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int n = this.elementData.length == 0 ? 1 : this.elementData.length;
        n = (int)((float)n * 2.0f);
        this.resize(n);
    }

    private void resize(int n) {
        if (n == this.elementData.length) {
            return;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), n);
        int n2 = this.elementData.length > objectArray.length ? objectArray.length : this.elementData.length;
        System.arraycopy(this.elementData, 0, objectArray, 0, n2);
        if (this.minimizeOnClear && this.reserveElementData == null) {
            ArrayUtil.clearArray(76, this.elementData, 0, this.elementData.length);
            this.reserveElementData = this.elementData;
        }
        this.elementData = objectArray;
    }

    public void trim() {
        this.resize(this.elementCount);
    }

    @Override
    public void clear() {
        if (this.minimizeOnClear && this.reserveElementData != null) {
            this.elementData = this.reserveElementData;
            this.reserveElementData = null;
            this.elementCount = 0;
            return;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int n) {
        if (n == 0) {
            this.clear();
            return;
        }
        if (n <= this.elementCount) {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
            this.elementCount = n;
            return;
        }
        while (n > this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementCount = n;
    }

    public Object[] toArray() {
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), this.elementCount);
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public Object[] toArray(int n, int n2) {
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), n2 - n);
        System.arraycopy(this.elementData, n, objectArray, 0, n2 - n);
        return objectArray;
    }

    public Object toArray(Object object) {
        if (Array.getLength(object) < this.elementCount) {
            object = Array.newInstance(object.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, object, 0, this.elementCount);
        return object;
    }

    public void sort(Comparator comparator) {
        if (this.elementCount < 2) {
            return;
        }
        ArraySort.sort(this.elementData, 0, this.elementCount, comparator);
    }

    public Object[] getArray() {
        return this.elementData;
    }
}

