/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long fileOffset;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;
    DoubleIntIndex transactionRowLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.cache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.dataFileName = string;
    }

    void process() {
        boolean bl = false;
        Error.printSystemOut("Defrag process begins");
        this.transactionRowLookup = this.database.txManager.getTransactionIDList();
        Error.printSystemOut("transaction count: " + this.transactionRowLookup.size());
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        this.rootsList = new int[hsqlArrayList.size()][];
        Storage storage = null;
        try {
            int n;
            OutputStream outputStream = this.database.logger.getFileAccess().openOutputStreamElement(this.dataFileName + ".new");
            this.fileStreamOut = new BufferedOutputStream(outputStream, 4096);
            for (n = 0; n < this.cache.initialFreePos; ++n) {
                this.fileStreamOut.write(0);
            }
            this.fileOffset = this.cache.initialFreePos;
            int n2 = hsqlArrayList.size();
            for (n = 0; n < n2; ++n) {
                Table table = (Table)hsqlArrayList.get(n);
                if (table.getTableType() == 4) {
                    int[] nArray = this.writeTableToDataFile(table);
                    this.rootsList[n] = nArray;
                } else {
                    this.rootsList[n] = null;
                }
                Error.printSystemOut("table: " + table.getName().name + " complete");
            }
            this.fileStreamOut.flush();
            this.fileStreamOut.close();
            this.fileStreamOut = null;
            n = this.database.logger.isStoredFileAccess() ? 3 : 0;
            storage = ScaledRAFile.newScaledRAFile(this.database, this.dataFileName + ".new", false, n);
            storage.seek(12L);
            storage.writeLong(this.fileOffset);
            n2 = 0;
            if (this.database.logger.propIncrementBackup) {
                n2 = BitMap.set(n2, 1);
            }
            n2 = BitMap.set(n2, 4);
            n2 = BitMap.set(n2, 2);
            storage.seek(28L);
            storage.writeInt(n2);
            storage.close();
            storage = null;
            for (int[] nArray : this.rootsList) {
                if (nArray == null) continue;
                Error.printSystemOut("roots: " + StringUtil.getList(nArray, ",", ""));
            }
            bl = true;
        }
        catch (IOException iOException) {
            throw Error.error(452, iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw Error.error(460, outOfMemoryError);
        }
        catch (Throwable throwable) {
            throw Error.error(458, throwable);
        }
        finally {
            try {
                if (this.fileStreamOut != null) {
                    this.fileStreamOut.close();
                }
                if (storage != null) {
                    storage.close();
                }
            }
            catch (Throwable throwable) {
                this.database.logger.logSevereEvent("backupFile failed", throwable);
            }
            if (!bl) {
                this.database.logger.getFileAccess().removeElement(this.dataFileName + ".new");
            }
        }
        Error.printSystemOut("Defrag transfer complete: " + this.stopw.elapsedTime());
    }

    void updateTableIndexRoots() {
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables();
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() != 4) continue;
            int[] nArray = this.rootsList[i];
            table.setIndexRoots(nArray);
        }
    }

    void updateTransactionRowIDs() {
        this.database.txManager.convertTransactionIDs(this.transactionRowLookup);
    }

    int[] writeTableToDataFile(Table table) throws IOException {
        Row row;
        Session session = this.database.getSessionManager().getSysSession();
        PersistentStore persistentStore = session.sessionData.getRowStore(table);
        RowOutputInterface rowOutputInterface = this.cache.rowOut.duplicate();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(persistentStore), false);
        int[] nArray = table.getIndexRootsArray();
        long l = this.fileOffset;
        int n = 0;
        doubleIntIndex.setKeysSearchTarget();
        Error.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIterator(persistentStore);
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            doubleIntIndex.addUnsorted(row.getPos(), (int)(l / (long)this.scale));
            if (n % 50000 == 0) {
                Error.printSystemOut("pointer pair for row " + n + " " + row.getPos() + " " + l);
            }
            l += (long)row.getStorageSize();
            ++n;
        }
        Error.printSystemOut("table: " + table.getName().name + " list done: " + this.stopw.elapsedTime());
        n = 0;
        rowIterator = table.rowIterator(persistentStore);
        while (rowIterator.hasNext()) {
            row = rowIterator.getNextRow();
            rowOutputInterface.reset();
            row.write(rowOutputInterface, doubleIntIndex);
            this.fileStreamOut.write(rowOutputInterface.getOutputStream().getBuffer(), 0, rowOutputInterface.size());
            this.fileOffset += (long)row.getStorageSize();
            if (n % 50000 == 0) {
                Error.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            ++n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = doubleIntIndex.findFirstEqualKeyIndex(nArray[i]);
            if (n2 == -1) {
                throw Error.error(466);
            }
            nArray[i] = doubleIntIndex.getValue(n2);
        }
        this.setTransactionRowLookups(doubleIntIndex);
        Error.printSystemOut("table: " + table.getName().name + " : table converted");
        return nArray;
    }

    public int[][] getIndexRoots() {
        return this.rootsList;
    }

    void setTransactionRowLookups(DoubleIntIndex doubleIntIndex) {
        int n = this.transactionRowLookup.size();
        for (int i = 0; i < n; ++i) {
            int n2 = this.transactionRowLookup.getKey(i);
            int n3 = doubleIntIndex.findFirstEqualKeyIndex(n2);
            if (n3 == -1) continue;
            this.transactionRowLookup.setValue(i, doubleIntIndex.getValue(n3));
        }
    }
}

