/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLMemory
extends RowStoreAVL
implements PersistentStore {
    Database database;
    int rowIdSequence = 0;

    public RowStoreAVLMemory(PersistentStoreCollection persistentStoreCollection, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        persistentStoreCollection.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(int n) {
        throw Error.runtimeError(201, "RowStoreAVMemory");
    }

    @Override
    public CachedObject getKeep(int n) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject get(int n, boolean bl) {
        throw Error.runtimeError(201, "RowStoreAVLMemory");
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        return cachedObject;
    }

    @Override
    public int getStorageSize(int n) {
        return 0;
    }

    @Override
    public void add(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        return null;
    }

    @Override
    public CachedObject getNewInstance(int n) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject getNewCachedObject(Session session, Object object) {
        int n;
        Object object2 = this;
        synchronized (object2) {
            n = this.rowIdSequence++;
        }
        object2 = new RowAVL(this.table, this.indexList.length, (Object[])object, n);
        if (session != null) {
            RowAction rowAction;
            ((Row)object2).rowAction = rowAction = new RowAction(session, this.table, 1, (Row)object2, null);
        }
        return object2;
    }

    @Override
    public void removeAll() {
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int n) {
    }

    @Override
    public void removePersistence(int n) {
    }

    @Override
    public void release(int n) {
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, (Table)this.table, objectArray);
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                this.delete(row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                row.delete(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return null;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, int n) {
    }

    @Override
    public void resetAccessorKeys(Index[] indexArray) {
        if (this.indexList.length == 0 || this.indexList[0] == null || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        CachedObject[] cachedObjectArray = this.accessorList;
        Index[] indexArray2 = this.indexList;
        int n = this.indexList.length;
        int n2 = 1;
        int n3 = 0;
        if (indexArray.length < this.indexList.length) {
            n2 = -1;
            n = indexArray.length;
        }
        while (n3 < n && this.indexList[n3] == indexArray[n3]) {
            ++n3;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, n3, n2);
        this.indexList = indexArray;
        try {
            if (n2 > 0) {
                this.insertIndexNodes(this.indexList[0], this.indexList[n3]);
            } else {
                this.dropIndexFromRows(this.indexList[0], indexArray2[n3]);
            }
        }
        catch (HsqlException hsqlException) {
            this.accessorList = cachedObjectArray;
            this.indexList = indexArray2;
            throw hsqlException;
        }
    }
}

