/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.error.Error;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInputTextLog
extends RowInputBase
implements RowInputInterface {
    Scanner scanner = new Scanner();
    String tableName = null;
    String schemaName = null;
    int statementType;
    Object value;
    boolean version18;

    public RowInputTextLog() {
        super(new byte[0]);
    }

    public RowInputTextLog(boolean bl) {
        super(new byte[0]);
        this.version18 = bl;
    }

    public void setSource(String string) {
        this.scanner.reset(string);
        this.statementType = 1;
        this.scanner.scanNext();
        String string2 = this.scanner.getString();
        if (string2.equals("INSERT")) {
            this.statementType = 3;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
            this.scanner.scanNext();
        } else if (string2.equals("DELETE")) {
            this.statementType = 2;
            this.scanner.scanNext();
            this.scanner.scanNext();
            this.tableName = this.scanner.getString();
        } else if (string2.equals("COMMIT")) {
            this.statementType = 4;
        } else if (string2.equals("SET")) {
            this.scanner.scanNext();
            if ("SCHEMA".equals(this.scanner.getString())) {
                this.scanner.scanNext();
                this.schemaName = this.scanner.getString();
                this.statementType = 6;
            }
        }
    }

    public int getStatementType() {
        return this.statementType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    protected void readField() {
        this.readFieldPrefix();
        this.scanner.scanNext();
        this.value = this.scanner.getValue();
    }

    protected void readNumberField(Type type) {
        boolean bl;
        this.readFieldPrefix();
        this.scanner.scanNext();
        boolean bl2 = bl = this.scanner.getTokenType() == 793;
        if (bl) {
            this.scanner.scanNext();
        }
        this.value = this.scanner.getValue();
        if (bl) {
            try {
                this.value = ((NumberType)this.scanner.getDataType()).negate(this.value);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    protected void readFieldPrefix() {
        this.scanner.scanNext();
        if (this.statementType == 2) {
            this.scanner.scanNext();
            this.scanner.scanNext();
        }
    }

    @Override
    public String readString() throws IOException {
        this.readField();
        return (String)this.value;
    }

    @Override
    public short readShort() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public int readInt() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public long readLong() throws IOException {
        throw Error.runtimeError(201, "");
    }

    @Override
    public int readType() throws IOException {
        return 0;
    }

    @Override
    protected boolean checkNull() {
        return false;
    }

    @Override
    protected String readChar(Type type) throws IOException {
        this.readField();
        return (String)this.value;
    }

    @Override
    protected Integer readSmallint() throws IOException {
        this.readNumberField(Type.SQL_SMALLINT);
        return (Integer)this.value;
    }

    @Override
    protected Integer readInteger() throws IOException {
        this.readNumberField(Type.SQL_INTEGER);
        return (Integer)this.value;
    }

    @Override
    protected Long readBigint() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        return ValuePool.getLong(((Number)this.value).longValue());
    }

    @Override
    protected Double readReal() throws IOException {
        this.readNumberField(Type.SQL_DOUBLE);
        if (this.value == null) {
            return null;
        }
        return (Double)this.value;
    }

    @Override
    protected BigDecimal readDecimal(Type type) throws IOException {
        this.readNumberField(type);
        if (this.value == null) {
            return null;
        }
        return (BigDecimal)type.convertToDefaultType(null, this.value);
    }

    @Override
    protected TimeData readTime(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Time time = Time.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(HsqlDateTime.tempCalDefault, time.getTime());
            l = HsqlDateTime.getNormalisedTime(l);
            return new TimeData((int)l / 1000, 0, 0);
        }
        return this.scanner.newTime((String)this.value);
    }

    @Override
    protected TimestampData readDate(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Date date = Date.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(HsqlDateTime.tempCalDefault, date.getTime());
            l = HsqlDateTime.getNormalisedDate(l);
            return new TimestampData(l / 1000L);
        }
        return this.scanner.newDate((String)this.value);
    }

    @Override
    protected TimestampData readTimestamp(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        if (this.version18) {
            Timestamp timestamp = Timestamp.valueOf((String)this.value);
            long l = HsqlDateTime.convertMillisFromCalendar(HsqlDateTime.tempCalDefault, timestamp.getTime());
            int n = timestamp.getNanos();
            DateTimeType cfr_ignored_0 = (DateTimeType)type;
            n = DateTimeType.normaliseFraction(n, type.scale);
            return new TimestampData(l / 1000L, n, 0);
        }
        return this.scanner.newTimestamp((String)this.value);
    }

    @Override
    protected IntervalMonthData readYearMonthInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalMonthData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected IntervalSecondData readDaySecondInterval(Type type) throws IOException {
        this.readField();
        if (this.value == null) {
            return null;
        }
        return (IntervalSecondData)this.scanner.newInterval((String)this.value, (IntervalType)type);
    }

    @Override
    protected Boolean readBoole() throws IOException {
        this.readFieldPrefix();
        this.scanner.scanNext();
        String string = this.scanner.getString();
        this.value = null;
        if (string.equalsIgnoreCase("TRUE")) {
            this.value = Boolean.TRUE;
        } else if (string.equalsIgnoreCase("FALSE")) {
            this.value = Boolean.FALSE;
        }
        return (Boolean)this.value;
    }

    @Override
    protected Object readOther() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return new JavaObjectData(((BinaryData)this.value).getBytes());
    }

    @Override
    protected BinaryData readBit() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBitStringWithQuote();
        if (this.scanner.getTokenType() == 855) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected BinaryData readBinary() throws IOException {
        this.readFieldPrefix();
        if (this.scanner.scanNull()) {
            return null;
        }
        this.scanner.scanBinaryStringWithQuote();
        if (this.scanner.getTokenType() == 856) {
            throw Error.error(5587);
        }
        this.value = this.scanner.getValue();
        return (BinaryData)this.value;
    }

    @Override
    protected ClobData readClob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new ClobDataID(l);
    }

    @Override
    protected BlobData readBlob() throws IOException {
        this.readNumberField(Type.SQL_BIGINT);
        if (this.value == null) {
            return null;
        }
        long l = ((Number)this.value).longValue();
        return new BlobDataID(l);
    }
}

