/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputBinary
extends RowOutputBase {
    protected static final int INT_STORE_SIZE = 4;
    int storageSize;
    final int scale;
    final int mask;

    public RowOutputBinary(int n, int n2) {
        super(n);
        this.scale = n2;
        this.mask = ~(n2 - 1);
    }

    public RowOutputBinary(byte[] byArray) {
        super(byArray);
        this.scale = 1;
        this.mask = ~(this.scale - 1);
    }

    @Override
    public void writeIntData(int n, int n2) {
        int n3 = this.count;
        this.count = n2;
        this.writeInt(n);
        if (this.count < n3) {
            this.count = n3;
        }
    }

    @Override
    public void writeData(Object[] objectArray, Type[] typeArray) {
        super.writeData(objectArray, typeArray);
    }

    @Override
    public void writeEnd() {
        if (this.count > this.storageSize) {
            Error.runtimeError(201, "RowOutputBinary");
        }
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    @Override
    public void writeSize(int n) {
        this.storageSize = n;
        this.writeInt(n);
    }

    @Override
    public void writeType(int n) {
        this.writeShort(n);
    }

    @Override
    public void writeString(String string) {
        int n = this.count;
        this.writeInt(0);
        if (string != null && string.length() != 0) {
            StringConverter.stringToUTFBytes(string, this);
            this.writeIntData(this.count - n - 4, n);
        }
    }

    @Override
    public int getSize(Row row) {
        Object[] objectArray = row.getData();
        Type[] typeArray = row.getTable().getColumnTypes();
        int n = row.getTable().getDataColumnCount();
        return 4 + this.getSize(objectArray, n, typeArray);
    }

    @Override
    public int getStorageSize(int n) {
        return n + this.scale - 1 & this.mask;
    }

    @Override
    protected void writeFieldType(Type type) {
        this.write(1);
    }

    @Override
    protected void writeNull(Type type) {
        this.write(0);
    }

    @Override
    protected void writeChar(String string, Type type) {
        this.writeString(string);
    }

    @Override
    protected void writeSmallint(Number number) {
        this.writeShort(number.intValue());
    }

    @Override
    protected void writeInteger(Number number) {
        this.writeInt(number.intValue());
    }

    @Override
    protected void writeBigint(Number number) {
        this.writeLong(number.longValue());
    }

    @Override
    protected void writeReal(Double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    protected void writeDecimal(BigDecimal bigDecimal, Type type) {
        int n = bigDecimal.scale();
        BigInteger bigInteger = JavaSystem.unscaledValue(bigDecimal);
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n);
    }

    @Override
    protected void writeBoolean(Boolean bl) {
        this.write(bl != false ? 1 : 0);
    }

    @Override
    protected void writeDate(TimestampData timestampData, Type type) {
        this.writeLong(timestampData.getSeconds());
    }

    @Override
    protected void writeTime(TimeData timeData, Type type) {
        this.writeInt(timeData.getSeconds());
        this.writeInt(timeData.getNanos());
        if (type.typeCode == 94) {
            this.writeInt(timeData.getZone());
        }
    }

    @Override
    protected void writeTimestamp(TimestampData timestampData, Type type) {
        this.writeLong(timestampData.getSeconds());
        this.writeInt(timestampData.getNanos());
        if (type.typeCode == 95) {
            this.writeInt(timestampData.getZone());
        }
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData intervalMonthData, Type type) {
        this.writeLong(intervalMonthData.units);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData intervalSecondData, Type type) {
        this.writeLong(intervalSecondData.units);
        this.writeInt(intervalSecondData.nanos);
    }

    @Override
    protected void writeOther(JavaObjectData javaObjectData) {
        this.writeByteArray(javaObjectData.getBytes());
    }

    @Override
    protected void writeBit(BinaryData binaryData) {
        this.writeInt((int)binaryData.bitLength(null));
        this.write(binaryData.getBytes(), 0, binaryData.getBytes().length);
    }

    @Override
    protected void writeBinary(BinaryData binaryData) {
        this.writeByteArray(binaryData.getBytes());
    }

    @Override
    protected void writeClob(ClobData clobData, Type type) {
        this.writeLong(clobData.getId());
    }

    @Override
    protected void writeBlob(BlobData blobData, Type type) {
        this.writeLong(blobData.getId());
    }

    public void writeByteArray(byte[] byArray) {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeCharArray(char[] cArray) {
        this.writeInt(cArray.length);
        this.write(cArray, 0, cArray.length);
    }

    private int getSize(Object[] objectArray, int n, Type[] typeArray) {
        int n2 = 0;
        block20: for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            ++n2;
            if (object == null) continue;
            switch (typeArray[i].typeCode) {
                case 0: {
                    continue block20;
                }
                case 1: 
                case 12: 
                case 100: {
                    n2 += 4;
                    n2 += StringConverter.getUTFSize((String)object);
                    continue block20;
                }
                case -6: 
                case 5: {
                    n2 += 2;
                    continue block20;
                }
                case 4: {
                    n2 += 4;
                    continue block20;
                }
                case 6: 
                case 7: 
                case 8: 
                case 25: {
                    n2 += 8;
                    continue block20;
                }
                case 2: 
                case 3: {
                    n2 += 8;
                    BigDecimal bigDecimal = (BigDecimal)object;
                    BigInteger bigInteger = JavaSystem.unscaledValue(bigDecimal);
                    n2 += bigInteger.toByteArray().length;
                    continue block20;
                }
                case 16: {
                    ++n2;
                    continue block20;
                }
                case 91: {
                    n2 += 8;
                    continue block20;
                }
                case 92: {
                    n2 += 8;
                    continue block20;
                }
                case 94: {
                    n2 += 12;
                    continue block20;
                }
                case 93: {
                    n2 += 12;
                    continue block20;
                }
                case 95: {
                    n2 += 16;
                    continue block20;
                }
                case 101: 
                case 102: 
                case 107: {
                    n2 += 8;
                    continue block20;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    n2 += 12;
                    continue block20;
                }
                case 60: 
                case 61: {
                    n2 += 4;
                    n2 = (int)((long)n2 + ((BinaryData)object).length(null));
                    continue block20;
                }
                case 14: 
                case 15: {
                    n2 += 4;
                    n2 = (int)((long)n2 + ((BinaryData)object).length(null));
                    continue block20;
                }
                case 30: 
                case 40: {
                    n2 += 8;
                    continue block20;
                }
                case 1111: {
                    JavaObjectData javaObjectData = (JavaObjectData)object;
                    n2 += 4;
                    n2 += javaObjectData.getBytesLength();
                    continue block20;
                }
                default: {
                    throw Error.runtimeError(201, "RowOutputBinary");
                }
            }
        }
        return n2;
    }

    @Override
    public void ensureRoom(int n) {
        super.ensureRoom(n);
    }

    @Override
    public void reset() {
        super.reset();
        this.storageSize = 0;
    }

    @Override
    public void reset(int n) {
        super.reset(n);
        this.storageSize = 0;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        this.buffer = byArray;
        this.reset();
    }

    @Override
    public RowOutputInterface duplicate() {
        return new RowOutputBinary(128, this.scale);
    }
}

