/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.Runtime;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class DataSourceResourceLoader
extends ResourceLoader {
    private String dataSourceName;
    private String tableName;
    private String keyColumn;
    private String templateColumn;
    private String timestampColumn;
    private InitialContext ctx;
    private DataSource dataSource;

    public void init(ExtendedProperties configuration) {
        this.dataSourceName = configuration.getString("resource.datasource");
        this.tableName = configuration.getString("resource.table");
        this.keyColumn = configuration.getString("resource.keycolumn");
        this.templateColumn = configuration.getString("resource.templatecolumn");
        this.timestampColumn = configuration.getString("resource.timestampcolumn");
        Runtime.info("Resources Loaded From: " + this.dataSourceName + "/" + this.tableName);
        Runtime.info("Resource Loader using columns: " + this.keyColumn + ", " + this.templateColumn + " and " + this.timestampColumn);
        Runtime.info("Resource Loader Initalized.");
    }

    public boolean isSourceModified(Resource resource) {
        return resource.getLastModified() != this.readLastModified(resource, "checking timestamp");
    }

    public long getLastModified(Resource resource) {
        return this.readLastModified(resource, "getting timestamp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (name == null) throw new ResourceNotFoundException("Need to specify a template name!");
        if (name.length() == 0) {
            throw new ResourceNotFoundException("Need to specify a template name!");
        }
        try {
            Connection conn = this.openDbConnection();
            try {
                ResultSet rs = this.readData(conn, this.templateColumn, name);
                try {
                    if (rs.next()) {
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(rs.getAsciiStream(this.templateColumn));
                        return bufferedInputStream;
                    }
                    String msg = "DataSourceResourceLoader Error: cannot find resource " + name;
                    Runtime.error(msg);
                    throw new ResourceNotFoundException(msg);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                this.closeDbConnection(conn);
            }
        }
        catch (Exception e) {
            String msg = "DataSourceResourceLoader Error: database problem trying to load resource " + name + ": " + e.toString();
            Runtime.error(msg);
            throw new ResourceNotFoundException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readLastModified(Resource resource, String i_operation) {
        String name = resource.getName();
        try {
            Connection conn = this.openDbConnection();
            try {
                ResultSet rs = this.readData(conn, this.timestampColumn, name);
                try {
                    if (rs.next()) {
                        long l = rs.getTimestamp(this.timestampColumn).getTime();
                        return l;
                    }
                    Runtime.error("DataSourceResourceLoader Error: while " + i_operation + " could not find resource " + name);
                    return 0L;
                }
                finally {
                    rs.close();
                }
            }
            finally {
                this.closeDbConnection(conn);
            }
        }
        catch (Exception e) {
            Runtime.error("DataSourceResourceLoader Error: error while " + i_operation + " when trying to load resource " + name + ": " + e.toString());
        }
        return 0L;
    }

    private Connection openDbConnection() throws Exception {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        if (this.dataSource == null) {
            this.dataSource = (DataSource)this.ctx.lookup(this.dataSourceName);
        }
        return this.dataSource.getConnection();
    }

    private void closeDbConnection(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            Runtime.info("DataSourceResourceLoader Quirk: problem when closing connection: " + e.toString());
        }
    }

    private ResultSet readData(Connection conn, String columnNames, String templateName) throws SQLException {
        Statement stmt = conn.createStatement();
        String sql = "SELECT " + columnNames + " FROM " + this.tableName + " WHERE " + this.keyColumn + " = '" + templateName + "'";
        return stmt.executeQuery(sql);
    }
}

