/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.JarHolder;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.StringUtils;

public class JarResourceLoader
extends ResourceLoader {
    private Hashtable entryDirectory = new Hashtable(559);
    private Hashtable jarfiles = new Hashtable(89);

    public void init(ExtendedProperties configuration) {
        this.rsvc.info("JarResourceLoader : initialization starting.");
        Vector paths = configuration.getVector("path");
        if ((paths == null || paths.size() == 0) && (paths = configuration.getVector("resource.path")) != null && paths.size() > 0) {
            this.rsvc.warn("JarResourceLoader : you are using a deprecated configuration property for the JarResourceLoader -> '<name>.resource.loader.resource.path'. Please change to the conventional '<name>.resource.loader.path'.");
        }
        this.rsvc.info("JarResourceLoader # of paths : " + paths.size());
        int i = 0;
        while (i < paths.size()) {
            this.loadJar((String)paths.get(i));
            ++i;
        }
        this.rsvc.info("JarResourceLoader : initialization complete.");
    }

    private void loadJar(String path) {
        this.rsvc.info("JarResourceLoader : trying to load: " + path);
        if (path == null) {
            this.rsvc.error("JarResourceLoader : can not load JAR - JAR path is null");
        }
        if (!path.startsWith("jar:")) {
            this.rsvc.error("JarResourceLoader : JAR path must start with jar: -> see java.net.JarURLConnection for information");
        }
        if (!path.endsWith("!/")) {
            path = String.valueOf(path) + "!/";
        }
        this.closeJar(path);
        JarHolder temp = new JarHolder(this.rsvc, path);
        this.addEntries(temp.getEntries());
        this.jarfiles.put(temp.getUrlPath(), temp);
    }

    private void closeJar(String path) {
        if (this.jarfiles.containsKey(path)) {
            JarHolder theJar = (JarHolder)this.jarfiles.get(path);
            theJar.close();
        }
    }

    private synchronized void addEntries(Hashtable entries) {
        this.entryDirectory.putAll(entries);
    }

    public synchronized InputStream getResourceStream(String source) throws ResourceNotFoundException {
        String jarurl;
        InputStream results = null;
        if (source == null || source.length() == 0) {
            throw new ResourceNotFoundException("Need to have a resource!");
        }
        String normalizedPath = StringUtils.normalizePath(source);
        if (normalizedPath == null || normalizedPath.length() == 0) {
            String msg = "JAR resource error : argument " + normalizedPath + " contains .. and may be trying to access " + "content outside of template root.  Rejected.";
            this.rsvc.error("JarResourceLoader : " + msg);
            throw new ResourceNotFoundException(msg);
        }
        if (normalizedPath.startsWith("/")) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (this.entryDirectory.containsKey(normalizedPath) && this.jarfiles.containsKey(jarurl = (String)this.entryDirectory.get(normalizedPath))) {
            JarHolder holder = (JarHolder)this.jarfiles.get(jarurl);
            results = holder.getResource(normalizedPath);
            return results;
        }
        throw new ResourceNotFoundException("JarResourceLoader Error: cannot find resource " + source);
    }

    public boolean isSourceModified(Resource resource) {
        return true;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

