/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.texen.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.velocity.texen.Generator;

public class PropertiesUtil {
    public Properties load(String propertiesFile) {
        Properties properties = new Properties();
        String templatePath = Generator.getInstance().getTemplatePath();
        properties = templatePath != null ? this.loadFromTemplatePath(propertiesFile) : this.loadFromClassPath(propertiesFile);
        return properties;
    }

    protected Properties loadFromTemplatePath(String propertiesFile) {
        Properties properties = new Properties();
        String templatePath = Generator.getInstance().getTemplatePath();
        StringTokenizer st = new StringTokenizer(templatePath, ",");
        while (st.hasMoreTokens()) {
            String templateDir = st.nextToken();
            try {
                String fullPath = propertiesFile;
                if (!fullPath.startsWith(templateDir)) {
                    fullPath = String.valueOf(templateDir) + "/" + propertiesFile;
                }
                properties.load(new FileInputStream(fullPath));
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    protected Properties loadFromClassPath(String propertiesFile) {
        Properties properties = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            if (propertiesFile.startsWith("$generator")) {
                propertiesFile = propertiesFile.substring("$generator.templatePath/".length());
            }
            InputStream inputStream = classLoader.getResourceAsStream(propertiesFile);
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }
}

