/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.beanutils.PropertyUtils;

public class MathTool {
    public Number add(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null) {
            return null;
        }
        double value = n1.doubleValue() + n2.doubleValue();
        return this.matchType(n1, n2, value);
    }

    public Number sub(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null) {
            return null;
        }
        double value = n1.doubleValue() - n2.doubleValue();
        return this.matchType(n1, n2, value);
    }

    public Number mul(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null) {
            return null;
        }
        double value = n1.doubleValue() * n2.doubleValue();
        return this.matchType(n1, n2, value);
    }

    public Number div(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null || n2.doubleValue() == 0.0) {
            return null;
        }
        double value = n1.doubleValue() / n2.doubleValue();
        return this.matchType(n1, n2, value);
    }

    public Number pow(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null) {
            return null;
        }
        double value = Math.pow(n1.doubleValue(), n2.doubleValue());
        return this.matchType(n1, n2, value);
    }

    public Integer idiv(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null || n2.intValue() == 0) {
            return null;
        }
        int value = n1.intValue() / n2.intValue();
        return new Integer(value);
    }

    public Integer mod(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null || n2.intValue() == 0) {
            return null;
        }
        int value = n1.intValue() % n2.intValue();
        return new Integer(value);
    }

    public Number max(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null) {
            return null;
        }
        double value = Math.max(n1.doubleValue(), n2.doubleValue());
        return this.matchType(n1, n2, value);
    }

    public Number min(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null) {
            return null;
        }
        double value = Math.min(n1.doubleValue(), n2.doubleValue());
        return this.matchType(n1, n2, value);
    }

    public Number abs(Object num) {
        Number n = this.toNumber(num);
        if (n == null) {
            return null;
        }
        double value = Math.abs(n.doubleValue());
        return this.matchType(n, value);
    }

    public Integer ceil(Object num) {
        Number n = this.toNumber(num);
        if (n == null) {
            return null;
        }
        return new Integer((int)Math.ceil(n.doubleValue()));
    }

    public Integer floor(Object num) {
        Number n = this.toNumber(num);
        if (n == null) {
            return null;
        }
        return new Integer((int)Math.floor(n.doubleValue()));
    }

    public Integer round(Object num) {
        Number n = this.toNumber(num);
        if (n == null) {
            return null;
        }
        return new Integer((int)Math.rint(n.doubleValue()));
    }

    public Double roundTo(Object decimals, Object num) {
        Number i = this.toNumber(decimals);
        Number d = this.toNumber(num);
        if (i == null || d == null) {
            return null;
        }
        int places = i.intValue();
        double value = d.doubleValue();
        if (places == 0) {
            value = (int)(value + 0.5);
        } else {
            double shift = Math.pow(10.0, places);
            value *= shift;
            value = (int)(value + 0.5);
            value /= shift;
        }
        return new Double(value);
    }

    public Double getRandom() {
        return new Double(Math.random());
    }

    public Number random(Object num1, Object num2) {
        Number n1 = this.toNumber(num1);
        Number n2 = this.toNumber(num2);
        if (n1 == null || n2 == null) {
            return null;
        }
        double diff = n2.doubleValue() - n1.doubleValue();
        double random = diff * Math.random() + n1.doubleValue();
        String in = String.valueOf(n1.toString()) + n2.toString();
        if (in.indexOf(46) < 0) {
            return this.matchType(n1, n2, Math.floor(random));
        }
        return new Double(random);
    }

    public Integer toInteger(Object num) {
        Number n = this.toNumber(num);
        if (n == null) {
            return null;
        }
        return new Integer(n.intValue());
    }

    public Double toDouble(Object num) {
        Number n = this.toNumber(num);
        if (n == null) {
            return null;
        }
        return new Double(n.doubleValue());
    }

    public Number toNumber(Object num) {
        if (num == null) {
            return null;
        }
        if (num instanceof Number) {
            return (Number)num;
        }
        try {
            return this.parseNumber(String.valueOf(num));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected Number matchType(Number in, double out) {
        return this.matchType(in, null, out);
    }

    protected Number matchType(Number in1, Number in2, double out) {
        boolean isWhole;
        boolean bl = isWhole = Math.rint(out) == out;
        if (isWhole) {
            String in = in1.toString();
            boolean bl2 = isWhole = in.indexOf(46) < 0;
            if (isWhole && in2 != null) {
                in = in2.toString();
                boolean bl3 = isWhole = in.indexOf(46) < 0;
            }
        }
        if (!isWhole) {
            return new Double(out);
        }
        if (out > 2.147483647E9 || out < -2.147483648E9) {
            return new Long((long)out);
        }
        return new Integer((int)out);
    }

    protected Number parseNumber(String value) throws NumberFormatException {
        if (value.indexOf(46) < 0) {
            long i = new Long(value);
            if (i > Integer.MAX_VALUE || i < Integer.MIN_VALUE) {
                return new Long(i);
            }
            return new Integer((int)i);
        }
        return new Double(value);
    }

    public Number getTotal(Collection collection, String field) {
        if (collection == null || field == null) {
            return null;
        }
        try {
            double result = 0.0;
            Number first = null;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                Object property = PropertyUtils.getProperty(i.next(), (String)field);
                Number value = this.toNumber(property);
                if (first == null) {
                    first = value;
                }
                result += value.doubleValue();
            }
            return this.matchType(first, result);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Number getAverage(Collection collection, String field) {
        Number result = this.getTotal(collection, field);
        if (result == null) {
            return null;
        }
        double avg = result.doubleValue() / (double)collection.size();
        return this.matchType(result, avg);
    }

    public Number getTotal(Object[] array, String field) {
        return this.getTotal(Arrays.asList(array), field);
    }

    public Number getAverage(Object[] array, String field) {
        return this.getAverage(Arrays.asList(array), field);
    }

    public Number getTotal(Collection collection) {
        if (collection == null) {
            return null;
        }
        double result = 0.0;
        Number first = null;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Number value = this.toNumber(i.next());
            if (value == null) {
                return null;
            }
            if (first == null) {
                first = value;
            }
            result += value.doubleValue();
        }
        return this.matchType(first, result);
    }

    public Number getAverage(Collection collection) {
        Number result = this.getTotal(collection);
        if (result == null) {
            return null;
        }
        double avg = result.doubleValue() / (double)collection.size();
        return this.matchType(result, avg);
    }

    public Number getTotal(Object[] array) {
        return this.getTotal(Arrays.asList(array));
    }

    public Number getAverage(Object[] array) {
        return this.getAverage(Arrays.asList(array));
    }

    public Number getTotal(double[] values) {
        if (values == null) {
            return null;
        }
        double result = 0.0;
        int i = 0;
        while (i < values.length) {
            result += values[i];
            ++i;
        }
        return new Double(result);
    }

    public Number getAverage(double[] values) {
        Number total = this.getTotal(values);
        if (total == null) {
            return null;
        }
        return new Double(total.doubleValue() / (double)values.length);
    }

    public Number getTotal(long[] values) {
        if (values == null) {
            return null;
        }
        long result = 0L;
        int i = 0;
        while (i < values.length) {
            result += values[i];
            ++i;
        }
        return new Long(result);
    }

    public Number getAverage(long[] values) {
        Number total = this.getTotal(values);
        if (total == null) {
            return null;
        }
        double avg = total.doubleValue() / (double)values.length;
        return this.matchType(total, avg);
    }
}

