/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class ValueParser {
    private Map source = null;

    public ValueParser() {
    }

    public ValueParser(Map source) {
        this.setSource(source);
    }

    protected void setSource(Map source) {
        this.source = source;
    }

    protected Map getSource() {
        if (this.source == null) {
            throw new NullPointerException("You must set a Map source for values to be parsed.");
        }
        return this.source;
    }

    public boolean exists(String key) {
        return this.getString(key) != null;
    }

    public String get(String key) {
        return this.getString(key);
    }

    public String getString(String key) {
        Object value = this.getSource().get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!values.isEmpty()) {
                value = values.iterator().next();
            }
        } else if (value.getClass().isArray() && Array.getLength(value) > 0) {
            value = Array.get(value, 0);
        }
        return String.valueOf(value);
    }

    public String getString(String key, String alternate) {
        String s = this.getString(key);
        return s != null ? s : alternate;
    }

    public Boolean getBoolean(String key) {
        String s = this.getString(key);
        return s != null ? this.parseBoolean(s) : null;
    }

    public boolean getBoolean(String key, boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Boolean getBoolean(String key, Boolean alternate) {
        Boolean bool = this.getBoolean(key);
        return bool != null ? bool : alternate;
    }

    public Number getNumber(String key) {
        String s = this.getString(key);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return this.parseNumber(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Number getNumber(String key, Number alternate) {
        Number n = this.getNumber(key);
        return n != null ? (Number)n : (Number)alternate;
    }

    public int getInt(String key, int alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.intValue() : alternate;
    }

    public double getDouble(String key, double alternate) {
        Number n = this.getNumber(key);
        return n != null ? n.doubleValue() : alternate;
    }

    public String[] getStrings(String key) {
        Object value = this.getSource().get(key);
        if (value == null) {
            return null;
        }
        String[] strings = null;
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (!values.isEmpty()) {
                strings = new String[values.size()];
                int index = 0;
                Iterator i = values.iterator();
                while (i.hasNext()) {
                    strings[index++] = String.valueOf(i.next());
                }
            }
        } else if (value.getClass().isArray()) {
            strings = new String[Array.getLength(value)];
            int i = 0;
            while (i < strings.length) {
                strings[i] = String.valueOf(Array.get(value, i));
                ++i;
            }
        } else {
            strings = new String[]{String.valueOf(value)};
        }
        return strings;
    }

    public Boolean[] getBooleans(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        Boolean[] bools = new Boolean[strings.length];
        int i = 0;
        while (i < strings.length) {
            if (strings[i] != null && strings[i].length() > 0) {
                bools[i] = this.parseBoolean(strings[i]);
            }
            ++i;
        }
        return bools;
    }

    public Number[] getNumbers(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        Number[] nums = new Number[strings.length];
        try {
            int i = 0;
            while (i < nums.length) {
                if (strings[i] != null && strings[i].length() > 0) {
                    nums[i] = this.parseNumber(strings[i]);
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return nums;
    }

    public int[] getInts(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        int[] ints = new int[strings.length];
        try {
            int i = 0;
            while (i < ints.length) {
                if (strings[i] != null && strings[i].length() > 0) {
                    ints[i] = this.parseNumber(strings[i]).intValue();
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return ints;
    }

    public double[] getDoubles(String key) {
        String[] strings = this.getStrings(key);
        if (strings == null) {
            return null;
        }
        double[] doubles = new double[strings.length];
        try {
            int i = 0;
            while (i < doubles.length) {
                if (strings[i] != null && strings[i].length() > 0) {
                    doubles[i] = this.parseNumber(strings[i]).doubleValue();
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return doubles;
    }

    protected Number parseNumber(String value) throws NumberFormatException {
        if (value.indexOf(46) >= 0) {
            return new Double(value);
        }
        return new Long(value);
    }

    protected Boolean parseBoolean(String value) {
        return Boolean.valueOf(value);
    }
}

