/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.intercept;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsUserToken
extends AbstractAuthenticationToken {
    private final Class<? extends Authentication> originalAuthentication;
    private final Object credentials;
    private final Object principal;
    private final int keyHash;

    public RunAsUserToken(String key, Object principal, Object credentials, GrantedAuthority[] authorities, Class<? extends Authentication> originalAuthentication) {
        this(key, principal, credentials, Arrays.asList(authorities), originalAuthentication);
    }

    public RunAsUserToken(String key, Object principal, Object credentials, Collection<GrantedAuthority> authorities, Class<? extends Authentication> originalAuthentication) {
        super(authorities);
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.credentials = credentials;
        this.originalAuthentication = originalAuthentication;
        this.setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return this.credentials;
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    public Class<? extends Authentication> getOriginalAuthentication() {
        return this.originalAuthentication;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        String className = this.originalAuthentication == null ? null : this.originalAuthentication.getName();
        sb.append("; Original Class: ").append(className);
        return sb.toString();
    }
}

