/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.remoting.rmi;

import java.lang.reflect.InvocationTargetException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ContextPropagatingRemoteInvocation
extends RemoteInvocation {
    private static final Log logger = LogFactory.getLog(ContextPropagatingRemoteInvocation.class);
    private final String principal;
    private final String credentials;

    public ContextPropagatingRemoteInvocation(MethodInvocation methodInvocation) {
        super(methodInvocation);
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser != null) {
            this.principal = currentUser.getPrincipal().toString();
            this.credentials = currentUser.getCredentials().toString();
        } else {
            this.credentials = null;
            this.principal = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("RemoteInvocation now has principal: " + this.principal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object targetObject) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.principal != null) {
            Authentication request = this.createAuthenticationRequest(this.principal, this.credentials);
            request.setAuthenticated(false);
            SecurityContextHolder.getContext().setAuthentication(request);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Set SecurityContextHolder to contain: " + request));
            }
        }
        try {
            Object object = super.invoke(targetObject);
            return object;
        }
        finally {
            SecurityContextHolder.clearContext();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Cleared SecurityContextHolder.");
            }
        }
    }

    protected Authentication createAuthenticationRequest(String principal, String credentials) {
        return new UsernamePasswordAuthenticationToken(principal, credentials);
    }
}

