/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging;

import flex.messaging.AbstractFlexSessionProvider;
import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.HttpFlexSessionProvider;
import flex.messaging.LocalizedException;
import flex.messaging.MessageException;
import flex.messaging.log.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class HttpFlexSession
extends FlexSession
implements HttpSessionBindingListener,
HttpSessionListener,
HttpSessionAttributeListener,
Serializable {
    private static final long serialVersionUID = -1260409488935306147L;
    static final String SESSION_ATTRIBUTE = "__flexSession";
    private static final String INVALIDATED_REQUEST = "__flexInvalidatedRequest";
    public static final String SESSION_MAP = "LCDS_HTTP_TO_FLEX_SESSION_MAP";
    static volatile boolean isHttpSessionListener;
    static volatile boolean warnedNoEventRedispatch;
    static String WARN_LOG_CATEGORY;
    HttpSession httpSession;
    public static final Object mapLock;

    public HttpFlexSession() {
    }

    public HttpFlexSession(HttpFlexSessionProvider provider) {
        super(provider);
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        Map httpSessionToFlexSessionMap;
        HttpFlexSession flexSession;
        if (!event.getName().equals(SESSION_ATTRIBUTE) && (flexSession = (HttpFlexSession)(httpSessionToFlexSessionMap = this.getHttpSessionToFlexSessionMap(event.getSession())).get(event.getSession().getId())) != null) {
            String name = event.getName();
            Object value = event.getValue();
            flexSession.notifyAttributeBound(name, value);
            flexSession.notifyAttributeAdded(name, value);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        Map httpSessionToFlexSessionMap;
        HttpFlexSession flexSession;
        if (!event.getName().equals(SESSION_ATTRIBUTE) && (flexSession = (HttpFlexSession)(httpSessionToFlexSessionMap = this.getHttpSessionToFlexSessionMap(event.getSession())).get(event.getSession().getId())) != null) {
            String name = event.getName();
            Object value = event.getValue();
            flexSession.notifyAttributeUnbound(name, value);
            flexSession.notifyAttributeRemoved(name, value);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        Map httpSessionToFlexSessionMap;
        HttpFlexSession flexSession;
        if (!event.getName().equals(SESSION_ATTRIBUTE) && (flexSession = (HttpFlexSession)(httpSessionToFlexSessionMap = this.getHttpSessionToFlexSessionMap(event.getSession())).get(event.getSession().getId())) != null) {
            String name = event.getName();
            Object value = event.getValue();
            Object newValue = flexSession.getAttribute(name);
            flexSession.notifyAttributeUnbound(name, value);
            flexSession.notifyAttributeReplaced(name, value);
            flexSession.notifyAttributeBound(name, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpFlexSession getFlexSession(HttpServletRequest req) {
        HttpFlexSession flexSession;
        HttpSession httpSession = req.getSession(true);
        if (!isHttpSessionListener && !warnedNoEventRedispatch) {
            warnedNoEventRedispatch = true;
            if (Log.isWarn()) {
                Log.getLogger((String)WARN_LOG_CATEGORY).warn("HttpFlexSession has not been registered as a listener in web.xml for this application so no events will be dispatched to FlexSessionAttributeListeners or FlexSessionBindingListeners. To correct this, register flex.messaging.HttpFlexSession as a listener in web.xml.");
            }
        }
        boolean isNew = false;
        HttpSession httpSession2 = httpSession;
        synchronized (httpSession2) {
            flexSession = (HttpFlexSession)httpSession.getAttribute(SESSION_ATTRIBUTE);
            if (flexSession == null) {
                flexSession = new HttpFlexSession();
                FlexContext.setThreadLocalSession(flexSession);
                httpSession.setAttribute(SESSION_ATTRIBUTE, (Object)flexSession);
                flexSession.setHttpSession(httpSession);
                isNew = true;
            } else {
                FlexContext.setThreadLocalSession(flexSession);
                if (flexSession.httpSession == null) {
                    flexSession.setHttpSession(httpSession);
                    isNew = true;
                }
            }
        }
        if (isNew) {
            flexSession.notifyCreated();
            if (Log.isDebug()) {
                Log.getLogger((String)"Endpoint.FlexSession").debug("FlexSession created with id '" + flexSession.getId() + "' for an Http-based client connection.");
            }
        }
        return flexSession;
    }

    public Principal getUserPrincipal() {
        HttpServletRequest req;
        Principal p = super.getUserPrincipal();
        if (p == null && (req = FlexContext.getHttpRequest()) != null && req.getAttribute(INVALIDATED_REQUEST) == null) {
            p = req.getUserPrincipal();
        }
        return p;
    }

    public void invalidate() {
        boolean recreate = FlexContext.getFlexSession() == this;
        this.invalidate(recreate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(boolean recreate) {
        HttpServletRequest req;
        HttpSession httpSession = this.httpSession;
        synchronized (httpSession) {
            try {
                this.httpSession.invalidate();
            }
            catch (IllegalStateException e) {
                try {
                    Map httpSessionToFlexSessionMap = this.getHttpSessionToFlexSessionMap(this.httpSession);
                    httpSessionToFlexSessionMap.remove(this.httpSession.getId());
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                super.invalidate();
            }
        }
        if (recreate && (req = FlexContext.getHttpRequest()) != null) {
            req.setAttribute(INVALIDATED_REQUEST, (Object)"true");
            AbstractFlexSessionProvider sessionProvider = this.getFlexSessionProvider();
            HttpFlexSession session = sessionProvider == null ? null : ((HttpFlexSessionProvider)sessionProvider).getOrCreateSession(req);
            FlexContext.setThreadLocalObjects(FlexContext.getFlexClient(), session, FlexContext.getMessageBroker(), req, FlexContext.getHttpResponse(), FlexContext.getServletConfig());
        }
    }

    public Object getAttribute(String name) {
        return this.httpSession.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.httpSession.getAttributeNames();
    }

    public String getId() {
        return this.httpSession.getId();
    }

    public boolean isPushSupported() {
        return false;
    }

    public void removeAttribute(String name) {
        this.httpSession.removeAttribute(name);
    }

    public void sessionCreated(HttpSessionEvent event) {
        isHttpSessionListener = true;
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        Map httpSessionToFlexSessionMap = this.getHttpSessionToFlexSessionMap(session);
        HttpFlexSession flexSession = (HttpFlexSession)httpSessionToFlexSessionMap.remove(session.getId());
        if (flexSession != null) {
            flexSession.superInvalidate();
            try {
                Enumeration e = session.getAttributeNames();
                while (e.hasMoreElements()) {
                    Object value;
                    String name = (String)e.nextElement();
                    if (name.equals(SESSION_ATTRIBUTE) || (value = session.getAttribute(name)) == null) continue;
                    flexSession.notifyAttributeUnbound(name, value);
                    flexSession.notifyAttributeRemoved(name, value);
                }
            }
            catch (IllegalStateException ignore) {
                // empty catch block
            }
        }
    }

    public void setAttribute(String name, Object value) {
        this.httpSession.setAttribute(name, value);
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        Map httpSessionToFlexSessionMap;
        HttpFlexSession flexSession;
        if (!isHttpSessionListener && (flexSession = (HttpFlexSession)(httpSessionToFlexSessionMap = this.getHttpSessionToFlexSessionMap(event.getSession())).remove(event.getSession().getId())) != null) {
            flexSession.superInvalidate();
        }
    }

    protected void internalInvalidate() {
        if (Log.isDebug()) {
            Log.getLogger((String)"Endpoint.FlexSession").debug("FlexSession with id '" + this.getId() + "' for an Http-based client connection has been invalidated.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHttpSession(HttpSession httpSession) {
        Object object = this.lock;
        synchronized (object) {
            this.httpSession = httpSession;
            Map httpSessionToFlexSessionMap = this.getHttpSessionToFlexSessionMap(httpSession);
            httpSessionToFlexSessionMap.put(httpSession.getId(), this);
        }
    }

    private void superInvalidate() {
        super.invalidate();
    }

    private void writeObject(ObjectOutputStream stream) {
        try {
            Principal principal = super.getUserPrincipal();
            if (principal != null && principal instanceof Serializable) {
                stream.writeObject(principal);
            }
        }
        catch (IOException e) {
        }
        catch (LocalizedException localizedException) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream stream) {
        try {
            this.setUserPrincipal((Principal)stream.readObject());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map getHttpSessionToFlexSessionMap(HttpSession session) {
        try {
            ServletContext context = session.getServletContext();
            Map map = (Map)context.getAttribute(SESSION_MAP);
            if (map == null) {
                if (Log.isError()) {
                    Log.getLogger((String)"Endpoint.FlexSession").error("HttpSession to FlexSession map not created in message broker for " + session.getId());
                }
                MessageException me = new MessageException();
                me.setMessage(10032, new Object[]{session.getId()});
                throw me;
            }
            return map;
        }
        catch (Exception e) {
            if (Log.isDebug()) {
                Log.getLogger((String)"Endpoint.FlexSession").debug("Unable to get HttpSession to FlexSession map for " + session.getId() + " " + e.toString());
            }
            return new ConcurrentHashMap();
        }
    }

    static {
        WARN_LOG_CATEGORY = "Configuration";
        mapLock = new Object();
    }
}

