/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.endpoints.amf;

import flex.messaging.FlexContext;
import flex.messaging.FlexSession;
import flex.messaging.MessageException;
import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.endpoints.amf.AMFFilter;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.log.Log;
import flex.messaging.messages.AbstractMessage;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import flex.messaging.messages.MessagePerformanceUtils;
import flex.messaging.util.ExceptionUtil;
import flex.messaging.util.StringUtils;
import flex.messaging.util.UUIDUtils;

public class MessageBrokerFilter
extends AMFFilter {
    private static final int UNHANDLED_ERROR = 10000;
    static final String LOG_CATEGORY = "Message.General";
    protected AbstractEndpoint endpoint;

    public MessageBrokerFilter(AbstractEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(ActionContext context) {
        FlexSession session2222;
        String replyMethodName;
        Message outMessage;
        MessageBody response;
        block21: {
            MessageBody request = context.getRequestMessageBody();
            response = context.getResponseMessageBody();
            Message inMessage = request.getDataAsMessage();
            outMessage = null;
            replyMethodName = "/onStatus";
            try {
                try {
                    CommandMessage command;
                    this.endpoint.setupFlexClient(inMessage);
                    if (!(inMessage.getClientId() != null || inMessage instanceof CommandMessage && ((CommandMessage)inMessage).getOperation() == 2)) {
                        String clientId = UUIDUtils.createUUID();
                        inMessage.setClientId(clientId);
                    }
                    if (inMessage instanceof CommandMessage && (command = (CommandMessage)inMessage).getOperation() == 2 && context.getRequestMessage().getBodyCount() != 1) {
                        command.setHeader("DSSuppressPollWait", Boolean.TRUE);
                    }
                    if (context.isMPIenabled()) {
                        MessagePerformanceUtils.setupMPII(context, inMessage);
                    }
                    if ((outMessage = this.endpoint.serviceMessage(inMessage)) instanceof ErrorMessage) {
                        context.setStatus(1);
                        replyMethodName = "/onStatus";
                    } else {
                        replyMethodName = "/onResult";
                    }
                }
                catch (MessageException e) {
                    FlexSession session2222;
                    context.setStatus(1);
                    replyMethodName = "/onStatus";
                    outMessage = e.createErrorMessage();
                    ((AsyncMessage)outMessage).setCorrelationId(inMessage.getMessageId());
                    ((AbstractMessage)outMessage).setDestination(inMessage.getDestination());
                    ((AbstractMessage)outMessage).setClientId(inMessage.getClientId());
                    e.logAtHingePoint(inMessage, (ErrorMessage)outMessage, null);
                    Object var11_11 = null;
                    if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
                        MessagePerformanceUtils.updateOutgoingMPI(context, inMessage, outMessage);
                    }
                    if ((session2222 = FlexContext.getFlexSession()) != null && session2222.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
                        outMessage = this.endpoint.convertToSmallMessage(outMessage);
                    }
                    response.setReplyMethod(replyMethodName);
                    response.setData(outMessage);
                    return;
                }
                catch (Throwable t) {
                    FlexSession session2222;
                    context.setStatus(1);
                    replyMethodName = "/onStatus";
                    String lmeMessage = t.getMessage();
                    if (lmeMessage == null) {
                        lmeMessage = t.getClass().getName();
                    }
                    MessageException lme = new MessageException();
                    lme.setMessage(10000, new Object[]{lmeMessage});
                    outMessage = lme.createErrorMessage();
                    ((ErrorMessage)outMessage).setCorrelationId(inMessage.getMessageId());
                    ((ErrorMessage)outMessage).setDestination(inMessage.getDestination());
                    ((ErrorMessage)outMessage).setClientId(inMessage.getClientId());
                    if (Log.isError()) {
                        Log.getLogger((String)LOG_CATEGORY).error("Unhandled error when processing a message: " + t.toString() + StringUtils.NEWLINE + "  incomingMessage: " + inMessage + StringUtils.NEWLINE + "  errorReply: " + outMessage + StringUtils.NEWLINE + ExceptionUtil.exceptionFollowedByRootCausesToString((Throwable)t) + StringUtils.NEWLINE);
                    }
                    Object var11_12 = null;
                    if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
                        MessagePerformanceUtils.updateOutgoingMPI(context, inMessage, outMessage);
                    }
                    if ((session2222 = FlexContext.getFlexSession()) != null && session2222.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
                        outMessage = this.endpoint.convertToSmallMessage(outMessage);
                    }
                    response.setReplyMethod(replyMethodName);
                    response.setData(outMessage);
                    return;
                }
                Object var11_10 = null;
                if (!context.isRecordMessageSizes() && !context.isRecordMessageTimes()) break block21;
            }
            catch (Throwable throwable) {
                FlexSession session2222;
                Object var11_13 = null;
                if (context.isRecordMessageSizes() || context.isRecordMessageTimes()) {
                    MessagePerformanceUtils.updateOutgoingMPI(context, inMessage, outMessage);
                }
                if ((session2222 = FlexContext.getFlexSession()) != null && session2222.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
                    outMessage = this.endpoint.convertToSmallMessage(outMessage);
                }
                response.setReplyMethod(replyMethodName);
                response.setData(outMessage);
                throw throwable;
            }
            MessagePerformanceUtils.updateOutgoingMPI(context, inMessage, outMessage);
        }
        if ((session2222 = FlexContext.getFlexSession()) != null && session2222.useSmallMessages() && !context.isLegacy() && context.getVersion() >= 3 && outMessage instanceof Message) {
            outMessage = this.endpoint.convertToSmallMessage(outMessage);
        }
        response.setReplyMethod(replyMethodName);
        response.setData(outMessage);
    }
}

