/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.MessageDeserializer;
import flex.messaging.io.MessageSerializer;
import flex.messaging.util.ClassUtil;
import flex.messaging.validators.DeserializationValidator;
import java.io.Serializable;

public class SerializationContext
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3020985035377116475L;
    public boolean legacyXMLDocument;
    public boolean legacyXMLNamespaces;
    public boolean legacyCollection;
    public boolean legacyMap;
    public boolean legacyThrowable;
    public boolean legacyBigNumbers;
    public boolean legacyExternalizable;
    public boolean restoreReferences;
    public boolean supportRemoteClass;
    public boolean supportDatesByReference;
    public boolean createASObjectForMissingType = false;
    public boolean enableSmallMessages = true;
    public boolean instantiateTypes = true;
    public boolean ignorePropertyErrors = true;
    public boolean logPropertyErrors = false;
    public boolean includeReadOnly = false;
    private Class deserializer;
    private Class serializer;
    private DeserializationValidator deserializationValidator;
    private static ThreadLocal<SerializationContext> contexts = new ThreadLocal();

    public Class getDeserializerClass() {
        return this.deserializer;
    }

    public void setDeserializerClass(Class c) {
        this.deserializer = c;
    }

    public Class getSerializerClass() {
        return this.serializer;
    }

    public void setSerializerClass(Class c) {
        this.serializer = c;
    }

    public MessageDeserializer newMessageDeserializer() {
        MessageDeserializer deserializer = (MessageDeserializer)ClassUtil.createDefaultInstance(this.getDeserializerClass(), MessageDeserializer.class);
        return deserializer;
    }

    public MessageSerializer newMessageSerializer() {
        MessageSerializer serializer = (MessageSerializer)ClassUtil.createDefaultInstance(this.getSerializerClass(), MessageSerializer.class);
        return serializer;
    }

    public DeserializationValidator getDeserializationValidator() {
        return this.deserializationValidator;
    }

    public void setDeserializationValidator(DeserializationValidator deserializationValidator) {
        this.deserializationValidator = deserializationValidator;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            SerializationContext context = new SerializationContext();
            context.createASObjectForMissingType = this.createASObjectForMissingType;
            context.legacyXMLDocument = this.legacyXMLDocument;
            context.legacyXMLNamespaces = this.legacyXMLNamespaces;
            context.legacyCollection = this.legacyCollection;
            context.legacyMap = this.legacyMap;
            context.legacyThrowable = this.legacyThrowable;
            context.legacyBigNumbers = this.legacyBigNumbers;
            context.legacyExternalizable = this.legacyExternalizable;
            context.restoreReferences = this.restoreReferences;
            context.supportRemoteClass = this.supportRemoteClass;
            context.supportDatesByReference = this.supportDatesByReference;
            context.instantiateTypes = this.instantiateTypes;
            context.ignorePropertyErrors = this.ignorePropertyErrors;
            context.includeReadOnly = this.includeReadOnly;
            context.logPropertyErrors = this.logPropertyErrors;
            context.deserializer = this.deserializer;
            context.serializer = this.serializer;
            context.deserializationValidator = this.deserializationValidator;
            return context;
        }
    }

    public static void setSerializationContext(SerializationContext context) {
        if (context == null) {
            contexts.remove();
        } else {
            contexts.set(context);
        }
    }

    public static SerializationContext getSerializationContext() {
        SerializationContext sc = contexts.get();
        if (sc == null) {
            sc = new SerializationContext();
            SerializationContext.setSerializationContext(sc);
        }
        return sc;
    }

    public static void clearThreadLocalObjects() {
        contexts.remove();
    }

    public static void createThreadLocalObjects() {
        if (contexts == null) {
            contexts = new ThreadLocal();
        }
    }

    public static void releaseThreadLocalObjects() {
        contexts = null;
    }
}

