/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.util;

import flex.messaging.MessageException;
import flex.messaging.util.ClassUtil;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLUtil {
    public static String INDENT_XML = "no";
    public static String OMIT_XML_DECLARATION = "yes";

    private XMLUtil() {
    }

    public static String documentToString(Document document) throws IOException {
        String xml = null;
        try {
            DOMSource dom = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult output = new StreamResult(writer);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", INDENT_XML);
            transformer.setOutputProperty("omit-xml-declaration", OMIT_XML_DECLARATION);
            transformer.transform(dom, output);
            xml = writer.toString();
        }
        catch (TransformerException te) {
            throw new IOException("Error serializing Document as String: " + te.getMessageAndLocation());
        }
        return xml;
    }

    public static Document stringToDocument(String xml) {
        return XMLUtil.stringToDocument(xml, true);
    }

    public static Document stringToDocument(String xml, boolean nameSpaceAware) {
        ClassUtil.validateCreation(Document.class);
        Document document = null;
        try {
            if (xml != null) {
                StringReader reader = new StringReader(xml);
                InputSource input = new InputSource(reader);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(nameSpaceAware);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(input);
            }
        }
        catch (Exception ex) {
            throw new MessageException("Error deserializing XML type " + ex.getMessage());
        }
        return document;
    }
}

