/*
 * Decompiled with CFR 0.152.
 */
package com.hehj.easyexecutor.config;

import com.hehj.easyexecutor.config.EasyexecutorConfig;
import com.hehj.easyexecutor.config.IEasyexecutorMeta;
import java.util.List;
import org.apache.commons.digester.Digester;

public class EasyexecutorConfigManager
implements IEasyexecutorMeta {
    private EasyexecutorConfig easyConfig;

    public EasyexecutorConfigManager(String configFilePath) {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("easyexecutorconfig", EasyexecutorConfig.class);
        digester.addCallMethod("easyexecutorconfig/worker-scan", "addScanPackage", 0);
        digester.addCallMethod("easyexecutorconfig/worker-global-interceptor", "addGlobalInterceptor", 0);
        try {
            this.easyConfig = (EasyexecutorConfig)digester.parse(EasyexecutorConfigManager.class.getResourceAsStream("/" + configFilePath));
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse ' " + configFilePath + " ',check it", e);
        }
    }

    @Override
    public boolean isScanPackage(String packageName) {
        for (String s : this.easyConfig.getScanPackages()) {
            if (!packageName.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> globalInterceptors() {
        return this.easyConfig.getGlobalInterceptorClasses();
    }
}

