/*
 * Decompiled with CFR 0.152.
 */
package com.hehj.easyexecutor.manager;

import com.hehj.easyexecutor.Interceptor.IInterceptor;
import com.hehj.easyexecutor.annotation.ClassInterceptors;
import com.hehj.easyexecutor.annotation.EasyInterceptor;
import com.hehj.easyexecutor.annotation.EasyInterceptors;
import com.hehj.easyexecutor.annotation.EasyMapping;
import com.hehj.easyexecutor.annotation.EasyWorker;
import com.hehj.easyexecutor.config.IEasyexecutorMeta;
import com.hehj.easyexecutor.manager.IEasyManager;
import com.hehj.easyexecutor.manager.IEasyWorkerContainer;
import com.hehj.easyexecutor.resolver.DefaultResolver;
import com.hehj.easyexecutor.resolver.IEasyResolver;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class DefaultManager
implements IEasyManager {
    private Map<String, IEasyResolver> resolvers = new HashMap<String, IEasyResolver>();
    private SortedMap<Integer, WildcardEntity> wildCardEntities = new ConcurrentSkipListMap<Integer, WildcardEntity>();
    private IEasyWorkerContainer workerContainer;
    private IEasyexecutorMeta easyexecutorMeta;
    private List<IInterceptor> globalInterceptors;

    public DefaultManager(IEasyexecutorMeta easyexecutorMeta, IEasyWorkerContainer workerContainer) {
        if (workerContainer == null) {
            throw new NullPointerException("workerContainer can't be null.");
        }
        if (easyexecutorMeta == null) {
            throw new NullPointerException("easyexecutorMeta can't be null.");
        }
        this.workerContainer = workerContainer;
        this.easyexecutorMeta = easyexecutorMeta;
        this.init();
    }

    public void init() {
        if (this.easyexecutorMeta.globalInterceptors().size() > 0) {
            this.globalInterceptors = new ArrayList<IInterceptor>();
            for (String className : this.easyexecutorMeta.globalInterceptors()) {
                try {
                    Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
                    this.globalInterceptors.add((IInterceptor)cls.newInstance());
                }
                catch (Exception e) {
                    throw new RuntimeException("", e);
                }
            }
        }
        File root = new File(DefaultManager.class.getClass().getResource("/").getFile());
        String prefix = root.getAbsolutePath();
        ArrayList classes = new ArrayList();
        this.listCommandClass(root, prefix, classes);
        for (Class clazz : classes) {
            this.analyzeClass(clazz);
        }
    }

    private void analyzeClass(Class<?> cls) {
        EasyWorker easyWorker = cls.getAnnotation(EasyWorker.class);
        if (easyWorker != null) {
            try {
                int n;
                int n2;
                Object[] objectArray;
                EasyInterceptor[] interceptors;
                ArrayList<IInterceptor> classInterceptorList = null;
                ClassInterceptors classInterceptors = cls.getAnnotation(ClassInterceptors.class);
                if (classInterceptors != null && (interceptors = classInterceptors.value()) != null && interceptors.length > 0) {
                    classInterceptorList = new ArrayList<IInterceptor>();
                    objectArray = interceptors;
                    n2 = interceptors.length;
                    n = 0;
                    while (n < n2) {
                        Object interceptor = objectArray[n];
                        IInterceptor tmp = interceptor.value().newInstance();
                        classInterceptorList.add(tmp);
                        ++n;
                    }
                }
                Method[] methods = cls.getDeclaredMethods();
                objectArray = methods;
                n2 = methods.length;
                n = 0;
                while (n < n2) {
                    Object m = objectArray[n];
                    EasyMapping commandMapping = ((Method)m).getAnnotation(EasyMapping.class);
                    if (commandMapping != null) {
                        EasyInterceptor[] interceptors2;
                        ArrayList<IInterceptor> methodInterceptors = null;
                        EasyInterceptors easyInterceptors = ((Method)m).getAnnotation(EasyInterceptors.class);
                        if (easyInterceptors != null && (interceptors2 = easyInterceptors.value()) != null && interceptors2.length > 0) {
                            methodInterceptors = new ArrayList<IInterceptor>();
                            EasyInterceptor[] easyInterceptorArray = interceptors2;
                            int n3 = interceptors2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                EasyInterceptor interceptor = easyInterceptorArray[n4];
                                IInterceptor tmp = interceptor.value().newInstance();
                                methodInterceptors.add(tmp);
                                ++n4;
                            }
                        }
                        Class<?>[] paramTypes = ((Method)m).getParameterTypes();
                        if ("".equals(easyWorker.workerName())) {
                            if (commandMapping.isWildcard()) {
                                this.wildCardEntities.put(commandMapping.weight(), new WildcardEntity(commandMapping.mapping(), new DefaultResolver((Method)m, paramTypes, cls, this.workerContainer.getWorker(cls), this.globalInterceptors, classInterceptorList, methodInterceptors)));
                            } else {
                                this.resolvers.put(commandMapping.mapping(), new DefaultResolver((Method)m, paramTypes, cls, this.workerContainer.getWorker(cls), this.globalInterceptors, classInterceptorList, methodInterceptors));
                            }
                        } else if (commandMapping.isWildcard()) {
                            this.wildCardEntities.put(commandMapping.weight(), new WildcardEntity(commandMapping.mapping(), new DefaultResolver((Method)m, paramTypes, cls, this.workerContainer.getWorker(easyWorker.workerName()), classInterceptorList, this.globalInterceptors, methodInterceptors)));
                        } else {
                            this.resolvers.put(commandMapping.mapping(), new DefaultResolver((Method)m, paramTypes, cls, this.workerContainer.getWorker(easyWorker.workerName()), classInterceptorList, this.globalInterceptors, methodInterceptors));
                        }
                    }
                    ++n;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error in analyzeClass", e);
            }
        }
    }

    private void listCommandClass(File file, String prefix, List<Class<?>> list) {
        File[] files = file.listFiles();
        if (files != null) {
            try {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (f.isDirectory()) {
                        this.listCommandClass(f, prefix, list);
                    } else if (f.getName().endsWith(".class")) {
                        String parent = f.getParent();
                        String name = f.getName();
                        String classpath = (String.valueOf(parent.substring(prefix.length() + 1)) + File.separator + name.substring(0, name.length() - 6)).replace("\\", ".");
                        if (this.easyexecutorMeta.isScanPackage(classpath)) {
                            list.add(Class.forName(classpath.replace(File.separator, ".")));
                        }
                    } else if (f.getName().endsWith(".jar")) {
                        JarFile jarFile = new JarFile(f);
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            String jarEntryName;
                            String classpath;
                            JarEntry jarEntry = jarEntries.nextElement();
                            if (!jarEntry.getName().endsWith(".class") || !this.easyexecutorMeta.isScanPackage(classpath = (jarEntryName = jarEntry.getName()).substring(0, jarEntryName.length() - 6).replace("/", "."))) continue;
                            list.add(Thread.currentThread().getContextClassLoader().loadClass(classpath));
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("error in listCommandClass", e);
            }
        }
    }

    @Override
    public IEasyResolver getResolver(String command) {
        IEasyResolver resolver = this.resolvers.get(command);
        if (resolver == null) {
            for (int weight : this.wildCardEntities.keySet()) {
                WildcardEntity entity = (WildcardEntity)this.wildCardEntities.get(weight);
                if (!entity.isMatch(command)) continue;
                return entity.getResolver();
            }
        }
        return resolver;
    }

    private class WildcardEntity {
        private Pattern p;
        private IEasyResolver resolver;

        public WildcardEntity(String wildString, IEasyResolver resolver) {
            this.p = Pattern.compile(wildString);
            this.resolver = resolver;
        }

        public boolean isMatch(String mappingString) {
            return this.p.matcher(mappingString).matches();
        }

        public IEasyResolver getResolver() {
            return this.resolver;
        }
    }
}

