/*
 * Decompiled with CFR 0.152.
 */
package com.hehj.easyexecutor.resolver;

import com.hehj.easyexecutor.Interceptor.IInterceptor;
import com.hehj.easyexecutor.context.IEasyContext;
import com.hehj.easyexecutor.resolver.IEasyResolver;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultResolver
implements IEasyResolver {
    private static final Log LOG = LogFactory.getLog(DefaultResolver.class);
    private Method m;
    private Class<?> targetCls;
    private Class<?>[] paramTypes;
    private Object target;
    private List<IInterceptor> globalInterceptors;
    private List<IInterceptor> classInterceptors;
    private List<IInterceptor> methodInterceptors;

    public DefaultResolver(Method m, Class<?>[] paramTypes, Class<?> targetCls, Object target, List<IInterceptor> globalInterceptors, List<IInterceptor> classInterceptors, List<IInterceptor> methodInterceptors) {
        this.m = m;
        this.paramTypes = paramTypes;
        this.targetCls = targetCls;
        this.target = target;
        this.globalInterceptors = globalInterceptors;
        this.classInterceptors = classInterceptors;
        this.methodInterceptors = methodInterceptors;
    }

    @Override
    public <T extends IEasyContext> void execute(T args) {
        try {
            if (this.globalInterceptors != null) {
                for (IInterceptor interceptor : this.globalInterceptors) {
                    if (interceptor.before(args)) continue;
                    return;
                }
            }
            if (this.classInterceptors != null) {
                for (IInterceptor interceptor : this.classInterceptors) {
                    if (interceptor.before(args)) continue;
                    return;
                }
            }
            if (this.methodInterceptors != null) {
                for (IInterceptor interceptor : this.methodInterceptors) {
                    if (interceptor.before(args)) continue;
                    return;
                }
            }
            Object[] params = new Object[this.paramTypes.length];
            int i = 0;
            while (i < this.paramTypes.length) {
                if (this.paramTypes[i].isInstance(args)) {
                    params[i] = args;
                }
                ++i;
            }
            this.m.invoke(this.target, params);
            if (this.methodInterceptors != null) {
                for (IInterceptor interceptor : this.methodInterceptors) {
                    if (interceptor.after(args)) continue;
                    return;
                }
            }
            if (this.classInterceptors != null) {
                for (IInterceptor interceptor : this.classInterceptors) {
                    if (interceptor.after(args)) continue;
                    return;
                }
            }
            if (this.globalInterceptors != null) {
                for (IInterceptor interceptor : this.globalInterceptors) {
                    if (interceptor.after(args)) continue;
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("", e);
        }
    }
}

