/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import oracle.AQ.AQDriver;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQSession;

public class AQDriverManager {
    static Vector drivers;
    private static boolean initialized;
    static OutputStream logstream;
    static PrintWriter pstream;
    static boolean cache_stmts;
    static boolean enable_jni;

    static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        AQDriverManager.loadInitialDrivers();
    }

    /*
     * Unable to fully structure code
     */
    private static void loadInitialDrivers() {
        try {
            var0 = System.getProperty("aq.drivers");
        }
        catch (Exception var1_1) {
            var0 = null;
        }
        if (var0 != null) ** GOTO lbl23
        return;
lbl-1000:
        // 1 sources

        {
            var1_2 = var0.indexOf(58);
            if (var1_2 < 0) {
                var2_3 = var0;
                var0 = "";
            } else {
                var2_3 = var0.substring(0, var1_2);
                var0 = var0.substring(var1_2 + 1);
            }
            if (var2_3.length() == 0) continue;
            try {
                AQOracleDebug.println("DriverManager.Initialize: loading " + var2_3);
                Class.forName(var2_3);
                continue;
            }
            catch (Exception var3_4) {
                AQOracleDebug.println("DriverManager.Initialize: load failed: " + var3_4);
            }
lbl23:
            // 4 sources

            ** while (var0.length() != 0)
        }
lbl24:
        // 1 sources

    }

    private AQDriverManager() {
    }

    public static void registerDriver(AQDriver aQDriver) {
        if (!initialized) {
            AQDriverManager.initialize();
        }
        drivers.addElement(aQDriver);
        AQOracleDebug.trace(4, "AQDriverManager.registerDriver", "Registered driver: " + aQDriver.toString());
    }

    public static Vector getDrivers() {
        return drivers;
    }

    public static synchronized AQSession createAQSession(Object object) throws AQException {
        int n = 0;
        AQSession aQSession = null;
        AQDriver aQDriver = null;
        boolean bl = false;
        Vector vector = AQDriverManager.getDrivers();
        if (!initialized) {
            AQDriverManager.initialize();
        }
        if (drivers == null || drivers.size() == 0) {
            if (drivers.size() == 0) {
                throw new AQException(0, "No AQ drivers registered");
            }
        } else {
            try {
                n = 0;
                while (n < drivers.size()) {
                    bl = false;
                    aQDriver = (AQDriver)drivers.elementAt(n);
                    try {
                        bl = aQDriver.acceptsObject(object);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bl) {
                        aQSession = aQDriver.createAQSession(object);
                        break;
                    }
                    ++n;
                }
                if (!bl) {
                    throw new AQException(0, "Cannot open connection - invalid conn");
                }
            }
            catch (Exception exception) {
                throw new AQException(0, exception.getMessage(), exception);
            }
        }
        return aQSession;
    }

    public static OutputStream getLogStream() {
        return logstream;
    }

    public static void setLogStream(OutputStream outputStream) {
        logstream = outputStream;
        pstream = new PrintWriter(logstream);
    }

    public static PrintWriter getPrintWriter() {
        return pstream;
    }

    public static boolean isStmtCachingEnabled() {
        return cache_stmts;
    }

    public static void setCacheStmtFlag(boolean bl) {
        cache_stmts = bl;
    }

    public static void enableOciAQ() {
        enable_jni = true;
    }

    public static void disableOciAQ() {
        enable_jni = false;
    }

    public static boolean isOciAQEnabled() {
        return enable_jni;
    }

    static {
        initialized = false;
        logstream = System.err;
        pstream = new PrintWriter(logstream);
        cache_stmts = true;
        enable_jni = true;
        drivers = new Vector();
    }
}

