/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import oracle.AQ.AQException;
import oracle.AQ.AQMessage;
import oracle.AQ.AQMessageProperty;
import oracle.AQ.AQObjectPayload;
import oracle.AQ.AQOracleObjectPayload;
import oracle.AQ.AQOracleRawPayload;
import oracle.AQ.AQRawPayload;
import oracle.AQ.AQUtil;

public class AQOracleMessage
implements AQMessage {
    private byte[] msg_id;
    private int pload_type;
    private AQOracleRawPayload r_payload;
    private AQOracleObjectPayload o_payload;
    private AQMessageProperty m_property;

    AQOracleMessage(int n, AQOracleRawPayload aQOracleRawPayload, AQMessageProperty aQMessageProperty) throws AQException {
        if (n != 2) {
            AQUtil.throwAQEx(122, "Payload type must be AQConstants.RAW_TYPE_PAYLOAD");
        }
        this.pload_type = n;
        this.r_payload = aQOracleRawPayload;
        this.o_payload = null;
        this.m_property = aQMessageProperty;
        this.msg_id = null;
    }

    AQOracleMessage(int n, AQOracleObjectPayload aQOracleObjectPayload, AQMessageProperty aQMessageProperty) throws AQException {
        if (n != 1) {
            AQUtil.throwAQEx(122, "Payload type must be AQConstants.OBJECT_TYPE_PAYLOAD");
        }
        this.pload_type = n;
        this.o_payload = aQOracleObjectPayload;
        this.r_payload = null;
        this.m_property = aQMessageProperty;
        this.msg_id = null;
    }

    AQOracleMessage(int n) throws AQException {
        if (n != 1 && n != 2) {
            AQUtil.throwAQEx(129);
        }
        this.pload_type = n;
        this.o_payload = null;
        this.r_payload = null;
        this.m_property = null;
        this.msg_id = null;
    }

    public byte[] getMessageId() throws AQException {
        return this.msg_id;
    }

    void setMessageId(byte[] byArray) throws AQException {
        this.msg_id = byArray;
    }

    public AQRawPayload getRawPayload() throws AQException {
        return this.r_payload;
    }

    public void setRawPayload(AQRawPayload aQRawPayload) throws AQException {
        Class<?> clazz = null;
        if (this.pload_type != 2) {
            AQUtil.throwAQEx(171, "RAW");
        }
        if (aQRawPayload != null) {
            try {
                clazz = Class.forName("oracle.AQ.AQOracleRawPayload");
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(109);
            }
            if (clazz.isInstance(aQRawPayload)) {
                this.r_payload = (AQOracleRawPayload)aQRawPayload;
            } else {
                AQUtil.throwAQEx(129);
            }
        } else {
            this.r_payload = null;
        }
    }

    public AQObjectPayload getObjectPayload() throws AQException {
        return this.o_payload;
    }

    public void setObjectPayload(AQObjectPayload aQObjectPayload) throws AQException {
        Class<?> clazz = null;
        if (this.pload_type != 1) {
            AQUtil.throwAQEx(171, "OBJECT");
        }
        if (aQObjectPayload != null) {
            try {
                clazz = Class.forName("oracle.AQ.AQOracleObjectPayload");
            }
            catch (Exception exception) {
                AQUtil.throwAQEx(109);
            }
            if (clazz.isInstance(aQObjectPayload)) {
                this.o_payload = (AQOracleObjectPayload)aQObjectPayload;
            } else {
                AQUtil.throwAQEx(129);
            }
        } else {
            this.o_payload = null;
        }
    }

    public AQMessageProperty getMessageProperty() throws AQException {
        return this.m_property;
    }

    public void setMessageProperty(AQMessageProperty aQMessageProperty) throws AQException {
        this.m_property = aQMessageProperty;
    }
}

