/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.AQ.AQAgent;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQQueue;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.AQ.AQSession;
import oracle.AQ.AQUtil;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public class AQOracleSession
implements AQSession {
    Connection db_conn;
    private CallableStatement crqu_stmt;
    private CallableStatement allq_stmt;
    private CallableStatement allqo_stmt;
    private OracleCallableStatement lstn_stmt;
    private short dbversion;

    public AQOracleSession(Connection connection) throws AQException {
        Hashtable hashtable = null;
        this.db_conn = connection;
        this.crqu_stmt = null;
        this.allq_stmt = null;
        this.allqo_stmt = null;
        this.lstn_stmt = null;
        if (connection == null) {
            AQUtil.throwAQEx(111);
        }
        try {
            hashtable = (Hashtable)((oracle.jdbc.OracleConnection)this.db_conn).getTypeMap();
            this.dbversion = ((OracleConnection)connection).getVersionNumber();
            if (hashtable == null) {
                ((oracle.jdbc.OracleConnection)connection).setTypeMap(new Hashtable(20));
            }
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(112);
        }
    }

    public AQQueueTable createQueueTable(String string, String string2, AQQueueTableProperty aQQueueTableProperty) throws AQException {
        Statement statement = null;
        String string3 = "";
        AQOracleQueueTable aQOracleQueueTable = null;
        String string4 = "true";
        String string5 = "false";
        String string6 = "false";
        String string7 = null;
        if (string2 == null || string2.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (string2.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, string2);
        }
        if (aQQueueTableProperty == null) {
            AQUtil.throwAQEx(186);
        }
        string3 = string == null || string.equals("") ? string2 : string + "." + string2;
        string7 = aQQueueTableProperty.getCompatible();
        if (string7 == null || string7.equals("")) {
            string7 = "8.1";
        }
        try {
            if (aQQueueTableProperty.isMulticonsumerEnabled()) {
                string5 = "true";
            }
            if (!aQQueueTableProperty.isAutoCommitEnabled()) {
                string4 = "false";
            }
            if (aQQueueTableProperty.isSecure()) {
                string6 = "true";
            }
            statement = this.is92compatible() ? this.db_conn.prepareCall("begin dbms_aqadm.create_queue_table(queue_table => ?, queue_payload_type => ?, storage_clause => ?, sort_list => ?, multiple_consumers => " + string5 + ", message_grouping => ?, comment => ?, auto_commit => " + string4 + ", primary_instance => ?, secondary_instance => ?, compatible => ?, non_repudiation => ?, secure => " + string6 + "); end;") : (this.is82compatible() ? this.db_conn.prepareCall("begin dbms_aqadm.create_queue_table(queue_table => ?, queue_payload_type => ?, storage_clause => ?, sort_list => ?, multiple_consumers => " + string5 + ", message_grouping => ?, comment => ?, auto_commit => " + string4 + ", primary_instance => ?, secondary_instance => ?, compatible => ?, non_repudiation => ?); end;") : this.db_conn.prepareCall("begin dbms_aqadm.create_queue_table(queue_table => ?, queue_payload_type => ?, storage_clause => ?, sort_list => ?, multiple_consumers => " + string5 + ", message_grouping => ?, comment => ?, auto_commit => " + string4 + ", primary_instance => ?, secondary_instance => ?, compatible => ?); end;"));
            statement.setString(1, string3);
            statement.setString(2, aQQueueTableProperty.getPayloadType());
            statement.setString(3, aQQueueTableProperty.getStorageClause());
            statement.setString(4, aQQueueTableProperty.getSortOrder());
            statement.setInt(5, aQQueueTableProperty.getMessageGrouping());
            statement.setString(6, aQQueueTableProperty.getComment());
            statement.setInt(7, aQQueueTableProperty.getPrimaryInstance());
            statement.setInt(8, aQQueueTableProperty.getSecondaryInstance());
            statement.setString(9, string7);
            if (this.is82compatible()) {
                statement.setInt(10, aQQueueTableProperty.getNonRepudiation());
            }
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleSession.createQueueTable", sQLException);
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        aQOracleQueueTable = new AQOracleQueueTable(this, string, string2, aQQueueTableProperty);
        return aQOracleQueueTable;
    }

    public AQQueueTable getQueueTable(String string, String string2) throws AQException {
        AQOracleQueueTable aQOracleQueueTable = null;
        AQQueueTableProperty aQQueueTableProperty = null;
        Object var5_5 = null;
        ResultSet resultSet = null;
        Object var7_7 = null;
        String string3 = null;
        String string4 = "";
        String string5 = null;
        Statement statement = null;
        Statement statement2 = null;
        String string6 = null;
        if (string2 == null || string2.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (string2.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, string2);
        }
        try {
            if (string != null && !string.equals("")) {
                string5 = string;
            }
            if (string5 != null) {
                try {
                    statement2 = this.is92compatible() ? this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where owner = ? and queue_table = ?") : this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where owner = ? and queue_table = ?");
                    statement2.setString(1, string5.toUpperCase());
                    statement2.setString(2, string2.toUpperCase());
                    resultSet = statement2.executeQuery();
                }
                catch (SQLException sQLException) {
                    AQOracleDebug.traceEx(3, "AQOracleSession.getQueueTable-1", sQLException);
                    throw sQLException;
                }
            }
            try {
                statement = this.is92compatible() ? this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where queue_table = ?") : this.db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where queue_table = ?");
                statement.setString(1, string2.toUpperCase());
                resultSet = statement.executeQuery();
            }
            catch (SQLException sQLException) {
                AQOracleDebug.traceEx(3, "AQOracleSession.getQueueTable-2", sQLException);
                throw sQLException;
            }
            if (resultSet != null && resultSet.next()) {
                string3 = resultSet.getString(2);
                AQOracleDebug.trace(5, "AQOracleSession.getQueueTable", "Payload type: " + string3);
                if (string3.equals("RAW")) {
                    aQQueueTableProperty = new AQQueueTableProperty("RAW");
                } else {
                    string4 = resultSet.getString(3);
                    aQQueueTableProperty = new AQQueueTableProperty(string4);
                }
                aQQueueTableProperty.setSortOrder(resultSet.getString(4));
                if (resultSet.getString(5).equals("SINGLE")) {
                    aQQueueTableProperty.setMultiConsumer(false);
                } else {
                    aQQueueTableProperty.setMultiConsumer(true);
                }
                if (resultSet.getString(6).equals("TRANSACTIONAL")) {
                    aQQueueTableProperty.setMessageGrouping(1);
                }
                if (resultSet.getString(7) != null) {
                    aQQueueTableProperty.setComment(resultSet.getString(7));
                }
                aQQueueTableProperty.setCompatible(resultSet.getString(8));
                aQQueueTableProperty.setPrimaryInstance(resultSet.getInt(9));
                aQQueueTableProperty.setSecondaryInstance(resultSet.getInt(10));
                if (this.is92compatible()) {
                    string6 = resultSet.getString(12);
                    AQOracleDebug.trace(5, "AQOracleSession.getQueueTable", "Secure queue table: " + string6);
                    if (string6.equalsIgnoreCase("YES")) {
                        aQQueueTableProperty.setSecure(true);
                    }
                }
            } else if (string5 != null) {
                AQUtil.throwAQEx(173, string5 + "." + string2);
            } else {
                AQUtil.throwAQEx(173, string2);
            }
            if (resultSet.next()) {
                if (string5 != null) {
                    AQUtil.throwAQEx(172, "");
                } else {
                    AQUtil.throwAQEx(172, "(must specify owner)");
                }
            }
            if (string5 != null) {
                try {
                    statement2.close();
                }
                catch (Exception exception) {}
            } else {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            if (string5 != null) {
                try {
                    statement2.close();
                }
                catch (Exception exception2) {}
            } else {
                try {
                    statement.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            AQOracleDebug.traceEx(3, "AQOracleSession.getQeueueTable-4", exception);
            if (exception.getClass().getName().equals("oracle.AQ.AQException")) {
                throw (AQException)exception;
            }
            throw new AQOracleSQLException((SQLException)exception);
        }
        aQOracleQueueTable = new AQOracleQueueTable(this, string5, string2, aQQueueTableProperty);
        return aQOracleQueueTable;
    }

    public AQQueue createQueue(AQQueueTable aQQueueTable, String string, AQQueueProperty aQQueueProperty) throws AQException {
        CallableStatement callableStatement = null;
        AQOracleQueue aQOracleQueue = null;
        String string2 = null;
        String string3 = "";
        String string4 = "true";
        String string5 = null;
        if (string == null || string.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (aQQueueProperty == null) {
            AQUtil.throwAQEx(185);
        }
        if (aQQueueTable == null) {
            AQUtil.throwAQEx(187);
        }
        if (string.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, string);
        }
        string3 = (string2 = aQQueueTable.getOwner()) == null || string2.equals("") ? aQQueueTable.getName() : string2 + "." + aQQueueTable.getName();
        try {
            if (!aQQueueProperty.isAutoCommitEnabled()) {
                string4 = "false";
                callableStatement = this.db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => false); end;");
            } else {
                if (this.crqu_stmt != null) {
                    this.crqu_stmt.clearParameters();
                } else {
                    this.crqu_stmt = this.db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => true); end;");
                }
                callableStatement = this.crqu_stmt;
            }
            callableStatement.setString(1, string);
            callableStatement.setString(2, string3);
            callableStatement.setInt(3, aQQueueProperty.getQueueType());
            if (aQQueueProperty.max_retries != null) {
                ((OracleCallableStatement)callableStatement).setObject(4, (Object)aQQueueProperty.max_retries, 4);
            } else {
                ((OracleCallableStatement)callableStatement).setNull(4, 4);
            }
            callableStatement.setDouble(5, aQQueueProperty.getRetryInterval());
            callableStatement.setDouble(6, aQQueueProperty.getRetentionTime());
            callableStatement.setString(7, aQQueueProperty.getComment());
            callableStatement.execute();
        }
        catch (SQLException sQLException) {
            if (string4.equals("true")) {
                try {
                    this.crqu_stmt.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.crqu_stmt = null;
            }
            AQOracleDebug.traceEx(3, "AQOracleSession.createQueue", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
        string5 = ((AQOracleQueueTable)aQQueueTable).property.getPayloadType();
        aQOracleQueue = string5.equalsIgnoreCase("RAW") ? new AQOracleQueue(this, string2, string, aQQueueTable.getName(), aQQueueProperty, 2, null, aQQueueTable.isSecure()) : new AQOracleQueue(this, string2, string, aQQueueTable.getName(), aQQueueProperty, 1, string5, aQQueueTable.isSecure());
        return aQOracleQueue;
    }

    public AQQueue getQueue(String string, String string2) throws AQException {
        AQOracleQueue aQOracleQueue = null;
        AQQueueProperty aQQueueProperty = null;
        ResultSet resultSet = null;
        int n = 0;
        String string3 = "";
        String string4 = "";
        String string5 = null;
        boolean bl = false;
        if (string2 == null || string2.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (string2.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, string2);
        }
        try {
            try {
                if (string == null || string.equals("")) {
                    if (this.allq_stmt == null) {
                        this.allq_stmt = this.is92compatible() ? this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type, t2.secure from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner") : this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type from all_queues t1, all_queue_tables t2 where t1.name=? and t1.queue_table=t2.queue_table and t1.owner=t2.owner");
                    } else {
                        this.allq_stmt.clearParameters();
                    }
                    this.allq_stmt.setString(1, string2.toUpperCase());
                    resultSet = this.allq_stmt.executeQuery();
                } else {
                    if (this.allqo_stmt == null) {
                        this.allqo_stmt = this.is92compatible() ? this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type, t2.secure from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table") : this.db_conn.prepareCall("select t1.owner, t1.name, t1.queue_table, t1.queue_type, t1.max_retries, t1.retry_delay, t1.retention, t1.user_comment, t2.type, t2.object_type from all_queues t1, all_queue_tables t2 where t1.owner=? and t1.name=? and t2.owner=? and t1.queue_table=t2.queue_table");
                    } else {
                        this.allqo_stmt.clearParameters();
                    }
                    this.allqo_stmt.setString(1, string.toUpperCase());
                    this.allqo_stmt.setString(2, string2.toUpperCase());
                    this.allqo_stmt.setString(3, string.toUpperCase());
                    resultSet = this.allqo_stmt.executeQuery();
                }
            }
            catch (SQLException sQLException) {
                AQOracleDebug.traceEx(3, "AQOracleSession.getQeueue-1", sQLException);
                if (string == null || string.equals("")) {
                    try {
                        this.allq_stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.allq_stmt = null;
                } else {
                    try {
                        this.allqo_stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.allqo_stmt = null;
                }
                throw sQLException;
            }
            if (resultSet.next()) {
                aQQueueProperty = new AQQueueProperty();
                if (resultSet.getString(4).equals("EXCEPTION_QUEUE")) {
                    aQQueueProperty.setQueueType(1);
                }
                aQQueueProperty.setMaxRetries(resultSet.getInt(5));
                aQQueueProperty.setRetryInterval(resultSet.getInt(6));
                string4 = resultSet.getString(7).trim();
                if (string4.equals("FOREVER")) {
                    aQQueueProperty.setRetentionTime(-1.0);
                } else {
                    aQQueueProperty.setRetentionTime(resultSet.getDouble(7));
                }
                aQQueueProperty.setComment(resultSet.getString(8));
                if (resultSet.getString(9).equals("RAW")) {
                    n = 2;
                } else {
                    n = 1;
                    string3 = resultSet.getString(10);
                }
                if (this.is92compatible()) {
                    string5 = resultSet.getString(11);
                    AQOracleDebug.trace(5, "AQOracleSession.getQueue", "Secure queue table: " + string5);
                    if (string5.equalsIgnoreCase("YES")) {
                        bl = true;
                    }
                }
            } else if (string == null || string.equals("")) {
                AQUtil.throwAQEx(190, string2);
            } else {
                AQUtil.throwAQEx(190, string + "." + string2);
            }
            aQOracleQueue = n == 2 ? new AQOracleQueue(this, resultSet.getString(1), string2, resultSet.getString(3), aQQueueProperty, n, null, bl) : new AQOracleQueue(this, resultSet.getString(1), string2, resultSet.getString(3), aQQueueProperty, n, string3, bl);
            if (resultSet.next()) {
                AQUtil.throwAQEx(182);
            }
        }
        catch (AQException aQException) {
            AQOracleDebug.traceEx(3, "AQOracleSession.getQueue-2", aQException);
            throw aQException;
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleSession.getQueue-3", sQLException);
            throw new AQOracleSQLException(sQLException);
        }
        return aQOracleQueue;
    }

    public AQAgent listen(AQAgent[] aQAgentArray, int n) throws AQException {
        Integer n2 = null;
        ARRAY aRRAY = null;
        Hashtable hashtable = null;
        AQAgent aQAgent = null;
        AQOracleAgent aQOracleAgent = null;
        ResultSet resultSet = null;
        AQOracleDebug.trace(4, "AQOracleSession.listen", "entry");
        if (aQAgentArray == null || aQAgentArray[0] == null) {
            AQUtil.throwAQEx(145);
        }
        try {
            if (this.db_conn == null) {
                AQUtil.throwAQEx(112);
            }
            hashtable = (Hashtable)((oracle.jdbc.OracleConnection)this.db_conn).getTypeMap();
            hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
        }
        catch (Exception exception) {
            AQUtil.throwAQEx(146, exception);
        }
        try {
            if (this.lstn_stmt == null) {
                AQOracleDebug.trace(4, "AQOracleSession.listen", "lstn_stmt = null");
                this.lstn_stmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_listen(?, ?, ?); end; ");
            } else {
                this.lstn_stmt.clearParameters();
            }
            aRRAY = this.createRecpArrayfromAgentList(aQAgentArray);
            if (aRRAY != null) {
                AQOracleDebug.trace(4, "AQOracleSession.listen", "generated recp array ");
            } else {
                AQOracleDebug.trace(4, "AQOracleSession.listen", "recp array = nul");
            }
            this.lstn_stmt.setObject(1, (Object)aRRAY, 2003);
            n2 = new Integer(n);
            AQOracleDebug.trace(4, "AQOracleSession.listen", "wait " + n2);
            this.lstn_stmt.setObject(2, (Object)n2, 4);
            this.lstn_stmt.registerOutParameter(3, 2002, "SYS.AQ$_AGENT");
            AQOracleDebug.trace(4, "AQOracleSession.listen", "before execute");
            resultSet = this.lstn_stmt.executeQuery();
            AQOracleDebug.trace(4, "AQOracleSession.listen", "after execute");
            aQOracleAgent = (AQOracleAgent)this.lstn_stmt.getObject(3);
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            AQOracleDebug.traceEx(3, "AQOracleSession.listen-3", sQLException);
            try {
                this.lstn_stmt.close();
            }
            catch (Exception exception) {
                AQOracleDebug.traceEx(3, "AQOracleSession.listen-close_ex", exception);
            }
            this.lstn_stmt = null;
            throw new AQOracleSQLException(sQLException);
        }
        if (aQOracleAgent != null) {
            aQAgent = new AQAgent(aQOracleAgent.name, aQOracleAgent.address, aQOracleAgent.protocol);
        }
        return aQAgent;
    }

    public Connection getDBConnection() throws AQException {
        return this.db_conn;
    }

    public void createAQAgent(String string) throws AQException {
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-1", "entry");
        this.createAQAgent(string, false, false, null);
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-1", "exit");
    }

    public void createAQAgent(String string, boolean bl, boolean bl2, String string2) throws AQException {
        Statement statement = null;
        String string3 = "false";
        String string4 = "false";
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-2", "entry");
        if (string == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (bl) {
            string3 = "true";
        }
        if (bl2) {
            string4 = "true";
        }
        try {
            statement = this.db_conn.prepareCall("begin dbms_aqadm.create_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + string3 + ", enable_smtp => " + string4 + "); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        AQOracleDebug.trace(4, "AQOracleSession.createAQAgent-2", "exit");
    }

    public void alterAQAgent(String string, boolean bl, boolean bl2, String string2) throws AQException {
        Statement statement = null;
        String string3 = "false";
        String string4 = "false";
        AQOracleDebug.trace(4, "AQOracleSession.alterAQAgent", "entry");
        if (string == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (bl) {
            string3 = "true";
        }
        if (bl2) {
            string4 = "true";
        }
        try {
            statement = this.db_conn.prepareCall("begin dbms_aqadm.alter_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + string3 + ", enable_smtp => " + string4 + "); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        AQOracleDebug.trace(4, "AQOracleSession.alterAQAgent", "exit");
    }

    public void dropAQAgent(String string) throws AQException {
        CallableStatement callableStatement = null;
        AQOracleDebug.trace(4, "AQOracleSession.dropAQAgent", "entry");
        if (string == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        try {
            callableStatement = this.db_conn.prepareCall("begin dbms_aqadm.drop_aq_agent(agent_name=> ? ); end;");
            callableStatement.setString(1, string);
            callableStatement.execute();
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                callableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        AQOracleDebug.trace(4, "AQOracleSession.dropAQAgent", "exit");
    }

    public void enableDBAccess(String string, String string2) throws AQException {
        CallableStatement callableStatement = null;
        AQOracleDebug.trace(4, "AQOracleSession.enableDBAccess", "entry");
        if (string == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (string2 == null) {
            AQUtil.throwAQEx(229, "db_username");
        }
        try {
            callableStatement = this.db_conn.prepareCall("begin dbms_aqadm.enable_db_access(agent_name=> ?, db_username => ? ); end;");
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            callableStatement.execute();
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                callableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        AQOracleDebug.trace(4, "AQOracleSession.enableDBAccess", "exit");
    }

    public void disableDBAccess(String string, String string2) throws AQException {
        CallableStatement callableStatement = null;
        AQOracleDebug.trace(4, "AQOracleSession.disableDBAccess", "entry");
        if (string == null) {
            AQUtil.throwAQEx(229, "agent_name");
        }
        if (string2 == null) {
            AQUtil.throwAQEx(229, "db_username");
        }
        try {
            callableStatement = this.db_conn.prepareCall("begin dbms_aqadm.disable_db_access(agent_name=> ?, db_username => ? ); end;");
            callableStatement.setString(1, string);
            callableStatement.setString(2, string2);
            callableStatement.execute();
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                callableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQOracleSQLException(sQLException);
        }
        AQOracleDebug.trace(4, "AQOracleSession.disableDBAccess", "exit");
    }

    private ARRAY createRecpArrayfromAgentList(AQAgent[] aQAgentArray) throws AQException {
        ArrayDescriptor arrayDescriptor = null;
        Object[] objectArray = null;
        ARRAY aRRAY = null;
        int n = 0;
        AQOracleAgent aQOracleAgent = null;
        AQAgent aQAgent = null;
        int n2 = 0;
        n = aQAgentArray.length;
        objectArray = new Object[n];
        AQOracleDebug.trace(4, "AQOracleSession.createRecpArrayfromAgentList", "num_agts = " + n);
        n2 = 0;
        while (n2 < n) {
            aQAgent = aQAgentArray[n2];
            if (aQAgent == null) {
                AQUtil.throwAQEx(145);
            }
            aQOracleAgent = new AQOracleAgent(aQAgent.getName(), aQAgent.getAddress(), aQAgent.getProtocol());
            AQOracleDebug.trace(4, "AQOracleSession.createRecpArrayfromAgentList", "agt-" + n2 + ":: " + aQOracleAgent.name + "::" + aQOracleAgent.address + "::" + aQOracleAgent.protocol);
            objectArray[n2] = aQOracleAgent;
            ++n2;
        }
        try {
            arrayDescriptor = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_RECIPIENTS", (Connection)this.db_conn);
            aRRAY = new ARRAY(arrayDescriptor, this.db_conn, (Object)objectArray);
        }
        catch (SQLException sQLException) {
            throw new AQOracleSQLException(sQLException);
        }
        return aRRAY;
    }

    boolean is82compatible() {
        boolean bl = false;
        if (this.dbversion >= 8200) {
            bl = true;
        }
        return bl;
    }

    boolean is92compatible() {
        boolean bl = false;
        if (this.dbversion >= 9200) {
            bl = true;
        }
        return bl;
    }

    public void close() {
        try {
            if (this.crqu_stmt != null) {
                this.crqu_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.allqo_stmt != null) {
                this.allqo_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.allq_stmt != null) {
                this.allq_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.lstn_stmt != null) {
                this.lstn_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.db_conn = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[AQOracleSession]");
        if (this.db_conn != null) {
            stringBuffer.append("\n  db_conn          : " + this.db_conn);
        } else {
            stringBuffer.append("\n  db_conn          : NULL");
        }
        return stringBuffer.toString();
    }
}

