/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jms.AQjmsConnectionMetaData;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsEventListener;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsExceptionListener;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsConnection
implements QueueConnection,
TopicConnection {
    String hostname;
    String oracle_sid;
    int portno;
    String user;
    Connection db_conn;
    OracleOCIConnectionPool cpool;
    boolean created_pool;
    String driver;
    String client_id;
    int conn_type;
    boolean started;
    AQjmsConnectionMetaData metadata;
    String connect_str;
    Session jms_sess_open;
    boolean opened_new_conn;
    volatile boolean close_in_progress;
    AQjmsEventListener eventListener;
    short dbversion;
    AQjmsExceptionListener m_el;
    int m_tempCount = 0;
    static Hashtable s_temps = new Hashtable();
    String connection_id;

    AQjmsConnection(String string, String string2, int n, String string3, String string4, String string5, int n2) throws JMSException {
        this.hostname = string;
        this.oracle_sid = string2;
        this.portno = n;
        this.driver = string5;
        this.user = string3;
        if (n2 == 10 || n2 == 20) {
            this.conn_type = n2;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            if (this.driver.equalsIgnoreCase("oci8") || this.driver.equalsIgnoreCase("oci")) {
                this.cpool = AQjmsConnection.createPool(string, string2, n, string3, string4);
                this.created_pool = true;
                this.driver = "oci8";
            } else {
                this.db_conn = AQjmsConnection.connect(string, string2, n, this.driver, string3, string4);
                this.db_conn.setAutoCommit(false);
                this.dbversion = ((oracle.jdbc.internal.OracleConnection)this.db_conn).getVersionNumber();
                this.opened_new_conn = true;
                this.driver = this.getDriverName(this.db_conn);
                this.cpool = null;
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection constructor", sQLException);
            if (sQLException.getErrorCode() == 1017) {
                throw new JMSSecurityException(AQjmsError.getMessage(232));
            }
            throw new AQjmsException(sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor - ClassNotFound", classNotFoundException);
            AQjmsError.throwEx(109, classNotFoundException);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.jms_sess_open = null;
        this.close_in_progress = false;
        this.m_el = null;
        this.setConnectionID();
    }

    AQjmsConnection(String string, Properties properties, int n) throws JMSException {
        if (n == 10 || n == 20) {
            this.conn_type = n;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            if (this.isOci8Url(string)) {
                if (properties == null) {
                    properties = new Properties();
                }
                this.cpool = AQjmsConnection.createPool(properties.getProperty("user"), properties.getProperty("password"), string, properties);
                if (this.cpool != null) {
                    this.cpool.setPoolConfig(properties);
                    this.created_pool = true;
                    this.user = properties.getProperty("user");
                    this.driver = "oci8";
                }
            } else {
                DriverManager.registerDriver((Driver)new OracleDriver());
                this.db_conn = properties != null ? DriverManager.getConnection(string, properties) : DriverManager.getConnection(string);
                this.db_conn.setAutoCommit(false);
                this.dbversion = ((oracle.jdbc.internal.OracleConnection)this.db_conn).getVersionNumber();
                this.opened_new_conn = true;
                this.cpool = null;
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor url", sQLException);
            if (sQLException.getErrorCode() == 1017) {
                throw new JMSSecurityException(AQjmsError.getMessage(232));
            }
            throw new AQjmsException(sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor - ClassNotFound", classNotFoundException);
            AQjmsError.throwEx(109, classNotFoundException);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.jms_sess_open = null;
        this.close_in_progress = false;
        try {
            if (this.db_conn != null) {
                this.user = ((oracle.jdbc.OracleConnection)this.db_conn).getUserName();
                this.driver = this.getDriverName(this.db_conn);
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection constructor url no_user", sQLException);
            if (sQLException.getErrorCode() == 1017) {
                throw new JMSSecurityException(AQjmsError.getMessage(232));
            }
            throw new AQjmsException(sQLException);
        }
        this.m_el = null;
        this.setConnectionID();
    }

    AQjmsConnection(String string, String string2, String string3, int n) throws JMSException {
        if (n == 10 || n == 20) {
            this.conn_type = n;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            if (this.isOci8Url(string)) {
                this.cpool = AQjmsConnection.createPool(string2, string3, string, null);
                if (this.cpool != null) {
                    this.created_pool = true;
                    this.user = string2;
                    this.driver = "oci8";
                }
            } else {
                DriverManager.registerDriver((Driver)new OracleDriver());
                this.db_conn = DriverManager.getConnection(string, string2, string3);
                this.db_conn.setAutoCommit(false);
                this.dbversion = ((oracle.jdbc.internal.OracleConnection)this.db_conn).getVersionNumber();
                this.opened_new_conn = true;
                this.cpool = null;
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor url un/ps", sQLException);
            if (sQLException.getErrorCode() == 1017) {
                throw new JMSSecurityException(AQjmsError.getMessage(232));
            }
            throw new AQjmsException(sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor - ClassNotFound", classNotFoundException);
            AQjmsError.throwEx(109, classNotFoundException);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.jms_sess_open = null;
        this.close_in_progress = false;
        try {
            if (this.db_conn != null) {
                this.user = ((oracle.jdbc.OracleConnection)this.db_conn).getUserName();
                this.driver = this.getDriverName(this.db_conn);
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection constructor url no_user", sQLException);
            throw new AQjmsException(sQLException);
        }
        this.m_el = null;
        this.setConnectionID();
    }

    AQjmsConnection(Connection connection, int n) throws JMSException {
        Class<?> clazz = null;
        if (n == 10 || n == 20) {
            this.conn_type = n;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            clazz = Class.forName("oracle.jdbc.internal.OracleConnection");
        }
        catch (Exception exception) {
            AQjmsError.throwEx(109);
        }
        try {
            if (connection == null) {
                AQjmsError.throwEx(111);
            } else if (clazz.isInstance(connection)) {
                this.db_conn = connection;
            } else {
                AQjmsError.throwEx(112);
            }
            if (!((oracle.jdbc.OracleConnection)this.db_conn).getUsingXAFlag()) {
                this.db_conn.setAutoCommit(false);
            }
            this.dbversion = ((oracle.jdbc.internal.OracleConnection)this.db_conn).getVersionNumber();
            this.user = ((oracle.jdbc.OracleConnection)this.db_conn).getUserName();
            this.driver = this.getDriverName(this.db_conn);
            this.cpool = null;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection: constructor db_conn", sQLException);
            throw new AQjmsException(sQLException);
        }
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.opened_new_conn = false;
        this.jms_sess_open = null;
        this.close_in_progress = false;
        this.m_el = null;
        this.setConnectionID();
    }

    AQjmsConnection(OracleOCIConnectionPool oracleOCIConnectionPool, int n) throws JMSException {
        Class<?> clazz = null;
        if (n == 10 || n == 20) {
            this.conn_type = n;
        } else {
            AQjmsError.throwEx(127);
        }
        try {
            clazz = Class.forName("oracle.jdbc.pool.OracleOCIConnectionPool");
        }
        catch (Exception exception) {
            AQjmsError.throwEx(109);
        }
        if (oracleOCIConnectionPool == null) {
            AQjmsError.throwEx(111);
        } else if (clazz.isInstance(oracleOCIConnectionPool)) {
            this.cpool = oracleOCIConnectionPool;
        } else {
            AQjmsError.throwEx(112);
        }
        this.user = oracleOCIConnectionPool.getUser();
        this.started = false;
        this.metadata = new AQjmsConnectionMetaData();
        this.created_pool = false;
        this.jms_sess_open = null;
        this.close_in_progress = false;
        this.driver = oracleOCIConnectionPool.getDriverType();
        this.m_el = null;
        this.setConnectionID();
    }

    /*
     * Loose catch block
     */
    private void setConnectionID() throws JMSException {
        block25: {
            Statement statement = null;
            ResultSet resultSet = null;
            boolean bl = false;
            Connection connection = null;
            if (this.db_conn != null) {
                connection = this.db_conn;
            } else if (this.cpool != null) {
                connection = this.cpool.getConnection();
                bl = true;
            } else {
                AQjmsError.throwEx(122, "No database connection within jms connection");
            }
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select SYS_GUID() from dual");
            resultSet.next();
            this.connection_id = this.BytesToString(resultSet.getBytes(1));
            Object var7_5 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                if (bl && connection != null) {
                    connection.close();
                }
                break block25;
            }
            catch (SQLException sQLException) {}
            break block25;
            {
                catch (SQLException sQLException) {
                    throw new AQjmsException(sQLException);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (bl && connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private String BytesToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(n2));
            ++n;
        }
        return stringBuffer.toString();
    }

    String getConnectionID() {
        return this.connection_id;
    }

    public String getClientID() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        return this.user;
    }

    public void setClientID(String string) throws JMSException {
        AQjmsError.throwIllegalStateEx(102, "setClientID");
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        return this.metadata;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.m_el != null) {
            this.m_el.setExceptionListener(exceptionListener);
        } else {
            this.m_el = this.created_pool || this.cpool != null ? new AQjmsExceptionListener(this.cpool) : new AQjmsExceptionListener(this.db_conn);
            if (this.started) {
                this.m_el.resumeExceptionListener();
            }
            this.m_el.setExceptionListener(exceptionListener);
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.m_el != null) {
            return this.m_el.getExceptionListener();
        }
        return null;
    }

    public synchronized void start() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.started) {
            return;
        }
        if (this.eventListener != null) {
            this.eventListener.startAQjmsEventListener();
        }
        if (this.m_el != null) {
            this.m_el.resumeExceptionListener();
        }
        this.started = true;
    }

    public synchronized void stop() throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (!this.started) {
            return;
        }
        if (this.eventListener != null) {
            this.eventListener.stopAQjmsEventListener();
        }
        if (this.m_el != null) {
            this.m_el.suspendExceptionListener();
        }
        this.started = false;
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsConnectionn.close", "closing connection");
        this.close_in_progress = true;
        this.closeConnectionResources();
        AQjmsOracleDebug.trace(5, "AQjmsConnection.close", "connection closed");
    }

    synchronized void closeConnectionResources() {
        if (this.m_el != null) {
            this.m_el.close();
            this.m_el = null;
        }
        try {
            try {
                if (this.eventListener != null) {
                    AQjmsOracleDebug.trace(3, "AQjmsConnection.closeConnectionResources", "calling stop event listener");
                    this.eventListener.stopAQjmsEventListener();
                    this.eventListener = null;
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsConnection.closeConnectionResources-ex", exception);
                this.eventListener = null;
            }
            Hashtable hashtable = s_temps;
            synchronized (hashtable) {
                Vector vector = new Vector();
                Enumeration enumeration = s_temps.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (s_temps.get(k) != this) continue;
                    vector.addElement(k);
                }
                int n = 0;
                while (n < vector.size()) {
                    AQjmsDestination aQjmsDestination = (AQjmsDestination)vector.elementAt(n);
                    s_temps.remove(aQjmsDestination);
                    try {
                        this.closeTemp(aQjmsDestination);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            try {
                if (this.jms_sess_open != null) {
                    this.jms_sess_open.close();
                    this.jms_sess_open = null;
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(3, "AQjmsConnection.closeConnectionResources-ex", exception);
                this.jms_sess_open = null;
            }
            if (this.opened_new_conn && this.db_conn != null) {
                this.db_conn.close();
            }
            if (this.created_pool && this.cpool != null) {
                this.cpool.close();
                this.created_pool = false;
                this.cpool = null;
            }
            AQjmsOracleDebug.trace(5, "AQjmsConnection.closeConnectionResources", "Connection closed");
            this.db_conn = null;
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnection.closeConnectionResources-sqlex", sQLException);
        }
    }

    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (!this.created_pool && this.cpool == null && this.getJmsSession() != null) {
            AQjmsError.throwEx(106);
        }
        AQjmsSession aQjmsSession = new AQjmsSession(this, n, bl, 10);
        this.setJmsSession((Session)aQjmsSession);
        return aQjmsSession;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        AQjmsSession aQjmsSession = null;
        if (this.isConnectionClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (!this.created_pool && this.cpool == null && this.getJmsSession() != null) {
            AQjmsError.throwEx(106);
        }
        aQjmsSession = new AQjmsSession(this, n, bl, 20);
        this.setJmsSession((Session)aQjmsSession);
        return aQjmsSession;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        AQjmsError.throwEx(102);
        return null;
    }

    public Session getCurrentJmsSession() {
        return this.jms_sess_open;
    }

    void eventListenerToPoll() throws JMSException {
        if (this.eventListener != null) {
            this.eventListener.pollMessages();
        }
    }

    AQjmsEventListener getEventListener() {
        return this.eventListener;
    }

    synchronized AQjmsEventListener createEventListener() throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.startEventListener", "enter");
        if (this.eventListener == null) {
            this.eventListener = new AQjmsEventListener("oracle.jms.AQjmsHttpRcv", 1024);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createEventListener", "start");
        AQjmsOracleDebug.trace(3, "AQjmsSession.createEventListener", "exit");
        return this.eventListener;
    }

    boolean isConnectionClosed() {
        boolean bl;
        block7: {
            bl = false;
            if (this.close_in_progress) {
                return true;
            }
            if (this.db_conn != null) {
                try {
                    if (!this.db_conn.isClosed()) {
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    bl = true;
                }
            } else {
                if (this.created_pool || this.cpool != null) {
                    return false;
                }
                bl = true;
            }
        }
        return bl;
    }

    boolean isConnectionStarted() throws JMSException {
        return !this.isConnectionClosed() && this.started;
    }

    boolean isOci8Url(String string) throws JMSException {
        if (string != null) {
            return string.toLowerCase().startsWith("jdbc:oracle:oci");
        }
        return false;
    }

    synchronized void setJmsSession(Session session) throws JMSException {
        if (this.jms_sess_open != null && !this.created_pool && this.cpool == null) {
            AQjmsError.throwEx(106);
        } else {
            this.jms_sess_open = session;
        }
    }

    Session getJmsSession() {
        return this.jms_sess_open;
    }

    synchronized void clearJmsSession() {
        this.jms_sess_open = null;
    }

    private static Connection connect(String string, String string2, int n, String string3, String string4, String string5) throws SQLException, ClassNotFoundException, JMSException {
        String string6;
        DriverManager.registerDriver((Driver)new OracleDriver());
        if (string3.equals("oci8") || string3.equals("oci")) {
            string6 = new String("jdbc:oracle:oci8:");
            string6 = string6.concat("@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(PORT=" + n);
            string6 = string6.concat(")(HOST=" + string + "))(CONNECT_DATA=(SID=" + string2 + ")))");
        } else if (string3.equals("thin")) {
            string6 = new String("jdbc:oracle:thin:");
            string6 = string6.concat("@" + string + ":" + n + ":" + string2);
        } else {
            AQjmsError.throwEx(135);
            throw new AQjmsException("unsupported driver", 0);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection.connect", "Connect as : " + string4 + ":" + string5);
        return DriverManager.getConnection(string6, string4, string5);
    }

    private static OracleOCIConnectionPool createPool(String string, String string2, int n, String string3, String string4) throws SQLException, ClassNotFoundException, JMSException {
        String string5 = new String("jdbc:oracle:oci8:");
        string5 = string5.concat("@(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(PORT=" + n);
        string5 = string5.concat(")(HOST=" + string + "))(CONNECT_DATA=(SID=" + string2 + ")))");
        AQjmsOracleDebug.trace(5, "AQjmsConnection.createPool", "Connect as : " + string3 + ":" + string4);
        return AQjmsConnection.createPool(string3, string4, string5, null);
    }

    private static OracleOCIConnectionPool createPool(String string, String string2, String string3, Properties properties) throws SQLException, ClassNotFoundException, JMSException {
        if (properties == null) {
            properties = new Properties();
        }
        if (!((Hashtable)properties).containsKey(OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT)) {
            ((Hashtable)properties).put(OracleOCIConnectionPool.CONNPOOL_MIN_LIMIT, Integer.toString(1));
        }
        if (!((Hashtable)properties).containsKey(OracleOCIConnectionPool.CONNPOOL_INCREMENT)) {
            ((Hashtable)properties).put(OracleOCIConnectionPool.CONNPOOL_INCREMENT, Integer.toString(1));
        }
        if (!((Hashtable)properties).containsKey(OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT)) {
            ((Hashtable)properties).put(OracleOCIConnectionPool.CONNPOOL_MAX_LIMIT, Integer.toString(50));
        }
        AQjmsOracleDebug.trace(5, "AQjmsConnection.createPool", "Connect as : " + string + ":" + string2 + " with url " + string3);
        return new OracleOCIConnectionPool(string, string2, string3, properties);
    }

    Connection getDBConnection() {
        return this.db_conn;
    }

    public OracleOCIConnectionPool getOCIConnectionPool() throws JMSException {
        return this.cpool;
    }

    String getDriver() {
        return this.driver;
    }

    void setPingPeriod(long l) throws JMSException {
        if (this.m_el != null) {
            this.m_el.setPingPeriod(l);
        } else {
            AQjmsError.throwEx(107, "Session with NO Exception Listener");
        }
    }

    long getPingPeriod() {
        if (this.m_el != null) {
            return this.m_el.getPingPeriod();
        }
        return 120000L;
    }

    protected void finalize() {
        try {
            if (!this.isConnectionClosed()) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AQjmsOracleDebug.println("AQjmsConnection.finalize");
    }

    private String getDriverName(Connection connection) throws SQLException {
        String string;
        if (connection instanceof OracleConnection) {
            return ((OracleConnection)connection).getProtocolType();
        }
        if (connection instanceof oracle.jdbc.internal.OracleConnection && (string = ((oracle.jdbc.internal.OracleConnection)connection).getURL()) != null && string.startsWith("jdbc:oracle:")) {
            String string2 = string.substring("jdbc:oracle:".length());
            return string2.substring(0, string2.indexOf(58));
        }
        return null;
    }

    synchronized int getTempCount() {
        return ++this.m_tempCount;
    }

    void registerTemp(AQjmsDestination aQjmsDestination) throws JMSException {
        aQjmsDestination.makeTemp();
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            s_temps.put(aQjmsDestination, this);
        }
    }

    /*
     * Loose catch block
     */
    synchronized void closeTemp(AQjmsDestination aQjmsDestination) throws JMSException {
        block15: {
            Exception exception2222;
            Statement statement;
            Connection connection;
            block14: {
                connection = null;
                statement = null;
                connection = this.db_conn;
                if (this.cpool != null) {
                    connection = this.cpool.getConnection();
                }
                statement = (OracleCallableStatement)connection.prepareCall("BEGIN dbms_aqadm.stop_queue(queue_name => ?); dbms_aqadm.drop_queue(queue_name => ?); dbms_aqadm.drop_queue_table(queue_table => ?, force => true, auto_commit => true); END;");
                statement.setString(1, aQjmsDestination.getCompleteName());
                statement.setString(2, aQjmsDestination.getCompleteName());
                statement.setString(3, aQjmsDestination.getCompleteTableName());
                statement.executeQuery();
                Object var6_4 = null;
                if (statement == null) break block14;
                try {
                    statement.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (this.cpool != null) {
                try {
                    connection.close();
                }
                catch (Exception exception2222) {}
            }
            break block15;
            {
                catch (SQLException sQLException) {
                    throw new AQjmsException(sQLException);
                }
            }
            catch (Throwable throwable) {
                Exception exception32222;
                Object var6_5 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                if (this.cpool != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    static void findCloseTemp(AQjmsDestination aQjmsDestination) throws JMSException {
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            if (!s_temps.containsKey(aQjmsDestination)) {
                return;
            }
            AQjmsConnection aQjmsConnection = (AQjmsConnection)s_temps.get(aQjmsDestination);
            s_temps.remove(aQjmsDestination);
            if (aQjmsConnection != null) {
                aQjmsConnection.closeTemp(aQjmsDestination);
            }
        }
    }

    static AQjmsConnection getJmsConnection(AQjmsDestination aQjmsDestination) {
        AQjmsConnection aQjmsConnection = null;
        Hashtable hashtable = s_temps;
        synchronized (hashtable) {
            if (s_temps.containsKey(aQjmsDestination)) {
                aQjmsConnection = (AQjmsConnection)s_temps.get(aQjmsDestination);
            }
        }
        return aQjmsConnection;
    }
}

