/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsQueueConnectionFactory;
import oracle.jms.AQjmsTopicConnectionFactory;

public class AQjmsConnectionFactory
implements ObjectFactory {
    String hostname;
    String oracle_sid;
    int portno;
    String jdbc_driver = "thin";
    String jdbc_conn_str = null;
    String user = null;
    String passwd = null;
    String classname = null;
    Properties jdbc_info = null;
    static final String HOST_ATTR = "host";
    static final String PORT_ATTR = "port";
    static final String SID_ATTR = "sid";
    static final String JDBC_CNN_ATTR = "jdbc_connect_string";
    static final String JDBC_DRV_ATTR = "driver";
    static final String USER_NAM_ATTR = "username";
    static final String PASSWORD_ATTR = "password";

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws JMSException {
        Reference reference = (Reference)object;
        AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.getObjectInstance", "entry");
        if (reference == null) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        this.classname = reference.getClassName();
        if (!this.classname.equals("oracle.jms.AQjmsQueueConnectionFactory") && !this.classname.equals("oracle.jms.AQjmsTopicConnectionFactory")) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "unable to manufacture object of class: " + this.classname);
            return null;
        }
        try {
            SearchControls searchControls = new SearchControls();
            String[] stringArray = new String[]{"orclDBAQGeneric"};
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(stringArray);
            DirContext dirContext = (DirContext)context;
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(name, "(objectclass=*)", searchControls);
            if (namingEnumeration != null) {
                SearchResult searchResult = namingEnumeration.next();
                Attribute attribute = searchResult.getAttributes().get("orclDBAQGeneric");
                int n = 0;
                while (n < attribute.size()) {
                    String string = (String)attribute.get(n);
                    if (string.toLowerCase().startsWith(HOST_ATTR)) {
                        this.hostname = string.substring(HOST_ATTR.length() + 1);
                    } else if (string.toLowerCase().startsWith(PORT_ATTR)) {
                        this.portno = Integer.valueOf(string.substring(PORT_ATTR.length() + 1));
                    } else if (string.toLowerCase().startsWith(SID_ATTR)) {
                        this.oracle_sid = string.substring(SID_ATTR.length() + 1);
                    } else if (string.toLowerCase().startsWith(JDBC_CNN_ATTR)) {
                        this.jdbc_conn_str = string.substring(JDBC_CNN_ATTR.length() + 1);
                    } else if (string.toLowerCase().startsWith(JDBC_DRV_ATTR)) {
                        this.jdbc_driver = string.substring(JDBC_DRV_ATTR.length() + 1);
                    } else if (string.toLowerCase().startsWith(USER_NAM_ATTR)) {
                        this.user = string.substring(USER_NAM_ATTR.length() + 1);
                    } else if (string.toLowerCase().startsWith(PASSWORD_ATTR)) {
                        this.passwd = string.substring(PASSWORD_ATTR.length() + 1);
                    }
                    ++n;
                }
                if (this.user != null && this.passwd != null) {
                    this.jdbc_info = new Properties();
                    ((Hashtable)this.jdbc_info).put("user", this.user);
                    ((Hashtable)this.jdbc_info).put(PASSWORD_ATTR, this.passwd);
                }
                if (this.classname.equals("oracle.jms.AQjmsQueueConnectionFactory")) {
                    if (this.jdbc_conn_str != null) {
                        return new AQjmsQueueConnectionFactory(this.jdbc_conn_str, this.jdbc_info);
                    }
                    return new AQjmsQueueConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                }
                if (this.jdbc_conn_str != null) {
                    AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.getObjectInstance", "exit");
                    return new AQjmsTopicConnectionFactory(this.jdbc_conn_str, this.jdbc_info);
                }
                AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.getObjectInstance", "exit");
                return new AQjmsTopicConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
            }
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnectionFactory.getObjectInstance", namingException);
            AQjmsError.throwEx(205, namingException);
        }
        return null;
    }
}

