/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQSignature;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsClientSubscriberMap;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsEventListener;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsQueueReceiver;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsTopicReceiver;
import oracle.jms.AQjmsTopicSubscriber;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;

public class AQjmsConsumer
implements AQjmsQueueReceiver,
AQjmsTopicSubscriber,
AQjmsTopicReceiver,
Referenceable {
    AQjmsSession jms_sess;
    AQjmsSelector selector;
    MessageListener listener;
    AQjmsDestination cons_dest;
    int dest_type;
    int deq_mode;
    int navig_mode;
    int visibility;
    String cons_name;
    boolean first_receive;
    boolean nolocal;
    boolean xml_receive;
    CustomDatumFactory cd_factory;
    ORADataFactory od_factory;
    volatile boolean close_in_progress;
    private AQjmsEventListener evtListener;
    private OracleCallableStatement deq_stmt;
    private String transfxm;
    private String client_id;

    AQjmsConsumer(AQjmsSession aQjmsSession, Destination destination, int n, int n2, String string, Object object) throws JMSException {
        this(aQjmsSession, destination, n, n2, string, object, null, null, false);
    }

    AQjmsConsumer(AQjmsSession aQjmsSession, Destination destination, int n, int n2, String string, Object object, AQjmsSelector aQjmsSelector, String string2) throws JMSException {
        this(aQjmsSession, destination, n, n2, string, object, aQjmsSelector, string2, false);
    }

    AQjmsConsumer(AQjmsSession aQjmsSession, Destination destination, int n, int n2, String string, Object object, AQjmsSelector aQjmsSelector, String string2, boolean bl) throws JMSException {
        String string3 = null;
        Map map = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "entry");
        if (destination == null) {
            AQjmsError.throwEx(200);
        }
        this.jms_sess = aQjmsSession;
        this.cons_dest = (AQjmsDestination)destination;
        this.dest_type = n;
        this.listener = null;
        this.deq_stmt = null;
        if (destination instanceof AQjmsDestination && ((AQjmsDestination)destination).isTemp() && this.jms_sess.getJmsConnection() != AQjmsConnection.getJmsConnection((AQjmsDestination)destination)) {
            AQjmsError.throwEx(231);
        }
        if (n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5) {
            this.deq_mode = n2;
        } else {
            AQjmsError.throwEx(124);
        }
        this.navig_mode = 3;
        this.visibility = 2;
        if (n == 20 && string == null) {
            AQjmsError.throwEx(116);
        }
        this.cons_name = string;
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "dest_type: " + n);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "cons_dest: " + this.cons_dest.getCompleteName());
        if (this.cons_name != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "consumer_name: " + this.cons_name);
        }
        string3 = this.cons_dest.getAdtType();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "p_type: " + string3);
        if (string3.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (object != null) {
                AQjmsError.throwEx(136);
            }
            this.cd_factory = null;
            this.od_factory = null;
        } else if (string3.equalsIgnoreCase("SYS.ANYDATA")) {
            if (object != null) {
                AQjmsError.throwEx(223);
            }
            map = this.jms_sess.getTypeMap();
            try {
                map.put("SYS.AQ$_JMS_TEXT_MESSAGE", Class.forName("oracle.jms.AQjmsTextMessage_C"));
                map.put("SYS.AQ$_JMS_BYTES_MESSAGE", Class.forName("oracle.jms.AQjmsBytesMessage_C"));
                map.put("SYS.AQ$_JMS_STREAM_MESSAGE", Class.forName("oracle.jms.AQjmsStreamMessage_C"));
                map.put("SYS.AQ$_JMS_MAP_MESSAGE", Class.forName("oracle.jms.AQjmsMapMessage_C"));
                map.put("SYS.AQ$_JMS_OBJECT_MESSAGE", Class.forName("oracle.jms.AQjmsObjectMessage_C"));
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(5, "AQjmsConsumer-constructor-typemap-ex", exception);
            }
        } else {
            if (object == null) {
                AQjmsError.throwEx(137);
            }
            this.cd_factory = null;
            this.od_factory = null;
            if (object instanceof CustomDatumFactory) {
                this.cd_factory = (CustomDatumFactory)object;
            } else if (object instanceof ORADataFactory) {
                this.od_factory = (ORADataFactory)object;
            } else {
                AQjmsError.throwEx(222);
            }
        }
        this.selector = aQjmsSelector;
        if (aQjmsSelector != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer-constructor", "selector: " + aQjmsSelector.getSelectorString());
        }
        this.nolocal = bl;
        this.first_receive = true;
        this.close_in_progress = false;
        this.transfxm = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer-constructor", "exit");
        this.client_id = this.jms_sess.jms_conn.getClientID();
    }

    private native AQjmsMessage ocideq(String var1, String var2, int var3, boolean var4, int var5, int var6, String var7, String var8, byte[] var9, int var10, long var11, boolean var13, long[] var14, long var15, String var17, AQjmsSession var18) throws Exception;

    public synchronized String getMessageSelector() throws JMSException {
        this.checkConsumerClosed();
        if (this.selector != null) {
            return this.selector.getSelectorString();
        }
        return null;
    }

    public Reference getReference() {
        Reference reference = new Reference("oracle.jms.AQjmsConsumer", "oracle.jms.AQjmsSubscriberFactory", null);
        return reference;
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        this.checkConsumerClosed();
        return this.listener;
    }

    void register(int n) throws JMSException {
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        Object var4_4 = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.register", "enter");
        try {
            oracleCallableStatement = this.jms_sess.getRegisterStmt();
            oracleCallableStatement.setString(1, this.cons_dest.getQueueOwner().toUpperCase());
            String string = this.dest_type == 20 ? this.cons_dest.getCompleteName() + ':' + this.cons_name : this.cons_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.register", "Subname " + string);
            oracleCallableStatement.setString(2, string.toUpperCase());
            AQjmsOracleDebug.println("protocol jmsc:");
            oracleCallableStatement.setString(3, "jmsc://");
            String string2 = InetAddress.getLocalHost().getHostName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.register", "address " + string2);
            oracleCallableStatement.setString(4, string2);
            Integer n2 = new Integer(n);
            oracleCallableStatement.setObject(5, (Object)n2, 4);
            Integer n3 = new Integer(1);
            oracleCallableStatement.setObject(6, (Object)n3, 4);
            Integer n4 = new Integer(1);
            oracleCallableStatement.setObject(7, (Object)n4, 4);
            resultSet = oracleCallableStatement.executeQuery();
        }
        catch (Exception exception) {
            this.jms_sess.destroyStmt(oracleCallableStatement);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.register-ex1", exception);
            AQjmsError.throwEx(199, exception);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.register", "exit");
    }

    void unregister(int n, AQjmsConnection aQjmsConnection) throws JMSException {
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        Object var5_5 = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.unregister", "enter");
        try {
            oracleCallableStatement = this.jms_sess.getUnregisterStmt();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.unregister", "Schema " + this.cons_dest.getQueueOwner());
            oracleCallableStatement.setString(1, this.cons_dest.getQueueOwner().toUpperCase());
            String string = this.dest_type == 20 ? this.cons_dest.getCompleteName() + ':' + this.cons_name : this.cons_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.unregister", "Subname " + string);
            oracleCallableStatement.setString(2, string.toUpperCase());
            AQjmsOracleDebug.println("protocol jmsc:");
            oracleCallableStatement.setString(3, "jmsc://");
            String string2 = InetAddress.getLocalHost().getHostName();
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.unregister", "address " + string2);
            oracleCallableStatement.setString(4, string2);
            Integer n2 = new Integer(n);
            oracleCallableStatement.setObject(5, (Object)n2, 4);
            resultSet = oracleCallableStatement.executeQuery();
        }
        catch (Exception exception) {
            this.jms_sess.destroyStmt(oracleCallableStatement);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.unregister-ex1", exception);
            AQjmsError.throwEx(202);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.unregister", "exit");
    }

    boolean pollMessage(MessageListener messageListener) throws JMSException {
        boolean bl = false;
        MessageListener messageListener2 = null;
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.pollMessage", "entry");
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.pollMessage", " cons_name:" + this.cons_name + "cons_length: " + this.cons_name);
        messageListener2 = messageListener != null ? messageListener : this.listener;
        if (messageListener2 == null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.pollMessage", "exit");
            return bl;
        }
        Message message = this.dequeue(this.cons_dest, 0L, this.cons_name, 1, 3, null, true);
        if (message != null) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.pollMessage", "before onMessage");
            try {
                this.jms_sess.startListener();
                messageListener2.onMessage(message);
                this.doCommit(this.jms_sess);
                Object var6_5 = null;
                this.jms_sess.stopListener();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.jms_sess.stopListener();
                throw throwable;
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.pollMessage", "after onMessage");
            bl = true;
        }
        AQjmsOracleDebug.trace(3, "AQjmsConsumer.pollMessage", "exit");
        return bl;
    }

    boolean notifyConsumer(Hashtable hashtable, MessageListener messageListener) throws JMSException {
        Message message;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.notifyConsumer", "entry");
        MessageListener messageListener2 = messageListener != null ? messageListener : this.listener;
        String string = (String)hashtable.get("QueueName");
        String string2 = (String)hashtable.get("Consumer");
        String string3 = this.cons_dest.getCompleteName();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.notifyConsumer", " queue:" + string + " queue length:" + string.length() + " myqueue:" + string3 + " myQueueLength:" + string3.length());
        if (this.dest_type == 20) {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.notifyConsumer", " consumer:" + string2 + "consumer length:" + string2.length() + " cons_name: " + this.cons_name + " cons_name length:" + this.cons_name.length());
        }
        if (this.dest_type == 20) {
            if (!string3.equalsIgnoreCase(string) || !string2.equalsIgnoreCase(this.cons_name)) {
                AQjmsOracleDebug.println("false1");
                return false;
            }
        } else if (!string3.equalsIgnoreCase(string)) {
            AQjmsOracleDebug.println("false2");
            return false;
        }
        if ((message = this.dequeue(this.cons_dest, 0L, string2, 1, 3, null, true)) != null) {
            AQjmsOracleDebug.println("there was a message");
            try {
                this.jms_sess.startListener();
                messageListener2.onMessage(message);
                this.doCommit(this.jms_sess);
                Object var9_8 = null;
                this.jms_sess.stopListener();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.jms_sess.stopListener();
                throw throwable;
            }
        } else {
            return false;
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.notifyConsumer", "exit");
        return true;
    }

    private void doCommit(AQjmsSession aQjmsSession) throws JMSException {
        try {
            if (!aQjmsSession.getTransacted() && aQjmsSession.getAckMode() != 2) {
                aQjmsSession.getDBConnection().commit();
            }
        }
        catch (Exception exception) {
            AQjmsError.throwEx(120, exception);
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        boolean bl = false;
        boolean bl2 = false;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "entry");
        this.checkConsumerClosed();
        AQjmsConnection aQjmsConnection = this.jms_sess.getJmsConnection();
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        if (this.listener != null) {
            bl2 = true;
        }
        this.listener = messageListener;
        if (!bl2 && this.listener != null) {
            this.evtListener = aQjmsConnection.createEventListener();
            this.jms_sess.register(this.evtListener.getPort(), this);
            if (aQjmsConnection.isConnectionStarted()) {
                this.evtListener.startAQjmsEventListener();
            }
            this.evtListener.addConsumer(this.jms_sess, this);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.setMessageListener", "exit");
    }

    public Message receive() throws JMSException {
        return this.receiveFromAQ(-1L);
    }

    public Message receiveNoWait() throws JMSException {
        return this.receiveFromAQ(0L);
    }

    public Message receive(long l) throws JMSException {
        if (l == 0L) {
            l = -1L;
        }
        return this.receiveFromAQ(l);
    }

    public Message receive(AQjmsSignature aQjmsSignature) throws JMSException {
        return this.receiveFromAQ(-1L, aQjmsSignature);
    }

    public Message receive(long l, AQjmsSignature aQjmsSignature) throws JMSException {
        if (l == 0L) {
            l = -1L;
        }
        return this.receiveFromAQ(l, aQjmsSignature);
    }

    public Message receiveFromAQ(long l) throws JMSException {
        return this.receiveFromAQ(l, null);
    }

    synchronized Message receiveFromAQ(long l, AQjmsSignature aQjmsSignature) throws JMSException {
        int n;
        Message message = null;
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "entry");
        this.checkConsumerClosed();
        aQjmsConnection = this.jms_sess.getJmsConnection();
        if (!aQjmsConnection.isConnectionStarted()) {
            return null;
        }
        if (this.jms_sess.getMessageListener() != null) {
            AQjmsError.throwEx(198);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receive-2", "timeout(millisecs): " + l);
        if (this.first_receive) {
            n = 1;
            this.first_receive = false;
        } else {
            n = this.navig_mode;
        }
        if (this.dest_type == 10) {
            message = this.dequeue(this.cons_dest, l, null, n, this.deq_mode, aQjmsSignature, false);
        } else if (this.dest_type == 20) {
            message = this.dequeue(this.cons_dest, l, this.cons_name, n, this.deq_mode, aQjmsSignature, false);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receive-2", "exit");
        return message;
    }

    synchronized void purgeSeen(Hashtable hashtable, int n) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.purgeSeen", "entry");
        if (hashtable != null) {
            AQjmsSelector aQjmsSelector = this.selector;
            int n2 = this.deq_mode;
            this.deq_mode = 3;
            JMSException jMSException = null;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    String string2 = "JMSMessageID = '" + string + "'";
                    this.selector = new AQjmsSelector(string2, 10, n, this.jms_sess.is82compatible());
                    this.receiveNoData(0L);
                }
                catch (JMSException jMSException2) {
                    AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.purgeSeen", (Exception)((Object)jMSException2));
                    jMSException = jMSException2;
                    break;
                }
            }
            this.selector = aQjmsSelector;
            this.deq_mode = n2;
            if (jMSException != null) {
                throw jMSException;
            }
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.purgeSeen", "exit");
    }

    synchronized Message dequeue(AQjmsDestination aQjmsDestination, long l, String string, int n, int n2, AQjmsSignature aQjmsSignature, boolean bl) throws JMSException {
        ORADataFactory oRADataFactory = null;
        Connection connection = null;
        AQjmsConnection aQjmsConnection = null;
        String string2 = "";
        ResultSet resultSet = null;
        Integer n3 = null;
        Integer n4 = null;
        Integer n5 = null;
        AQjmsTextMessage_C aQjmsTextMessage_C = null;
        AQjmsTextMessage aQjmsTextMessage = null;
        AQjmsBytesMessage_C aQjmsBytesMessage_C = null;
        AQjmsBytesMessage aQjmsBytesMessage = null;
        AQjmsMapMessage_C aQjmsMapMessage_C = null;
        AQjmsMapMessage aQjmsMapMessage = null;
        AQjmsObjectMessage_C aQjmsObjectMessage_C = null;
        AQjmsObjectMessage aQjmsObjectMessage = null;
        AQjmsStreamMessage_C aQjmsStreamMessage_C = null;
        AQjmsStreamMessage aQjmsStreamMessage = null;
        Object object = null;
        CustomDatum customDatum = null;
        ORAData oRAData = null;
        AQjmsAdtMessage aQjmsAdtMessage = null;
        AQjmsPropertyList aQjmsPropertyList = null;
        AQjmsMessageHeaderExt aQjmsMessageHeaderExt = null;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        AQjmsAgent aQjmsAgent = null;
        Timestamp timestamp = null;
        int n6 = 0;
        int n7 = 0;
        long l2 = 1L;
        long l3 = 0L;
        int n8 = 0;
        boolean bl2 = false;
        long l4 = 0L;
        long l5 = 0L;
        int n9 = 0;
        int n10 = -1;
        boolean bl3 = false;
        long[] lArray = null;
        boolean bl4 = false;
        long l6 = 0L;
        Object object2 = null;
        boolean bl5 = false;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "entry");
        this.checkConsumerClosed();
        l4 = l >= 0L ? (l + 999L) / 1000L : -1L;
        n7 = this.jms_sess.getCloseCheckInterval();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "sec_timeout: " + l4 + "  close_check_interval: " + n7);
        if (l4 > (long)n7) {
            l2 = l4 / (long)n7;
            l3 = l4 % (long)n7;
            if (l3 > 0L) {
                ++l2;
            } else {
                l3 = n7;
            }
        } else {
            l2 = 1L;
            l3 = l4;
        }
        AQjmsOracleDebug.println("Timeout: " + l4 + " Iterations: " + l2 + " Interval: " + n7 + " Last_interval: " + l3);
        if (aQjmsDestination == null || aQjmsDestination.getCompleteName() == null) {
            AQjmsError.throwEx(200);
        }
        String string6 = aQjmsDestination.getAdtType();
        string2 = aQjmsDestination.getCompleteName();
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "q_name: " + string2 + "  p_data_type: " + string6);
        aQjmsConnection = this.jms_sess.getJmsConnection();
        if (string6.equalsIgnoreCase("SYS.ANYDATA") && !aQjmsConnection.getDriver().equalsIgnoreCase("oci8")) {
            AQjmsError.throwEx(225);
        }
        try {
            connection = this.jms_sess.getDBConnection();
            hashtable2 = (Hashtable)((OracleConnection)connection).getTypeMap();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "After getDbConnection");
        try {
            hashtable2.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
        }
        catch (Exception exception) {
            AQjmsError.throwEx(146);
        }
        try {
            Object object3;
            if (string6.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
                bl3 = true;
                n10 = 0;
            } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                oRADataFactory = AQjmsTextMessage_C.getFactory();
                n10 = 0;
            } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                oRADataFactory = AQjmsBytesMessage_C.getFactory();
                n10 = 1;
            } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                oRADataFactory = AQjmsStreamMessage_C.getFactory();
                n10 = 2;
            } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                oRADataFactory = AQjmsMapMessage_C.getFactory();
                n10 = 3;
            } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                oRADataFactory = AQjmsObjectMessage_C.getFactory();
                n10 = 4;
            } else if (string6.equalsIgnoreCase("SYS.ANYDATA")) {
                oRADataFactory = null;
            } else if (this.cd_factory != null || this.od_factory != null) {
                oRADataFactory = this.cd_factory != null ? this.cd_factory : this.od_factory;
            } else {
                AQjmsError.throwEx(129, string6);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Payload type" + n10);
            if (this.selector != null) {
                AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                if (this.selector.getSelectorType() == 30) {
                    byArray2 = this.selector.getSelectorMessageId();
                    AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                } else if (this.selector.getSelectorType() == 20) {
                    string4 = this.selector.getSelectorCorrelationId();
                    AQjmsOracleDebug.println("AQjmsConsumer selector corr_id: " + string4);
                } else if (this.selector.getSelectorType() == 50) {
                    string3 = this.selector.getRule();
                    AQjmsOracleDebug.println("AQjmsConsumer selector deq_cnd: " + string3);
                }
            }
            if (aQjmsConnection.getDriver() != null && aQjmsConnection.getDriver().equalsIgnoreCase("oci8") && this.cd_factory == null && this.od_factory == null && !string6.equalsIgnoreCase("SYS.ANYDATA") && AQDriverManager.isOciAQEnabled()) {
                lArray = new long[]{this.jms_sess.oci_env_handle, this.jms_sess.oci_err_handle, this.jms_sess.oci_svc_handle};
                l6 = this.jms_sess.oci_aq_cntxt;
                bl4 = true;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = true");
            } else {
                if (bl3) {
                    AQjmsError.throwEx(129, string6);
                }
                bl4 = false;
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "use_ociaq_lib = false");
                this.deq_stmt = this.jms_sess.getDequeueStmt();
                this.deq_stmt.setString(1, string2);
                this.deq_stmt.setString(2, string);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "consumer_name: " + string);
                if (this.selector != null) {
                    AQjmsOracleDebug.println("AQjmsConsumer selector: " + this.selector);
                    if (this.selector.getSelectorType() == 30) {
                        byArray2 = this.selector.getSelectorMessageId();
                        this.deq_stmt.setBytes(3, byArray2);
                        this.deq_stmt.setString(4, null);
                        if (this.jms_sess.is82compatible()) {
                            this.deq_stmt.setString(26, null);
                        }
                        AQjmsOracleDebug.println("AQjmsConsumer selector-msgid: " + RepConversion.bArray2String((byte[])this.selector.getSelectorMessageId()));
                    } else if (this.selector.getSelectorType() == 20) {
                        this.deq_stmt.setNull(3, -2);
                        this.deq_stmt.setString(4, string4);
                        if (this.jms_sess.is82compatible()) {
                            this.deq_stmt.setString(26, null);
                        }
                        AQjmsOracleDebug.println("AQjmsConsumer selector-corrid: " + string4);
                    } else if (this.selector.getSelectorType() == 50) {
                        this.deq_stmt.setNull(3, -2);
                        this.deq_stmt.setString(4, null);
                        if (this.jms_sess.is82compatible()) {
                            this.deq_stmt.setString(26, string3);
                        }
                        AQjmsOracleDebug.println("AQjmsConsumer selector-condition: " + string3);
                    } else {
                        this.deq_stmt.setNull(3, -2);
                        this.deq_stmt.setString(4, null);
                        if (this.jms_sess.is82compatible()) {
                            this.deq_stmt.setString(26, null);
                        }
                    }
                } else {
                    this.deq_stmt.setNull(3, -2);
                    this.deq_stmt.setString(4, null);
                    if (this.jms_sess.is82compatible()) {
                        this.deq_stmt.setString(26, null);
                    }
                }
                n5 = new Integer(n2);
                this.deq_stmt.setObject(5, (Object)n5, 4);
                n3 = new Integer(n);
                this.deq_stmt.setObject(6, (Object)n3, 4);
                n4 = new Integer(this.visibility);
                this.deq_stmt.setObject(7, (Object)n4, 4);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "dq_mode: " + n5 + "navig: " + n3 + "visibility: " + n4);
                this.deq_stmt.registerOutParameter(9, 91);
                this.deq_stmt.registerOutParameter(10, 4);
                this.deq_stmt.registerOutParameter(11, -2);
                this.deq_stmt.registerOutParameter(12, 12);
                this.deq_stmt.registerOutParameter(13, 4);
                this.deq_stmt.registerOutParameter(14, 4);
                this.deq_stmt.registerOutParameter(15, 4);
                this.deq_stmt.registerOutParameter(16, 4);
                this.deq_stmt.registerOutParameter(17, 12);
                this.deq_stmt.registerOutParameter(18, 2003, "SYS.AQ$_RECIPIENTS");
                this.deq_stmt.registerOutParameter(19, 12);
                this.deq_stmt.registerOutParameter(20, 12);
                this.deq_stmt.registerOutParameter(21, 4);
                this.deq_stmt.registerOutParameter(22, -2);
                object3 = new Integer(1);
                this.deq_stmt.setObject(23, object3, 4);
                this.deq_stmt.registerOutParameter(24, -2);
                if (this.transfxm != null) {
                    String string7 = this.getTransfxmDest(aQjmsDestination, this.transfxm);
                    if (string7.equalsIgnoreCase("SYS.XMLTYPE")) {
                        this.deq_stmt.registerOutParameter(25, 2007, string7);
                    } else {
                        this.deq_stmt.registerOutParameter(25, 2002, string7);
                    }
                } else if (string6.equalsIgnoreCase("SYS.XMLTYPE")) {
                    this.deq_stmt.registerOutParameter(25, 2007, string6);
                } else {
                    this.deq_stmt.registerOutParameter(25, 2002, string6);
                }
                if (this.jms_sess.is82compatible()) {
                    if (aQjmsSignature != null) {
                        this.deq_stmt.setORAData(27, (ORAData)aQjmsSignature);
                    } else {
                        this.deq_stmt.setNull(27, 2002, "SYS.AQ$_SIG_PROP");
                    }
                    this.deq_stmt.registerOutParameter(28, 2002, "SYS.AQ$_SIG_PROP");
                    this.deq_stmt.setString(29, this.transfxm);
                }
            }
            if (l4 == -1L) {
                do {
                    bl2 = false;
                    try {
                        long l7 = n7;
                        AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + l7);
                        if (bl4) {
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Calling Native Deq-1");
                            if (string != null) {
                                string = string.toUpperCase();
                            }
                            object = this.ocideq(string2, string, n10, bl3, n, n2, string4, string3, byArray2, this.visibility, l7, this.xml_receive, lArray, l6, this.transfxm, this.jms_sess);
                        } else {
                            this.deq_stmt.setLong(8, l7);
                            resultSet = this.deq_stmt.executeQuery();
                        }
                    }
                    catch (SQLException sQLException) {
                        AQjmsOracleDebug.println("SQL excpetion-1:" + sQLException.getErrorCode());
                        if (sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263) {
                            bl2 = true;
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                        AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-sqlex", sQLException);
                        throw sQLException;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + bl2);
                    if (!this.jms_sess.isSessionClosed() && !this.close_in_progress) continue;
                    AQjmsOracleDebug.println("Session closed: return");
                    if (this.deq_stmt != null) {
                        this.jms_sess.destroyStmt(this.deq_stmt);
                    }
                    return null;
                } while (bl2);
            } else {
                n8 = 0;
                while ((long)n8 < l2) {
                    bl2 = false;
                    try {
                        long l8 = (long)n8 == l2 - 1L ? l3 : (long)n7;
                        AQjmsOracleDebug.println("AQjmsConsumer.dequeue: wt_time: " + l8);
                        if (bl4) {
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Calling Native Deq-2");
                            AQjmsOracleDebug.println("Context: " + l6);
                            if (string != null) {
                                string = string.toUpperCase();
                            }
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_dequeue_mode: " + n2);
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "consumer_name: " + string);
                            object = this.ocideq(string2, string, n10, bl3, n, n2, string4, string3, byArray2, this.visibility, l8, this.xml_receive, lArray, l6, this.transfxm, this.jms_sess);
                        } else {
                            this.deq_stmt.setLong(8, l8);
                            resultSet = this.deq_stmt.executeQuery();
                        }
                    }
                    catch (SQLException sQLException) {
                        AQjmsOracleDebug.println("SQL excpetion-2:" + sQLException.getErrorCode());
                        if ((long)n8 < l2 - 1L && (sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263)) {
                            bl2 = true;
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                        throw sQLException;
                    }
                    AQjmsOracleDebug.println("Checking if session is closed: retry: " + bl2);
                    if (this.jms_sess.isSessionClosed() || this.close_in_progress) {
                        AQjmsOracleDebug.println("Session closed: return");
                        if (this.deq_stmt != null) {
                            this.jms_sess.destroyStmt(this.deq_stmt);
                        }
                        return null;
                    }
                    if (!bl2) break;
                    ++n8;
                }
            }
            if (n2 == 4) {
                AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-1");
                if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                    this.jms_sess.destroyStmt(this.deq_stmt);
                }
                return null;
            }
            if (object == null) {
                AQjmsOracleDebug.trace(1, "AQjmsConsumer.dequeue", "faking empty bytes message");
                object = (AQjmsMessage)this.jms_sess.createBytesMessage();
            }
            if (bl4) {
                n9 = ((AQjmsMessage)object).getAttempts();
            } else {
                if (string6.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
                    aQjmsTextMessage_C = (AQjmsTextMessage_C)this.deq_stmt.getORAData(25, oRADataFactory);
                    aQjmsTextMessage = new AQjmsTextMessage(this.jms_sess, aQjmsTextMessage_C, (OracleConnection)connection);
                    object = aQjmsTextMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "text_message retrieved");
                } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
                    aQjmsBytesMessage_C = (AQjmsBytesMessage_C)this.deq_stmt.getORAData(25, oRADataFactory);
                    aQjmsBytesMessage = new AQjmsBytesMessage(this.jms_sess, aQjmsBytesMessage_C);
                    object = aQjmsBytesMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "bytes_message retrieved");
                } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
                    aQjmsMapMessage_C = (AQjmsMapMessage_C)this.deq_stmt.getORAData(25, oRADataFactory);
                    aQjmsMapMessage = new AQjmsMapMessage(this.jms_sess, aQjmsMapMessage_C);
                    object = aQjmsMapMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "map_message retrieved");
                } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
                    aQjmsObjectMessage_C = (AQjmsObjectMessage_C)this.deq_stmt.getORAData(25, oRADataFactory);
                    aQjmsObjectMessage = new AQjmsObjectMessage(this.jms_sess, aQjmsObjectMessage_C, this.xml_receive);
                    object = aQjmsObjectMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "object_message retrieved");
                } else if (string6.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                    aQjmsStreamMessage_C = (AQjmsStreamMessage_C)this.deq_stmt.getORAData(25, oRADataFactory);
                    aQjmsStreamMessage = new AQjmsStreamMessage(this.jms_sess, aQjmsStreamMessage_C);
                    object = aQjmsStreamMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "stream_message retrieved");
                } else if (string6.equalsIgnoreCase("SYS.ANYDATA")) {
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "before receiving anydata message");
                    object2 = this.deq_stmt.getAnyDataEmbeddedObject(25);
                    if (object2 instanceof ORAData) {
                        if (object2 instanceof AQjmsTextMessage_C) {
                            aQjmsTextMessage_C = (AQjmsTextMessage_C)object2;
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "text_message retrieved from anydata");
                            aQjmsTextMessage = new AQjmsTextMessage(this.jms_sess, aQjmsTextMessage_C, (OracleConnection)connection);
                            object = aQjmsTextMessage;
                            bl5 = true;
                        } else if (object2 instanceof AQjmsBytesMessage_C) {
                            aQjmsBytesMessage_C = (AQjmsBytesMessage_C)object2;
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "bytes_message retrieved from anydata");
                            aQjmsBytesMessage = new AQjmsBytesMessage(this.jms_sess, aQjmsBytesMessage_C);
                            object = aQjmsBytesMessage;
                            bl5 = true;
                        } else if (object2 instanceof AQjmsMapMessage_C) {
                            aQjmsMapMessage_C = (AQjmsMapMessage_C)object2;
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "map_message retrieved from anydata");
                            aQjmsMapMessage = new AQjmsMapMessage(this.jms_sess, aQjmsMapMessage_C);
                            object = aQjmsMapMessage;
                            bl5 = true;
                        } else if (object2 instanceof AQjmsObjectMessage_C) {
                            aQjmsObjectMessage_C = (AQjmsObjectMessage_C)object2;
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "object_message retrieved from anydata");
                            aQjmsObjectMessage = new AQjmsObjectMessage(this.jms_sess, aQjmsObjectMessage_C, this.xml_receive);
                            object = aQjmsObjectMessage;
                            bl5 = true;
                        } else if (object2 instanceof AQjmsStreamMessage_C) {
                            aQjmsStreamMessage_C = (AQjmsStreamMessage_C)object2;
                            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "stream_message retrieved from anydata");
                            aQjmsStreamMessage = new AQjmsStreamMessage(this.jms_sess, aQjmsStreamMessage_C);
                            object = aQjmsStreamMessage;
                            bl5 = true;
                        } else {
                            aQjmsAdtMessage = new AQjmsAdtMessage((ORAData)object2);
                            object = aQjmsAdtMessage;
                            bl5 = false;
                        }
                    } else {
                        AQjmsOracleDebug.trace(3, "AQjmsConsumer.dequeue", "anydata-invalid obj");
                        if (object2 != null) {
                            AQjmsOracleDebug.trace(3, "AQjmsConsumer.dequeue", "anydata-invalid obj class:" + object2.getClass().getName());
                        }
                        AQjmsError.throwEx(224);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "AnyData AdtMessage retrieved");
                } else {
                    if (oRADataFactory instanceof CustomDatumFactory) {
                        customDatum = (CustomDatum)this.deq_stmt.getCustomDatum(25, (CustomDatumFactory)oRADataFactory);
                        aQjmsAdtMessage = new AQjmsAdtMessage(customDatum);
                    } else {
                        oRAData = (ORAData)this.deq_stmt.getORAData(25, oRADataFactory);
                        aQjmsAdtMessage = new AQjmsAdtMessage(oRAData);
                    }
                    object = aQjmsAdtMessage;
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "adt_message retrieved");
                }
                timestamp = this.deq_stmt.getTimestamp(9);
                long l9 = ((java.util.Date)timestamp).getTime();
                ((AQjmsMessage)object).setJMSTimestamp(l9);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "enq_time: " + timestamp);
                ((AQjmsMessage)object).setMessageState(this.deq_stmt.getInt(10));
                byArray = this.deq_stmt.getBytes(11);
                ((AQjmsMessage)object).setJMSMessageID(byArray);
                ((AQjmsMessage)object).setJMSCorrelationID(this.deq_stmt.getString(12));
                ((AQjmsMessage)object).setJMSPriority(this.deq_stmt.getInt(13));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_id: " + RepConversion.bArray2String((byte[])byArray) + " corrid: " + this.deq_stmt.getString(12) + " priority: " + this.deq_stmt.getInt(13));
                n6 = this.deq_stmt.getInt(14);
                ((AQjmsMessage)object).setDelay(n6);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "msg_delay(secs): " + n6);
                l5 = this.deq_stmt.getLong(15);
                ((AQjmsMessage)object).setJMSExpiration(l5);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "exptime(secs): " + l5);
                n9 = this.deq_stmt.getInt(16);
                ((AQjmsMessage)object).setAttempts(n9);
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "attempts: " + n9);
                ((AQjmsMessage)object).setExceptionQueue(this.deq_stmt.getString(17));
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "excp_q: " + this.deq_stmt.getString(17));
                string5 = this.deq_stmt.getString(19);
                if (string5 != null && !string5.equals("")) {
                    aQjmsAgent = new AQjmsAgent();
                    aQjmsAgent.setName(string5);
                    aQjmsAgent.setAddress(this.deq_stmt.getString(20));
                    aQjmsAgent.setProtocol(this.deq_stmt.getInt(21));
                    ((AQjmsMessage)object).setSenderID(aQjmsAgent);
                    AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "Sender" + aQjmsAgent);
                }
                ((AQjmsMessage)object).setOriginalMessageId(this.deq_stmt.getBytes(22));
                if (this.jms_sess.is82compatible()) {
                    ((AQjmsMessage)object).setSignature((AQjmsSignature)this.deq_stmt.getORAData(28, AQSignature.getFactory()));
                }
            }
            if (((AQjmsMessage)object).isJMSBody() && AQjmsConstants.isJ2eeCompliant()) {
                ((AQjmsMessage)object).setJMSPriority(AQjmsMessage.toJMSPriority(((AQjmsMessage)object).getJMSPriority()));
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive- anyd_jms " + bl5);
            if (this.cd_factory == null && this.od_factory == null && object2 == null || bl5) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-0 " + object);
                aQjmsMessageHeaderExt = ((AQjmsMessage)object).getMessageHeaderExt();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-1");
                aQjmsPropertyList = aQjmsMessageHeaderExt.getProperties();
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "after receive-2");
                hashtable = aQjmsPropertyList == null ? new Hashtable() : AQjmsMessage.convertPropertyListToHashtable(aQjmsPropertyList);
                ((AQjmsMessage)object).setPropertiesHashtable(hashtable);
            }
            if (hashtable != null && hashtable.get("JMS_OracleHeaderOnly") != null) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", " Header only, Copying to generic msg");
                object3 = new AQjmsMessage((AQjmsMessage)object);
                object = null;
                object = object3;
                ((AQjmsMessage)object).setHeaderOnly();
            }
            if (hashtable != null && hashtable.get("JMS_OracleDeliveryMode") != null) {
                ((AQjmsMessage)object).setJMSDeliveryMode(Integer.parseInt(((AQjmsMessage)object).getStringProperty("JMS_OracleDeliveryMode")));
            }
            if (((AQjmsMessage)object).getJMSExpiration() <= 0L) {
                ((AQjmsMessage)object).setJMSExpiration(0L);
            } else {
                ((AQjmsMessage)object).setJMSExpiration(((AQjmsMessage)object).getJMSExpiration() * 1000L + ((AQjmsMessage)object).getJMSTimestamp());
            }
            object3 = new java.util.Date();
            ((AQjmsMessage)object).setReceiveTime(((java.util.Date)object3).getTime());
            if (n9 > 0) {
                ((AQjmsMessage)object).setJMSRedelivered(true);
            } else {
                ((AQjmsMessage)object).setJMSRedelivered(false);
            }
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "recv_time: " + object3);
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.dequeue", "enq_time: " + ((AQjmsMessage)object).getJMSTimestamp() + "  " + new Date(((AQjmsMessage)object).getJMSTimestamp()));
            ((AQjmsMessage)object).setPropReadOnly(true);
            ((AQjmsMessage)object).setAccessMode(0);
            ((AQjmsMessage)object).setJMSDestination((Destination)aQjmsDestination);
            if (!bl) {
                this.doCommit(this.jms_sess);
            }
            if (!this.jms_sess.isDeqStmtCachingEnabled() && this.deq_stmt != null) {
                this.jms_sess.destroyStmt(this.deq_stmt);
            }
        }
        catch (SQLException sQLException) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            if ((sQLException.getErrorCode() == 25228 || sQLException.getErrorCode() == 25263) && n2 != 4) {
                object = null;
            } else {
                AQjmsError.throwEx(120, sQLException);
            }
        }
        catch (Exception exception) {
            this.jms_sess.destroyStmt(this.deq_stmt);
            AQjmsOracleDebug.traceEx(3, "AQjmsConsumer.dequeue-ex3", exception);
            AQjmsError.throwEx(120, exception);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.dequeue", "exit-2");
        return object;
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "entry");
        if (!this.isConsumerClosed()) {
            this.close_in_progress = true;
            this.closeConsumerResources(this.jms_sess.getJmsConnection());
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit");
    }

    void closeFromSession(AQjmsConnection aQjmsConnection) {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeFromSession", "entry");
        this.close_in_progress = true;
        this.closeConsumerResources(aQjmsConnection);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeFromSession", "exit");
    }

    synchronized void closeConsumerResources(AQjmsConnection aQjmsConnection) {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.closeConsumerResources", "entry");
        if (this.jms_sess == null) {
            AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit-1");
            return;
        }
        this.jms_sess.destroyStmt(this.deq_stmt);
        this.jms_sess.removeConsumer(this);
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deq_stmt closed");
        try {
            AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deleting listener info");
            if (this.evtListener != null) {
                if (this.listener != null) {
                    AQjmsOracleDebug.println("there was a listener");
                    this.unregister(this.evtListener.getPort(), aQjmsConnection);
                }
                this.evtListener.removeConsumer(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (AQjmsConstants.isJ2eeCompliant() && this.cons_name != null && !this.cons_name.equals("") && this.client_id != null) {
            boolean bl = AQjmsClientSubscriberMap.deactivateClientSubscriber(this.client_id, this.cons_name);
            if (bl) {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deactivate subscriber " + this.cons_name + " success.");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsConsumer.close", "deactivate subscriber, " + this.cons_name + " not found.");
            }
        }
        this.evtListener = null;
        this.listener = null;
        this.selector = null;
        this.cons_dest = null;
        this.cd_factory = null;
        this.od_factory = null;
        this.jms_sess = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.close", "exit-2");
    }

    public synchronized Queue getQueue() throws JMSException {
        this.checkConsumerClosed();
        if (this.dest_type == 10) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "TopicSubscriber");
        return null;
    }

    public synchronized Topic getTopic() throws JMSException {
        this.checkConsumerClosed();
        if (this.dest_type == 20) {
            return this.cons_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    public synchronized boolean getNoLocal() throws JMSException {
        this.checkConsumerClosed();
        return this.nolocal;
    }

    public synchronized int getNavigationMode() throws JMSException {
        this.checkConsumerClosed();
        return this.navig_mode;
    }

    public synchronized void setNavigationMode(int n) throws JMSException {
        this.checkConsumerClosed();
        if (n == 1 || n == 3 || n == 2) {
            this.navig_mode = n;
        } else {
            AQjmsError.throwEx(128);
        }
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.setNavigationMode", "navig_mode: " + n);
    }

    public synchronized void setTransformation(String string) {
        this.transfxm = string;
    }

    public synchronized String getTransformation() {
        return this.transfxm;
    }

    public synchronized void receiveNoData() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "entry");
        this.receiveNoData(-1L);
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-1", "exit");
    }

    public synchronized void receiveNoData(long l) throws JMSException {
        int n;
        Message message = null;
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receiveNoData", "timeout: " + l);
        this.checkConsumerClosed();
        aQjmsConnection = this.jms_sess.getJmsConnection();
        if (!aQjmsConnection.isConnectionStarted()) {
            AQjmsError.throwEx(113);
        }
        if (this.first_receive) {
            n = 1;
            this.first_receive = false;
        } else {
            n = this.navig_mode;
        }
        if (this.dest_type == 10) {
            message = this.dequeue(this.cons_dest, l, null, n, 4, null, false);
        } else if (this.dest_type == 20) {
            message = this.dequeue(this.cons_dest, l, this.cons_name, n, 4, null, false);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveNoData-2", "exit");
    }

    public Message receiveSignature() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-1", "entry");
        return this.receiveSignature(-1L);
    }

    public synchronized Message receiveSignature(long l) throws JMSException {
        int n;
        Message message = null;
        AQjmsConnection aQjmsConnection = null;
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-2", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsConsumer.receiveSignature-2", "timeout: " + l);
        this.checkConsumerClosed();
        aQjmsConnection = this.jms_sess.getJmsConnection();
        if (!aQjmsConnection.isConnectionStarted()) {
            AQjmsError.throwEx(113);
        }
        if (this.first_receive) {
            n = 1;
            this.first_receive = false;
        } else {
            n = this.navig_mode;
        }
        if (this.dest_type == 10) {
            message = this.dequeue(this.cons_dest, l, null, n, 5, null, false);
        } else if (this.dest_type == 20) {
            message = this.dequeue(this.cons_dest, l, this.cons_name, n, 5, null, false);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConsumer.receiveSignature-2", "exit");
        return message;
    }

    boolean isConsumerClosed() {
        return this.close_in_progress || this.jms_sess == null;
    }

    void checkConsumerClosed() throws JMSException {
        if (this.isConsumerClosed()) {
            AQjmsError.throwIllegalStateEx(115, null);
        }
    }

    public void setXmlReceive(boolean bl) {
        this.xml_receive = bl;
    }

    public Message browse(long l, boolean bl) throws JMSException {
        if (l == 0L) {
            l = -1L;
        }
        this.deq_mode = bl ? 2 : 1;
        return this.receiveFromAQ(l);
    }

    public Message browseNoWait(boolean bl) throws JMSException {
        this.deq_mode = bl ? 2 : 1;
        return this.receiveFromAQ(0L);
    }

    String getTransfxmDest(AQjmsDestination aQjmsDestination, String string) throws JMSException {
        int n = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Hashtable hashtable = aQjmsDestination.getTransTable();
        Connection connection = null;
        n = string.indexOf(".", 1);
        AQjmsOracleDebug.trace(3, "AQjmsSession.getTransfxmDest", "enter:" + string);
        try {
            connection = this.jms_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112);
        }
        try {
            if (n == -1) {
                string4 = ((OracleConnection)connection).getUserName();
                string5 = string;
            } else {
                string4 = string.substring(0, n);
                string5 = string.substring(n + 1);
            }
            AQjmsOracleDebug.trace(3, "AQjmsSession.getTransfxmDest", "schema" + string4 + " name: " + string5);
            string3 = (String)hashtable.get(string4 + "." + string5);
            if (string3 != null) {
                AQjmsOracleDebug.trace(3, "AQjmsSession.getTransfxmDest", "dest_type cached:" + string3);
                return string3;
            }
            statement = (OracleCallableStatement)connection.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ?, ?);end;");
            statement.setString(1, string4);
            statement.setString(2, string5);
            statement.registerOutParameter(3, 12);
            statement.registerOutParameter(4, 12);
            resultSet = statement.executeQuery();
            string2 = statement.getString(3);
            string3 = statement.getString(4);
            AQjmsOracleDebug.trace(3, "AQjmsSession.getTransfxmDest", "dest_type:" + string3);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getTransfxmDest ex", sQLException);
        }
        try {
            statement.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string3 != null) {
            hashtable.put(string4 + "." + string5, string3);
        }
        return string3;
    }

    public void finalize() {
        AQjmsOracleDebug.println("AQjmsConsumer.finalize");
    }
}

