/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQQueueProperty;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsDestination
implements Queue,
Topic,
Referenceable,
Serializable,
TemporaryQueue,
TemporaryTopic {
    private int type;
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    private AQjmsDestinationProperty property;
    private Hashtable dest_properties;
    private Hashtable trans_list;
    private boolean secure;
    private boolean is_temp;

    AQjmsDestination(String string, String string2, int n, int n2, String string3, String string4, boolean bl) throws JMSException {
        this.owner = string;
        this.name = string2;
        this.type = n;
        this.p_data_type = n2 == 2 ? null : string3;
        this.pload_type = n2;
        this.property = new AQjmsDestinationProperty();
        this.table = string4;
        this.trans_list = new Hashtable();
        this.secure = bl;
        this.is_temp = false;
    }

    AQjmsDestination(String string, String string2, int n, int n2, String string3, AQjmsDestinationProperty aQjmsDestinationProperty, String string4, boolean bl) throws JMSException {
        this.owner = string;
        this.name = string2;
        this.type = n;
        this.p_data_type = n2 == 2 ? null : string3;
        this.property = aQjmsDestinationProperty;
        this.table = string4;
        this.trans_list = new Hashtable();
        this.secure = bl;
        this.is_temp = false;
    }

    public String getQueueName() throws JMSException {
        if (this.type == 10) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getTopicName() throws JMSException {
        if (this.type == 20) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getQueueOwner() throws JMSException {
        return this.owner;
    }

    public String getTopicOwner() throws JMSException {
        return this.owner;
    }

    public Reference getReference() {
        Reference reference = new Reference("oracle.jms.AQjmsDestination", "oracle.jms.AQjmsDestinationFactory", null);
        return reference;
    }

    String getAdtType() {
        return this.p_data_type;
    }

    int getPloadType() {
        return this.pload_type;
    }

    String getQueueTableName() {
        return this.table;
    }

    AQjmsDestinationProperty getProperty() {
        return this.property;
    }

    public String getCompleteName() {
        String string = null;
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return string;
    }

    public String getCompleteTableName() {
        String string = null;
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.table : this.table;
        return string;
    }

    public String toString() {
        String string = null;
        string = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return string;
    }

    public void start(Session session, boolean bl, boolean bl2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.start(bl, bl2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void stop(Session session, boolean bl, boolean bl2, boolean bl3) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.stop(bl, bl2, bl3);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void alter(Session session, AQjmsDestinationProperty aQjmsDestinationProperty) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.alterQueue(aQjmsDestinationProperty);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void drop(Session session) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.drop();
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void schedulePropagation(Session session, String string, Date date, Double d, String string2, Double d2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.schedulePropagation(string, date, d, string2, d2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void unschedulePropagation(Session session, String string) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.unschedulePropagation(string);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void alterPropagationSchedule(Session session, String string, Double d, String string2, Double d2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.alterPropagationSchedule(string, d, string2, d2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void enablePropagationSchedule(Session session, String string) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.enablePropagationSchedule(string);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void disablePropagationSchedule(Session session, String string) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.disablePropagationSchedule(string);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void grantQueuePrivilege(Session session, String string, String string2, boolean bl) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.grantQueuePrivilege(string, string2, bl);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void grantTopicPrivilege(Session session, String string, String string2, boolean bl) throws JMSException {
        this.grantQueuePrivilege(session, string, string2, bl);
    }

    public void revokeQueuePrivilege(Session session, String string, String string2) throws JMSException {
        AQOracleQueue aQOracleQueue = null;
        try {
            aQOracleQueue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aQOracleQueue.revokeQueuePrivilege(string, string2);
            aQOracleQueue.close();
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
    }

    public void revokeTopicPrivilege(Session session, String string, String string2) throws JMSException {
        this.revokeQueuePrivilege(session, string, string2);
    }

    boolean isQueue() {
        return this.type == 10;
    }

    boolean isTopic() {
        return this.type == 20;
    }

    public boolean isSecure() {
        return this.secure;
    }

    Hashtable getTransTable() {
        return this.trans_list;
    }

    void setTransTable(Hashtable hashtable) {
        this.trans_list = hashtable;
    }

    public AQjmsDestination cloneDestination() throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        aQjmsDestination = new AQjmsDestination(this.owner, this.name, this.type, this.pload_type, this.p_data_type, this.table, this.secure);
        aQjmsDestination.setTransTable((Hashtable)this.trans_list.clone());
        return aQjmsDestination;
    }

    boolean isTemp() {
        return this.is_temp;
    }

    void makeTemp() {
        this.is_temp = true;
    }

    public void delete() throws JMSException {
        if (this.is_temp) {
            AQjmsConnection.findCloseTemp(this);
        }
    }
}

