/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsQueueConnectionFactory;
import oracle.jms.AQjmsTopicConnectionFactory;

public class AQjmsFactory {
    public static QueueConnectionFactory getQueueConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        AQjmsQueueConnectionFactory aQjmsQueueConnectionFactory = null;
        aQjmsQueueConnectionFactory = new AQjmsQueueConnectionFactory(string, string2, n, string3);
        return aQjmsQueueConnectionFactory;
    }

    public static QueueConnectionFactory getQueueConnectionFactory(String string, Properties properties) throws JMSException {
        AQjmsQueueConnectionFactory aQjmsQueueConnectionFactory = null;
        aQjmsQueueConnectionFactory = new AQjmsQueueConnectionFactory(string, properties);
        return aQjmsQueueConnectionFactory;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String string, String string2, int n, String string3) throws JMSException {
        AQjmsTopicConnectionFactory aQjmsTopicConnectionFactory = null;
        aQjmsTopicConnectionFactory = new AQjmsTopicConnectionFactory(string, string2, n, string3);
        return aQjmsTopicConnectionFactory;
    }

    public static TopicConnectionFactory getTopicConnectionFactory(String string, Properties properties) throws JMSException {
        AQjmsTopicConnectionFactory aQjmsTopicConnectionFactory = null;
        aQjmsTopicConnectionFactory = new AQjmsTopicConnectionFactory(string, properties);
        return aQjmsTopicConnectionFactory;
    }

    public static int registerConnectionFactory(Connection connection, String string, String string2, String string3, int n, String string4, String string5) throws JMSException {
        Statement statement = null;
        try {
            statement = string5.toLowerCase().equals("queue") ? connection.prepareCall("begin dbms_aqadm_sys.add_connection_to_ldap(connection=>?, host=>?, port=>?, sid=>?, driver=>?, type=>1); end;") : connection.prepareCall("begin dbms_aqadm_sys.add_connection_to_ldap(connection=>?, host=>?, port=>?, sid=>?, driver=>?, type=>2); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.setInt(3, n);
            statement.setString(4, string3);
            statement.setString(5, string4);
            statement.execute();
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", sQLException);
            throw new AQjmsException(sQLException);
        }
        return 0;
    }

    public static int registerConnectionFactory(Connection connection, String string, String string2, Properties properties, String string3) throws JMSException {
        Statement statement = null;
        try {
            statement = string3.toLowerCase().equals("queue") ? connection.prepareCall("begin dbms_aqadm_sys.add_connection_to_ldap(connection=>?, jdbc_string=>?, type=>1, username=>?, password=>?); end;") : connection.prepareCall("begin dbms_aqadm_sys.add_connection_to_ldap(connection=>?, jdbc_string=>?, type=>2, username=>?, password=>?); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.setString(3, properties == null ? properties.getProperty("user", null) : null);
            statement.setString(4, properties == null ? properties.getProperty("password", null) : null);
            statement.execute();
            statement.close();
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", sQLException);
            throw new AQjmsException(sQLException);
        }
        return 0;
    }

    public static int unregisterConnectionFactory(Connection connection, String string) throws JMSException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = connection.prepareCall("begin dbms_aqadm.del_connection_from_ldap(connection=>?); end;");
            callableStatement.setString(1, string);
            callableStatement.execute();
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            try {
                callableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.unregisterConnectionFactory", sQLException);
            throw new AQjmsException(sQLException);
        }
        return 0;
    }

    public static int registerConnectionFactory(Hashtable hashtable, String string, String string2, String string3, int n, String string4, String string5) throws JMSException {
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String string6 = "cn=oracledbconnections," + (String)hashtable.get("server_dn");
            DirContext dirContext = (DirContext)initialDirContext.lookup(string6);
            BasicAttributes basicAttributes = new BasicAttributes(false);
            BasicAttribute basicAttribute = new BasicAttribute("objectclass");
            basicAttribute.add("top");
            basicAttribute.add("javaContainer");
            basicAttribute.add("javaObject");
            basicAttribute.add("javaNamingReference");
            basicAttribute.add("orclDBAQConnection");
            BasicAttribute basicAttribute2 = new BasicAttribute("orclDBAQGeneric");
            basicAttribute2.add("Host=" + string2);
            basicAttribute2.add("Port=" + String.valueOf(n));
            basicAttribute2.add("Sid=" + string3);
            if (string4 != null) {
                basicAttribute2.add("Driver=" + string4);
            }
            basicAttributes.put("cn", string);
            basicAttributes.put(basicAttribute2);
            if (string5.toLowerCase().equals("queue")) {
                basicAttributes.put("javaclassname", "oracle.jms.AQjmsQueueConnectionFactory");
            } else {
                basicAttributes.put("javaclassname", "oracle.jms.AQjmsTopicConnectionFactory");
            }
            basicAttributes.put("javafactory", "oracle.jms.AQjmsConnectionFactory");
            basicAttributes.put(basicAttribute);
            dirContext.createSubcontext("cn=" + string, (Attributes)basicAttributes);
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", namingException);
            AQjmsError.throwEx(205, namingException);
        }
        return 0;
    }

    public static int registerConnectionFactory(Hashtable hashtable, String string, String string2, Properties properties, String string3) throws JMSException {
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String string4 = "cn=oracledbconnections," + (String)hashtable.get("server_dn");
            DirContext dirContext = (DirContext)initialDirContext.lookup(string4);
            BasicAttributes basicAttributes = new BasicAttributes(false);
            BasicAttribute basicAttribute = new BasicAttribute("objectclass");
            basicAttribute.add("top");
            basicAttribute.add("javaContainer");
            basicAttribute.add("javaObject");
            basicAttribute.add("javaNamingReference");
            basicAttribute.add("orclDBAQConnection");
            BasicAttribute basicAttribute2 = new BasicAttribute("orclDBAQGeneric");
            basicAttribute2.add("JDBC_connect_string=" + string2);
            if (properties != null && properties.getProperty("user", null) != null && properties.getProperty("password", null) != null) {
                basicAttribute2.add("Username=" + properties.getProperty("user"));
                basicAttribute2.add("Password=" + properties.getProperty("password"));
            }
            basicAttributes.put("cn", string);
            basicAttributes.put(basicAttribute2);
            if (string3.toLowerCase().equals("queue")) {
                basicAttributes.put("javaclassname", "oracle.jms.AQjmsQueueConnectionFactory");
            } else {
                basicAttributes.put("javaclassname", "oracle.jms.AQjmsTopicConnectionFactory");
            }
            basicAttributes.put("javafactory", "oracle.jms.AQjmsConnectionFactory");
            basicAttributes.put(basicAttribute);
            dirContext.createSubcontext("cn=" + string, (Attributes)basicAttributes);
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.registerConnectionFactory", namingException);
            AQjmsError.throwEx(205, namingException);
        }
        return 0;
    }

    public static int unregisterConnectionFactory(Hashtable hashtable, String string) throws JMSException {
        try {
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            String string2 = "cn=oracledbconnections," + (String)hashtable.get("server_dn");
            DirContext dirContext = (DirContext)initialDirContext.lookup(string2);
            dirContext.destroySubcontext("cn=" + string);
        }
        catch (NamingException namingException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsFactory.unregisterConnectionFactory", namingException);
            AQjmsError.throwEx(205, namingException);
        }
        return 0;
    }
}

