/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.sql.BLOB;
import oracle.sql.ORADataFactory;

public class AQjmsMapMessage
extends AQjmsMessage
implements MapMessage {
    public Hashtable mapItemHash;
    AQjmsMapMessage_C map_msg_cont;

    public AQjmsMapMessage() throws JMSException {
        super(true);
        try {
            this.map_msg_cont = new AQjmsMapMessage_C();
            this.map_msg_cont.setHeader(this.header_ext);
            this.mapItemHash = new Hashtable();
            this.access_mode = 2;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public AQjmsMapMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.map_msg_cont = new AQjmsMapMessage_C();
            this.map_msg_cont.setHeader(this.header_ext);
            this.mapItemHash = new Hashtable();
            this.access_mode = 2;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsMapMessage(AQjmsSession aQjmsSession, AQjmsMapMessage_C aQjmsMapMessage_C) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.map_msg_cont = aQjmsMapMessage_C;
            this.header_ext = aQjmsMapMessage_C.getHeader();
            this.mapItemHash = this.readMapMessageContainer();
            this.access_mode = 0;
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.map_msg_cont != null) {
                this.map_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsMapMessage(AQjmsSession aQjmsSession, byte[] byArray) throws JMSException {
        super(aQjmsSession, true);
        this.mapItemHash = AQjmsMapMessage.convertByteArrayToHashtable(byArray);
        this.access_mode = 0;
    }

    public byte[] getHashTable() throws JMSException {
        return AQjmsMapMessage.convertHashtableToByteArray(this.mapItemHash);
    }

    public void setBoolean(String string, boolean bl) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Boolean(bl));
    }

    public void setByte(String string, byte by) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Byte(by));
    }

    public void setShort(String string, short s) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Short(s));
    }

    public void setChar(String string, char c) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Character(c));
    }

    public void setDouble(String string, double d) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Double(d));
    }

    public void setFloat(String string, float f) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Float(f));
    }

    public void setInt(String string, int n) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Integer(n));
    }

    public void setLong(String string, long l) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, new Long(l));
    }

    public void setString(String string, String string2) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (string2 != null) {
            this.mapItemHash.put(string, string2);
        }
    }

    public void setObject(String string, Object object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (object instanceof Integer || object instanceof Character || object instanceof Long || object instanceof Float || object instanceof Short || object instanceof Byte || object instanceof Double || object instanceof String || object instanceof byte[] || object instanceof Boolean) {
            this.mapItemHash.put(string, object);
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
    }

    public void setBytes(String string, byte[] byArray) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.mapItemHash.put(string, byArray);
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.mapItemHash.put(string, byArray2);
    }

    public boolean getBoolean(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Boolean) {
                    return (Boolean)v;
                }
                if (v instanceof String) {
                    return new Boolean((String)v);
                }
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return false;
        }
        AQjmsError.throwEx(164);
        return false;
    }

    public byte getByte(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Byte) {
                    return (Byte)v;
                }
                if (v instanceof String) {
                    return Byte.parseByte((String)v);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0;
        }
        AQjmsError.throwEx(164);
        return 0;
    }

    public byte[] getBytes(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                return (byte[])v;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
                AQjmsError.throwMsgFormatEx(117, null);
                return null;
            }
        }
        return null;
    }

    public char getChar(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Character) {
                    return ((Character)v).charValue();
                }
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return '\u0000';
        }
        throw new NullPointerException(AQjmsError.getMessage(164));
    }

    public double getDouble(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Float) {
                    return ((Float)v).floatValue();
                }
                if (v instanceof Double) {
                    return (Double)v;
                }
                if (v instanceof String) {
                    return new Double((String)v);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0.0;
        }
        AQjmsError.throwEx(164);
        return 0.0;
    }

    public float getFloat(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Float) {
                    return ((Float)v).floatValue();
                }
                if (v instanceof String) {
                    return new Float((String)v).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0.0f;
        }
        AQjmsError.throwEx(164);
        return 0.0f;
    }

    public int getInt(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Byte) {
                    return ((Byte)v).byteValue();
                }
                if (v instanceof Short) {
                    return ((Short)v).shortValue();
                }
                if (v instanceof Integer) {
                    return (Integer)v;
                }
                if (v instanceof String) {
                    return new Integer((String)v);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0;
        }
        AQjmsError.throwEx(164);
        return 0;
    }

    public long getLong(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Byte) {
                    return ((Byte)v).byteValue();
                }
                if (v instanceof Short) {
                    return ((Short)v).shortValue();
                }
                if (v instanceof Integer) {
                    return ((Integer)v).intValue();
                }
                if (v instanceof Long) {
                    return (Long)v;
                }
                if (v instanceof String) {
                    return new Long((String)v);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0L;
        }
        AQjmsError.throwEx(164);
        return 0L;
    }

    public Enumeration getMapNames() throws JMSException {
        return this.mapItemHash.keys();
    }

    public Object getObject(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        return v;
    }

    public short getShort(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Byte) {
                    return ((Byte)v).byteValue();
                }
                if (v instanceof Short) {
                    return (Short)v;
                }
                if (v instanceof String) {
                    return new Short((String)v);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw numberFormatException;
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return 0;
        }
        AQjmsError.throwEx(164);
        return 0;
    }

    public String getString(String string) throws JMSException {
        Object v = this.mapItemHash.get(string);
        if (v != null) {
            try {
                if (v instanceof Integer || v instanceof Character || v instanceof Long || v instanceof Float || v instanceof Short || v instanceof Byte || v instanceof Double || v instanceof String || v instanceof Boolean) {
                    return v.toString();
                }
            }
            catch (Exception exception) {
                AQjmsError.throwMsgFormatEx(117, exception.getMessage());
            }
            AQjmsError.throwMsgFormatEx(117, null);
            return null;
        }
        return null;
    }

    public boolean itemExists(String string) throws JMSException {
        return this.mapItemHash.containsKey(string);
    }

    public void clearBody() throws JMSException {
        this.mapItemHash.clear();
        this.setAccessMode(2);
        this.setPropReadOnly(false);
    }

    AQjmsMapMessage_C getMessageCont() {
        return this.map_msg_cont;
    }

    static byte[] convertHashtableToByteArray(Hashtable hashtable) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashtableToByteArray", "entry");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(hashtable);
            AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashtableToByteArray", "exit");
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertHashtableToByteArray IO", iOException);
            AQjmsError.throwEx(157, iOException.getMessage());
            return null;
        }
    }

    static Hashtable convertByteArrayToHashtable(byte[] byArray) throws JMSException {
        Hashtable hashtable = new Hashtable();
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashTable", "entry");
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            hashtable = (Hashtable)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashTable CNF", classNotFoundException);
            AQjmsError.throwEx(109, classNotFoundException.getMessage());
            return null;
        }
        catch (InvalidClassException invalidClassException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashTable ICE", invalidClassException);
            AQjmsError.throwEx(156, invalidClassException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashTable IO", iOException);
            AQjmsError.throwEx(157, iOException.getMessage());
            return null;
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashTable", "exit");
        return hashtable;
    }

    void populateMapMessageContainer() throws JMSException {
        Object var1_1 = null;
        int n = 0;
        byte[] byArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.populateMapMessageContainer", "entry");
        try {
            this.map_msg_cont.setHeader(this.header_ext);
            byArray = AQjmsMapMessage.convertHashtableToByteArray(this.mapItemHash);
            n = byArray.length;
            AQjmsOracleDebug.trace(5, "AQjmsMapMessage.populateMapMessageContainer", " bytes_len " + n);
            this.map_msg_cont.setBytesLen(new Integer(n));
            if (n > 2000) {
                this.map_msg_cont.setBytesRaw(null);
            } else {
                this.map_msg_cont.setBytesRaw(byArray);
                this.map_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.populateMapMessageContainer", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.populateMapMessageContainer", "exit");
    }

    void write_blob(Connection connection, String string, byte[] byArray, boolean bl, boolean bl2) throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray2 = null;
        int n2 = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.write_blob", "entry");
        try {
            byArray2 = AQjmsMapMessage.convertHashtableToByteArray(this.mapItemHash);
            n = byArray2.length;
            if (string == null) {
                AQjmsOracleDebug.trace(1, "AQjmsMapMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsMapMessage.write_blob", "bytes_len: " + n);
            if (n > 2000) {
                ORADataFactory oRADataFactory = bl ? AQjmsGenMessage_C.getFactory() : AQjmsMapMessage_C.getFactory();
                AQjmsOracleDebug.trace(5, "AQjmsMapMessage.write_blob", "is_anydata_dest: " + bl2);
                statement = bl2 ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + string + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT user_data FROM " + string + " where msgid = ?");
                statement.setBytes(1, byArray);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    if (bl2) {
                        bLOB = ((OracleResultSet)resultSet).getBLOB(1);
                    } else if (bl) {
                        AQjmsGenMessage_C aQjmsGenMessage_C = (AQjmsGenMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsGenMessage_C.getBytesLob();
                    } else {
                        AQjmsMapMessage_C aQjmsMapMessage_C = (AQjmsMapMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsMapMessage_C.getBytesLob();
                    }
                }
                if (bLOB == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsMapMessage.write_blob", "Internal error - bytes_blob is null");
                    AQjmsError.throwEx(122, "bytes_blob is null");
                }
                n2 = bLOB.putBytes(1L, byArray2);
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessaeg.write_blob", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.write_blob", "exit");
    }

    Hashtable readMapMessageContainer() throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.readMapMessageContainer", "entry");
        try {
            n = this.map_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsMapMessage.readMapMessageContainer", "bytes_len: " + n);
            if (n > 2000) {
                bLOB = this.map_msg_cont.getBytesLob();
                if (bLOB != null) {
                    byArray = bLOB.getBytes(1L, n);
                }
            } else {
                byArray = this.map_msg_cont.getBytesRaw();
            }
            AQjmsOracleDebug.trace(4, "AQjmsMapMessage.readMapMessageContainer", "exit");
            return AQjmsMapMessage.convertByteArrayToHashtable(byArray);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.readMapMessageContainer", sQLException);
            throw new AQjmsException(sQLException);
        }
    }
}

