/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.OutputStream;
import java.io.PrintWriter;
import oracle.AQ.AQOracleDebug;

public class AQjmsOracleDebug {
    static OutputStream logstream = System.out;
    static PrintWriter pstream = new PrintWriter(logstream);
    public static boolean DEBUG = false;
    private static int TRACE_LEVEL = Integer.getInteger("oracle.jms.traceLevel", 0);
    public static final int AQ_ORA_TR1 = 1;
    public static final int AQ_ORA_TR2 = 2;
    public static final int AQ_ORA_TR3 = 3;
    public static final int AQ_ORA_TR4 = 4;
    public static final int AQ_ORA_TR5 = 5;

    private AQjmsOracleDebug() {
    }

    public static void setDebug(boolean bl) {
        DEBUG = bl;
        AQOracleDebug.setDebug(bl);
    }

    public static void setTraceLevel(int n) {
        TRACE_LEVEL = n > 5 ? 5 : (n < 0 ? 0 : n);
        AQOracleDebug.setTraceLevel(n);
    }

    public static int getTraceLevel() {
        return TRACE_LEVEL;
    }

    public static OutputStream getLogStream() {
        return logstream;
    }

    public static void setLogStream(OutputStream outputStream) {
        logstream = outputStream;
        pstream = new PrintWriter(logstream);
    }

    static void trace(int n, String string, String string2) {
        if (TRACE_LEVEL >= n) {
            pstream.println(Thread.currentThread().getName() + "  " + string + ":  " + string2);
            pstream.flush();
        }
    }

    static void traceEx(int n, String string, Exception exception) {
        if (TRACE_LEVEL >= n) {
            pstream.println(Thread.currentThread().getName() + "  " + string + ": Exception: " + exception);
            if (TRACE_LEVEL >= 5 && exception != null) {
                exception.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void traceErr(int n, String string, Error error) {
        if (TRACE_LEVEL >= n) {
            pstream.println(Thread.currentThread().getName() + "  " + string + ": Error: " + error);
            if (TRACE_LEVEL >= 5 && error != null) {
                error.printStackTrace(pstream);
            }
            pstream.flush();
        }
    }

    static void print(String string) {
        if (DEBUG) {
            pstream.print(string);
            pstream.flush();
        }
    }

    static void println(String string) {
        if (DEBUG) {
            pstream.println(Thread.currentThread().getName() + "  " + string);
            pstream.flush();
        }
    }
}

