/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.JMSException;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsParserConstants;
import oracle.jms.AQjmsParserTokenManager;
import oracle.jms.ASCII_CharStream;
import oracle.jms.JJAQjmsParserCalls;
import oracle.jms.ParseException;
import oracle.jms.Token;

class AQjmsParser
implements AQjmsParserConstants {
    boolean is_func_call = false;
    int dest_pload_type = 0;
    public AQjmsParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[30];
    private final int[] jj_la1_0 = new int[]{1703955456, 4096, 32, 1024, 1703954432, 0, 256, 1984, 0x8000000, 1024, 1024, 1024, 8192, 1024, 0x60000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0x60000000, 0x60000000, 2048, 93339648, 0, 0, -443529216, -443529216, 0, 0, 0x1100000, 0};
    private final int[] jj_la1_1 = new int[]{0, 0, 0, 0, 0, 1016, 0, 1016, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 0, 0, 0, 0, 4, 4, 0, 0, 4, 4, 0, 1016};
    private final JJAQjmsParserCalls[] jj_2_rtns = new JJAQjmsParserCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] stringArray) throws ParseException {
        AQjmsParser aQjmsParser = null;
        String string = null;
        AQjmsOracleDebug.setTraceLevel(5);
        AQjmsOracleDebug.setDebug(true);
        if (stringArray.length < 1) {
            System.out.println("Reading from stdin");
            aQjmsParser = new AQjmsParser(System.in);
        } else {
            try {
                aQjmsParser = new AQjmsParser(new DataInputStream(new FileInputStream(stringArray[0])));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("File " + stringArray[0] + " not found. Reading from stdin");
                aQjmsParser = new AQjmsParser(System.in);
            }
        }
        if (stringArray.length > 0) {
            System.out.println("Reading from file: " + stringArray[0]);
        }
        string = aQjmsParser.SubscriberRule();
        System.out.println("Parse Successful");
        System.out.println("Expression: " + string);
    }

    public void setDestPayloadType(int n) {
        this.dest_pload_type = n;
    }

    public String parseRule(String string) throws JMSException {
        AQjmsParser aQjmsParser = null;
        String string2 = null;
        AQjmsOracleDebug.trace(4, "AQjmsParser.parseRule", "entry");
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        aQjmsParser = new AQjmsParser(byteArrayInputStream);
        try {
            string2 = aQjmsParser.SubscriberRule();
            AQjmsOracleDebug.trace(5, "AQjmsParser.parseRule", "Rule: " + string2);
            AQjmsOracleDebug.println("\nMessage parsed successfully");
        }
        catch (ParseException parseException) {
            AQjmsOracleDebug.traceEx(4, "Rule parse error", parseException);
            new AQjmsException("Rule Parse error", 100, parseException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsParser.parseRule", "exit");
        return string2;
    }

    public String mapJMSStringToColumn(String string, int n) throws ParseException {
        String string2 = null;
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSStringToColumn", "Sel type: " + n);
        if (n == 10 || n == 50) {
            string2 = this.mapJMSStringToRule(string);
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String mapJMSStringToRule(String string) throws ParseException {
        String string2 = null;
        if (string == null) {
            throw new ParseException("input is NULL");
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSStringToRule", "Input: " + string);
        if (string.equals("")) {
            return string;
        }
        if (string.equalsIgnoreCase("true")) {
            return "1";
        }
        if (string.equalsIgnoreCase("false")) {
            return "0";
        }
        if (string.equalsIgnoreCase("NULL")) {
            return string;
        }
        if (string.startsWith("JMS_Oracle")) {
            if (!string.equals("JMS_OracleConnectionID")) {
                throw new ParseException("Oracle specific property: " + string + " not supported in message selector");
            }
            string2 = "decode(dbms_aqjms.get_ptype('" + string + "', tab.user_data.header.properties), " + "100, dbms_aqjms.get_strval('" + string + "', tab.user_data.header.properties), " + "200, dbms_aqjms.get_numval('" + string + "', tab.user_data.header.properties))";
        } else if (string.startsWith("JMS")) {
            if (string.equals("JMSPriority")) {
                string2 = AQjmsConstants.isJ2eeCompliant() ? "(9 - priority)" : "priority";
            } else if (string.equals("JMSCorrelationID")) {
                string2 = "corrid";
            } else if (string.equals("JMSTimestamp")) {
                string2 = "enq_time";
            } else if (string.equals("JMSMessageID")) {
                string2 = "tab.msgid";
            } else if (string.equals("JMSType")) {
                string2 = "tab.user_data.header.type";
            } else if (string.equals("JMSXUserID")) {
                string2 = "tab.user_data.header.userid";
            } else if (string.equals("JMSXAppID")) {
                string2 = "tab.user_data.header.appid";
            } else if (string.equals("JMSXGroupID")) {
                string2 = "tab.user_data.header.groupid";
            } else {
                if (!string.equals("JMSXGroupSeq")) throw new ParseException("System property: " + string + " not supported in message selector");
                string2 = "tab.user_data.header.groupseq";
            }
        } else {
            string2 = this.is_func_call ? string : (this.dest_pload_type == 3 ? "decode(dbms_aqjms.get_ptype('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), " + "100, dbms_aqjms.get_strval('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)), " + "200, dbms_aqjms.get_numval('" + string + "', dbms_aqjms.aq$_pr(tab.user_data)))" : "decode(dbms_aqjms.get_ptype('" + string + "', tab.user_data.header.properties), " + "100, dbms_aqjms.get_strval('" + string + "', tab.user_data.header.properties), " + "200, dbms_aqjms.get_numval('" + string + "', tab.user_data.header.properties))");
        }
        AQjmsOracleDebug.trace(5, "AQjmsParser.mapJMSStringToRule", "New value: " + string2);
        return string2;
    }

    String trimIDPrefix(String string) throws ParseException {
        AQjmsOracleDebug.trace(4, "AQjmsParser", "trimIDPrefix - entry");
        if (string == null || string.length() < 5 || !string.substring(1, 4).equals("ID:")) {
            AQjmsOracleDebug.trace(3, "AQjmsParser", "trimIDPrefix - parse exception");
            throw new ParseException("Invalid JMSMessageID in selector");
        }
        String string2 = string.substring(0, 1) + string.substring(4);
        AQjmsOracleDebug.trace(4, "AQjmsParser", "trimIDPrefix - exit");
        return string2;
    }

    String checkForEscapeChars(String string) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        String string2 = null;
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        AQjmsOracleDebug.trace(5, "AQjmsParser.checkForEscapeChars", "QuotedInput:  " + string);
        if (string == null || string.length() <= 2) {
            return string;
        }
        string2 = string.substring(1, string.length() - 1);
        stringBuffer.append("'");
        if (string2 != null && string2.length() > 0) {
            while (bl2) {
                n2 = string2.indexOf("\\", n);
                if (n2 == -1) {
                    bl2 = false;
                    if (n == 0) {
                        stringBuffer.append(string2);
                        continue;
                    }
                    stringBuffer.append(string2.substring(n));
                    continue;
                }
                if (n2 < string2.length() - 1 && string2.charAt(n2 + 1) == '\'') {
                    stringBuffer.append(string2.substring(n, n2));
                    stringBuffer.append("'");
                    stringBuffer.append(string2.charAt(n2 + 1));
                    n = n2 + 2;
                } else {
                    stringBuffer.append(string2.substring(n, n2 + 1));
                    n = n2 + 1;
                }
                bl2 = n < string2.length();
            }
        } else {
            stringBuffer.append(string2);
        }
        stringBuffer.append("'");
        string3 = stringBuffer.toString();
        AQjmsOracleDebug.trace(5, "AQjmsParser.checkForEscapeChars", "New String:  " + string3);
        return string3;
    }

    public final String SequenceOfStatements() throws ParseException {
        String string = new String("");
        String string2 = null;
        block3: while (true) {
            string2 = this.SubscriberRule();
            string = string + string2 + "\n";
            this.jj_consume_token(25);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 11: 
                case 14: 
                case 20: 
                case 23: 
                case 24: 
                case 26: 
                case 29: 
                case 30: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[0] = this.jj_gen;
        return string;
    }

    public final String SubscriberRule() throws ParseException {
        String string = this.SQLExpression();
        this.jj_consume_token(25);
        AQjmsOracleDebug.println("SubscriberRule: \n" + string);
        return string;
    }

    public final String SQLExpression() throws ParseException {
        String string = new String("");
        String string2 = this.SQLAndExpression();
        string = string + string2;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(12);
            string = string + " OR ";
            string2 = this.SQLAndExpression();
            string = string + string2;
        }
        AQjmsOracleDebug.println("SQLExpression: " + string);
        return string;
    }

    public final String SQLAndExpression() throws ParseException {
        String string = new String("");
        String string2 = this.SQLUnaryLogicalExpression();
        string = string + string2;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
            string = string + " AND ";
            string2 = this.SQLUnaryLogicalExpression();
            string = string + string2;
        }
        return string;
    }

    public final String SQLUnaryLogicalExpression() throws ParseException {
        String string = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                string = string + " NOT ";
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        String string2 = this.SQLRelationalExpression();
        string = string + string2;
        return string;
    }

    public final String SQLRelationalExpression() throws ParseException {
        String string;
        boolean bl = false;
        String string2 = new String("");
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(26);
            string2 = string2 + "(";
            string = this.SQLExpressionList(false);
            string2 = string2 + string;
            this.jj_consume_token(28);
            string2 = string2 + ")";
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 14: 
                case 20: 
                case 23: 
                case 24: 
                case 26: 
                case 29: 
                case 30: {
                    string = this.SQLSimpleExpression();
                    string2 = string2 + string;
                    if (!"tab.msgid".equals(string)) break;
                    bl = true;
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        string = this.SQLRelationalOperatorExpression(bl);
                        string2 = string2 + string;
                        break block3;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                if (this.jj_2_2(2)) {
                    string = this.SQLInClause(bl);
                    string2 = string2 + string;
                    break;
                }
                if (this.jj_2_3(2)) {
                    string = this.SQLBetweenClause(bl);
                    string2 = string2 + string;
                    break;
                }
                if (this.jj_2_4(2)) {
                    string = this.SQLLikeClause(bl);
                    string2 = string2 + string;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        string = this.IsNullClause();
                        string2 = string2 + string;
                        break block3;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        return string2;
    }

    public final String SQLExpressionList(boolean bl) throws ParseException {
        String string = new String("");
        String string2 = this.SQLSimpleExpression();
        if (bl) {
            string2 = this.trimIDPrefix(string2);
        }
        string = string + string2;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(27);
            string = string + ", ";
            string2 = this.SQLSimpleExpression();
            if (bl) {
                string2 = this.trimIDPrefix(string2);
            }
            string = string + string2;
        }
        AQjmsOracleDebug.println("SQLExpressionList: " + string);
        return string;
    }

    public final String SQLRelationalOperatorExpression(boolean bl) throws ParseException {
        String string = new String("");
        String string2 = this.Relop();
        string = string + string2;
        string2 = this.SQLSimpleExpression();
        if (bl) {
            string2 = this.trimIDPrefix(string2);
        }
        string = string + string2;
        return string;
    }

    public final String SQLInClause(boolean bl) throws ParseException {
        String string = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                string = string + " NOT ";
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        this.jj_consume_token(7);
        string = string + " IN ";
        this.jj_consume_token(26);
        string = string + "(";
        String string2 = this.SQLExpressionList(bl);
        string = string + string2;
        this.jj_consume_token(28);
        string = string + ")";
        return string;
    }

    public final String SQLBetweenClause(boolean bl) throws ParseException {
        String string = new String("");
        String string2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                string = string + " NOT ";
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.jj_consume_token(6);
        string = string + " BETWEEN ";
        string2 = this.SQLSimpleExpression();
        if (bl) {
            string2 = this.trimIDPrefix(string2);
        }
        string = string + string2;
        this.jj_consume_token(5);
        string = string + " AND ";
        string2 = this.SQLSimpleExpression();
        if (bl) {
            string2 = this.trimIDPrefix(string2);
        }
        string = string + string2;
        return string;
    }

    public final String SQLLikeClause(boolean bl) throws ParseException {
        String string = new String("");
        String string2 = null;
        Object var4_4 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                string = string + " NOT ";
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(9);
        string = string + " LIKE ";
        string2 = this.SQLSimpleExpression();
        if (bl) {
            string2 = this.trimIDPrefix(string2);
        }
        string = string + string2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                string = string + " ESCAPE ";
                string2 = this.SQLSimpleExpression();
                string = string + string2;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        return string;
    }

    public final String IsNullClause() throws ParseException {
        String string = new String("");
        this.jj_consume_token(8);
        string = string + " IS ";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                this.jj_consume_token(10);
                string = string + " NOT ";
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(11);
        string = string + " NULL ";
        return string;
    }

    public final String SQLSimpleExpression() throws ParseException {
        String string = new String("");
        String string2 = null;
        string2 = this.SQLMultiplicativeExpression();
        string = string + string2;
        while (this.jj_2_5(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    this.jj_consume_token(29);
                    string = string + " + ";
                    break;
                }
                case 30: {
                    this.jj_consume_token(30);
                    string = string + " - ";
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            string2 = this.SQLMultiplicativeExpression();
            string = string + string2;
        }
        AQjmsOracleDebug.println("SQLSimpleExpression: " + string);
        return string;
    }

    public final String SQLMultiplicativeExpression() throws ParseException {
        String string = new String("");
        String string2 = null;
        string2 = this.SQLExponentExpression();
        string = string + string2;
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    this.jj_consume_token(31);
                    string = string + "*";
                    break;
                }
                case 32: {
                    this.jj_consume_token(32);
                    string = string + "/";
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            string2 = this.SQLExponentExpression();
            string = string + string2;
        }
        AQjmsOracleDebug.println("SQLMultiplicativeExpression: " + string);
        return string;
    }

    public final String SQLExponentExpression() throws ParseException {
        String string = new String("");
        String string2 = null;
        string2 = this.SQLUnaryExpression();
        string = string + string2;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(33);
            string = string + "**";
            string2 = this.SQLUnaryExpression();
            string = string + string2;
        }
        return string;
    }

    public final String SQLUnaryExpression() throws ParseException {
        String string = new String("");
        String string2 = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 30: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        this.jj_consume_token(29);
                        string = string + "+";
                        break block0;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        string = string + "-";
                        break block0;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        string2 = this.SQLPrimaryExpression();
        string = string + string2;
        return string;
    }

    public final String SQLPrimaryExpression() throws ParseException {
        String string = new String("");
        String string2 = null;
        Token token = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                string = string + " NULL ";
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                if (this.jj_2_6(Integer.MAX_VALUE)) {
                    string2 = this.FunctionCall();
                    string = string + string2;
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: 
                    case 24: {
                        string2 = this.TableColumn();
                        string = string + string2;
                        break block0;
                    }
                    case 14: {
                        token = this.jj_consume_token(14);
                        string = string + token.image;
                        break block0;
                    }
                    case 23: {
                        token = this.jj_consume_token(23);
                        string = string + this.checkForEscapeChars(token.image);
                        break block0;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        string = string + "(";
                        string2 = this.SQLExpression();
                        string = string + string2;
                        this.jj_consume_token(28);
                        string = string + ")";
                        break block0;
                    }
                }
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AQjmsOracleDebug.println("SQLPrimaryExpression: " + string);
        return string;
    }

    public final String FunctionCall() throws ParseException {
        AQjmsOracleDebug.println("Before evaluating function: ");
        this.is_func_call = true;
        String string = new String("");
        String string2 = null;
        string2 = this.OracleObjectName();
        string = string + string2;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                string = string + ".";
                string2 = this.OracleObjectName();
                string = string + string2;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        this.jj_consume_token(34);
                        string = string + ".";
                        string2 = this.OracleObjectName();
                        string = string + string2;
                        break block0;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        string = string + "(";
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 14: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 31: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: 
                    case 14: 
                    case 20: 
                    case 23: 
                    case 24: 
                    case 26: 
                    case 29: 
                    case 30: {
                        string2 = this.SQLArguments();
                        string = string + string2;
                        break block6;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        string = string + "*";
                        break block6;
                    }
                }
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        this.jj_consume_token(28);
        string = string + ")";
        AQjmsOracleDebug.println("Function: " + string);
        AQjmsOracleDebug.println("After evaluating function: ");
        this.is_func_call = false;
        return string;
    }

    public final String SQLArguments() throws ParseException {
        String string = new String("");
        String string2 = null;
        string2 = this.SQLExpressionList(false);
        string = string + string2;
        AQjmsOracleDebug.println("SQL Arguments: " + string);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String TableColumn() throws ParseException {
        String string = new String("");
        String string2 = null;
        String string3 = new String("");
        String string4 = null;
        string2 = this.OracleObjectName();
        string = string + string2;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                string = string + ".";
                string2 = this.OracleObjectName();
                string = string + string2;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        this.jj_consume_token(34);
                        string = string + ".";
                        string2 = this.OracleObjectName();
                        string = string + string2;
                        break block0;
                    }
                }
                this.jj_la1[26] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        AQjmsOracleDebug.println("TableColumn: " + string);
        if (string.length() >= 13) {
            string4 = string.substring(0, 13);
            AQjmsOracleDebug.println("TableColumn-substr: " + string4);
        }
        if (string4 != null && string4.equalsIgnoreCase("tab.user_data")) {
            if (this.dest_pload_type != 3) throw new ParseException("invalid object name: " + string);
            return string;
        }
        if (string.indexOf(".") != -1) throw new ParseException("invalid object name: " + string);
        return this.mapJMSStringToColumn(string, 10);
    }

    public final String OracleObjectName() throws ParseException {
        String string = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Token token = this.jj_consume_token(20);
                string = string + token.image;
                break;
            }
            case 24: {
                Token token = this.jj_consume_token(24);
                string = string + token.image;
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        AQjmsOracleDebug.println("OracleObjectName: " + string);
        return string;
    }

    public final String Relop() throws ParseException {
        String string = new String("");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                string = string + " = ";
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                string = string + " <> ";
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                string = string + " != ";
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                string = string + " > ";
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                string = string + " >= ";
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                string = string + " < ";
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                string = string + " <= ";
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    private final boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_1();
        this.jj_save(0, n);
        return bl;
    }

    private final boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_2();
        this.jj_save(1, n);
        return bl;
    }

    private final boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_3();
        this.jj_save(2, n);
        return bl;
    }

    private final boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_4();
        this.jj_save(3, n);
        return bl;
    }

    private final boolean jj_2_5(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_5();
        this.jj_save(4, n);
        return bl;
    }

    private final boolean jj_2_6(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean bl = !this.jj_3_6();
        this.jj_save(5, n);
        return bl;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_15()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_52()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        Token token;
        block3: {
            if (this.jj_3R_52()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_53()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(23)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_3R_45()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_3R_15()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = token;
            if (this.jj_3R_39()) {
                this.jj_scanpos = token;
                if (this.jj_3R_40()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_41()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_42()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_43()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_49()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        Token token;
        block3: {
            if (this.jj_3R_49()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_50()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = token;
            if (this.jj_3R_37()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_24() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_33()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_18() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_18()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_64()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        Token token;
        block3: {
            if (this.jj_3R_8()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_46()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_3R_62()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_11()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_3R_10()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_9()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_3R_61()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = token;
            if (this.jj_3_2()) {
                this.jj_scanpos = token;
                if (this.jj_3_3()) {
                    this.jj_scanpos = token;
                    if (this.jj_3_4()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_60()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_19() {
        Token token;
        block3: {
            if (this.jj_3R_24()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_30()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(39)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_17() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_23() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_31()) {
            this.jj_scanpos = token;
            if (this.jj_3R_32()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_10() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_17()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_8()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = token;
            if (this.jj_3R_67()) {
                this.jj_scanpos = token;
                if (this.jj_3R_68()) {
                    this.jj_scanpos = token;
                    if (this.jj_3R_69()) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_70()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_71()) {
                                this.jj_scanpos = token;
                                if (this.jj_3R_72()) {
                                    return true;
                                }
                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = token;
            if (this.jj_3R_57()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_14() {
        Token token;
        block3: {
            if (this.jj_3R_19()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3R_23()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(29)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_26() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_22() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = token;
            if (this.jj_3R_29()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_25() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_16() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_21() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_20() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_25()) {
            this.jj_scanpos = token;
            if (this.jj_3R_26()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_13() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_9() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_16()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_44()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = token;
            if (this.jj_3R_13()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_15() {
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        token = this.jj_scanpos;
        if (this.jj_3R_22()) {
            this.jj_scanpos = token;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_8() {
        Token token;
        block3: {
            if (this.jj_3R_14()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                token = this.jj_scanpos;
                if (this.jj_3_5()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = token;
        return false;
    }

    public AQjmsParser(InputStream inputStream) {
        this.jj_input_stream = new ASCII_CharStream(inputStream, 1, 1);
        this.token_source = new AQjmsParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 30) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJAQjmsParserCalls();
            ++n2;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 30) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJAQjmsParserCalls();
            ++n2;
        }
    }

    public AQjmsParser(AQjmsParserTokenManager aQjmsParserTokenManager) {
        this.token_source = aQjmsParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 30) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJAQjmsParserCalls();
            ++n2;
        }
    }

    public void ReInit(AQjmsParserTokenManager aQjmsParserTokenManager) {
        this.token_source = aQjmsParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int n = 0;
        while (n < 30) {
            this.jj_la1[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[n2] = new JJAQjmsParserCalls();
            ++n2;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int n2 = 0;
                while (n2 < this.jj_2_rtns.length) {
                    JJAQjmsParserCalls jJAQjmsParserCalls = this.jj_2_rtns[n2];
                    while (jJAQjmsParserCalls != null) {
                        if (jJAQjmsParserCalls.gen < this.jj_gen) {
                            jJAQjmsParserCalls.first = null;
                        }
                        jJAQjmsParserCalls = jJAQjmsParserCalls.next;
                    }
                    ++n2;
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        return this.jj_scanpos.kind != n;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.lookingAhead ? this.jj_scanpos : this.token;
        int n2 = 0;
        while (n2 < n) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
            ++n2;
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int n3 = 0;
            while (n3 < this.jj_endpos) {
                this.jj_expentry[n3] = this.jj_lasttokens[n3];
                ++n3;
            }
            boolean bl = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                if (nArray.length != this.jj_expentry.length) continue;
                bl = true;
                int n4 = 0;
                while (n4 < this.jj_expentry.length) {
                    if (nArray[n4] != this.jj_expentry[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) break;
            }
            if (!bl) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public final ParseException generateParseException() {
        int n;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[42];
        int n2 = 0;
        while (n2 < 42) {
            blArray[n2] = false;
            ++n2;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int n3 = 0;
        while (n3 < 30) {
            if (this.jj_la1[n3] == this.jj_gen) {
                n = 0;
                while (n < 32) {
                    if ((this.jj_la1_0[n3] & 1 << n) != 0) {
                        blArray[n] = true;
                    }
                    if ((this.jj_la1_1[n3] & 1 << n) != 0) {
                        blArray[32 + n] = true;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        n = 0;
        while (n < 42) {
            if (blArray[n]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = n;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++n;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        int n4 = 0;
        while (n4 < this.jj_expentries.size()) {
            nArrayArray[n4] = (int[])this.jj_expentries.elementAt(n4);
            ++n4;
        }
        return new ParseException(this.token, nArrayArray, AQjmsParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int n = 0;
        while (n < 6) {
            JJAQjmsParserCalls jJAQjmsParserCalls = this.jj_2_rtns[n];
            do {
                if (jJAQjmsParserCalls.gen <= this.jj_gen) continue;
                this.jj_la = jJAQjmsParserCalls.arg;
                this.jj_lastpos = this.jj_scanpos = jJAQjmsParserCalls.first;
                switch (n) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                    }
                }
            } while ((jJAQjmsParserCalls = jJAQjmsParserCalls.next) != null);
            ++n;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int n, int n2) {
        JJAQjmsParserCalls jJAQjmsParserCalls = this.jj_2_rtns[n];
        while (jJAQjmsParserCalls.gen > this.jj_gen) {
            if (jJAQjmsParserCalls.next == null) {
                jJAQjmsParserCalls = jJAQjmsParserCalls.next = new JJAQjmsParserCalls();
                break;
            }
            jJAQjmsParserCalls = jJAQjmsParserCalls.next;
        }
        jJAQjmsParserCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJAQjmsParserCalls.first = this.token;
        jJAQjmsParserCalls.arg = n2;
    }
}

