/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQOracleAgent;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsQueueSender;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTopicPublisher;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.ORAData;

public class AQjmsProducer
implements AQjmsQueueSender,
AQjmsTopicPublisher {
    AQjmsSession jms_sess;
    AQjmsDestination prod_dest;
    int type;
    boolean msgid_enabled;
    boolean timestamp_enabled;
    int m_priority;
    long m_timetolive;
    int del_mode;
    private String transfxm;
    private String connection_id;

    AQjmsProducer(AQjmsSession aQjmsSession, AQjmsDestination aQjmsDestination, int n) throws JMSException {
        this.jms_sess = aQjmsSession;
        this.prod_dest = aQjmsDestination;
        this.type = n;
        this.del_mode = 2;
        this.m_priority = AQjmsConstants.isJ2eeCompliant() ? 4 : 1;
        this.m_timetolive = -1L;
        this.timestamp_enabled = true;
        this.msgid_enabled = true;
        this.transfxm = null;
        this.connection_id = this.jms_sess.jms_conn.getConnectionID();
    }

    private native void ocienq(String var1, Message var2, int var3, boolean var4, int var5, int var6, long var7, AQjmsAgent[] var9, long[] var10, long var11, String var13) throws Exception;

    public synchronized void setDisableMessageID(boolean bl) throws JMSException {
        this.checkProducerClosed();
        this.msgid_enabled = bl;
    }

    public synchronized boolean getDisableMessageID() throws JMSException {
        this.checkProducerClosed();
        return this.msgid_enabled;
    }

    public synchronized void setDisableMessageTimestamp(boolean bl) throws JMSException {
        this.checkProducerClosed();
        this.timestamp_enabled = bl;
    }

    public synchronized boolean getDisableMessageTimestamp() throws JMSException {
        this.checkProducerClosed();
        return this.timestamp_enabled;
    }

    public synchronized void setDeliveryMode(int n) throws JMSException {
        this.checkProducerClosed();
        if (n != 2 && n != 1) {
            AQjmsError.throwEx(101, Integer.toString(n));
        }
        this.del_mode = n;
    }

    public synchronized int getDeliveryMode() throws JMSException {
        this.checkProducerClosed();
        return this.del_mode;
    }

    public synchronized void setPriority(int n) throws JMSException {
        this.checkProducerClosed();
        this.m_priority = n;
    }

    public synchronized int getPriority() throws JMSException {
        this.checkProducerClosed();
        return this.m_priority;
    }

    public synchronized void setTimeToLive(long l) throws JMSException {
        this.checkProducerClosed();
        this.m_timetolive = l;
    }

    public synchronized long getTimeToLive() throws JMSException {
        this.checkProducerClosed();
        return this.m_timetolive;
    }

    public synchronized Queue getQueue() throws JMSException {
        this.checkProducerClosed();
        if (this.type == 10) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "TopicPublisher");
        return null;
    }

    public synchronized void setTransformation(String string) {
        this.transfxm = string;
    }

    public synchronized String getTransformation() {
        return this.transfxm;
    }

    public synchronized void send(Message message) throws JMSException {
        boolean bl = false;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "entry");
        this.checkProducerClosed();
        if (!this.jms_sess.getTransacted()) {
            bl = true;
        }
        if (this.type != 10) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        this.send(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, bl);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-1", "exit");
    }

    public synchronized void send(Message message, int n, int n2, long l) throws JMSException {
        boolean bl = false;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "entry");
        this.checkProducerClosed();
        if (!this.jms_sess.getTransacted()) {
            bl = true;
        }
        if (this.type != 10) {
            AQjmsError.throwEx(107, "TopicPublisher");
        }
        this.send(this.prod_dest, message, n, n2, l, null, null, bl);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-2", "exit");
    }

    public synchronized void send(Queue queue, Message message) throws JMSException {
        boolean bl = false;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "entry");
        this.checkProducerClosed();
        if (!this.jms_sess.getTransacted()) {
            bl = true;
        }
        this.send(queue, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, bl);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-3", "exit");
    }

    public synchronized void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        boolean bl = false;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "entry");
        this.checkProducerClosed();
        if (!this.jms_sess.getTransacted()) {
            bl = true;
        }
        this.send(queue, message, n, n2, l, null, null, bl);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-4", "exit");
    }

    synchronized void send(Queue queue, Message message, int n, int n2, long l, Integer n3, byte[] byArray, boolean bl) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "entry");
        this.checkProducerClosed();
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (queue == null) {
            if (this.prod_dest == null || this.prod_dest.getQueueName() == null) {
                AQjmsError.throwInvalidDestEx(143);
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "prod_dest: " + this.prod_dest.getCompleteName());
                aQjmsDestination = this.prod_dest;
            }
        } else if (queue.getQueueName() != null) {
            if (queue instanceof AQjmsDestination) {
                AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "queue: " + ((AQjmsDestination)queue).getCompleteName());
                aQjmsDestination = (AQjmsDestination)queue;
            } else {
                AQjmsError.throwInvalidDestEx(125);
            }
        } else {
            AQjmsError.throwInvalidDestEx(143);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.send", "dest_queue: " + aQjmsDestination.getCompleteName());
        this.enqueue(aQjmsDestination, 10, message, n, n2, l, n3, byArray, bl, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.send-main", "exit");
    }

    synchronized void enqueue(AQjmsDestination aQjmsDestination, int n, Message message, int n2, int n3, long l, Integer n4, byte[] byArray, boolean bl, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        Connection connection = null;
        AQjmsConnection aQjmsConnection = null;
        Object var14_13 = null;
        AQjmsMessageHeaderExt aQjmsMessageHeaderExt = null;
        AQjmsPropertyList aQjmsPropertyList = null;
        String string = "";
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        AQjmsAgent aQjmsAgent = null;
        Object var21_20 = null;
        byte[] byArray2 = null;
        Object var23_22 = null;
        Integer n5 = null;
        Integer n6 = null;
        Integer n7 = null;
        long l2 = 0L;
        long l3 = 0L;
        Integer n8 = null;
        Hashtable hashtable = null;
        Object var33_30 = null;
        boolean bl2 = false;
        ARRAY aRRAY = null;
        Object object = null;
        Object var37_34 = null;
        String string2 = null;
        String string3 = null;
        int n9 = 0;
        AQjmsAgent aQjmsAgent2 = null;
        AQjmsSignature aQjmsSignature = null;
        int n10 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        Message message2 = null;
        Date date = new Date();
        AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "entry");
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        message2 = message;
        if (((AQjmsMessage)(message = AQjmsProducer.convert(this.jms_sess, message))).isJMSBody() && AQjmsConstants.isJ2eeCompliant()) {
            n3 = AQjmsMessage.toJMSPriority(n3);
        }
        if (((AQjmsMessage)message).isHeaderOnly()) {
            ((AQjmsMessage)message).setStringProperty2("JMS_OracleHeaderOnly", "yes");
        }
        if (!(message instanceof AQjmsAdtMessage)) {
            ((AQjmsMessage)message).setStringProperty2("JMS_OracleDeliveryMode", "" + n2);
        }
        if (this.type == 20 && !(message instanceof AQjmsAdtMessage)) {
            ((AQjmsMessage)message).setStringProperty2("JMS_OracleConnectionID", this.connection_id);
        }
        if (aQjmsDestination == null) {
            AQjmsError.throwEx(127);
        }
        aQjmsConnection = this.jms_sess.getJmsConnection();
        bl4 = aQjmsDestination.getAdtType().equalsIgnoreCase("SYS.ANYDATA");
        boolean bl5 = aQjmsConnection.getDriver() != null && aQjmsConnection.getDriver().equalsIgnoreCase("oci8") && !(message instanceof AQjmsAdtMessage) && !bl4 && AQDriverManager.isOciAQEnabled();
        this.checkMessageType(aQjmsDestination, message, bl5);
        string = aQjmsDestination.getCompleteName();
        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "q_name: " + string);
        l3 = l == 0L || l == -1L ? -1L : l / 1000L;
        try {
            connection = this.jms_sess.getDBConnection();
            hashtable = (Hashtable)((OracleConnection)connection).getTypeMap();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112);
        }
        try {
            if (!(message instanceof AQjmsAdtMessage)) {
                aQjmsMessageHeaderExt = ((AQjmsMessage)message).getMessageHeaderExt();
                if (aQjmsMessageHeaderExt.getReplyto() == null) {
                    aQjmsAgent2 = new AQjmsAgent(" ", null, 0);
                    aQjmsMessageHeaderExt.setReplyto(aQjmsAgent2);
                }
                string2 = aQjmsConnection.getClientID();
                aQjmsMessageHeaderExt.setUserid(string2);
                aQjmsPropertyList = AQjmsMessage.convertHashtableToPropertyList(((AQjmsMessage)message).getPropertiesHashtable());
                aQjmsMessageHeaderExt.setProperties(aQjmsPropertyList);
            }
            n9 = ((AQjmsMessage)message).getDelay();
            string3 = ((AQjmsMessage)message).getExceptionQueue();
            aQjmsSignature = ((AQjmsMessage)message).getSignature();
            if (bl5) {
                long[] lArray = new long[3];
                int n11 = 0;
                lArray[0] = this.jms_sess.oci_env_handle;
                lArray[1] = this.jms_sess.oci_err_handle;
                lArray[2] = this.jms_sess.oci_svc_handle;
                if (message instanceof AQjmsTextMessage) {
                    n11 = 0;
                } else if (message instanceof AQjmsBytesMessage) {
                    n11 = 1;
                } else if (message instanceof AQjmsStreamMessage) {
                    n11 = 2;
                } else if (message instanceof AQjmsMapMessage) {
                    n11 = 3;
                } else if (message instanceof AQjmsObjectMessage) {
                    n11 = 4;
                } else {
                    AQjmsError.throwEx(122, "wrong msg type for OCI calls");
                }
                bl3 = "SYS.AQ$_JMS_MESSAGE".equalsIgnoreCase(aQjmsDestination.getAdtType());
                AQjmsOracleDebug.println("Context: " + this.jms_sess.oci_aq_cntxt);
                n5 = !bl ? new Integer(2) : new Integer(1);
                AQjmsSession aQjmsSession = this.jms_sess;
                synchronized (aQjmsSession) {
                    this.ocienq(string, message, n11, bl3, n3, n5, l3, aQjmsAgentArray, lArray, this.jms_sess.oci_aq_cntxt, this.transfxm);
                }
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message id: " + message.getJMSMessageID());
            } else {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "message type: " + message.getClass().getName());
                if (message instanceof AQjmsTextMessage) {
                    ((AQjmsTextMessage)message).populateTextMessageContainer((OracleConnection)connection);
                    oracleCallableStatement = this.jms_sess.getTextStmt();
                    oracleCallableStatement.setORAData(15, (ORAData)((AQjmsTextMessage)message).getMessageCont());
                } else if (message instanceof AQjmsBytesMessage) {
                    ((AQjmsBytesMessage)message).populateBytesMessageContainer();
                    oracleCallableStatement = this.jms_sess.getBytesStmt();
                    oracleCallableStatement.setORAData(15, (ORAData)((AQjmsBytesMessage)message).getBytesMessageCont());
                } else if (message instanceof AQjmsStreamMessage) {
                    ((AQjmsStreamMessage)message).populateStreamMessageContainer();
                    oracleCallableStatement = this.jms_sess.getStreamStmt();
                    oracleCallableStatement.setORAData(15, (ORAData)((AQjmsStreamMessage)message).getStreamMessageCont());
                } else if (message instanceof AQjmsMapMessage) {
                    ((AQjmsMapMessage)message).populateMapMessageContainer();
                    oracleCallableStatement = this.jms_sess.getMapStmt();
                    oracleCallableStatement.setORAData(15, (ORAData)((AQjmsMapMessage)message).getMessageCont());
                } else if (message instanceof AQjmsObjectMessage) {
                    ((AQjmsObjectMessage)message).populateObjectMessageContainer();
                    oracleCallableStatement = this.jms_sess.getObjectStmt();
                    oracleCallableStatement.setORAData(15, (ORAData)((AQjmsObjectMessage)message).getMessageCont());
                } else if (message instanceof AQjmsAdtMessage) {
                    object = ((AQjmsAdtMessage)message).getAdtPayload();
                    if (object == null) {
                        AQjmsError.throwEx(104);
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "co_payload: " + object.getClass().getName());
                    if (aQjmsAgentArray != null && aQjmsAgentArray.length > 0) {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list specified");
                        oracleCallableStatement = this.jms_sess.getAdtStmt();
                        aRRAY = this.createRecpArrayfromAgentList(aQjmsAgentArray);
                        oracleCallableStatement.setObject(17, (Object)aRRAY, 2003);
                    } else {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recipient list not specified");
                        oracleCallableStatement = this.jms_sess.getAdtNoRecplStmt();
                    }
                    if (object instanceof CustomDatum) {
                        oracleCallableStatement.setCustomDatum(15, (CustomDatum)object);
                    } else if (object instanceof ORAData) {
                        oracleCallableStatement.setORAData(15, (ORAData)object);
                    } else {
                        AQjmsError.throwEx(129);
                    }
                } else {
                    AQjmsError.throwEx(129);
                }
                oracleCallableStatement.setString(1, string);
                aQjmsAgent = ((AQjmsMessage)message).getSenderID();
                if (aQjmsAgent != null) {
                    oracleCallableStatement.setString(2, aQjmsAgent.getName());
                    oracleCallableStatement.setString(3, aQjmsAgent.getAddress());
                    oracleCallableStatement.setInt(4, aQjmsAgent.getProtocol());
                    AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "sender: " + aQjmsAgent.getName() + ":: " + aQjmsAgent.getAddress());
                } else {
                    oracleCallableStatement.setString(2, null);
                    oracleCallableStatement.setString(3, null);
                    oracleCallableStatement.setInt(4, 0);
                }
                oracleCallableStatement.setNull(5, -2);
                oracleCallableStatement.setString(6, message.getJMSCorrelationID());
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "corrid: " + message.getJMSCorrelationID());
                n5 = !bl ? new Integer(2) : new Integer(1);
                oracleCallableStatement.setObject(7, (Object)n5, 4);
                n6 = new Integer(n3);
                oracleCallableStatement.setObject(8, (Object)n6, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "priority: " + n6);
                n7 = new Integer(n9);
                oracleCallableStatement.setObject(9, (Object)n7, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "delay: " + n7);
                oracleCallableStatement.setLong(10, l3);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "ttl_secs: " + l3);
                if (n4 != null) {
                    if (n4 == 2 || n4 == 3) {
                        oracleCallableStatement.setObject(12, (Object)n4, 4);
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "seq_dev: " + n4);
                        if (byArray != null) {
                            oracleCallableStatement.setObject(11, (Object)byArray, -2);
                        } else {
                            oracleCallableStatement.setNull(11, -2);
                        }
                    } else {
                        AQjmsError.throwEx(154);
                    }
                } else {
                    oracleCallableStatement.setNull(12, 2);
                    oracleCallableStatement.setNull(11, -2);
                }
                oracleCallableStatement.setString(13, string3);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "exceptionQ: " + string3);
                n8 = new Integer(1);
                oracleCallableStatement.setObject(14, (Object)n8, 4);
                AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "p_type: " + n8);
                n10 = 18;
                if (message instanceof AQjmsAdtMessage) {
                    oracleCallableStatement.registerOutParameter(16, -2);
                    if (aQjmsAgentArray == null || aQjmsAgentArray.length <= 0) {
                        n10 = 17;
                    }
                } else {
                    if (aQjmsAgentArray != null && aQjmsAgentArray.length > 0) {
                        AQjmsOracleDebug.trace(5, "AQjmsProducer.enqueue", "recp_list_len: " + aQjmsAgentArray.length);
                        aRRAY = this.createRecpArrayfromAgentList(aQjmsAgentArray);
                        oracleCallableStatement.setObject(16, (Object)aRRAY, 2003);
                    } else {
                        oracleCallableStatement.setNull(16, 2003, "SYS.AQ$_RECIPIENTS");
                    }
                    oracleCallableStatement.registerOutParameter(17, -2);
                }
                if (this.jms_sess.is82compatible()) {
                    if (aQjmsSignature != null) {
                        oracleCallableStatement.setORAData(n10, (ORAData)aQjmsSignature);
                    } else {
                        oracleCallableStatement.setNull(n10, 2002, "SYS.AQ$_SIG_PROP");
                    }
                    oracleCallableStatement.setString(++n10, this.transfxm);
                }
                resultSet = oracleCallableStatement.executeQuery();
                byArray2 = message instanceof AQjmsAdtMessage ? oracleCallableStatement.getBytes(16) : oracleCallableStatement.getBytes(17);
                ((AQjmsMessage)message).setJMSMessageID(byArray2);
            }
            byArray2 = ((AQjmsMessage)message).getJMSMessageIDAsBytes();
            if (message instanceof AQjmsTextMessage) {
                ((AQjmsTextMessage)message).write_lob(connection, aQjmsDestination.getCompleteTableName(), byArray2, bl3, bl4);
            } else if (message instanceof AQjmsBytesMessage) {
                ((AQjmsBytesMessage)message).write_blob(connection, aQjmsDestination.getCompleteTableName(), byArray2, bl3, bl4);
            } else if (message instanceof AQjmsStreamMessage) {
                ((AQjmsStreamMessage)message).write_blob(connection, aQjmsDestination.getCompleteTableName(), byArray2, bl3, bl4);
            } else if (message instanceof AQjmsMapMessage) {
                ((AQjmsMapMessage)message).write_blob(connection, aQjmsDestination.getCompleteTableName(), byArray2, bl3, bl4);
            } else if (message instanceof AQjmsObjectMessage) {
                ((AQjmsObjectMessage)message).write_blob(connection, aQjmsDestination.getCompleteTableName(), byArray2, bl3, bl4);
            }
            message.setJMSTimestamp(date.getTime());
            message.setJMSDestination((Destination)aQjmsDestination);
            message.setJMSDeliveryMode(n2);
            if (l == 0L || l == -1L) {
                message.setJMSExpiration(0L);
            } else {
                l2 = date.getTime() + l3 * 1000L;
                message.setJMSExpiration(l2);
            }
            message.setJMSPriority(n3);
            ((AQjmsMessage)message).setDelay(n9);
            ((AQjmsMessage)message).setExceptionQueue(string3);
            if (!this.jms_sess.getTransacted()) {
                this.jms_sess.getDBConnection().commit();
            }
        }
        catch (SQLException sQLException) {
            try {
                if (oracleCallableStatement != null) {
                    this.jms_sess.destroyStmt(oracleCallableStatement);
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(5, "AQjmsProducer.enqueue-ex2", exception);
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.enqueue-ex3", sQLException);
            if (sQLException.getErrorCode() != 24033) {
                throw new AQjmsException(sQLException);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(146, classNotFoundException);
        }
        catch (Exception exception) {
            AQjmsError.throwEx(204, exception);
        }
        if (message2 != message) {
            AQjmsProducer.convertHeaders(message2, message);
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.enqueue", "exit");
    }

    public synchronized Topic getTopic() throws JMSException {
        this.checkProducerClosed();
        if (this.type == 20) {
            return this.prod_dest;
        }
        AQjmsError.throwEx(107, "QueueReceiver");
        return null;
    }

    public synchronized void publish(Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "entry");
        this.checkProducerClosed();
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-1", "exit");
    }

    public synchronized void publish(Message message, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "entry");
        this.checkProducerClosed();
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, n, n2, l, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-2", "exit");
    }

    public synchronized void publish(Topic topic, Message message) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-3", "exit");
    }

    public synchronized void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "entry");
        this.publish(topic, message, n, n2, l, null, null, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-4", "exit");
    }

    synchronized void publish(Topic topic, Message message, int n, int n2, long l, Integer n3, byte[] byArray, boolean bl, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "entry");
        this.checkProducerClosed();
        if (message == null) {
            AQjmsError.throwEx(133);
        }
        if (topic == null) {
            if (this.prod_dest == null || this.prod_dest.getTopicName() == null) {
                AQjmsError.throwInvalidDestEx(166);
            } else {
                aQjmsDestination = this.prod_dest;
            }
        } else if (topic instanceof AQjmsDestination) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.publish", "topic: " + ((AQjmsDestination)topic).getCompleteName());
            aQjmsDestination = (AQjmsDestination)topic;
        } else {
            AQjmsError.throwInvalidDestEx(166);
        }
        this.enqueue(aQjmsDestination, 20, message, n, n2, l, n3, byArray, bl, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-5", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "entry");
        this.checkProducerClosed();
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-6", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "entry");
        this.publish(topic, message, this.del_mode, this.m_priority, this.m_timetolive, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-7", "exit");
    }

    public synchronized void publish(Message message, AQjmsAgent[] aQjmsAgentArray, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "entry");
        if (this.type != 20) {
            AQjmsError.throwEx(107, "QueueSender");
        }
        this.publish(this.prod_dest, message, n, n2, l, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-8", "exit");
    }

    public synchronized void publish(Topic topic, Message message, AQjmsAgent[] aQjmsAgentArray, int n, int n2, long l) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "entry");
        this.publish(topic, message, n, n2, l, null, null, false, aQjmsAgentArray);
        AQjmsOracleDebug.trace(4, "AQjmsProducer.publish-9", "exit");
    }

    private ARRAY createRecpArrayfromAgentList(AQjmsAgent[] aQjmsAgentArray) throws JMSException {
        Connection connection = null;
        ArrayDescriptor arrayDescriptor = null;
        Object[] objectArray = null;
        ARRAY aRRAY = null;
        int n = 0;
        AQOracleAgent aQOracleAgent = null;
        AQjmsAgent aQjmsAgent = null;
        int n2 = 0;
        int n3 = 0;
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "entry");
        if (aQjmsAgentArray == null || aQjmsAgentArray.length == 0) {
            AQjmsError.throwEx(145);
        }
        n = aQjmsAgentArray.length;
        objectArray = new Object[n];
        try {
            n2 = 0;
            while (n2 < n) {
                aQjmsAgent = aQjmsAgentArray[n2];
                if (aQjmsAgent == null) {
                    n3 = n2 + 1;
                    AQjmsError.throwEx(201);
                }
                aQOracleAgent = new AQOracleAgent(aQjmsAgent.getName(), aQjmsAgent.getAddress(), aQjmsAgent.getProtocol());
                AQjmsOracleDebug.trace(5, "AQjmsProducer", "recp[" + n2 + "]: " + aQjmsAgent.getName() + "::" + aQjmsAgent.getAddress() + "::" + aQjmsAgent.getProtocol());
                objectArray[n2] = aQOracleAgent;
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        try {
            connection = this.jms_sess.getDBConnection();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(112);
        }
        try {
            arrayDescriptor = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_RECIPIENTS", (Connection)connection);
            aRRAY = new ARRAY(arrayDescriptor, connection, (Object)objectArray);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsProducer.createRecpArrayfromAgentList", sQLException);
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(5, "AQjmsProducer.createRecpArrayfromAgentList", "exit");
        return aRRAY;
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsProducer.close", "entry");
        if (!this.isProducerClosed()) {
            this.jms_sess.removeProducer(this);
            this.jms_sess = null;
        }
        AQjmsOracleDebug.trace(4, "AQjmsProducer.close", "exit");
    }

    boolean isProducerClosed() {
        if (this.jms_sess == null) {
            AQjmsOracleDebug.trace(5, "AQjmsProducer.isProducerClosed", "Producer closed");
            return true;
        }
        return false;
    }

    void checkProducerClosed() throws JMSException {
        if (this.isProducerClosed()) {
            AQjmsError.throwIllegalStateEx(138, null);
        }
    }

    boolean checkMessageType(AQjmsDestination aQjmsDestination, Message message, boolean bl) throws JMSException {
        boolean bl2;
        boolean bl3 = false;
        String string = null;
        string = aQjmsDestination.getAdtType();
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "adt_type: " + string);
        AQjmsOracleDebug.trace(5, "AQjmsProducer.checkMessageType", "message_class: " + message.getClass().getName());
        boolean bl4 = bl2 = bl && string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE");
        if (message instanceof AQjmsTextMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "TextMessage", string);
            }
        } else if (message instanceof AQjmsBytesMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "BytesMessage", string);
            }
        } else if (message instanceof AQjmsStreamMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "StreamMessage", string);
            }
        } else if (message instanceof AQjmsMapMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "MapMessage", string);
            }
        } else if (message instanceof AQjmsObjectMessage) {
            if (!(string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string.equalsIgnoreCase("SYS.ANYDATA") || bl2)) {
                AQjmsError.throwEx(108, "ObjectMessage", string);
            }
        } else if (message instanceof AQjmsAdtMessage) {
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsError.throwEx(108, "AdtMessage", string);
            }
        } else {
            AQjmsError.throwEx(108, message.getClass().getName(), string);
        }
        return bl3;
    }

    private static Message convert(AQjmsSession aQjmsSession, Message message) throws JMSException {
        Object object;
        if (message == null || message instanceof AQjmsMessage) {
            return message;
        }
        Object object2 = null;
        object2 = message instanceof BytesMessage ? aQjmsSession.createBytesMessage() : (message instanceof MapMessage ? aQjmsSession.createMapMessage() : (message instanceof ObjectMessage ? aQjmsSession.createObjectMessage() : (message instanceof StreamMessage ? aQjmsSession.createStreamMessage() : (message instanceof TextMessage ? aQjmsSession.createTextMessage() : aQjmsSession.createMessage()))));
        AQjmsProducer.convertHeaders((Message)object2, message);
        Enumeration enumeration = message.getPropertyNames();
        while (enumeration != null && enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (((String)object).startsWith("JMS_Oracle")) continue;
            object2.setObjectProperty((String)object, message.getObjectProperty((String)object));
        }
        if (message instanceof BytesMessage) {
            ((BytesMessage)message).reset();
            int n = 0;
            byte[] byArray = new byte[1024];
            while ((n = ((BytesMessage)message).readBytes(byArray)) != -1) {
                object2.writeBytes(byArray, 0, n);
            }
        } else if (message instanceof MapMessage) {
            object = ((MapMessage)message).getMapNames();
            while (object != null && object.hasMoreElements()) {
                String string = (String)object.nextElement();
                ((MapMessage)object2).setObject(string, ((MapMessage)message).getObject(string));
            }
        } else if (message instanceof ObjectMessage) {
            object = ((ObjectMessage)message).getObject();
            if (object != null) {
                ((ObjectMessage)object2).setObject((Serializable)object);
            }
        } else if (message instanceof StreamMessage) {
            ((StreamMessage)message).reset();
            try {
                object = null;
                while ((object = ((StreamMessage)message).readObject()) != null) {
                    ((StreamMessage)object2).writeObject(object);
                }
            }
            catch (MessageEOFException messageEOFException) {}
        } else if (message instanceof TextMessage && (object = ((TextMessage)message).getText()) != null) {
            ((TextMessage)object2).setText((String)object);
        }
        return object2;
    }

    private static void convertHeaders(Message message, Message message2) throws JMSException {
        if (message2.getJMSCorrelationID() != null) {
            message.setJMSCorrelationID(message2.getJMSCorrelationID());
        }
        if (message2.getJMSReplyTo() != null) {
            message.setJMSReplyTo(message2.getJMSReplyTo());
        }
        if (message2.getJMSType() != null) {
            message.setJMSType(message2.getJMSType());
        }
        message.setJMSDeliveryMode(message2.getJMSDeliveryMode());
        message.setJMSDestination(message2.getJMSDestination());
        message.setJMSExpiration(message2.getJMSExpiration());
        message.setJMSMessageID(message2.getJMSMessageID());
        message.setJMSPriority(message2.getJMSPriority());
        message.setJMSRedelivered(message2.getJMSRedelivered());
        message.setJMSTimestamp(message2.getJMSTimestamp());
    }
}

