/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleAdmin;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsCliSubMapEntry;
import oracle.jms.AQjmsClientSubscriberMap;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsEventListener;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsProducer;
import oracle.jms.AQjmsQueueBrowser;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTopicBrowser;
import oracle.jms.AQjmsTopicReceiver;
import oracle.jms.AdtMessage;
import oracle.jms.TopicBrowser;
import oracle.sql.CustomDatum;
import oracle.sql.ORAData;

public class AQjmsSession
implements QueueSession,
TopicSession {
    int cl_check_interval = 120;
    AQjmsConnection jms_conn;
    int ack_mode;
    boolean transacted;
    int sess_type;
    private CallableStatement rems_stmt;
    private CallableStatement adds_stmt;
    private CallableStatement alts_stmt;
    private CallableStatement bind_stmt;
    private CallableStatement ubnd_stmt;
    private CallableStatement chks_stmt;
    private Hashtable prod_list;
    private Hashtable cons_list;
    private Hashtable qbrowser_list;
    private Hashtable tbrowser_list;
    private volatile boolean close_in_progress;
    private QueueBrowser queue_browser;
    private MessageListener privileged_listener;
    long oci_env_handle;
    long oci_err_handle;
    long oci_svc_handle;
    long oci_aq_cntxt;
    short dbversion;
    OracleCallableStatement st_text = null;
    OracleCallableStatement st_bytes = null;
    OracleCallableStatement st_map = null;
    OracleCallableStatement st_stream = null;
    OracleCallableStatement st_object = null;
    OracleCallableStatement st_adt = null;
    OracleCallableStatement st_adt_rep = null;
    OracleCallableStatement reg_stmt = null;
    OracleCallableStatement unreg_stmt = null;
    OracleCallableStatement deq_stmt = null;
    Connection db_conn = null;
    boolean cache_deq_stmt = false;
    static boolean loaded_library = false;
    private Hashtable m_ndsubs = new Hashtable();
    private Hashtable m_subt = new Hashtable();
    private AQjmsEventListener evtListener;
    private Boolean m_lsync = new Boolean(true);
    private boolean m_inlis = false;
    private static final int CHOP_LEN = 20;

    AQjmsSession(AQjmsConnection aQjmsConnection, int n, boolean bl, int n2) throws JMSException {
        this.jms_conn = aQjmsConnection;
        this.ack_mode = n;
        this.transacted = bl;
        if (!aQjmsConnection.created_pool && aQjmsConnection.cpool == null) {
            this.db_conn = aQjmsConnection.db_conn;
            this.dbversion = aQjmsConnection.dbversion;
        } else {
            try {
                this.db_conn = aQjmsConnection.cpool.getConnection();
                this.db_conn.setAutoCommit(false);
                this.dbversion = ((OracleConnection)this.db_conn).getVersionNumber();
            }
            catch (SQLException sQLException) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession constructor", sQLException);
                throw new AQjmsException(sQLException);
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.constructor", "dbversion=" + this.dbversion);
        this.rems_stmt = null;
        this.adds_stmt = null;
        this.alts_stmt = null;
        this.bind_stmt = null;
        this.ubnd_stmt = null;
        this.chks_stmt = null;
        if (n2 == 10 || n2 == 20) {
            this.sess_type = n2;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Invalid type - not a Queue or Topic");
            AQjmsError.throwEx(122, "invalid type");
        }
        this.prod_list = new Hashtable();
        this.cons_list = new Hashtable();
        this.qbrowser_list = new Hashtable();
        this.tbrowser_list = new Hashtable();
        this.close_in_progress = false;
        this.queue_browser = null;
        this.privileged_listener = null;
        this.cache_deq_stmt = false;
        String string = aQjmsConnection.getDriver();
        if (string != null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.constructor1", "oci enabled = " + AQDriverManager.isOciAQEnabled());
            if ((string.equalsIgnoreCase("oci8") || string.equalsIgnoreCase("oci")) && AQDriverManager.isOciAQEnabled()) {
                this.getOCIHandles();
                AQjmsOracleDebug.trace(3, "AQjmsSession.constructor1", "got oci handles ");
            } else {
                this.oci_aq_cntxt = 0L;
            }
        }
    }

    private native long ociinit(long[] var1, int var2, int var3) throws Exception;

    private native void ocifrctx(long[] var1, long var2, int var4) throws Exception;

    public synchronized BytesMessage createBytesMessage() throws JMSException {
        AQjmsBytesMessage aQjmsBytesMessage = null;
        Object var2_2 = null;
        this.checkSessionStarted();
        aQjmsBytesMessage = new AQjmsBytesMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createBytesMesage", "returning bytes message");
        return aQjmsBytesMessage;
    }

    public synchronized MapMessage createMapMessage() throws JMSException {
        AQjmsMapMessage aQjmsMapMessage = null;
        Object var2_2 = null;
        this.checkSessionStarted();
        aQjmsMapMessage = new AQjmsMapMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMapMessage", "returning map message");
        return aQjmsMapMessage;
    }

    public synchronized Message createMessage() throws JMSException {
        AQjmsTextMessage aQjmsTextMessage = null;
        Object var2_2 = null;
        this.checkSessionStarted();
        aQjmsTextMessage = new AQjmsTextMessage(this);
        aQjmsTextMessage.setText("");
        ((AQjmsMessage)aQjmsTextMessage).setHeaderOnly();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMessage", "return message");
        return aQjmsTextMessage;
    }

    public synchronized ObjectMessage createObjectMessage() throws JMSException {
        AQjmsObjectMessage aQjmsObjectMessage = null;
        Object var2_2 = null;
        this.checkSessionStarted();
        aQjmsObjectMessage = new AQjmsObjectMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return object message");
        return aQjmsObjectMessage;
    }

    public synchronized ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        AQjmsObjectMessage aQjmsObjectMessage = null;
        Object var3_3 = null;
        this.checkSessionStarted();
        aQjmsObjectMessage = new AQjmsObjectMessage(this);
        aQjmsObjectMessage.setObject(serializable);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return initialized object message");
        return aQjmsObjectMessage;
    }

    public synchronized AdtMessage createAdtMessage() throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        aQjmsAdtMessage = this.createAdtMessage(null);
        return aQjmsAdtMessage;
    }

    public synchronized AQjmsAdtMessage createAdtMessage(CustomDatum customDatum) throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        Object var3_3 = null;
        this.checkSessionStarted();
        aQjmsAdtMessage = new AQjmsAdtMessage(customDatum);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return aQjmsAdtMessage;
    }

    public synchronized AdtMessage createORAMessage() throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        aQjmsAdtMessage = this.createORAMessage(null);
        return aQjmsAdtMessage;
    }

    public synchronized AQjmsAdtMessage createORAMessage(ORAData oRAData) throws JMSException {
        AQjmsAdtMessage aQjmsAdtMessage = null;
        Object var3_3 = null;
        this.checkSessionStarted();
        aQjmsAdtMessage = new AQjmsAdtMessage(oRAData);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return aQjmsAdtMessage;
    }

    public synchronized StreamMessage createStreamMessage() throws JMSException {
        AQjmsStreamMessage aQjmsStreamMessage = null;
        Object var2_2 = null;
        this.checkSessionStarted();
        aQjmsStreamMessage = new AQjmsStreamMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createStreamMessage", "return stream message");
        return aQjmsStreamMessage;
    }

    public synchronized TextMessage createTextMessage() throws JMSException {
        AQjmsTextMessage aQjmsTextMessage = null;
        Object var2_2 = null;
        this.checkSessionStarted();
        aQjmsTextMessage = new AQjmsTextMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return text message");
        return aQjmsTextMessage;
    }

    public synchronized TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        AQjmsTextMessage aQjmsTextMessage = null;
        Object var3_3 = null;
        this.checkSessionStarted();
        aQjmsTextMessage = new AQjmsTextMessage(this);
        aQjmsTextMessage.setText(stringBuffer.toString());
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return aQjmsTextMessage;
    }

    public synchronized TextMessage createTextMessage(String string) throws JMSException {
        AQjmsTextMessage aQjmsTextMessage = null;
        Object var3_3 = null;
        this.checkSessionStarted();
        aQjmsTextMessage = new AQjmsTextMessage(this);
        aQjmsTextMessage.setText(string);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return aQjmsTextMessage;
    }

    public synchronized boolean getTransacted() throws JMSException {
        this.checkSessionStarted();
        return this.transacted;
    }

    public synchronized int getAckMode() throws JMSException {
        this.checkSessionStarted();
        return this.ack_mode;
    }

    public synchronized void commit() throws JMSException {
        this.checkSessionStarted();
        Connection connection = null;
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(227, null);
        }
        connection = this.getDBConnection();
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public synchronized void rollback() throws JMSException {
        this.checkSessionStarted();
        Connection connection = null;
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(228, null);
        }
        connection = this.getDBConnection();
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        this.jms_conn.eventListenerToPoll();
    }

    public void close() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.closing", "session closing ...");
        this.close_in_progress = true;
        this.closeSessionResources();
        AQjmsOracleDebug.trace(4, "AQjmsSession.close", "session closed.");
    }

    synchronized void closeSessionResources() throws JMSException {
        Object object;
        AQjmsConnection aQjmsConnection = null;
        Session session = null;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        AQjmsProducer aQjmsProducer = null;
        AQjmsConsumer aQjmsConsumer = null;
        Enumeration enumeration3 = null;
        AQjmsQueueBrowser aQjmsQueueBrowser = null;
        Properties properties = null;
        Connection connection = null;
        Connection connection2 = null;
        if (this.jms_conn == null) {
            return;
        }
        aQjmsConnection = this.jms_conn;
        this.jms_conn = null;
        enumeration3 = this.qbrowser_list.keys();
        while (enumeration3.hasMoreElements()) {
            aQjmsQueueBrowser = (AQjmsQueueBrowser)enumeration3.nextElement();
            try {
                aQjmsQueueBrowser.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        enumeration3 = this.tbrowser_list.keys();
        while (enumeration3.hasMoreElements()) {
            object = (AQjmsTopicBrowser)enumeration3.nextElement();
            try {
                ((AQjmsTopicBrowser)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        enumeration = this.prod_list.elements();
        while (enumeration.hasMoreElements()) {
            aQjmsProducer = (AQjmsProducer)enumeration.nextElement();
            try {
                aQjmsProducer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.privileged_listener != null) {
                object = this.cons_list.elements();
                while (object.hasMoreElements()) {
                    AQjmsConsumer aQjmsConsumer2 = (AQjmsConsumer)object.nextElement();
                    aQjmsConsumer2.unregister(this.evtListener.getPort(), aQjmsConnection);
                }
                this.privileged_listener = null;
            }
            if (this.evtListener != null) {
                this.evtListener.removeSession(this);
                this.evtListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.close", "listener removed");
        enumeration2 = this.cons_list.elements();
        while (enumeration2.hasMoreElements()) {
            aQjmsConsumer = (AQjmsConsumer)enumeration2.nextElement();
            try {
                aQjmsConsumer.closeFromSession(aQjmsConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.oci_aq_cntxt != 0L) {
            properties = new Properties();
            try {
                connection = aQjmsConnection.created_pool || aQjmsConnection.cpool != null ? this.db_conn : aQjmsConnection.getDBConnection();
                properties = ((OracleConnection)connection).getDBAccessProperties();
                if (properties != null) {
                    this.oci_env_handle = Long.parseLong(properties.getProperty("OCIEnvHandle"));
                    this.oci_err_handle = Long.parseLong(properties.getProperty("OCIErrHandle"));
                    this.oci_svc_handle = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
                    object = new long[3];
                    object[0] = this.oci_env_handle;
                    object[1] = this.oci_err_handle;
                    object[2] = this.oci_svc_handle;
                    this.ocifrctx((long[])object, this.oci_aq_cntxt, AQjmsOracleDebug.getTraceLevel());
                }
            }
            catch (Exception exception) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.close-exc", exception);
            }
        }
        try {
            if (this.rems_stmt != null) {
                this.rems_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.adds_stmt != null) {
                this.adds_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.alts_stmt != null) {
                this.alts_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.bind_stmt != null) {
                this.bind_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.chks_stmt != null) {
                this.chks_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chks_stmt = null;
        this.destroyStmt(this.st_text);
        this.destroyStmt(this.st_bytes);
        this.destroyStmt(this.st_map);
        this.destroyStmt(this.st_object);
        this.destroyStmt(this.st_stream);
        this.destroyStmt(this.st_adt);
        this.destroyStmt(this.st_adt_rep);
        this.destroyStmt(this.reg_stmt);
        this.destroyStmt(this.unreg_stmt);
        this.destroyStmt(this.deq_stmt);
        if (aQjmsConnection != null && (session = aQjmsConnection.getJmsSession()) != null && session.equals(this)) {
            aQjmsConnection.clearJmsSession();
        }
        try {
            connection2 = aQjmsConnection.created_pool || aQjmsConnection.cpool != null ? this.db_conn : aQjmsConnection.getDBConnection();
            if (connection2 != null && !connection2.isClosed()) {
                if (aQjmsConnection.opened_new_conn || aQjmsConnection.created_pool) {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.closeSessionResources", "abort txn");
                    connection2.rollback();
                } else {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.closeSessionResources", "not aborting txn");
                }
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    void startListener() {
        Boolean bl = this.m_lsync;
        synchronized (bl) {
            this.m_inlis = true;
        }
    }

    void stopListener() {
        Boolean bl = this.m_lsync;
        synchronized (bl) {
            this.m_inlis = false;
        }
    }

    boolean inListener() {
        boolean bl = false;
        Boolean bl2 = this.m_lsync;
        synchronized (bl2) {
            bl = this.m_inlis;
        }
        return bl;
    }

    public synchronized void recover() throws JMSException {
        this.checkSessionStarted();
        Connection connection = null;
        if (this.getAckMode() == 2 || this.inListener()) {
            try {
                connection = this.getDBConnection();
                connection.rollback();
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
            this.jms_conn.eventListenerToPoll();
        }
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.privileged_listener;
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        boolean bl = false;
        this.privileged_listener = messageListener;
        this.evtListener = this.jms_conn.createEventListener();
        Enumeration enumeration = this.cons_list.elements();
        while (enumeration.hasMoreElements()) {
            AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
            aQjmsConsumer.register(this.evtListener.getPort());
        }
        this.evtListener.addSession(this, this.cons_list);
        if (this.jms_conn.isConnectionStarted()) {
            this.evtListener.startAQjmsEventListener();
        }
    }

    synchronized boolean pollMessage(AQjmsConsumer aQjmsConsumer) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.pollMessage", "enter-exit");
        return aQjmsConsumer.pollMessage(this.privileged_listener);
    }

    synchronized void notifySession(Hashtable hashtable, Hashtable hashtable2) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.notifySession", "enter");
        if (!this.jms_conn.isConnectionStarted()) {
            return;
        }
        Hashtable hashtable3 = this.privileged_listener != null ? this.cons_list : hashtable2;
        Enumeration enumeration = hashtable3.elements();
        while (enumeration.hasMoreElements()) {
            AQjmsConsumer aQjmsConsumer = (AQjmsConsumer)enumeration.nextElement();
            aQjmsConsumer.notifyConsumer(hashtable, this.privileged_listener);
        }
    }

    public synchronized Queue createQueue(String string) throws JMSException {
        this.checkSessionStarted();
        String string2 = this.getAQOwner(string);
        String string3 = this.getAQName(string);
        Queue queue = null;
        try {
            queue = this.getQueue(string2, string3);
        }
        catch (Exception exception) {
            queue = null;
        }
        return queue;
    }

    public synchronized QueueReceiver createReceiver(Queue queue) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, null);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    public synchronized QueueReceiver createReceiver(Queue queue, Object object) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, object);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        return this.createReceiver(queue, string, null);
    }

    public synchronized QueueReceiver createReceiver(Queue queue, String string, Object object) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        AQjmsSelector aQjmsSelector = null;
        String string2 = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        if (string != null && !string.equals("")) {
            aQjmsSelector = object != null ? new AQjmsSelector(string, 10, 2, this.is82compatible()) : ((string2 = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string, 10, 3, this.is82compatible()) : new AQjmsSelector(string, 10, 1, this.is82compatible()));
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.createReceiver", "Selector: " + aQjmsSelector);
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, object, aQjmsSelector, null);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    public synchronized QueueSender createSender(Queue queue) throws JMSException {
        AQjmsProducer aQjmsProducer = null;
        this.checkSessionStarted();
        if (!(queue == null || queue instanceof AQjmsDestination && ((AQjmsDestination)queue).isQueue())) {
            AQjmsError.throwInvalidDestEx(125);
        }
        aQjmsProducer = new AQjmsProducer(this, (AQjmsDestination)queue, 10);
        this.prod_list.put(aQjmsProducer, aQjmsProducer);
        return aQjmsProducer;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, Object object) throws JMSException {
        return this.createBrowser(queue, null, object, false);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        return this.createBrowser(queue, string, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, String string, boolean bl) throws JMSException {
        return this.createBrowser(queue, string, null, bl);
    }

    public QueueBrowser createBrowser(Queue queue, String string, Object object) throws JMSException {
        return this.createBrowser(queue, string, object, false);
    }

    public synchronized QueueBrowser createBrowser(Queue queue, String string, Object object, boolean bl) throws JMSException {
        AQjmsQueueBrowser aQjmsQueueBrowser = null;
        int n = 1;
        AQjmsSelector aQjmsSelector = null;
        Object var8_8 = null;
        String string2 = null;
        String string3 = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        string2 = ((AQjmsDestination)queue).getCompleteName();
        if (bl) {
            n = 2;
        }
        if (string != null && !string.equals("")) {
            aQjmsSelector = object != null ? new AQjmsSelector(string, 10, 2, this.is82compatible()) : ((string3 = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string, 10, 3, this.is82compatible()) : new AQjmsSelector(string, 10, 1, this.is82compatible()));
        }
        aQjmsQueueBrowser = new AQjmsQueueBrowser((Session)this, (Destination)queue, 10, n, null, aQjmsSelector, object);
        this.qbrowser_list.put(aQjmsQueueBrowser, string2);
        return aQjmsQueueBrowser;
    }

    public TopicBrowser createBrowser(Topic topic, String string) throws JMSException {
        return this.createBrowser(topic, string, null, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String string, boolean bl) throws JMSException {
        return this.createBrowser(topic, string, null, null, bl);
    }

    public TopicBrowser createBrowser(Topic topic, String string, Object object) throws JMSException {
        return this.createBrowser(topic, string, null, object, false);
    }

    public TopicBrowser createBrowser(Topic topic, String string, Object object, boolean bl) throws JMSException {
        return this.createBrowser(topic, string, null, object, bl);
    }

    public TopicBrowser createBrowser(Topic topic, String string, String string2) throws JMSException {
        return this.createBrowser(topic, string, string2, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return this.createBrowser(topic, string, string2, null, bl);
    }

    public TopicBrowser createBrowser(Topic topic, String string, String string2, Object object) throws JMSException {
        return this.createBrowser(topic, string, string2, object, false);
    }

    public synchronized TopicBrowser createBrowser(Topic topic, String string, String string2, Object object, boolean bl) throws JMSException {
        AQjmsTopicBrowser aQjmsTopicBrowser = null;
        int n = 1;
        AQjmsSelector aQjmsSelector = null;
        Object var9_9 = null;
        String string3 = null;
        String string4 = null;
        this.checkSessionStarted();
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        string3 = ((AQjmsDestination)topic).getCompleteName();
        if (bl) {
            n = 2;
        }
        if (string2 != null && !string2.equals("")) {
            aQjmsSelector = object != null ? new AQjmsSelector(string2, 20, 2, this.is82compatible()) : ((string4 = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string2, 20, 3, this.is82compatible()) : new AQjmsSelector(string2, 20, 1, this.is82compatible()));
        }
        aQjmsTopicBrowser = new AQjmsTopicBrowser((Session)this, (Destination)topic, 20, n, string, aQjmsSelector, object);
        this.tbrowser_list.put(aQjmsTopicBrowser, string3);
        return aQjmsTopicBrowser;
    }

    public synchronized TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionStarted();
        return this.makeTemporaryQueue(false);
    }

    public synchronized Topic createTopic(String string) throws JMSException {
        this.checkSessionStarted();
        String string2 = this.getAQOwner(string);
        String string3 = this.getAQName(string);
        Topic topic = null;
        try {
            topic = this.getTopic(string2, string3);
        }
        catch (Exception exception) {
            topic = null;
        }
        return topic;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkSessionStarted();
        String string = this.getSubsName();
        TopicSubscriber topicSubscriber = this.createDurableSubscriber(topic, string);
        this.m_ndsubs.put(topicSubscriber, string);
        return topicSubscriber;
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        this.checkSessionStarted();
        String string2 = this.getSubsName();
        TopicSubscriber topicSubscriber = this.createDurableSubscriber(topic, string2, string, bl);
        this.m_ndsubs.put(topicSubscriber, string2);
        return topicSubscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        return this.createDurableSubscriber(topic, string, null, false, null, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, Object object) throws JMSException {
        return this.createDurableSubscriber(topic, string, null, false, object, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, bl, null, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl, Object object) throws JMSException {
        return this.createDurableSubscriber(topic, string, string2, bl, object, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl, Object object, String string3) throws JMSException {
        AQjmsAgent aQjmsAgent = null;
        TopicSubscriber topicSubscriber = null;
        Object var9_9 = null;
        AQjmsSelector aQjmsSelector = null;
        Connection connection = null;
        String string4 = null;
        this.checkSessionStarted();
        connection = this.getDBConnection();
        if (string == null) {
            AQjmsError.throwEx(116);
        }
        string = AQjmsSession.chopit(string);
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createDurableSubscriber after MessageListener of Session is set");
        }
        try {
            aQjmsAgent = new AQjmsAgent();
            aQjmsAgent.setName(string);
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createDurableSubscriber - error createing agent", sQLException);
            throw new AQjmsException(sQLException);
        }
        string4 = ((AQjmsDestination)topic).getAdtType();
        boolean bl2 = string4.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string4.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string4.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string4.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string4.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string4.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE");
        String string5 = string2;
        if (bl && bl2) {
            string5 = string2 == null || string2.trim().equals("") ? "JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "'" : "(" + string2 + ") and (JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "')";
            AQjmsOracleDebug.trace(5, "AQjmsSession.createDurableSubscriber", "The fixed selector for noLocal option is: " + string5);
        }
        if (string5 != null && !string5.equals("")) {
            if (bl2) {
                aQjmsSelector = new AQjmsSelector(string5, 20, 1, this.is82compatible());
            } else if (string4.equalsIgnoreCase("SYS.ANYDATA")) {
                aQjmsSelector = new AQjmsSelector(string5, 20, 3, this.is82compatible());
            } else {
                if (object == null) {
                    AQjmsError.throwEx(137);
                }
                aQjmsSelector = new AQjmsSelector(string5, 20, 2, this.is82compatible());
            }
        }
        topicSubscriber = AQjmsConstants.isJ2eeCompliant() ? this.createSubInCompliantMode(topic, string, string2, aQjmsSelector, bl, object, string3, aQjmsAgent) : this.createSubInOldMode(topic, string, aQjmsSelector, bl, object, string3, aQjmsAgent);
        this.cons_list.put(topicSubscriber, topicSubscriber);
        this.m_subt.put(string, topic);
        return topicSubscriber;
    }

    private TopicSubscriber createSubInCompliantMode(Topic topic, String string, String string2, AQjmsSelector aQjmsSelector, boolean bl, Object object, String string3, AQjmsAgent aQjmsAgent) throws JMSException {
        TopicSubscriber topicSubscriber = null;
        String string4 = this.jms_conn.getClientID();
        AQjmsCliSubMapEntry aQjmsCliSubMapEntry = AQjmsClientSubscriberMap.addClientSubscriber(string4, string, topic, string2, bl, this.jms_conn.getConnectionID(), string3);
        if (this.checkSubscriberExists(topic, aQjmsAgent)) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is in database.");
            if (aQjmsCliSubMapEntry == null) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is not in subscribers map in memory.");
                try {
                    topicSubscriber = this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, object, false, string3);
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "alterDurableSubscriber is called.");
                }
                catch (AQjmsException aQjmsException) {
                    AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                    if (aQjmsException.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                        topicSubscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, string3);
                    }
                    AQjmsClientSubscriberMap.removeClientSubscriber(string4, string);
                    throw aQjmsException;
                }
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is in subscribers map in memory.");
                boolean bl2 = false;
                try {
                    bl2 = this.topicEquals((AQjmsDestination)topic, (AQjmsDestination)aQjmsCliSubMapEntry.m_topic) && this.selectorEquals(string2, aQjmsCliSubMapEntry.m_selector);
                }
                catch (JMSException jMSException) {
                    AQjmsClientSubscriberMap.recoverClientSubscriber(string4, string, aQjmsCliSubMapEntry);
                    throw jMSException;
                }
                if (bl2) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are the same for old and new subscribers");
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Always alter the subscriber.");
                    try {
                        topicSubscriber = this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, object, false, string3);
                    }
                    catch (AQjmsException aQjmsException) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode-2 - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                        if (aQjmsException.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                            topicSubscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, string3);
                        }
                        AQjmsClientSubscriberMap.recoverClientSubscriber(string4, string, aQjmsCliSubMapEntry);
                        throw aQjmsException;
                    }
                } else {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are different for old and new subscribers");
                    try {
                        this.removeSubscriber(aQjmsCliSubMapEntry.m_topic, aQjmsAgent);
                        topicSubscriber = this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string3);
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber is removed and then recreated.");
                    }
                    catch (AQjmsException aQjmsException) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                        AQjmsClientSubscriberMap.removeClientSubscriber(string4, string);
                        throw aQjmsException;
                    }
                }
            }
        } else {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + string + " is not in database.");
            try {
                topicSubscriber = this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string3);
            }
            catch (AQjmsException aQjmsException) {
                AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
                AQjmsClientSubscriberMap.removeClientSubscriber(string4, string);
                throw aQjmsException;
            }
        }
        return topicSubscriber;
    }

    private TopicSubscriber createSubInOldMode(Topic topic, String string, AQjmsSelector aQjmsSelector, boolean bl, Object object, String string2, AQjmsAgent aQjmsAgent) throws JMSException {
        TopicSubscriber topicSubscriber = null;
        try {
            topicSubscriber = this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, bl, object, false, string2);
        }
        catch (AQjmsException aQjmsException) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInOldMode - aq_ex", "error number: " + aQjmsException.getErrorNumber());
            if (aQjmsException.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInOldMode", "secure queue - check if agent exists");
                if (this.checkSubscriberExists(topic, aQjmsAgent)) {
                    topicSubscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, string2);
                }
                throw aQjmsException;
            }
            if (aQjmsException.getErrorNumber() == 24034) {
                topicSubscriber = this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, object, false, string2);
            }
            throw aQjmsException;
        }
        return topicSubscriber;
    }

    private boolean selectorEquals(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.trim();
        string2 = string2.trim();
        return string.equals(string2);
    }

    private boolean topicEquals(AQjmsDestination aQjmsDestination, AQjmsDestination aQjmsDestination2) throws JMSException {
        boolean bl = this.stringEqualsNoCase(aQjmsDestination.getTopicOwner(), aQjmsDestination2.getTopicOwner());
        boolean bl2 = this.stringEqualsNoCase(aQjmsDestination.getTopicName(), aQjmsDestination2.getTopicName());
        return bl && bl2;
    }

    private boolean stringEqualsNoCase(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return string.equalsIgnoreCase(string2);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent, String string) throws JMSException {
        this.createRemoteSubscriber(topic, aQjmsAgent, string, null, null);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent, String string, Object object) throws JMSException {
        this.createRemoteSubscriber(topic, aQjmsAgent, string, object, null);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent, String string, Object object, String string2) throws JMSException {
        Object var6_6 = null;
        AQjmsSelector aQjmsSelector = null;
        Connection connection = null;
        String string3 = null;
        String string4 = null;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string4 = aQjmsAgent.getAddress();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createRemoteSubscriber1 - get address of remote subscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (string4 == null || string4.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (string != null && !string.equals("")) {
            string3 = ((AQjmsDestination)topic).getAdtType();
            if (string3.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string3.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                aQjmsSelector = new AQjmsSelector(string, 20, 1, this.is82compatible());
            } else if (string3.equalsIgnoreCase("SYS.ANYDATA")) {
                aQjmsSelector = new AQjmsSelector(string, 20, 3, this.is82compatible());
            } else {
                if (object == null) {
                    AQjmsError.throwEx(137);
                }
                aQjmsSelector = new AQjmsSelector(string, 20, 2, this.is82compatible());
            }
        }
        try {
            this.addDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, false, null, true, string2);
        }
        catch (AQjmsException aQjmsException) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.createRemoteSubscriber - aq_ex", "error number: " + aQjmsException.getErrorNumber());
            if (aQjmsException.getErrorNumber() == 24034) {
                this.alterDurableSubscriber(topic, aQjmsAgent, aQjmsSelector, null, true, string2);
            }
            throw aQjmsException;
        }
    }

    synchronized void removeRemoteSubscriber(Topic topic, AQjmsAgent aQjmsAgent) throws JMSException {
        String string = null;
        Connection connection = null;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string = aQjmsAgent.getAddress();
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeRemoteSubscriber2 - get address of remote subscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (string == null || string.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        this.removeSubscriber(topic, aQjmsAgent);
    }

    synchronized boolean checkSubscriberExists(Topic topic, AQjmsAgent aQjmsAgent) {
        String string = "";
        String string2 = "";
        AQOracleAgent aQOracleAgent = null;
        Hashtable hashtable = null;
        String string3 = null;
        int n = 0;
        Object var9_9 = null;
        Object var10_10 = null;
        Connection connection = null;
        int n2 = 0;
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "entry");
        try {
            if (aQjmsAgent == null) {
                AQjmsError.throwEx(105);
            }
            connection = this.getDBConnection();
            string2 = aQjmsAgent.getName();
            string3 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            string = ((AQjmsDestination)topic).getCompleteName();
            try {
                hashtable = (Hashtable)((oracle.jdbc.OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, exception);
            }
            aQOracleAgent = new AQOracleAgent(string2, string3, n);
            AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "subs_name: " + string2 + " subs_addr: " + string3 + " subs_prot: " + n);
            if (this.chks_stmt != null) {
                this.chks_stmt.clearParameters();
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "before subs_exists t_name: " + string);
                this.chks_stmt = connection.prepareCall("begin dbms_aqjms.subscriber_exists(?, ?, ?, ?, ?, ?, ?, ?); end;");
            }
            this.chks_stmt.setString(1, string);
            this.chks_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.chks_stmt.setObject(3, (Object)new Integer(1));
            this.chks_stmt.registerOutParameter(4, 2);
            this.chks_stmt.registerOutParameter(5, 12);
            this.chks_stmt.registerOutParameter(6, 12);
            this.chks_stmt.registerOutParameter(7, 12);
            this.chks_stmt.registerOutParameter(8, 2);
            this.chks_stmt.executeQuery();
            n2 = this.chks_stmt.getInt(8);
        }
        catch (SQLException sQLException) {
            try {
                this.chks_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.chks_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-sqlex", sQLException);
            n2 = 0;
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-ex", exception);
            n2 = 0;
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "exit s_exists=" + n2);
        return n2 == 1;
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String string, String string2) throws JMSException {
        return this.createTopicReceiver(topic, string, string2, null);
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String string, String string2, Object object) throws JMSException {
        AQjmsConsumer aQjmsConsumer = null;
        AQjmsSelector aQjmsSelector = null;
        String string3 = null;
        this.checkSessionStarted();
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createTopicReceiver after MessageListener is set");
        }
        if (string2 != null && !string2.equals("")) {
            aQjmsSelector = object != null ? new AQjmsSelector(string2, 10, 2, this.is82compatible()) : ((string3 = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(string2, 10, 3, this.is82compatible()) : new AQjmsSelector(string2, 10, 1, this.is82compatible()));
        }
        aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string, object, aQjmsSelector, null);
        this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
        return aQjmsConsumer;
    }

    synchronized TopicSubscriber addDurableSubscriber(Topic topic, AQjmsAgent aQjmsAgent, AQjmsSelector aQjmsSelector, boolean bl, Object object, boolean bl2, String string) throws JMSException {
        String string2 = "";
        String string3 = "";
        AQOracleAgent aQOracleAgent = null;
        Hashtable hashtable = null;
        String string4 = null;
        int n = 0;
        String string5 = null;
        AQjmsConsumer aQjmsConsumer = null;
        Connection connection = null;
        connection = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string3 = aQjmsAgent.getName();
            string4 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            string2 = ((AQjmsDestination)topic).getCompleteName();
            try {
                hashtable = (Hashtable)((oracle.jdbc.OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, exception);
            }
            aQOracleAgent = new AQOracleAgent(string3, string4, n);
            if (aQjmsSelector != null) {
                if (aQjmsSelector.getSelectorType() == 10) {
                    string5 = aQjmsSelector.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "Rule: " + string5);
                } else if (aQjmsSelector.getSelectorType() == 40) {
                    string5 = aQjmsSelector.getAdtRule();
                }
            }
            if (this.adds_stmt != null) {
                this.adds_stmt.clearParameters();
            } else if (this.is92compatible()) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "before add_sub-92");
                this.adds_stmt = connection.prepareCall("begin dbms_aqjms.aq$_add_subscriber(?, ?, ?, ?, ?); end;");
            } else if (this.is82compatible()) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "before add_sub-82");
                this.adds_stmt = connection.prepareCall("begin dbms_aqjms.aq$_add_subscriber(?, ?, ?, ?); end;");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "before add_sub-81");
                this.adds_stmt = connection.prepareCall("begin dbms_aqjms.aq$_add_subscriber(?, ?, ?); end;");
            }
            this.adds_stmt.setString(1, string2);
            this.adds_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.adds_stmt.setString(3, string5);
            if (this.is82compatible()) {
                this.adds_stmt.setString(4, string);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        this.adds_stmt.setInt(5, 1);
                    } else {
                        this.adds_stmt.setInt(5, 0);
                    }
                }
            }
            this.adds_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.adds_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.adds_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addDurableSubscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (!bl2) {
            aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string3, object, aQjmsSelector, string);
            this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
            return aQjmsConsumer;
        }
        return null;
    }

    synchronized TopicSubscriber alterDurableSubscriber(Topic topic, AQjmsAgent aQjmsAgent, AQjmsSelector aQjmsSelector, Object object, boolean bl, String string) throws JMSException {
        String string2 = "";
        String string3 = "";
        AQOracleAgent aQOracleAgent = null;
        Hashtable hashtable = null;
        String string4 = null;
        int n = 0;
        String string5 = null;
        AQjmsConsumer aQjmsConsumer = null;
        Connection connection = null;
        connection = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string3 = aQjmsAgent.getName();
            string4 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            string2 = ((AQjmsDestination)topic).getCompleteName();
            try {
                hashtable = (Hashtable)((oracle.jdbc.OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146);
            }
            aQOracleAgent = new AQOracleAgent(string3, string4, n);
            if (aQjmsSelector != null) {
                if (aQjmsSelector.getSelectorType() == 10) {
                    string5 = aQjmsSelector.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Rule: " + string5);
                } else if (aQjmsSelector.getSelectorType() == 40) {
                    string5 = aQjmsSelector.getAdtRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Rule: " + string5);
                }
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                this.alts_stmt = this.is92compatible() ? connection.prepareCall("begin dbms_aqjms.aq$_alter_subscriber(?, ?, ?, ?, ?); end;") : (this.is82compatible() ? connection.prepareCall("begin dbms_aqjms.aq$_alter_subscriber(?, ?, ?, ?); end;") : connection.prepareCall("begin dbms_aqjms.aq$_alter_subscriber(?, ?, ?); end;"));
            }
            this.alts_stmt.setString(1, string2);
            this.alts_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            this.alts_stmt.setString(3, string5);
            if (this.is82compatible()) {
                this.alts_stmt.setString(4, string);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        this.alts_stmt.setInt(5, 1);
                    } else {
                        this.alts_stmt.setInt(5, 0);
                    }
                }
            }
            this.alts_stmt.execute();
            AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Subscriber");
        }
        catch (SQLException sQLException) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.alts_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.alterDurableSubscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
        if (!bl) {
            aQjmsConsumer = new AQjmsConsumer(this, (Destination)topic, 20, 3, string3, object, aQjmsSelector, string);
            this.cons_list.put(aQjmsConsumer, aQjmsConsumer);
            return aQjmsConsumer;
        }
        return null;
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        AQjmsProducer aQjmsProducer = null;
        this.checkSessionStarted();
        if (!(topic == null || topic instanceof AQjmsDestination && ((AQjmsDestination)topic).isTopic())) {
            AQjmsError.throwInvalidDestEx(126);
        }
        aQjmsProducer = new AQjmsProducer(this, (AQjmsDestination)topic, 20);
        this.prod_list.put(aQjmsProducer, aQjmsProducer);
        return aQjmsProducer;
    }

    public synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionStarted();
        return this.makeTemporaryQueue(true);
    }

    public synchronized void unsubscribe(String string) throws JMSException {
        this.checkSessionStarted();
        if (string != null) {
            string = AQjmsSession.chopit(string);
        }
        if (string == null || !this.m_subt.containsKey(string)) {
            throw new InvalidDestinationException(AQjmsError.getMessage(102));
        }
        this.unsubscribe((Topic)this.m_subt.get(string), string);
        this.m_subt.remove(string);
    }

    public synchronized void unsubscribe(Topic topic, String string) throws JMSException {
        Object var3_3 = null;
        AQjmsAgent aQjmsAgent = null;
        Connection connection = null;
        this.checkSessionStarted();
        connection = this.getDBConnection();
        if (string == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        string = AQjmsSession.chopit(string);
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (AQjmsConstants.isJ2eeCompliant()) {
            Object object;
            Object object2 = object = AQjmsClientSubscriberMap.getMapLock();
            synchronized (object2) {
                AQjmsClientSubscriberMap.unsubscribeClientSubscriber(this.jms_conn.getClientID(), string);
                try {
                    aQjmsAgent = new AQjmsAgent();
                    aQjmsAgent.setName(string);
                    this.removeSubscriber(topic, aQjmsAgent);
                }
                catch (SQLException sQLException) {
                    throw new AQjmsException(sQLException);
                }
            }
        }
        try {
            aQjmsAgent = new AQjmsAgent();
            aQjmsAgent.setName(string);
            this.removeSubscriber(topic, aQjmsAgent);
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    public synchronized void unsubscribe(Topic topic, AQjmsAgent aQjmsAgent) throws JMSException {
        this.checkSessionStarted();
        this.removeRemoteSubscriber(topic, aQjmsAgent);
    }

    synchronized void removeSubscriber(Topic topic, AQjmsAgent aQjmsAgent) throws JMSException {
        String string = "";
        String string2 = "";
        AQOracleAgent aQOracleAgent = null;
        Hashtable hashtable = null;
        String string3 = null;
        int n = 0;
        Connection connection = null;
        connection = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string = ((AQjmsDestination)topic).getCompleteName();
            string2 = aQjmsAgent.getName();
            string3 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            try {
                hashtable = (Hashtable)((oracle.jdbc.OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146);
            }
            aQOracleAgent = new AQOracleAgent(string2, string3, n);
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else if (this.is92compatible()) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.removeSubscriber", "before remove_sub-92");
                this.rems_stmt = connection.prepareCall("begin dbms_aqjms.aq$_remove_subscriber(?, ?, ?); end;");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.removeSubscriber", "before remove_sub-81");
                this.rems_stmt = connection.prepareCall("begin dbms_aqjms.aq$_remove_subscriber(queue => ?, subscriber => ?); end;");
            }
            this.rems_stmt.setString(1, string);
            this.rems_stmt.setObject(2, (Object)aQOracleAgent, 2002);
            if (this.is92compatible()) {
                if (((AQjmsDestination)topic).isSecure()) {
                    this.rems_stmt.setInt(3, 1);
                } else {
                    this.rems_stmt.setInt(3, 0);
                }
            }
            this.rems_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeSubscriber", sQLException);
            throw new AQjmsException(sQLException);
        }
    }

    public void run() {
    }

    public synchronized Connection getDBConnection() throws JMSException {
        this.checkSessionStarted();
        return this.jms_conn.created_pool || this.jms_conn.cpool != null ? this.db_conn : this.jms_conn.getDBConnection();
    }

    public Map getTypeMap() throws JMSException {
        Map<String, Class<?>> map = null;
        oracle.jdbc.OracleConnection oracleConnection = null;
        try {
            oracleConnection = (oracle.jdbc.OracleConnection)this.getDBConnection();
            map = oracleConnection.getTypeMap();
            if (map != null) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap found");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap NULL");
            }
        }
        catch (SQLException sQLException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getTypeMap", sQLException);
            throw new AQjmsException(sQLException);
        }
        return map;
    }

    private void checkSessionStarted() throws JMSException {
        if (this.isSessionClosed()) {
            AQjmsError.throwIllegalStateEx(131, null);
        }
    }

    public synchronized AQjmsConnection getJmsConnection() throws JMSException {
        this.checkSessionStarted();
        return this.jms_conn;
    }

    public synchronized AQQueueTable createQueueTable(String string, String string2, AQQueueTableProperty aQQueueTableProperty) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQQueueTable aQQueueTable = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            aQQueueTable = aQOracleSession.createQueueTable(string, string2, aQQueueTableProperty);
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueueTable", aQException);
            throw new AQjmsException(aQException);
        }
        return aQQueueTable;
    }

    public synchronized AQQueueTable getQueueTable(String string, String string2) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQQueueTable aQQueueTable = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            aQQueueTable = aQOracleSession.getQueueTable(string, string2);
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getQueueTable", aQException);
            throw new AQjmsException(aQException);
        }
        return aQQueueTable;
    }

    public synchronized Queue createQueue(AQQueueTable aQQueueTable, String string, AQjmsDestinationProperty aQjmsDestinationProperty) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        Connection connection = null;
        AQjmsDestinationProperty aQjmsDestinationProperty2 = null;
        connection = this.getDBConnection();
        if (aQjmsDestinationProperty == null) {
            AQjmsError.throwEx(121);
        }
        if (aQQueueTable == null) {
            AQjmsError.throwEx(187);
        }
        try {
            if (((AQOracleQueueTable)aQQueueTable).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(144);
            }
            aQOracleSession = new AQOracleSession(connection);
            aQOracleQueue = (AQOracleQueue)aQOracleSession.createQueue(aQQueueTable, string, aQjmsDestinationProperty);
            aQjmsDestinationProperty2 = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 10, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty2, aQOracleQueue.getQueueTableName(), aQQueueTable.isSecure());
            aQOracleQueue.close();
            aQOracleSession.close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueue", aQException);
            throw new AQjmsException(aQException);
        }
        return aQjmsDestination;
    }

    public synchronized Topic createTopic(AQQueueTable aQQueueTable, String string, AQjmsDestinationProperty aQjmsDestinationProperty) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        Connection connection = null;
        AQjmsDestinationProperty aQjmsDestinationProperty2 = null;
        connection = this.getDBConnection();
        if (aQQueueTable == null) {
            AQjmsError.throwEx(187);
        }
        if (aQjmsDestinationProperty == null) {
            AQjmsError.throwEx(121);
        }
        try {
            if (aQjmsDestinationProperty.getQueueType() == 1) {
                AQjmsError.throwEx(151);
            }
            if (!((AQOracleQueueTable)aQQueueTable).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
            aQOracleSession = new AQOracleSession(connection);
            aQOracleQueue = (AQOracleQueue)aQOracleSession.createQueue(aQQueueTable, string, aQjmsDestinationProperty);
            AQjmsOracleDebug.trace(5, "AQjmsSession.createTopic", "Queue table: " + aQOracleQueue.getQueueTableName());
            aQjmsDestinationProperty2 = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 20, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty2, aQOracleQueue.getQueueTableName(), aQQueueTable.isSecure());
            aQOracleQueue.close();
            aQOracleSession.close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic", aQException);
            throw new AQjmsException(aQException);
        }
        return aQjmsDestination;
    }

    public synchronized Queue getQueue(String string, String string2) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        AQjmsDestinationProperty aQjmsDestinationProperty = null;
        Connection connection = null;
        AQOracleQueueTable aQOracleQueueTable = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            aQOracleQueue = (AQOracleQueue)aQOracleSession.getQueue(string, string2);
            aQjmsDestinationProperty = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 10, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure());
            aQOracleQueueTable = (AQOracleQueueTable)this.getQueueTable(aQOracleQueue.getOwner(), aQOracleQueue.getQueueTableName());
            aQOracleQueue.close();
            aQOracleSession.close();
            if (aQOracleQueueTable.isMulticonsumerEnabled() && aQjmsDestinationProperty.getQueueType() != 1) {
                AQjmsError.throwEx(130);
            }
            aQOracleQueueTable.getAQSession().close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getQueue", aQException);
            throw new AQjmsException(aQException);
        }
        return aQjmsDestination;
    }

    public Destination getJmsDestination(AQOracleQueue aQOracleQueue) throws JMSException {
        AQjmsDestination aQjmsDestination = null;
        AQjmsDestinationProperty aQjmsDestinationProperty = null;
        Connection connection = null;
        Object var5_5 = null;
        String string = null;
        connection = this.getDBConnection();
        try {
            string = aQOracleQueue.getObjectPayloadType();
            if (string.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || string.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getJmsDestination", "before newAQjmsDestProp");
                aQjmsDestinationProperty = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
                aQjmsDestination = !aQOracleQueue.isMultiConsumer() || aQjmsDestinationProperty.getQueueType() == 1 ? new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 10, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure()) : new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 20, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure());
            } else {
                aQjmsDestination = null;
            }
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.geJmsDestination", aQException);
            throw new AQjmsException(aQException);
        }
        return aQjmsDestination;
    }

    public synchronized Topic getTopic(String string, String string2) throws JMSException {
        AQOracleSession aQOracleSession = null;
        AQOracleQueue aQOracleQueue = null;
        AQjmsDestination aQjmsDestination = null;
        AQjmsDestinationProperty aQjmsDestinationProperty = null;
        Connection connection = null;
        AQOracleQueueTable aQOracleQueueTable = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            aQOracleQueue = (AQOracleQueue)aQOracleSession.getQueue(string, string2);
            aQjmsDestinationProperty = new AQjmsDestinationProperty(aQOracleQueue.getProperty(true));
            aQjmsDestination = new AQjmsDestination(aQOracleQueue.getOwner(), aQOracleQueue.getName(), 20, aQOracleQueue.getPayloadType(), aQOracleQueue.getObjectPayloadType(), aQjmsDestinationProperty, aQOracleQueue.getQueueTableName(), aQOracleQueue.isSecure());
            aQOracleQueueTable = (AQOracleQueueTable)this.getQueueTable(aQOracleQueue.getOwner(), aQOracleQueue.getQueueTableName());
            aQOracleQueue.close();
            aQOracleSession.close();
            if (!aQOracleQueueTable.isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
            aQOracleQueueTable.getAQSession().close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getTopic", aQException);
            throw new AQjmsException(aQException);
        }
        return aQjmsDestination;
    }

    boolean isSessionClosed() throws JMSException {
        boolean bl = false;
        if (this.close_in_progress) {
            return true;
        }
        if (this.jms_conn == null) {
            bl = true;
        } else {
            block10: {
                if (this.jms_conn.created_pool || this.jms_conn.cpool != null) {
                    if (this.db_conn != null) {
                        try {
                            if (!this.db_conn.isClosed()) {
                                bl = false;
                                break block10;
                            }
                            bl = true;
                        }
                        catch (Exception exception) {
                            bl = true;
                        }
                    }
                } else {
                    bl = this.jms_conn.isConnectionClosed();
                }
            }
            if (bl) {
                this.jms_conn = null;
            }
        }
        return bl;
    }

    int getCloseCheckInterval() {
        return this.cl_check_interval;
    }

    public synchronized void setCloseCheckInterval(int n) throws JMSException {
        if (n >= 1) {
            this.cl_check_interval = n;
        } else {
            AQjmsError.throwEx(123, Integer.toString(1));
        }
    }

    public void grantSystemPrivilege(String string, String string2, boolean bl) throws JMSException {
        AQOracleSession aQOracleSession = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            AQOracleAdmin.grantSystemPrivilege(aQOracleSession, string, string2, bl);
            aQOracleSession.close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.grantSystemPrivilege", aQException);
            throw new AQjmsException(aQException);
        }
    }

    public void revokeSystemPrivilege(String string, String string2) throws JMSException {
        AQOracleSession aQOracleSession = null;
        Connection connection = null;
        connection = this.getDBConnection();
        try {
            aQOracleSession = new AQOracleSession(connection);
            AQOracleAdmin.revokeSystemPrivilege(aQOracleSession, string, string2);
            aQOracleSession.close();
        }
        catch (AQException aQException) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.revokeSystemPrivilege", aQException);
            throw new AQjmsException(aQException);
        }
    }

    public void createAQAgent(String string) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "entry");
        this.createAQAgent(string, false, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "exit");
    }

    public void createAQAgent(String string, boolean bl, boolean bl2, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        String string3 = "false";
        String string4 = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (bl) {
            string3 = "true";
        }
        if (bl2) {
            string4 = "true";
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.create_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + string3 + ", enable_smtp => " + string4 + "); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "exit");
    }

    public void alterAQAgent(String string, boolean bl, boolean bl2, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        String string3 = "false";
        String string4 = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (bl) {
            string3 = "true";
        }
        if (bl2) {
            string4 = "true";
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.alter_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + string3 + ", enable_smtp => " + string4 + "); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "exit");
    }

    public void dropAQAgent(String string) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.drop_aq_agent(agent_name=> ? ); end;");
            statement.setString(1, string);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "exit");
    }

    public void enableDBAccess(String string, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (string2 == null) {
            AQjmsError.throwEx(229, "db_username");
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.enable_db_access(agent_name=> ?, db_username => ? ); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "exit");
    }

    public void disableDBAccess(String string, String string2) throws JMSException {
        Statement statement = null;
        Connection connection = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "entry");
        if (string == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (string2 == null) {
            AQjmsError.throwEx(229, "db_username");
        }
        try {
            connection = this.getDBConnection();
            statement = connection.prepareCall("begin dbms_aqadm.disable_db_access(agent_name=> ?, db_username => ? ); end;");
            statement.setString(1, string);
            statement.setString(2, string2);
            statement.execute();
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
        catch (SQLException sQLException) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "exit");
    }

    public boolean isDeqStmtCachingEnabled() {
        return this.cache_deq_stmt;
    }

    public void setDeqStmtCachingFlag(boolean bl) {
        this.cache_deq_stmt = bl;
    }

    public void bindAgent(AQjmsAgent aQjmsAgent, String string) throws JMSException {
        Connection connection = null;
        String string2 = "";
        AQOracleAgent aQOracleAgent = null;
        Hashtable hashtable = null;
        String string3 = null;
        int n = 0;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string2 = aQjmsAgent.getName();
            string3 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            try {
                hashtable = (Hashtable)((oracle.jdbc.OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, exception);
            }
            aQOracleAgent = new AQOracleAgent(string2, string3, n);
            if (this.bind_stmt != null) {
                this.bind_stmt.clearParameters();
            } else {
                this.bind_stmt = connection.prepareCall("begin dbms_aq.bind_agent(agent=>?, certificate_location=>?); end;");
            }
            this.bind_stmt.setObject(1, (Object)aQOracleAgent, 2002);
            this.bind_stmt.setString(2, string);
            this.bind_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.bind_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bind_stmt = null;
            throw new AQjmsException(sQLException);
        }
    }

    public void unbindAgent(AQjmsAgent aQjmsAgent) throws JMSException {
        Connection connection = null;
        String string = "";
        AQOracleAgent aQOracleAgent = null;
        Hashtable hashtable = null;
        String string2 = null;
        int n = 0;
        connection = this.getDBConnection();
        if (aQjmsAgent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            string = aQjmsAgent.getName();
            string2 = aQjmsAgent.getAddress();
            n = aQjmsAgent.getProtocol();
            try {
                hashtable = (Hashtable)((oracle.jdbc.OracleConnection)connection).getTypeMap();
            }
            catch (Exception exception) {
                AQjmsError.throwEx(112);
            }
            try {
                hashtable.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception exception) {
                AQjmsError.throwEx(146, exception);
            }
            aQOracleAgent = new AQOracleAgent(string, string2, n);
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.clearParameters();
            } else {
                this.ubnd_stmt = connection.prepareCall("begin dbms_aq.unbind_agent(agent=>?); end;");
            }
            this.ubnd_stmt.setObject(1, (Object)aQOracleAgent, 2002);
            this.ubnd_stmt.execute();
        }
        catch (SQLException sQLException) {
            try {
                this.ubnd_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ubnd_stmt = null;
            throw new AQjmsException(sQLException);
        }
    }

    void closeQueueBrowser(AQjmsQueueBrowser aQjmsQueueBrowser) {
        try {
            this.qbrowser_list.remove(aQjmsQueueBrowser);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void closeTopicBrowser(AQjmsTopicBrowser aQjmsTopicBrowser) {
        try {
            this.tbrowser_list.remove(aQjmsTopicBrowser);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    OracleCallableStatement getTextStmt() throws SQLException {
        if (this.st_text == null) {
            this.st_text = this.is82compatible() ? (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_text_message( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ?, signature => ?, transformation=> ? ); end; ") : (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_text_message( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_text.clearParameters();
        }
        return this.st_text;
    }

    OracleCallableStatement getMapStmt() throws SQLException {
        if (this.st_map == null) {
            this.st_map = this.is82compatible() ? (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_map_message( queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ?); end; ") : (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_map_message( queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_map.clearParameters();
        }
        return this.st_map;
    }

    OracleCallableStatement getStreamStmt() throws SQLException {
        if (this.st_stream == null) {
            this.st_stream = this.is82compatible() ? (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_stream_message( queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ?); end; ") : (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_stream_message( queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_stream.clearParameters();
        }
        return this.st_stream;
    }

    OracleCallableStatement getBytesStmt() throws SQLException {
        if (this.st_bytes == null) {
            this.st_bytes = this.is82compatible() ? (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_bytes_message( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ? ); end; ") : (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_bytes_message( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_bytes.clearParameters();
        }
        return this.st_bytes;
    }

    OracleCallableStatement getObjectStmt() throws SQLException {
        if (this.st_object == null) {
            this.st_object = this.is82compatible() ? (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_object_message( queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ? ); end; ") : (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_jms_enqueue_object_message( queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ? ); end; ");
        } else {
            this.st_object.clearParameters();
        }
        return this.st_object;
    }

    OracleCallableStatement getAdtStmt() throws SQLException {
        if (this.st_adt == null) {
            this.st_adt = this.is82compatible() ? (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority=> ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?,exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ?, signature => ?, transformation => ? ); end; ") : (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj( queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority=> ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?,exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ? ); end; ");
        } else {
            this.st_adt.clearParameters();
        }
        return this.st_adt;
    }

    OracleCallableStatement getAdtNoRecplStmt() throws SQLException {
        if (this.st_adt_rep == null) {
            if (this.is82compatible()) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtNoRecplStmt", "82compat- adt");
                this.st_adt_rep = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?,priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, signature => ?, transformation => ? ); end; ");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtNoRecplStmt", "not 82 compat- adt");
                this.st_adt_rep = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_enqueue_obj_no_recpl( queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?,priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?); end; ");
            }
        } else {
            this.st_adt_rep.clearParameters();
        }
        return this.st_adt_rep;
    }

    OracleCallableStatement getRegisterStmt() throws SQLException {
        if (this.reg_stmt == null) {
            this.reg_stmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms.aq$_register(?, ?, ?, ?, ?, ?, ?); end;");
        } else {
            this.reg_stmt.clearParameters();
        }
        return this.reg_stmt;
    }

    OracleCallableStatement getUnregisterStmt() throws SQLException {
        if (this.unreg_stmt == null) {
            this.unreg_stmt = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms.aq$_unregister(?, ?, ?, ?, ?); end;");
        } else {
            this.unreg_stmt.clearParameters();
        }
        return this.unreg_stmt;
    }

    OracleCallableStatement getDequeueStmt() throws SQLException {
        if (this.deq_stmt == null) {
            this.deq_stmt = this.is82compatible() ? (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ") : (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ");
        } else {
            this.deq_stmt.clearParameters();
        }
        return this.deq_stmt;
    }

    void destroyStmt(OracleCallableStatement oracleCallableStatement) {
        if (oracleCallableStatement == null) {
            return;
        }
        boolean bl = false;
        if (oracleCallableStatement == this.st_text) {
            this.st_text = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_map) {
            this.st_map = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_bytes) {
            this.st_bytes = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_stream) {
            this.st_stream = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_object) {
            this.st_object = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_adt) {
            this.st_adt = null;
            bl = true;
        } else if (oracleCallableStatement == this.st_adt_rep) {
            this.st_adt_rep = null;
            bl = true;
        } else if (oracleCallableStatement == this.reg_stmt) {
            this.reg_stmt = null;
            bl = true;
        } else if (oracleCallableStatement == this.unreg_stmt) {
            this.unreg_stmt = null;
            bl = true;
        } else if (oracleCallableStatement == this.deq_stmt) {
            this.deq_stmt = null;
            bl = true;
        }
        if (bl) {
            try {
                oracleCallableStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void getOCIHandles() throws JMSException {
        Object object;
        Properties properties = new Properties();
        Connection connection = this.getDBConnection();
        try {
            if (!loaded_library && ((String)(object = System.getProperty("os.name"))).toUpperCase().startsWith("WINDOWS")) {
                System.loadLibrary("oraclient9");
                loaded_library = true;
            }
        }
        catch (Exception exception) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.loadLibrary excp:", exception);
        }
        catch (Error error) {
            AQjmsOracleDebug.traceErr(3, "AQjmsSession.loadLibrary error:", error);
        }
        try {
            properties = ((OracleConnection)connection).getDBAccessProperties();
        }
        catch (Exception exception) {
            AQjmsError.throwEx(122, "Properties Not Found", exception);
        }
        this.oci_env_handle = Long.parseLong(properties.getProperty("OCIEnvHandle"));
        this.oci_err_handle = Long.parseLong(properties.getProperty("OCIErrHandle"));
        this.oci_svc_handle = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
        object = new long[3];
        object[0] = this.oci_env_handle;
        object[1] = this.oci_err_handle;
        object[2] = this.oci_svc_handle;
        String string = Thread.currentThread().getName();
        int n = 0;
        try {
            AQjmsOracleDebug.println("Tname.substring:" + string.substring(7) + "::");
            n = Integer.parseInt(string.substring(7));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.oci_aq_cntxt = this.ociinit((long[])object, AQjmsOracleDebug.getTraceLevel(), n);
        }
        catch (Exception exception) {
            AQjmsError.throwEx(122, "OCI Init failed!", exception);
        }
    }

    synchronized void register(int n, AQjmsConsumer aQjmsConsumer) throws JMSException {
        OracleCallableStatement oracleCallableStatement = null;
        ResultSet resultSet = null;
        Object var5_5 = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.register", "enter");
        try {
            oracleCallableStatement = this.getRegisterStmt();
            oracleCallableStatement.setString(1, aQjmsConsumer.cons_dest.getQueueOwner().toUpperCase());
            String string = aQjmsConsumer.dest_type == 20 ? aQjmsConsumer.cons_dest.getCompleteName() + ':' + aQjmsConsumer.cons_name : aQjmsConsumer.cons_dest.getCompleteName();
            AQjmsOracleDebug.trace(5, "AQjmsSession.register", "Subname " + string);
            oracleCallableStatement.setString(2, string.toUpperCase());
            AQjmsOracleDebug.println("protocol jmsc:");
            oracleCallableStatement.setString(3, "jmsc://");
            String string2 = InetAddress.getLocalHost().getHostName();
            AQjmsOracleDebug.trace(5, "AQjmsSession.register", "address " + string2);
            oracleCallableStatement.setString(4, string2);
            Integer n2 = new Integer(n);
            oracleCallableStatement.setObject(5, (Object)n2, 4);
            Integer n3 = new Integer(1);
            oracleCallableStatement.setObject(6, (Object)n3, 4);
            Integer n4 = new Integer(1);
            oracleCallableStatement.setObject(7, (Object)n4, 4);
            resultSet = oracleCallableStatement.executeQuery();
        }
        catch (Exception exception) {
            this.destroyStmt(oracleCallableStatement);
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.register-ex1", exception);
            AQjmsError.throwEx(199, exception);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.register", "exit");
    }

    boolean is82compatible() {
        boolean bl = false;
        if (this.dbversion >= 8200) {
            bl = true;
        }
        return bl;
    }

    boolean is92compatible() {
        boolean bl = false;
        if (this.dbversion >= 9200) {
            bl = true;
        }
        return bl;
    }

    public synchronized void removeConsumer(AQjmsConsumer aQjmsConsumer) {
        if (this.m_ndsubs.containsKey(aQjmsConsumer)) {
            String string = (String)this.m_ndsubs.get(aQjmsConsumer);
            try {
                this.unsubscribe(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_ndsubs.remove(aQjmsConsumer);
        }
        this.cons_list.remove(aQjmsConsumer);
    }

    public synchronized void removeProducer(AQjmsProducer aQjmsProducer) {
        this.cons_list.remove(aQjmsProducer);
    }

    public void finalize() {
        AQjmsOracleDebug.println("AQjmsSession.finalize");
    }

    private String getAQOwner(String string) throws JMSException {
        if (string.indexOf(46) == -1) {
            try {
                return this.getDBConnection().getMetaData().getUserName();
            }
            catch (SQLException sQLException) {
                throw new AQjmsException(sQLException);
            }
        }
        return string.substring(0, string.indexOf(46));
    }

    private String getAQName(String string) {
        if (string.indexOf(46) == -1) {
            return string;
        }
        return string.substring(1 + string.indexOf(46));
    }

    private String getTempName() throws JMSException {
        String string = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        return "TMPQ_" + n + "_" + string;
    }

    private String getSubsName() throws JMSException {
        String string = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        String string2 = AQjmsSession.chopit("TSUB_" + n + "_" + string);
        return string2;
    }

    private static String chopit(String string) {
        if (string.length() >= 20) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.chopit", string + " -> " + string.substring(0, 20));
            string = string.substring(0, 20);
        }
        return string;
    }

    private AQjmsDestination makeTemporaryQueue(boolean bl) throws JMSException {
        String string = this.getAQOwner("");
        String string2 = AQjmsSession.chopit(this.getTempName());
        String string3 = AQjmsSession.chopit(string2);
        AQQueueTableProperty aQQueueTableProperty = null;
        try {
            aQQueueTableProperty = new AQQueueTableProperty("SYS.AQ$_JMS_MESSAGE");
            aQQueueTableProperty.setSortOrder("priority,enq_time");
            aQQueueTableProperty.setMultiConsumer(bl);
        }
        catch (AQException aQException) {
            throw new AQjmsException(aQException);
        }
        AQQueueTable aQQueueTable = this.createQueueTable(string, string3, aQQueueTableProperty);
        AQjmsDestination aQjmsDestination = null;
        aQjmsDestination = bl ? (AQjmsDestination)this.createTopic(aQQueueTable, string2, new AQjmsDestinationProperty()) : (AQjmsDestination)this.createQueue(aQQueueTable, string2, new AQjmsDestinationProperty());
        aQjmsDestination.start((Session)this, true, true);
        this.jms_conn.registerTemp(aQjmsDestination);
        return aQjmsDestination;
    }
}

