/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jms.JMSException;
import javax.jms.StreamMessage;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.sql.BLOB;
import oracle.sql.ORADataFactory;

public class AQjmsStreamMessage
extends AQjmsMessage
implements StreamMessage {
    byte[] bytes_data;
    AQjmsStreamMessage_C stream_msg_cont;
    ByteArrayInputStream bytes_instream;
    ObjectInputStream bytes_objectinstream;
    ByteArrayOutputStream bytes_outstream;
    ObjectOutputStream bytes_objectoutstream;
    byte[] bytes_cache = null;
    boolean cache_valid = false;

    AQjmsStreamMessage() throws JMSException {
        super(true);
        this.bytes_data = null;
        try {
            this.stream_msg_cont = new AQjmsStreamMessage_C();
            this.stream_msg_cont.setHeader(this.header_ext);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
            this.access_mode = 1;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession) throws JMSException {
        super(aQjmsSession, true);
        this.bytes_data = null;
        try {
            this.stream_msg_cont = new AQjmsStreamMessage_C();
            this.stream_msg_cont.setHeader(this.header_ext);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
            this.access_mode = 1;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession, AQjmsStreamMessage_C aQjmsStreamMessage_C) throws JMSException {
        super(aQjmsSession, true);
        this.bytes_data = null;
        try {
            this.stream_msg_cont = aQjmsStreamMessage_C;
            this.header_ext = this.stream_msg_cont.getHeader();
            this.readStreamMessageContainer();
            this.bytes_instream = new ByteArrayInputStream(this.bytes_data);
            this.bytes_objectinstream = new ObjectInputStream(this.bytes_instream);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
            this.access_mode = 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    AQjmsStreamMessage(AQjmsSession aQjmsSession, byte[] byArray) throws JMSException {
        super(aQjmsSession, true);
        try {
            this.bytes_data = byArray;
            this.bytes_instream = new ByteArrayInputStream(this.bytes_data);
            this.bytes_objectinstream = new ObjectInputStream(this.bytes_instream);
            this.bytes_outstream = new ByteArrayOutputStream();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
            this.access_mode = 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
        }
    }

    public void clearProperties() throws JMSException {
        super.clearProperties();
        try {
            if (this.stream_msg_cont != null) {
                this.stream_msg_cont.setHeader(this.header_ext);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
    }

    private void checkCacheInvalid() throws JMSException {
        if (this.cache_valid) {
            AQjmsError.throwMsgFormatEx(161, null);
        }
    }

    public boolean readBoolean() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return false;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return false;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof String) {
                return Boolean.valueOf((String)object);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return false;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return false;
        }
    }

    public byte readByte() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        this.checkCacheInvalid();
        try {
            this.bytes_instream.mark(this.bytes_instream.available());
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Boolean || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (object instanceof Byte) {
                return (Byte)object;
            }
            if (object instanceof String) {
                return Byte.valueOf((String)object);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                this.bytes_instream.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw numberFormatException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return 0;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public short readShort() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Boolean || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (object instanceof Short) {
                return (Short)object;
            }
            if (object instanceof Byte) {
                return ((Byte)object).shortValue();
            }
            if (object instanceof String) {
                return Short.valueOf((String)object);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return 0;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public char readChar() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return '\u0000';
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object == null) {
                throw new NullPointerException("readChar() of null value");
            }
            if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return '\u0000';
            }
            if (object instanceof Character) {
                return ((Character)object).charValue();
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return '\u0000';
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return '\u0000';
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return '\u0000';
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return '\u0000';
        }
    }

    public int readInt() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Boolean || object instanceof Character || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (object instanceof Byte) {
                return ((Byte)object).intValue();
            }
            if (object instanceof Short) {
                return ((Short)object).intValue();
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            if (object instanceof String) {
                return Integer.valueOf((String)object);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return 0;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public long readLong() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0L;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Boolean || object instanceof Character || object instanceof Float || object instanceof Double || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0L;
            }
            if (object instanceof Byte) {
                return ((Byte)object).longValue();
            }
            if (object instanceof Short) {
                return ((Short)object).longValue();
            }
            if (object instanceof Integer) {
                return ((Integer)object).longValue();
            }
            if (object instanceof Long) {
                return (Long)object;
            }
            if (object instanceof String) {
                return Long.valueOf((String)object);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0L;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return 0L;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0L;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0L;
        }
    }

    public float readFloat() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0f;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0.0f;
            }
            if (object instanceof Float) {
                return ((Float)object).floatValue();
            }
            if (object instanceof String) {
                return Float.valueOf((String)object).floatValue();
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0.0f;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return 0.0f;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0.0f;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0.0f;
        }
    }

    public double readDouble() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0.0;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0.0;
            }
            if (object instanceof Float) {
                return ((Float)object).doubleValue();
            }
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof String) {
                return Double.valueOf((String)object);
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0.0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return 0.0;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0.0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0.0;
        }
    }

    public String readString() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return null;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double) {
                return object.toString();
            }
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof byte[]) {
                AQjmsError.throwMsgFormatEx(161, null);
                return null;
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return null;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return null;
        }
    }

    public int readBytes(byte[] byArray) throws JMSException {
        Object object = null;
        Object var3_3 = null;
        boolean bl = false;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0;
        }
        try {
            if (this.cache_valid) {
                if (this.bytes_cache == null) {
                    this.cache_valid = false;
                    return -1;
                }
                if (this.bytes_cache.length <= byArray.length) {
                    System.arraycopy(this.bytes_cache, 0, byArray, 0, this.bytes_cache.length);
                    this.bytes_cache = null;
                    this.cache_valid = this.bytes_cache.length == byArray.length;
                    return this.bytes_cache.length;
                }
                System.arraycopy(this.bytes_cache, 0, byArray, 0, byArray.length);
                byte[] byArray2 = new byte[this.bytes_cache.length - byArray.length];
                System.arraycopy(this.bytes_cache, byArray.length, byArray2, 0, byArray2.length);
                this.bytes_cache = byArray2;
                this.cache_valid = true;
                return byArray.length;
            }
            object = this.bytes_objectinstream.readObject();
            if (object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String) {
                AQjmsError.throwMsgFormatEx(161, null);
                return 0;
            }
            if (object instanceof byte[]) {
                byte[] byArray3 = (byte[])object;
                if (byArray3.length <= byArray.length) {
                    System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
                    this.bytes_cache = null;
                    this.cache_valid = true;
                    return byArray3.length;
                }
                System.arraycopy(byArray3, 0, byArray, 0, byArray.length);
                byte[] byArray4 = new byte[byArray3.length - byArray.length];
                System.arraycopy(byArray3, byArray.length, byArray4, 0, byArray4.length);
                this.bytes_cache = byArray4;
                this.cache_valid = true;
                return byArray.length;
            }
            AQjmsError.throwMsgFormatEx(161, "invalid type");
            return 0;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwMsgFormatEx(161, classNotFoundException.getMessage());
            return 0;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return 0;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return 0;
        }
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Boolean bl2 = new Boolean(bl);
                this.bytes_objectoutstream.writeObject(bl2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Byte by2 = new Byte(by);
                this.bytes_objectoutstream.writeObject(by2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeShort(short s) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Short s2 = new Short(s);
                this.bytes_objectoutstream.writeObject(s2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeChar(char c) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Character c2 = new Character(c);
                this.bytes_objectoutstream.writeObject(c2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeInt(int n) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Integer n2 = new Integer(n);
                this.bytes_objectoutstream.writeObject(n2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeLong(long l) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Long l2 = new Long(l);
                this.bytes_objectoutstream.writeObject(l2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Float f2 = new Float(f);
                this.bytes_objectoutstream.writeObject(f2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                Double d2 = new Double(d);
                this.bytes_objectoutstream.writeObject(d2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeString(String string) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_objectoutstream.writeObject(string);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                this.bytes_objectoutstream.writeObject(byArray);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        byte[] byArray2 = new byte[n2];
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
                byteArrayInputStream.read(byArray2, 0, n2);
                this.bytes_objectoutstream.writeObject(byArray2);
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        } else {
            try {
                if (object == null) {
                    this.bytes_objectoutstream.writeObject(object);
                } else if (object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String) {
                    this.bytes_objectoutstream.writeObject(object);
                } else if (object instanceof byte[]) {
                    this.bytes_objectoutstream.writeObject(object);
                } else {
                    AQjmsError.throwMsgFormatEx(161, null);
                }
            }
            catch (IOException iOException) {
                AQjmsError.throwEx(157, iOException.getMessage());
            }
        }
    }

    public Object readObject() throws JMSException {
        Object object = null;
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return null;
        }
        this.checkCacheInvalid();
        try {
            object = this.bytes_objectinstream.readObject();
            return object;
        }
        catch (EOFException eOFException) {
            AQjmsError.throwEOFileEx(160, eOFException.getMessage());
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AQjmsError.throwEx(109, classNotFoundException.getMessage());
            return null;
        }
        catch (InvalidClassException invalidClassException) {
            AQjmsError.throwEx(156, invalidClassException.getMessage());
            return null;
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
            return null;
        }
    }

    public void reset() throws JMSException {
        byte[] byArray = null;
        byArray = this.getBytesData();
        this.setAccessMode(0);
        this.setPropReadOnly(true);
        try {
            this.bytes_instream = new ByteArrayInputStream(byArray);
            this.bytes_objectinstream = new ObjectInputStream(this.bytes_instream);
            this.bytes_outstream.reset();
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
        }
    }

    public void clearBody() throws JMSException {
        this.bytes_data = null;
        this.setAccessMode(1);
        this.setPropReadOnly(false);
        this.bytes_outstream.reset();
        try {
            this.bytes_objectoutstream = new ObjectOutputStream(this.bytes_outstream);
        }
        catch (IOException iOException) {
            AQjmsError.throwEx(157, iOException.getMessage());
        }
    }

    AQjmsStreamMessage_C getStreamMessageCont() {
        return this.stream_msg_cont;
    }

    byte[] getBytesData() {
        if (this.bytes_data == null) {
            this.bytes_data = this.bytes_outstream.toByteArray();
        }
        return this.bytes_data;
    }

    void readStreamMessageContainer() throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.readBytesMessageContainer", "entry");
        try {
            n = this.stream_msg_cont.getBytesLen();
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.readStreamMessageContainer", "- bytes_len: " + n);
            if (n > 2000) {
                bLOB = this.stream_msg_cont.getBytesLob();
                if (bLOB != null) {
                    byArray = bLOB.getBytes(1L, n);
                }
                this.bytes_data = byArray;
            } else {
                byArray = this.stream_msg_cont.getBytesRaw();
                this.bytes_data = byArray;
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.readStreamMessageContainer", "exit");
    }

    void populateStreamMessageContainer() throws JMSException {
        Object var1_1 = null;
        int n = 0;
        byte[] byArray = null;
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.populateStreamMessageContainer", "entry");
        try {
            this.stream_msg_cont.setHeader(this.header_ext);
            byArray = this.getBytesData();
            n = this.bytes_data.length;
            this.reset();
            this.stream_msg_cont.setBytesLen(new Integer(n));
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.populateStreamMessageContainer", "- bytes_len: " + n);
            if (n > 2000) {
                this.stream_msg_cont.setBytesRaw(null);
            } else {
                this.stream_msg_cont.setBytesRaw(byArray);
                this.stream_msg_cont.setBytesLob(null);
            }
        }
        catch (SQLException sQLException) {
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.populateStreamMessageContainer", "exit");
    }

    void write_blob(Connection connection, String string, byte[] byArray, boolean bl, boolean bl2) throws JMSException {
        BLOB bLOB = null;
        int n = 0;
        byte[] byArray2 = null;
        int n2 = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.write_blob", "entry");
        try {
            byArray2 = this.getBytesData();
            n = byArray2.length;
            if (string == null) {
                AQjmsOracleDebug.trace(1, "AQjmsStreamMessage.write_blob", "Internal error - qtable is null");
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.write_blob", "- bytes_len: " + n + "   qtable: " + string);
            if (n > 2000) {
                ORADataFactory oRADataFactory = bl ? AQjmsGenMessage_C.getFactory() : AQjmsStreamMessage_C.getFactory();
                AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.write_blob", "is_anydata_dest: " + bl2);
                statement = bl2 ? (OracleCallableStatement)connection.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + string + " where msgid = ?") : (OracleCallableStatement)connection.prepareCall("SELECT user_data FROM " + string + " where msgid = ?");
                statement.setBytes(1, byArray);
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    if (bl2) {
                        bLOB = ((OracleResultSet)resultSet).getBLOB(1);
                    } else if (bl) {
                        AQjmsGenMessage_C aQjmsGenMessage_C = (AQjmsGenMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsGenMessage_C.getBytesLob();
                    } else {
                        AQjmsStreamMessage_C aQjmsStreamMessage_C = (AQjmsStreamMessage_C)((OracleResultSet)resultSet).getORAData(1, oRADataFactory);
                        bLOB = aQjmsStreamMessage_C.getBytesLob();
                    }
                }
                if (bLOB == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsStreamMessage.write_blob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                n2 = bLOB.putBytes(1L, byArray2);
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new AQjmsException(sQLException);
        }
        AQjmsOracleDebug.trace(4, "AQjmsStreamMessage.write_blob", "exit");
    }
}

