/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class BinaryDoubleAccessor
extends Accessor {
    static final int MAXLENGTH = 8;

    BinaryDoubleAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 101, 101, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    BinaryDoubleAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 101, 101, s, false);
        this.initForDescribe(101, n, bl, n2, n3, n4, n5, n6, s, null);
        int n7 = oracleStatement.maxFieldSize;
        if (n7 > 0 && (n == 0 || n7 < n)) {
            n = n7;
        }
        this.initForDataAccess(0, n, null);
    }

    BINARY_DOUBLE getBINARY_DOUBLE(int n) throws SQLException {
        BINARY_DOUBLE bINARY_DOUBLE = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            bINARY_DOUBLE = new BINARY_DOUBLE(byArray);
        }
        return bINARY_DOUBLE;
    }

    BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            return new BigDecimal(this.getString(n));
        }
        return null;
    }

    BigInteger getBigInteger(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            return new BigInteger(this.getString(n));
        }
        return null;
    }

    byte getByte(int n) throws SQLException {
        return (byte)this.getDouble(n);
    }

    double getDouble(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return 0.0;
        }
        int n2 = this.columnIndex + this.byteLength * n;
        int n3 = this.rowSpaceByte[n2];
        int n4 = this.rowSpaceByte[n2 + 1];
        int n5 = this.rowSpaceByte[n2 + 2];
        int n6 = this.rowSpaceByte[n2 + 3];
        int n7 = this.rowSpaceByte[n2 + 4];
        int n8 = this.rowSpaceByte[n2 + 5];
        int n9 = this.rowSpaceByte[n2 + 6];
        int n10 = this.rowSpaceByte[n2 + 7];
        if ((n3 & 0x80) != 0) {
            n3 &= 0x7F;
            n4 &= 0xFF;
            n5 &= 0xFF;
            n6 &= 0xFF;
            n7 &= 0xFF;
            n8 &= 0xFF;
            n9 &= 0xFF;
            n10 &= 0xFF;
        } else {
            n3 = ~n3 & 0xFF;
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
            n6 = ~n6 & 0xFF;
            n7 = ~n7 & 0xFF;
            n8 = ~n8 & 0xFF;
            n9 = ~n9 & 0xFF;
            n10 = ~n10 & 0xFF;
        }
        int n11 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
        int n12 = n7 << 24 | n8 << 16 | n9 << 8 | n10;
        long l = (long)n11 << 32 | (long)n12 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    int getInt(int n) throws SQLException {
        return (int)this.getDouble(n);
    }

    long getLong(int n) throws SQLException {
        return (long)this.getDouble(n);
    }

    NUMBER getNUMBER(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            return new NUMBER(this.getDouble(n));
        }
        return null;
    }

    Object getObject(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            return new Double(this.getDouble(n));
        }
        return null;
    }

    Object getObject(int n, Map map) throws SQLException {
        return new Double(this.getDouble(n));
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getBINARY_DOUBLE(n);
    }

    short getShort(int n) throws SQLException {
        return (short)this.getDouble(n);
    }

    String getString(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            return Double.toString(this.getDouble(n));
        }
        return null;
    }

    void init(OracleStatement oracleStatement, int n, int n2, int n3, short s, int n4) throws SQLException {
        this.init(oracleStatement, n, n2, s, false);
        this.initForDataAccess(n4, n3, null);
    }

    void init(OracleStatement oracleStatement, int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s) throws SQLException {
        this.init(oracleStatement, n, n2, s, false);
        this.initForDescribe(n, n3, bl, n4, n5, n6, n7, n8, s, null);
        int n9 = oracleStatement.maxFieldSize;
        if (n9 > 0 && (n3 == 0 || n9 < n3)) {
            n3 = n9;
        }
        this.initForDataAccess(0, n3, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 8;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }
}

