/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;

class OutRawAccessor
extends RawCommonAccessor {
    static final int MAXLENGTH_NEW = Short.MAX_VALUE;
    static final int MAXLENGTH_OLD = Short.MAX_VALUE;

    OutRawAccessor(OracleStatement oracleStatement, int n, short s, int n2) throws SQLException {
        this.init(oracleStatement, 23, 23, s, true);
        this.initForDataAccess(n2, n, null);
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            int n2 = this.columnIndex + this.byteLength * n;
            byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
        }
        return byArray;
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? Short.MAX_VALUE : Short.MAX_VALUE;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }
}

