/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LongAccessor;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CNamedTypeAccessor;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.oracore.OracleTypeADT;

class T2CCallableStatement
extends OracleCallableStatement {
    T2CConnection connection = null;
    int userResultSetType = -1;
    int userResultSetConcur = -1;
    static int T2C_EXTEND_BUFFER = -3;
    long[] t2cOutput = new long[10];
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Jan_24_08:51:07_PST_2006";

    T2CCallableStatement(T2CConnection t2CConnection, String string, int n, int n2, int n3, int n4) throws SQLException {
        super(t2CConnection, string, n, n2, n3, n4);
        this.userResultSetType = n3;
        this.userResultSetConcur = n4;
        this.connection = t2CConnection;
    }

    Accessor allocateAccessor(int n, int n2, int n3, int n4, short s, String string, boolean bl) throws SQLException {
        if (n == 109) {
            if (string == null) {
                if (bl) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                } else {
                    DatabaseError.throwSqlException(60, "Unable to resolve type \"null\"");
                }
            }
            T2CNamedTypeAccessor t2CNamedTypeAccessor = new T2CNamedTypeAccessor(this, string, s, n2, bl, n3 - 1);
            ((Accessor)t2CNamedTypeAccessor).initMetadata();
            return t2CNamedTypeAccessor;
        }
        if (n == 116 || n == 102) {
            if (bl && string != null) {
                DatabaseError.throwSqlException(12, "sqlType=" + n2);
            }
            T2CResultSetAccessor t2CResultSetAccessor = new T2CResultSetAccessor(this, n4, s, n2, bl);
            return t2CResultSetAccessor;
        }
        return super.allocateAccessor(n, n2, n3, n4, s, string, bl);
    }

    String bytes2String(byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.connection.conversion.CharBytesToString(byArray2, n2);
    }

    void closeQuery() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    void closeUsedStreams(int n) throws SQLException {
        block5: {
            while (this.nextStream != null && this.nextStream.columnIndex < n) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (this.nextStream == null) break block5;
            try {
                this.nextStream.needBytes();
            }
            catch (IOException iOException) {
                DatabaseError.throwSqlException(iOException);
            }
        }
    }

    void doClose() throws SQLException {
        int n;
        if (this.defineBytes != null) {
            this.defineBytes = null;
            this.accessorByteOffset = 0;
        }
        if (this.defineChars != null) {
            this.defineChars = null;
            this.accessorCharOffset = 0;
        }
        if (this.defineIndicators != null) {
            this.defineIndicators = null;
            this.accessorShortOffset = 0;
        }
        if ((n = T2CStatement.t2cCloseStatement(this.c_state)) != 0) {
            this.connection.checkError(n);
        }
        this.t2cOutput = null;
    }

    void doDefineExecuteFetch() throws SQLException {
        short[] sArray = null;
        if (this.needToPrepareDefineBuffer || this.needToParse) {
            this.setupForDefine();
            sArray = this.connection.queryMetaData1;
        }
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, byArray, byArray.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, sArray, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.preparedAllBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset);
        if (this.validRows == -1) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
        this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
        this.needToParse = false;
    }

    void doDefineFetch() throws SQLException {
        if (!this.needToPrepareDefineBuffer) {
            throw new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
        }
        this.setupForDefine();
        this.t2cOutput[2] = 0L;
        this.validRows = T2CStatement.t2cDefineFetch(this.c_state, this.rowPrefetch, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
        if (this.validRows == -1) {
            this.connection.checkError(this.validRows);
        }
        if (this.t2cOutput[2] != 0L) {
            this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
        }
    }

    void doDescribe(boolean bl) throws SQLException {
        boolean bl2;
        if (this.closed) {
            DatabaseError.throwSqlException(9);
        }
        if (this.described) {
            return;
        }
        if (!this.isOpen) {
            DatabaseError.throwSqlException(144);
        }
        do {
            bl2 = false;
            this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size);
            if (this.numberOfDefinePositions == -1) {
                this.connection.checkError(this.numberOfDefinePositions);
            }
            if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
            bl2 = true;
            this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2);
        } while (bl2);
        this.processDescribeData();
    }

    void executeForDescribe() throws SQLException {
        boolean bl;
        this.t2cOutput[0] = 0L;
        this.t2cOutput[2] = 0L;
        boolean bl2 = this.described ^ true;
        boolean bl3 = false;
        do {
            bl = false;
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            int n = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, this.currentRowBindAccessors != null, this.needToParse, bl2, bl3, byArray, byArray.length, this.sqlKind, this.rowPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.connection.queryMetaData1, this.connection.queryMetaData2, this.connection.queryMetaData1Offset, this.connection.queryMetaData2Offset, this.connection.queryMetaData1Size, this.connection.queryMetaData2Size, this.preparedAllBinds, this.preparedCharBinds, this.outBindAccessors, this.parameterDatum, this.t2cOutput, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.connection.plsqlCompilerWarnings);
            this.validRows = (int)this.t2cOutput[1];
            if (n == -1) {
                this.connection.checkError(n);
            } else if (n == T2C_EXTEND_BUFFER) {
                n = this.connection.queryMetaData1Size * 2;
            }
            if (this.t2cOutput[3] != 0L) {
                this.foundPlsqlCompilerWarning();
            } else if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            this.needToParse = false;
            bl3 = true;
            if (this.sqlKind == 0) {
                this.numberOfDefinePositions = n;
                if (this.numberOfDefinePositions <= this.connection.queryMetaData1Size) continue;
                bl = true;
                bl3 = true;
                this.connection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                continue;
            }
            this.numberOfDefinePositions = 0;
            this.validRows = n;
        } while (bl);
        this.processDescribeData();
    }

    void executeForRows(boolean bl) throws SQLException {
        if (this.connection.endToEndAnyChanged) {
            this.pushEndToEndValues();
            this.connection.endToEndAnyChanged = false;
        }
        if (!bl) {
            if (this.numberOfDefinePositions > 0) {
                this.doDefineExecuteFetch();
            } else {
                this.executeForDescribe();
            }
        } else if (this.numberOfDefinePositions > 0) {
            this.doDefineFetch();
        }
        this.needToPrepareDefineBuffer = false;
    }

    void fetch() throws SQLException {
        if (this.numberOfDefinePositions > 0) {
            if (this.needToPrepareDefineBuffer) {
                this.doDefineFetch();
            } else {
                this.t2cOutput[2] = 0L;
                this.validRows = T2CStatement.t2cFetch(this.c_state, this.needToPrepareDefineBuffer, this.rowPrefetch, this.accessors, this.defineBytes, this.accessorByteOffset, this.defineChars, this.accessorCharOffset, this.defineIndicators, this.accessorShortOffset, this.t2cOutput);
                if (this.validRows == -1) {
                    this.connection.checkError(this.validRows);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.connection.checkError(1, this.sqlWarning);
                }
            }
        }
    }

    void fetchDmlReturnParams() throws SQLException {
        this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
        if (this.rowsDmlReturned != 0) {
            this.allocateDmlReturnStorage();
            int n = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this.returnParamAccessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
        }
        this.returnParamsFetched = true;
    }

    void initializeIndicatorSubRange() {
        this.bindIndicatorSubRange = this.numberOfBindPositions * 5;
    }

    void prepareBindPreambles(int n, int n2) {
        int n3 = this.bindIndicatorSubRange;
        this.initializeIndicatorSubRange();
        int n4 = this.bindIndicatorSubRange;
        this.bindIndicatorSubRange = n3;
        int n5 = this.bindIndicatorSubRange - n4;
        OracleTypeADT[] oracleTypeADTArray = this.parameterOtype == null ? null : this.parameterOtype[this.firstRowInBatch];
        int n6 = 0;
        while (n6 < this.numberOfBindPositions) {
            int n7;
            OracleTypeADT oracleTypeADT;
            Binder binder = this.lastBinders[n6];
            if (binder == this.theReturnParamBinder) {
                oracleTypeADT = (OracleTypeADT)this.returnParamAccessors[n6].internalOtype;
                n7 = 0;
            } else {
                OracleTypeADT oracleTypeADT2 = oracleTypeADT = oracleTypeADTArray == null ? null : oracleTypeADTArray[n6];
                if (this.outBindAccessors == null) {
                    n7 = 0;
                } else {
                    Accessor accessor = this.outBindAccessors[n6];
                    if (accessor == null) {
                        n7 = 0;
                    } else if (binder == this.theOutBinder) {
                        n7 = 1;
                        if (oracleTypeADT == null) {
                            oracleTypeADT = (OracleTypeADT)accessor.internalOtype;
                        }
                    } else {
                        n7 = 2;
                    }
                }
                if (binder == this.theSetCHARBinder) {
                    n7 = (short)(n7 | 4);
                }
            }
            this.bindIndicators[n5++] = n7;
            if (oracleTypeADT != null) {
                long l = oracleTypeADT.getTdoCState();
                this.bindIndicators[n5] = (short)(l >> 48 & 0xFFFFL);
                this.bindIndicators[n5 + 1] = (short)(l >> 32 & 0xFFFFL);
                this.bindIndicators[n5 + 2] = (short)(l >> 16 & 0xFFFFL);
                this.bindIndicators[n5 + 3] = (short)(l & 0xFFFFL);
            }
            n5 += 4;
            ++n6;
        }
    }

    void processDescribeData() throws SQLException {
        this.described = true;
        this.describedWithNames = true;
        if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
            this.accessors = new Accessor[this.numberOfDefinePositions];
        }
        int n = this.connection.queryMetaData1Offset;
        int n2 = this.connection.queryMetaData2Offset;
        short[] sArray = this.connection.queryMetaData1;
        byte[] byArray = this.connection.queryMetaData2;
        int n3 = 0;
        while (n3 < this.numberOfDefinePositions) {
            Accessor accessor;
            short s = sArray[n];
            short s2 = sArray[n + 1];
            short s3 = sArray[n + 11];
            boolean bl = sArray[n + 2] != 0;
            short s4 = sArray[n + 3];
            short s5 = sArray[n + 4];
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            short s6 = sArray[n + 5];
            short s7 = sArray[n + 6];
            String string = this.bytes2String(byArray, n2, s7);
            short s8 = sArray[n + 12];
            String string2 = null;
            OracleTypeADT oracleTypeADT = null;
            n2 += s7;
            if (s8 > 0) {
                string2 = this.bytes2String(byArray, n2, s8);
                n2 += s8;
                oracleTypeADT = new OracleTypeADT(string2, (Connection)this.connection);
                oracleTypeADT.tdoCState = ((long)sArray[n + 7] & 0xFFFFL) << 48 | ((long)sArray[n + 8] & 0xFFFFL) << 32 | ((long)sArray[n + 9] & 0xFFFFL) << 16 | (long)sArray[n + 10] & 0xFFFFL;
            }
            if ((accessor = this.accessors[n3]) != null && !accessor.useForDescribeIfPossible(s, s2, bl, n4, s4, s5, n5, n6, s6, string2)) {
                accessor = null;
            }
            if (accessor == null) {
                switch (s) {
                    case 1: {
                        accessor = new VarcharAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        if (s3 <= 0) break;
                        accessor.setDisplaySize(s3);
                        break;
                    }
                    case 96: {
                        accessor = new CharAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        if (s3 <= 0) break;
                        accessor.setDisplaySize(s3);
                        break;
                    }
                    case 2: {
                        accessor = new NumberAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 23: {
                        accessor = new RawAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 100: {
                        accessor = new BinaryFloatAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 101: {
                        accessor = new BinaryDoubleAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 8: {
                        accessor = new LongAccessor(this, n3 + 1, s2, bl, n4, s4, s5, n5, n6, s6);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 24: {
                        accessor = new LongRawAccessor(this, n3 + 1, s2, bl, n4, s4, s5, n5, n6, s6);
                        this.rowPrefetch = 1;
                        break;
                    }
                    case 104: {
                        accessor = new RowidAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 102: 
                    case 116: {
                        accessor = new T2CResultSetAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 12: {
                        accessor = new DateAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 180: {
                        accessor = new TimestampAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 181: {
                        accessor = new TimestamptzAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 231: {
                        accessor = new TimestampltzAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 182: {
                        accessor = new IntervalymAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 183: {
                        accessor = new IntervaldsAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 112: {
                        accessor = new ClobAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 113: {
                        accessor = new BlobAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 114: {
                        accessor = new BfileAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6);
                        break;
                    }
                    case 109: {
                        accessor = new NamedTypeAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6, string2, oracleTypeADT);
                        break;
                    }
                    case 111: {
                        accessor = new RefTypeAccessor(this, s2, bl, n4, s4, s5, n5, n6, s6, string2, oracleTypeADT);
                        break;
                    }
                    default: {
                        throw new SQLException("Unknown or unimplemented accessor type: " + s);
                    }
                }
                this.accessors[n3] = accessor;
            } else if (oracleTypeADT != null) {
                accessor.initMetadata();
            }
            accessor.columnName = string;
            ++n3;
            n += 13;
        }
    }

    void pushEndToEndValues() throws SQLException {
        T2CConnection t2CConnection = this.connection;
        byte[] byArray = new byte[]{};
        byte[] byArray2 = new byte[]{};
        byte[] byArray3 = new byte[]{};
        byte[] byArray4 = new byte[]{};
        if (t2CConnection.endToEndValues != null) {
            String string;
            if (t2CConnection.endToEndHasChanged[0]) {
                string = t2CConnection.endToEndValues[0];
                if (string != null) {
                    byArray = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[0] = false;
            }
            if (t2CConnection.endToEndHasChanged[1]) {
                string = t2CConnection.endToEndValues[1];
                if (string != null) {
                    byArray2 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[1] = false;
            }
            if (t2CConnection.endToEndHasChanged[2]) {
                string = t2CConnection.endToEndValues[2];
                if (string != null) {
                    byArray3 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[2] = false;
            }
            if (t2CConnection.endToEndHasChanged[3]) {
                string = t2CConnection.endToEndValues[3];
                if (string != null) {
                    byArray4 = DBConversion.stringToDriverCharBytes(string, t2CConnection.m_clientCharacterSet);
                }
                t2CConnection.endToEndHasChanged[3] = false;
            }
            T2CStatement.t2cEndToEndUpdate(this.c_state, byArray, byArray.length, byArray2, byArray2.length, byArray3, byArray3.length, byArray4, byArray4.length, t2CConnection.endToEndECIDSequenceNumber);
        }
    }

    void registerOutParameterInternal(int n, int n2, int n3, int n4, String string) throws SQLException {
        int n5;
        int n6 = n - 1;
        if (n6 < 0 || n > this.numberOfBindPositions) {
            DatabaseError.throwSqlException(3);
        }
        if ((n5 = this.getInternalType(n2)) == 995) {
            DatabaseError.throwSqlException(4);
        }
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (n2) {
            default: {
                n4 = 0;
            }
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
        }
        this.currentRowBindAccessors[n6] = this.allocateAccessor(n5, n2, n, n4, this.currentRowFormOfUse[n6], string, true);
    }

    void setupForDefine() throws SQLException {
        if (this.numberOfDefinePositions > this.connection.queryMetaData1Size) {
            this.connection.reallocateQueryMetaData(this.connection.queryMetaData1Size * 2, this.connection.queryMetaData2Size * 2 * 8);
        }
        short[] sArray = this.connection.queryMetaData1;
        int n = this.connection.queryMetaData1Offset;
        int n2 = 0;
        while (n2 < this.numberOfDefinePositions) {
            Accessor accessor = this.accessors[n2];
            if (accessor == null) {
                DatabaseError.throwSqlException(21);
            }
            sArray[n] = (short)accessor.defineType;
            sArray[n + 11] = (short)accessor.charLength;
            sArray[n + 1] = (short)accessor.byteLength;
            sArray[n + 5] = accessor.formOfUse;
            if (accessor.internalOtype != null) {
                long l = ((OracleTypeADT)accessor.internalOtype).getTdoCState();
                sArray[n + 7] = (short)((l & 0xFFFF000000000000L) >> 48);
                sArray[n + 8] = (short)((l & 0xFFFF00000000L) >> 32);
                sArray[n + 9] = (short)((l & 0xFFFF0000L) >> 16);
                sArray[n + 10] = (short)(l & 0xFFFFL);
            }
            ++n2;
            n += 13;
        }
    }
}

