/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;

class T4CPreparedStatement
extends OraclePreparedStatement {
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Jan_24_08:51:10_PST_2006";

    T4CPreparedStatement(PhysicalConnection physicalConnection, String string, int n, int n2) throws SQLException {
        super(physicalConnection, string, physicalConnection.defaultBatch, physicalConnection.defaultRowPrefetch, n, n2);
        this.nbPostPonedColumns = new int[1];
        this.nbPostPonedColumns[0] = 0;
        this.indexOfPostPonedColumn = new int[1][3];
        this.t4Connection = (T4CConnection)physicalConnection;
        this.theRowidBinder = OraclePreparedStatement.theStaticT4CRowidBinder;
        this.theRowidNullBinder = OraclePreparedStatement.theStaticT4CRowidNullBinder;
    }

    Accessor allocateAccessor(int n, int n2, int n3, int n4, short s, String string, boolean bl) throws SQLException {
        Accessor accessor = null;
        switch (n) {
            case 96: {
                accessor = new T4CCharAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!bl) {
                    accessor = new T4CLongAccessor(this, n3, n4, s, n2, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                accessor = new T4CVarcharAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 2: {
                accessor = new T4CNumberAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 6: {
                accessor = new T4CVarnumAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!bl) {
                    accessor = new T4CLongRawAccessor(this, n3, n4, s, n2, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (bl && string != null) {
                    DatabaseError.throwSqlException(12, "sqlType=" + n2);
                }
                if (bl) {
                    accessor = new T4COutRawAccessor(this, n4, s, n2, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CRawAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 100: {
                accessor = new T4CBinaryFloatAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 101: {
                accessor = new T4CBinaryDoubleAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 104: {
                accessor = new T4CRowidAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 102: {
                accessor = new T4CResultSetAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 12: {
                accessor = new T4CDateAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 113: {
                accessor = new T4CBlobAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 112: {
                accessor = new T4CClobAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 114: {
                accessor = new T4CBfileAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 109: {
                accessor = new T4CNamedTypeAccessor(this, string, s, n2, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 111: {
                accessor = new T4CRefTypeAccessor(this, string, s, n2, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 180: {
                if (this.connection.v8Compatible) {
                    accessor = new T4CDateAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CTimestampAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 181: {
                accessor = new T4CTimestamptzAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 231: {
                accessor = new T4CTimestampltzAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 182: {
                accessor = new T4CIntervalymAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 183: {
                accessor = new T4CIntervaldsAccessor(this, n4, s, n2, bl, this.t4Connection.mare);
                break;
            }
            case 995: {
                DatabaseError.throwSqlException(89);
            }
        }
        return accessor;
    }

    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    public synchronized void clearDefines() throws SQLException {
        super.clearDefines();
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
    }

    void closeQuery() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    void continueReadRow(int n) throws SQLException {
        try {
            if (!this.connection.useFetchSizeWithLongColumn) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n);
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    protected void defineColumnTypeInternal(int n, int n2, int n3, short s, boolean bl, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefineColumnType) {
            return;
        }
        if (n < 1) {
            DatabaseError.throwSqlException(3);
        }
        if (bl) {
            if (n2 == 1 || n2 == 12) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
            }
        } else if (n3 < 0) {
            DatabaseError.throwSqlException(53);
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            DatabaseError.throwSqlException(28);
        }
        int n4 = n - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n4) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n4 + 1) * 4];
            } else {
                nArray = new int[(n4 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n4] = n2;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n4) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n4 + 1) * 4];
            } else {
                nArray = new int[(n4 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        this.definedColumnSize[n4] = n3;
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= n4) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(n4 + 1) * 4];
            } else {
                nArray = new int[(n4 + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = nArray;
            }
        }
        this.definedColumnFormOfUse[n4] = s;
        if (this.accessors != null && n4 < this.accessors.length && this.accessors[n4] != null) {
            this.accessors[n4].definedColumnSize = n3;
            if (!(this.accessors[n4].internalType != 96 && this.accessors[n4].internalType != 1 || n2 != 1 && n2 != 12 || n3 > this.accessors[n4].oacmxl)) {
                this.needToPrepareDefineBuffer = true;
                this.columnsDefinedByUser = true;
                this.accessors[n4].initForDataAccess(n2, n3, null);
                this.accessors[n4].calculateSizeTmpByteArray();
            }
        }
    }

    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.do_close");
        try {
            if (this.cursorId != 0) {
                this.t4Connection.cursorToClose[this.t4Connection.cursorToCloseOffset++] = this.cursorId;
                if (this.t4Connection.cursorToCloseOffset >= this.t4Connection.cursorToClose.length) {
                    this.t4Connection.sendPiggyBackedMessages();
                }
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    void doDescribe(boolean bl) throws SQLException {
        if (!this.isOpen) {
            DatabaseError.throwSqlException(144);
        }
        try {
            this.t4Connection.sendPiggyBackedMessages();
            this.t4Connection.describe.init(this, 0);
            this.t4Connection.describe.marshal();
            this.accessors = this.t4Connection.describe.receive(this.accessors);
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            int n = 0;
            while (n < this.numberOfDefinePositions) {
                this.accessors[n].initMetadata();
                ++n;
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
        this.describedWithNames = true;
        this.described = true;
    }

    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException, IOException {
        int n;
        if (bl || bl4 || !bl2 || this.sqlKind != 2 && this.sqlKind != 1 && this.sqlKind != 4) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.doOall8");
        if (this.sqlKind != 1 && this.sqlKind != 4 && this.sqlKind != 3 && this.sqlKind != 0 && this.sqlKind != 2) {
            DatabaseError.throwSqlException(439);
        }
        int n2 = this.numberOfDefinePositions;
        if (this.sqlKind == 2) {
            n2 = 0;
        }
        if (bl3) {
            if (this.accessors != null) {
                n = 0;
                while (n < this.numberOfDefinePositions) {
                    if (this.accessors[n] != null) {
                        this.accessors[n].lastRowProcessed = 0;
                    }
                    ++n;
                }
            }
            if (this.outBindAccessors != null) {
                n = 0;
                while (n < this.outBindAccessors.length) {
                    if (this.outBindAccessors[n] != null) {
                        this.outBindAccessors[n].lastRowProcessed = 0;
                    }
                    ++n;
                }
            }
        }
        if (this.returnParamAccessors != null) {
            n = 0;
            while (n < this.numberOfBindPositions) {
                if (this.returnParamAccessors[n] != null) {
                    this.returnParamAccessors[n].lastRowProcessed = 0;
                }
                ++n;
            }
        }
        if (this.bindIndicators != null) {
            n = this.bindIndicators[this.bindIndicatorSubRange + 2] & 0xFFFF;
            int n3 = 0;
            if (this.ibtBindChars != null) {
                n3 = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            int n4 = 0;
            while (n4 < this.numberOfBindPositions) {
                int n5 = this.bindIndicatorSubRange + 3 + 10 * n4;
                int n6 = this.bindIndicators[n5 + 2] & 0xFFFF;
                if (n6 != 0) {
                    int n7 = this.bindIndicators[n5 + 9] & 0xFFFF;
                    n3 = n7 == 2 ? Math.max(n6 * this.connection.conversion.maxNCharSize, n3) : Math.max(n6 * this.connection.conversion.cMaxCharSize, n3);
                }
                ++n4;
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[n3];
            } else if (this.tmpBindsByteArray.length < n3) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[n3];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        this.allocateTmpByteArray();
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        this.t4Connection.sendPiggyBackedMessages();
        this.oacdefSent = t4C8Oall.marshal(bl, bl2, bl3, bl4, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), this.rowPrefetch, this.outBindAccessors, this.numberOfBindPositions, this.accessors, n2, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, this.definedColumnType, this.definedColumnSize, this.definedColumnFormOfUse);
        try {
            t4C8Oall.receive();
            this.cursorId = t4C8Oall.getCursorId();
        }
        catch (SQLException sQLException) {
            this.cursorId = t4C8Oall.getCursorId();
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
        this.cleanOldTempLobs();
        try {
            try {
                if (this.t4Connection.useFetchSizeWithLongColumn) {
                    this.doOall8(true, true, true, true);
                } else {
                    this.doOall8(true, true, false, true);
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (IOException iOException) {
                ((T4CConnection)this.connection).handleIOException(iOException);
                DatabaseError.throwSqlException(iOException);
            }
            Object var2_3 = null;
            this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
            this.validRows = this.t4Connection.all8.getNumRows();
            throw throwable;
        }
        this.needToParse = false;
        int n = 0;
        while (n < this.numberOfDefinePositions) {
            this.accessors[n].initMetadata();
            ++n;
        }
        this.needToPrepareDefineBuffer = false;
    }

    void executeForRows(boolean bl) throws SQLException {
        try {
            try {
                this.doOall8(this.needToParse, bl ^ true, true, false);
                this.needToParse = false;
            }
            finally {
                Object var3_2 = null;
                this.validRows = this.t4Connection.all8.getNumRows();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void executeMaybeDescribe() throws SQLException {
        if (!this.t4Connection.useFetchSizeWithLongColumn) {
            super.executeMaybeDescribe();
        } else {
            if (this.rowPrefetchChanged) {
                if (this.streamList == null && this.rowPrefetch != this.definesBatchSize) {
                    this.needToPrepareDefineBuffer = true;
                }
                this.rowPrefetchChanged = false;
            }
            if (!this.needToPrepareDefineBuffer) {
                if (this.accessors == null) {
                    this.needToPrepareDefineBuffer = true;
                } else if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = this.checkAccessorsUsable() ^ true;
                }
            }
            boolean bl = false;
            try {
                try {
                    this.isExecuting = true;
                    if (this.needToPrepareDefineBuffer) {
                        this.executeForDescribe();
                        bl = true;
                    } else {
                        int n = this.accessors.length;
                        int n2 = this.numberOfDefinePositions;
                        while (n2 < n) {
                            Accessor accessor = this.accessors[n2];
                            if (accessor != null) {
                                accessor.rowSpaceIndicator = null;
                            }
                            ++n2;
                        }
                        this.executeForRows(bl);
                    }
                }
                catch (SQLException sQLException) {
                    this.needToParse = true;
                    throw sQLException;
                }
                Object var3_6 = null;
                this.isExecuting = false;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                this.isExecuting = false;
                throw throwable;
            }
        }
    }

    void fetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    DatabaseError.throwSqlException(iOException);
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        try {
            this.doOall8(false, false, true, false);
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            DatabaseError.throwSqlException(iOException);
        }
    }

    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
        int n;
        if (bl) {
            sArray = new short[this.defineIndicators.length];
            n = this.accessors[0].lengthIndexLastRow;
            int n2 = this.accessors[0].indicatorIndexLastRow;
            int n3 = 1;
            while (n3 <= this.accessors.length) {
                int n4 = n + this.rowPrefetchAtExecute * n3 - 1;
                int n5 = n2 + this.rowPrefetchAtExecute * n3 - 1;
                sArray[n5] = this.defineIndicators[n5];
                sArray[n4] = this.defineIndicators[n4];
                ++n3;
            }
        }
        n = 0;
        while (n < this.accessors.length) {
            this.accessors[n].saveDataFromOldDefineBuffers(byArray, cArray, sArray, this.rowPrefetchAtExecute != -1 ? this.rowPrefetchAtExecute : this.rowPrefetch, this.rowPrefetch);
            ++n;
        }
    }
}

