/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.PrintWriter;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ArrayDescriptor;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORAData;
import oracle.sql.STRUCT;

public class ARRAY
extends DatumWithConnection
implements Array {
    static final byte KOPUP_INLINE_COLL = 1;
    ArrayDescriptor descriptor;
    Object objArray;
    Datum[] datumArray;
    byte[] locator;
    byte prefixFlag;
    byte[] prefixSegment;
    int numElems = -1;
    boolean enableBuffering = false;
    boolean enableIndexing = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int accessDirection = 3;
    long lastIndex;
    long lastOffset;
    long[] indexArray;
    long imageOffset;
    long imageLength;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Tue_Jan_24_08:50:58_PST_2006";

    public ARRAY(ArrayDescriptor arrayDescriptor, Connection connection, Object object) throws SQLException {
        DatumWithConnection.assertNotNull(arrayDescriptor);
        this.descriptor = arrayDescriptor;
        DatumWithConnection.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            throw new SQLException("Cannot construct ARRAY instance, invalid connection");
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = object == null ? new Datum[0] : this.descriptor.toOracleArray(object, 1L, -1);
    }

    public ARRAY(ArrayDescriptor arrayDescriptor, byte[] byArray, Connection connection) throws SQLException {
        super(byArray);
        DatumWithConnection.assertNotNull(arrayDescriptor);
        this.descriptor = arrayDescriptor;
        DatumWithConnection.assertNotNull(connection);
        if (!arrayDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin())) {
            throw new SQLException("Cannot construct ARRAY instance, invalid connection");
        }
        arrayDescriptor.setConnection(connection);
        this.setPhysicalConnectionOf(connection);
        this.datumArray = null;
        this.locator = null;
    }

    public String dump() throws SQLException {
        return STRUCT.dump(this);
    }

    static void dump(ARRAY aRRAY, PrintWriter printWriter, int n) throws SQLException {
        if (n > 0) {
            printWriter.println();
        }
        ArrayDescriptor arrayDescriptor = aRRAY.getDescriptor();
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.println("name = " + arrayDescriptor.getName());
        n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        printWriter.println("max length = " + arrayDescriptor.getMaxLength());
        Object[] objectArray = (Object[])aRRAY.getArray();
        n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
        int n3 = objectArray.length;
        printWriter.println("length = " + n3);
        n2 = 0;
        while (n2 < n3) {
            int n4 = 0;
            while (n4 < n) {
                printWriter.print(' ');
                ++n4;
            }
            printWriter.print("element[" + n2 + "] = ");
            STRUCT.dump(objectArray[n2], printWriter, n + 4);
            ++n2;
        }
    }

    public int getAccessDirection() throws SQLException {
        return this.accessDirection;
    }

    public synchronized Object getArray() throws SQLException {
        return this.descriptor.toJavaArray(this, 1L, -1, this.getMap(), this.enableBuffering);
    }

    public synchronized Object getArray(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DatabaseError.throwSqlException(68, "getArray()");
        }
        return this.descriptor.toJavaArray(this, l, n, this.getMap(), false);
    }

    public synchronized Object getArray(long l, int n, Map map) throws SQLException {
        if (l < 1L || n < 0) {
            DatabaseError.throwSqlException(68, "getArray()");
        }
        return this.descriptor.toJavaArray(this, l, n, map, false);
    }

    public synchronized Object getArray(Map map) throws SQLException {
        return this.descriptor.toJavaArray(this, 1L, -1, map, this.enableBuffering);
    }

    public boolean getAutoBuffering() throws SQLException {
        return this.enableBuffering;
    }

    public boolean getAutoIndexing() throws SQLException {
        return this.enableIndexing;
    }

    public synchronized int getBaseType() throws SQLException {
        return this.descriptor.getBaseType();
    }

    public synchronized String getBaseTypeName() throws SQLException {
        String string = this.descriptor.getBaseName();
        return string;
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.descriptor;
    }

    public synchronized double[] getDoubleArray() throws SQLException {
        return (double[])this.descriptor.toNumericArray(this, 1L, -1, 5, this.enableBuffering);
    }

    public synchronized double[] getDoubleArray(long l, int n) throws SQLException {
        return (double[])this.descriptor.toNumericArray(this, l, n, 5, false);
    }

    public synchronized float[] getFloatArray() throws SQLException {
        return (float[])this.descriptor.toNumericArray(this, 1L, -1, 6, this.enableBuffering);
    }

    public synchronized float[] getFloatArray(long l, int n) throws SQLException {
        return (float[])this.descriptor.toNumericArray(this, l, n, 6, false);
    }

    public long getImageLength() {
        return this.imageLength;
    }

    public long getImageOffset() {
        return this.imageOffset;
    }

    public synchronized int[] getIntArray() throws SQLException {
        return (int[])this.descriptor.toNumericArray(this, 1L, -1, 4, this.enableBuffering);
    }

    public synchronized int[] getIntArray(long l, int n) throws SQLException {
        return (int[])this.descriptor.toNumericArray(this, l, n, 4, false);
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public long getLastIndex() throws SQLException {
        return this.lastIndex;
    }

    public long getLastOffset() throws SQLException {
        return this.lastOffset;
    }

    public byte[] getLocator() {
        return this.locator;
    }

    public synchronized long[] getLongArray() throws SQLException {
        return (long[])this.descriptor.toNumericArray(this, 1L, -1, 7, this.enableBuffering);
    }

    public synchronized long[] getLongArray(long l, int n) throws SQLException {
        return (long[])this.descriptor.toNumericArray(this, l, n, 7, false);
    }

    public Map getMap() throws SQLException {
        return this.getInternalConnection().getTypeMap();
    }

    public long getOffset(long l) throws SQLException {
        long l2 = -1L;
        if (this.indexArray != null) {
            l2 = this.indexArray[(int)l - 1];
        }
        return l2;
    }

    public synchronized Datum[] getOracleArray() throws SQLException {
        return this.descriptor.toOracleArray(this, 1L, -1, this.enableBuffering);
    }

    public synchronized Datum[] getOracleArray(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            DatabaseError.throwSqlException(68, "getOracleArray()");
        }
        return this.descriptor.toOracleArray(this, l, n, false);
    }

    public synchronized ResultSet getResultSet() throws SQLException {
        return this.getResultSet(this.getInternalConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(long l, int n) throws SQLException {
        return this.getResultSet(l, n, this.getInternalConnection().getTypeMap());
    }

    public synchronized ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        if (l < 1L || n < -1) {
            DatabaseError.throwSqlException(68, "getResultSet()");
        }
        return this.descriptor.toResultSet(this, l, n, map, false);
    }

    public synchronized ResultSet getResultSet(Map map) throws SQLException {
        return this.descriptor.toResultSet(this, 1L, -1, map, this.enableBuffering);
    }

    public synchronized String getSQLTypeName() throws SQLException {
        String string = null;
        if (this.descriptor != null) {
            string = this.descriptor.getName();
        } else {
            DatabaseError.throwSqlException(61, "ARRAY");
        }
        return string;
    }

    public synchronized short[] getShortArray() throws SQLException {
        return (short[])this.descriptor.toNumericArray(this, 1L, -1, 8, this.enableBuffering);
    }

    public synchronized short[] getShortArray(long l, int n) throws SQLException {
        return (short[])this.descriptor.toNumericArray(this, l, n, 8, false);
    }

    public boolean hasDataSeg() {
        return this.locator == null;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public boolean isInline() {
        return (this.prefixFlag & 1) == 1;
    }

    public synchronized int length() throws SQLException {
        return this.descriptor.toLength(this);
    }

    public Object makeJdbcArray(int n) {
        return new Object[n][];
    }

    public synchronized void setAutoBuffering(boolean bl) throws SQLException {
        this.enableBuffering = bl;
    }

    public synchronized void setAutoIndexing(boolean bl) throws SQLException {
        this.enableIndexing = bl;
        this.accessDirection = 3;
    }

    public synchronized void setAutoIndexing(boolean bl, int n) throws SQLException {
        this.enableIndexing = bl;
        this.accessDirection = n;
    }

    public synchronized void setDatumArray(Datum[] datumArray) {
        this.datumArray = datumArray;
    }

    public void setImage(byte[] byArray, long l, long l2) throws SQLException {
        this.setShareBytes(byArray);
        this.imageOffset = l;
        this.imageLength = l2;
    }

    public void setImageLength(long l) throws SQLException {
        this.imageLength = l;
    }

    public void setIndexOffset(long l, long l2) throws SQLException {
        if (this.indexArray == null) {
            this.indexArray = new long[this.numElems];
        }
        this.indexArray[(int)l - 1] = l2;
    }

    public void setLastIndexOffset(long l, long l2) throws SQLException {
        this.lastIndex = l;
        this.lastOffset = l2;
    }

    public synchronized void setLength(int n) {
        this.numElems = n;
    }

    public synchronized void setLocator(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.locator = byArray;
        }
    }

    public synchronized void setObjArray(Object object) throws SQLException {
        if (object == null) {
            DatabaseError.throwSqlException(1);
        }
        this.objArray = object;
    }

    public synchronized void setPrefixFlag(byte by) {
        this.prefixFlag = by;
    }

    public synchronized void setPrefixSegment(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            this.prefixSegment = byArray;
        }
    }

    public static ARRAY toARRAY(Object object, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        ARRAY aRRAY = null;
        if (object != null) {
            if (object instanceof ARRAY) {
                aRRAY = (ARRAY)object;
            } else if (object instanceof ORAData) {
                aRRAY = (ARRAY)((ORAData)object).toDatum(oracleConnection);
            } else if (object instanceof CustomDatum) {
                aRRAY = (ARRAY)((OracleConnection)oracleConnection).toDatum((CustomDatum)object);
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return aRRAY;
    }

    public synchronized byte[] toBytes() throws SQLException {
        return this.descriptor.toBytes(this, this.enableBuffering);
    }

    public Object toJdbc() throws SQLException {
        return this;
    }
}

