/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import net.shopxx.AuthenticationToken;
import net.shopxx.Principal;
import net.shopxx.Setting;
import net.shopxx.entity.Admin;
import net.shopxx.service.AdminService;
import net.shopxx.service.CaptchaService;
import net.shopxx.util.SettingUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.pam.UnsupportedTokenException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class AuthenticationRealm
extends AuthorizingRealm {
    @Resource(name="captchaServiceImpl")
    private CaptchaService IIIllIlI;
    @Resource(name="adminServiceImpl")
    private AdminService IIIllIll;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AuthenticationInfo doGetAuthenticationInfo(org.apache.shiro.authc.AuthenticationToken token) {
        int n;
        AuthenticationToken authenticationToken = (AuthenticationToken)token;
        String string = authenticationToken.getUsername();
        String string2 = new String(authenticationToken.getPassword());
        String string3 = authenticationToken.getCaptchaId();
        String string4 = authenticationToken.getCaptcha();
        String string5 = authenticationToken.getHost();
        if (!this.IIIllIlI.isValid(Setting.CaptchaType.adminLogin, string3, string4)) {
            throw new UnsupportedTokenException();
        }
        if (string == null || string2 == null) throw new UnknownAccountException();
        Admin admin = this.IIIllIll.findByUsername(string);
        if (admin == null) {
            throw new UnknownAccountException();
        }
        if (!admin.getIsEnabled().booleanValue()) {
            throw new DisabledAccountException();
        }
        Setting setting = SettingUtils.get();
        if (admin.getIsLocked().booleanValue()) {
            if (ArrayUtils.contains((Object[])setting.getAccountLockTypes(), (Object)Setting.AccountLockType.admin)) {
                n = setting.getAccountLockTime();
                if (n == 0) {
                    throw new LockedAccountException();
                }
                Date date = admin.getLockedDate();
                Date date2 = DateUtils.addMinutes((Date)date, (int)n);
                if (!new Date().after(date2)) throw new LockedAccountException();
                admin.setLoginFailureCount(Integer.valueOf(0));
                admin.setIsLocked(Boolean.valueOf(false));
                admin.setLockedDate(null);
                this.IIIllIll.update((Object)admin);
            } else {
                admin.setLoginFailureCount(Integer.valueOf(0));
                admin.setIsLocked(Boolean.valueOf(false));
                admin.setLockedDate(null);
                this.IIIllIll.update((Object)admin);
            }
        }
        if (!DigestUtils.md5Hex((String)string2).equals(admin.getPassword())) {
            n = admin.getLoginFailureCount() + 1;
            if (n >= setting.getAccountLockCount()) {
                admin.setIsLocked(Boolean.valueOf(true));
                admin.setLockedDate(new Date());
            }
            admin.setLoginFailureCount(Integer.valueOf(n));
            this.IIIllIll.update((Object)admin);
            throw new IncorrectCredentialsException();
        }
        admin.setLoginIp(string5);
        admin.setLoginDate(new Date());
        admin.setLoginFailureCount(Integer.valueOf(0));
        this.IIIllIll.update((Object)admin);
        return new SimpleAuthenticationInfo((Object)new Principal(admin.getId(), string), (Object)string2, this.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        List list;
        Principal principal = (Principal)principals.fromRealm(this.getName()).iterator().next();
        if (principal != null && (list = this.IIIllIll.findAuthorities(principal.getId())) != null) {
            SimpleAuthorizationInfo simpleAuthorizationInfo = new SimpleAuthorizationInfo();
            simpleAuthorizationInfo.addStringPermissions((Collection)list);
            return simpleAuthorizationInfo;
        }
        return null;
    }
}

