/*
 * Decompiled with CFR 0.152.
 */
package net.shopxx.controller.admin;

import java.io.Serializable;
import java.util.HashSet;
import javax.annotation.Resource;
import net.shopxx.Message;
import net.shopxx.Pageable;
import net.shopxx.controller.admin.BaseController;
import net.shopxx.entity.Admin;
import net.shopxx.entity.BaseEntity;
import net.shopxx.service.AdminService;
import net.shopxx.service.RoleService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="adminAdminController")
@RequestMapping(value={"/admin/admin"})
public class AdminController
extends BaseController {
    @Resource(name="adminServiceImpl")
    private AdminService IIIlllIl;
    @Resource(name="roleServiceImpl")
    private RoleService IIIllllI;

    @RequestMapping(value={"/check_username"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean checkUsername(String username) {
        if (StringUtils.isEmpty((String)username)) {
            return false;
        }
        return !this.IIIlllIl.usernameExists(username);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(ModelMap model) {
        model.addAttribute("roles", (Object)this.IIIllllI.findAll());
        return "/admin/admin/add";
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public String save(Admin admin, Long[] roleIds, RedirectAttributes redirectAttributes) {
        admin.setRoles(new HashSet(this.IIIllllI.findList((Serializable[])roleIds)));
        if (!this.IIIllIlI((Object)admin, new Class[]{BaseEntity.Save.class})) {
            return "/admin/common/error";
        }
        if (this.IIIlllIl.usernameExists(admin.getUsername())) {
            return "/admin/common/error";
        }
        admin.setPassword(DigestUtils.md5Hex((String)admin.getPassword()));
        admin.setIsLocked(Boolean.valueOf(false));
        admin.setLoginFailureCount(Integer.valueOf(0));
        admin.setLockedDate(null);
        admin.setLoginDate(null);
        admin.setLoginIp(null);
        admin.setOrders(null);
        this.IIIlllIl.save((Object)admin);
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.GET})
    public String edit(Long id, ModelMap model) {
        model.addAttribute("roles", (Object)this.IIIllllI.findAll());
        model.addAttribute("admin", this.IIIlllIl.find((Serializable)id));
        return "/admin/admin/edit";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(Admin admin, Long[] roleIds, RedirectAttributes redirectAttributes) {
        admin.setRoles(new HashSet(this.IIIllllI.findList((Serializable[])roleIds)));
        if (!this.IIIllIlI((Object)admin, new Class[0])) {
            return "/admin/common/error";
        }
        Admin admin2 = (Admin)this.IIIlllIl.find((Serializable)admin.getId());
        if (admin2 == null) {
            return "/admin/common/error";
        }
        if (StringUtils.isNotEmpty((String)admin.getPassword())) {
            admin.setPassword(DigestUtils.md5Hex((String)admin.getPassword()));
        } else {
            admin.setPassword(admin2.getPassword());
        }
        if (admin2.getIsLocked().booleanValue() && !admin.getIsLocked().booleanValue()) {
            admin.setLoginFailureCount(Integer.valueOf(0));
            admin.setLockedDate(null);
        } else {
            admin.setIsLocked(admin2.getIsLocked());
            admin.setLoginFailureCount(admin2.getLoginFailureCount());
            admin.setLockedDate(admin2.getLockedDate());
        }
        this.IIIlllIl.update((Object)admin, new String[]{"username", "loginDate", "loginIp", "orders"});
        this.IIIllIlI(redirectAttributes, IIIlllII);
        return "redirect:list.jhtml";
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public String list(Pageable pageable, ModelMap model) {
        model.addAttribute("page", (Object)this.IIIlllIl.findPage(pageable));
        return "/admin/admin/list";
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Message delete(Long[] ids) {
        if ((long)ids.length >= this.IIIlllIl.count()) {
            return Message.error((String)"admin.common.deleteAllNotAllowed", (Object[])new Object[0]);
        }
        this.IIIlllIl.delete((Serializable[])ids);
        return IIIlllII;
    }
}

